/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.DriveStrength;
import com.cburch.logisim.fpga.data.IoComponentTypes;
import com.cburch.logisim.fpga.data.IoComponentsInformation;
import com.cburch.logisim.fpga.data.IoStandards;
import com.cburch.logisim.fpga.data.LedArrayDriving;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.data.MapListModel;
import com.cburch.logisim.fpga.data.PinActivity;
import com.cburch.logisim.fpga.data.PullBehaviors;
import com.cburch.logisim.fpga.gui.BoardManipulator;
import com.cburch.logisim.fpga.gui.FpgaIoInformationSettingsDialog;
import com.cburch.logisim.fpga.gui.PartialMapDialog;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.io.DipSwitch;
import com.cburch.logisim.std.io.DotMatrix;
import com.cburch.logisim.std.io.LedBar;
import com.cburch.logisim.std.io.RgbLed;
import com.cburch.logisim.util.CollectionUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FpgaIoInformationContainer
implements Cloneable {
    static final Logger logger = LoggerFactory.getLogger(FpgaIoInformationContainer.class);
    private IoComponentTypes myType;
    protected BoardRectangle myRectangle;
    protected int myRotation = 0;
    private Map<Integer, String> myPinLocations;
    private Set<Integer> myInputPins;
    private Set<Integer> myOutputPins;
    private Set<Integer> myIoPins;
    private Integer[][] partialMapArray;
    private Integer nrOfPins;
    private Integer nrOfExternalPins = 0;
    private Integer myArrayId = -1;
    private char myPullBehavior;
    private char myActivityLevel;
    private char myIoStandard;
    private char myDriveStrength;
    private String myLabel;
    private boolean toBeDeleted = false;
    private ArrayList<mapType> pinIsMapped;
    private int paintColor = 1;
    private boolean mapMode = false;
    private boolean highlighted = false;
    private int nrOfRows = 4;
    private int nrOfColumns = 4;
    private char driving = '\u0000';
    protected boolean selectable = false;
    protected int selectedPin = -1;
    protected MapListModel.MapInfo selComp = null;

    public static List<String> getComponentTypes() {
        LinkedList<String> result = new LinkedList<String>();
        for (IoComponentTypes comp : IoComponentTypes.KNOWN_COMPONENT_SET) {
            result.add(comp.toString());
        }
        return result;
    }

    public FpgaIoInformationContainer() {
        this.myType = IoComponentTypes.Unknown;
        this.myRectangle = null;
        this.myPinLocations = new HashMap<Integer, String>();
        this.setNrOfPins(0);
        this.myPullBehavior = (char)255;
        this.myActivityLevel = (char)255;
        this.myIoStandard = (char)255;
        this.myDriveStrength = (char)255;
        this.myLabel = null;
    }

    public FpgaIoInformationContainer(IoComponentTypes Type2, BoardRectangle rect, IoComponentsInformation iocomps) {
        this.myType = Type2;
        this.myRectangle = rect;
        this.myPinLocations = new HashMap<Integer, String>();
        this.setNrOfPins(0);
        this.myPullBehavior = (char)255;
        this.myActivityLevel = (char)255;
        this.myIoStandard = (char)255;
        this.myDriveStrength = (char)255;
        this.myLabel = null;
        if (rect != null) {
            rect.setLabel(null);
        }
        if (IoComponentTypes.SIMPLE_INPUT_SET.contains((Object)Type2)) {
            FpgaIoInformationSettingsDialog.getSimpleInformationDialog(false, iocomps, this);
            return;
        }
        this.myType = IoComponentTypes.Unknown;
    }

    public FpgaIoInformationContainer(IoComponentTypes Type2, BoardRectangle rect, String loc, String pull, String active, String standard, String drive, String label) {
        this.set(Type2, rect, loc, pull, active, standard, drive, label);
    }

    public FpgaIoInformationContainer(Node DocumentInfo) {
        int i;
        this.myType = IoComponentTypes.Unknown;
        this.myRectangle = null;
        this.myPinLocations = new HashMap<Integer, String>();
        this.setNrOfPins(0);
        this.myPullBehavior = (char)255;
        this.myActivityLevel = (char)255;
        this.myIoStandard = (char)255;
        this.myDriveStrength = (char)255;
        this.myLabel = null;
        ArrayList<String> InputLocs = new ArrayList<String>();
        ArrayList<String> OutputLocs = new ArrayList<String>();
        ArrayList<String> IOLocs = new ArrayList<String>();
        IoComponentTypes SetId = IoComponentTypes.getEnumFromString(DocumentInfo.getNodeName());
        if (!IoComponentTypes.KNOWN_COMPONENT_SET.contains((Object)SetId)) {
            return;
        }
        this.myType = SetId;
        NamedNodeMap attrs = DocumentInfo.getAttributes();
        int x = -1;
        int y = -1;
        int width = -1;
        int height = -1;
        for (int attributeIndex = 0; attributeIndex < attrs.getLength(); ++attributeIndex) {
            String[] vals;
            Node thisAttr = attrs.item(attributeIndex);
            if (thisAttr.getNodeName().equals("rotation")) {
                this.myRotation = Integer.parseInt(thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("LocationX")) {
                x = Integer.parseInt(thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("LocationY")) {
                y = Integer.parseInt(thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("Width")) {
                width = Integer.parseInt(thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("Height")) {
                height = Integer.parseInt(thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("Rect_x_y_w_h") && (vals = thisAttr.getNodeValue().split(",")).length == 4) {
                try {
                    x = Integer.parseUnsignedInt(vals[0]);
                    y = Integer.parseUnsignedInt(vals[1]);
                    width = Integer.parseUnsignedInt(vals[2]);
                    height = Integer.parseUnsignedInt(vals[3]);
                }
                catch (NumberFormatException e) {
                    height = -1;
                    width = -1;
                    y = -1;
                    x = -1;
                }
            }
            if (thisAttr.getNodeName().equals("LedArrayInfo") && (vals = thisAttr.getNodeValue().split(",")).length == 3) {
                try {
                    this.nrOfRows = Integer.parseUnsignedInt(vals[0]);
                    this.nrOfColumns = Integer.parseUnsignedInt(vals[1]);
                    this.driving = LedArrayDriving.getId(vals[2]);
                }
                catch (NumberFormatException e) {
                    this.nrOfColumns = 4;
                    this.nrOfRows = 4;
                    this.driving = '\u0000';
                }
            }
            if (thisAttr.getNodeName().equals("FPGAPinName")) {
                this.setNrOfPins(1);
                this.myPinLocations.put(0, thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("NrOfPins")) {
                this.setNrOfPins(Integer.parseInt(thisAttr.getNodeValue()));
            }
            if (thisAttr.getNodeName().startsWith("FPGAPin_")) {
                String Id = thisAttr.getNodeName().substring("FPGAPin_".length());
                this.myPinLocations.put(Integer.parseInt(Id), thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("Label")) {
                this.myLabel = thisAttr.getNodeValue();
            }
            if (thisAttr.getNodeName().equals("FPGAPinDriveStrength")) {
                this.myDriveStrength = DriveStrength.getId(thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("FPGAPinPullBehavior")) {
                this.myPullBehavior = PullBehaviors.getId(thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("FPGAPinIOStandard")) {
                this.myIoStandard = IoStandards.getId(thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().equals("ActivityLevel")) {
                this.myActivityLevel = PinActivity.getId(thisAttr.getNodeValue());
            }
            if (thisAttr.getNodeName().contentEquals("InputPinSet")) {
                InputLocs.addAll(Arrays.asList(thisAttr.getNodeValue().split(",")));
            }
            if (thisAttr.getNodeName().contentEquals("OutputPinSet")) {
                OutputLocs.addAll(Arrays.asList(thisAttr.getNodeValue().split(",")));
            }
            if (!thisAttr.getNodeName().contentEquals("BiDirPinSet")) continue;
            IOLocs.addAll(Arrays.asList(thisAttr.getNodeValue().split(",")));
        }
        if (x < 0 || y < 0 || width < 1 || height < 1) {
            this.myType = IoComponentTypes.Unknown;
            return;
        }
        int idx = 0;
        for (String loc : InputLocs) {
            this.myPinLocations.put(idx, loc);
            if (this.myInputPins == null) {
                this.myInputPins = new HashSet<Integer>();
            }
            this.myInputPins.add(idx++);
        }
        for (String loc : OutputLocs) {
            this.myPinLocations.put(idx, loc);
            if (this.myOutputPins == null) {
                this.myOutputPins = new HashSet<Integer>();
            }
            this.myOutputPins.add(idx++);
        }
        for (String loc : IOLocs) {
            this.myPinLocations.put(idx, loc);
            if (this.myIoPins == null) {
                this.myIoPins = new HashSet<Integer>();
            }
            this.myIoPins.add(idx++);
        }
        if (idx != 0) {
            this.setNrOfPins(idx);
        }
        boolean PinsComplete = true;
        for (i = 0; i < this.nrOfPins; ++i) {
            if (this.myPinLocations.containsKey(i)) continue;
            logger.warn("Bizar missing pin {} of component!", (Object)i);
            PinsComplete = false;
        }
        if (!PinsComplete) {
            this.myType = IoComponentTypes.Unknown;
            return;
        }
        if (this.myInputPins == null && this.myOutputPins == null && this.myIoPins == null) {
            int NrInpPins = IoComponentTypes.getFpgaInputRequirement(this.myType);
            int NrOutpPins = IoComponentTypes.getFpgaOutputRequirement(this.myType);
            for (int i2 = 0; i2 < this.nrOfPins; ++i2) {
                if (i2 < NrInpPins) {
                    if (this.myInputPins == null) {
                        this.myInputPins = new HashSet<Integer>();
                    }
                    this.myInputPins.add(i2);
                    continue;
                }
                if (i2 < NrInpPins + NrOutpPins) {
                    if (this.myOutputPins == null) {
                        this.myOutputPins = new HashSet<Integer>();
                    }
                    this.myOutputPins.add(i2);
                    continue;
                }
                if (this.myIoPins == null) {
                    this.myIoPins = new HashSet<Integer>();
                }
                this.myIoPins.add(i2);
            }
        }
        if (this.myType.equals((Object)IoComponentTypes.Pin)) {
            this.myActivityLevel = '\u0001';
        }
        this.myRectangle = new BoardRectangle(x, y, width, height);
        if (this.myLabel != null) {
            this.myRectangle.setLabel(this.myLabel);
        }
        if (this.myType.equals((Object)IoComponentTypes.LedArray)) {
            this.nrOfExternalPins = this.nrOfPins;
            this.nrOfPins = this.nrOfRows * this.nrOfColumns;
            this.setNrOfPins(this.nrOfPins);
            this.myOutputPins.clear();
            for (i = 0; i < this.nrOfPins; ++i) {
                this.myOutputPins.add(i);
            }
        }
    }

    public void setArrayId(int val) {
        this.myArrayId = val;
    }

    public int getArrayId() {
        return this.myArrayId;
    }

    public void setMapRotation(int val) {
        if (val == -90 || val == 90 || val == 0) {
            this.myRotation = val;
        }
    }

    public int getMapRotation() {
        return this.myRotation;
    }

    public int getExternalPinCount() {
        return this.nrOfExternalPins;
    }

    public boolean hasMap() {
        boolean ret = false;
        for (int i = 0; i < this.nrOfPins; ++i) {
            ret |= this.isPinMapped(i);
        }
        return ret;
    }

    public int getNrOfInputPins() {
        return this.myInputPins == null ? 0 : this.myInputPins.size();
    }

    public int getNrOfOutputPins() {
        return this.myOutputPins == null ? 0 : this.myOutputPins.size();
    }

    public int getNrOfRows() {
        return this.nrOfRows;
    }

    public int getNrOfColumns() {
        return this.nrOfColumns;
    }

    public char getArrayDriveMode() {
        return this.driving;
    }

    public void setNrOfRows(int value) {
        this.nrOfRows = value;
    }

    public void setNrOfColumns(int value) {
        this.nrOfColumns = value;
    }

    public void setArrayDriveMode(char value) {
        this.driving = value;
    }

    public void edit(Boolean deleteButton, IoComponentsInformation IoComps) {
        FpgaIoInformationSettingsDialog.getSimpleInformationDialog(deleteButton, IoComps, this);
    }

    public void setMapMode() {
        this.mapMode = true;
        this.paintColor = 0;
    }

    public void setToBeDeleted() {
        this.toBeDeleted = true;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public char getActivityLevel() {
        return this.myActivityLevel;
    }

    public void setActivityLevel(char activity) {
        this.myActivityLevel = activity;
    }

    public Object clone() throws CloneNotSupportedException {
        FpgaIoInformationContainer clone = new FpgaIoInformationContainer();
        clone.myType = this.myType;
        clone.myRectangle = this.myRectangle;
        clone.myRotation = this.myRotation;
        clone.myPinLocations = this.myPinLocations;
        clone.myInputPins = this.myInputPins;
        clone.myOutputPins = this.myOutputPins;
        clone.myIoPins = this.myIoPins;
        clone.nrOfPins = this.nrOfPins;
        clone.nrOfExternalPins = this.nrOfExternalPins;
        clone.myArrayId = this.myArrayId;
        clone.myPullBehavior = this.myPullBehavior;
        clone.myActivityLevel = this.myActivityLevel;
        clone.myIoStandard = this.myIoStandard;
        clone.myDriveStrength = this.myDriveStrength;
        clone.myLabel = this.myLabel;
        clone.driving = this.driving;
        clone.nrOfRows = this.nrOfRows;
        clone.nrOfColumns = this.nrOfColumns;
        for (int pinId = 0; pinId < this.nrOfPins; ++pinId) {
            clone.pinIsMapped.add(null);
        }
        return clone;
    }

    public String getPinLocation(int index) {
        return this.myPinLocations.getOrDefault(index, "");
    }

    public void setInputPinLocation(int index, String value) {
        if (this.myOutputPins != null) {
            this.myOutputPins.remove(index);
        }
        if (this.myIoPins != null) {
            this.myIoPins.remove(index);
        }
        if (this.myInputPins == null) {
            this.myInputPins = new HashSet<Integer>();
        }
        this.myInputPins.add(index);
        this.myPinLocations.put(index, value);
    }

    public void setOutputPinLocation(int index, String value) {
        if (this.myInputPins != null) {
            this.myInputPins.remove(index);
        }
        if (this.myIoPins != null) {
            this.myIoPins.remove(index);
        }
        if (this.myOutputPins == null) {
            this.myOutputPins = new HashSet<Integer>();
        }
        this.myOutputPins.add(index);
        this.myPinLocations.put(index, value);
    }

    public void setIOPinLocation(int index, String value) {
        if (this.myInputPins != null) {
            this.myInputPins.remove(index);
        }
        if (this.myOutputPins != null) {
            this.myOutputPins.remove(index);
        }
        if (this.myIoPins == null) {
            this.myIoPins = new HashSet<Integer>();
        }
        this.myIoPins.add(index);
        this.myPinLocations.put(index, value);
    }

    public Element getDocumentElement(Document doc) {
        if (this.myType.equals((Object)IoComponentTypes.Unknown)) {
            return null;
        }
        try {
            int i;
            boolean first;
            StringBuilder sb;
            Attr attrSet;
            Element result = doc.createElement(this.myType.toString());
            result.setAttribute("Rect_x_y_w_h", this.myRectangle.getXpos() + "," + this.myRectangle.getYpos() + "," + this.myRectangle.getWidth() + "," + this.myRectangle.getHeight());
            if (this.myLabel != null) {
                Attr label = doc.createAttribute("Label");
                label.setValue(this.myLabel);
                result.setAttributeNode(label);
            }
            if (this.myType.equals((Object)IoComponentTypes.LedArray)) {
                result.setAttribute("LedArrayInfo", this.nrOfRows + "," + this.nrOfColumns + "," + LedArrayDriving.getStrings().get(this.driving));
            }
            if (IoComponentTypes.hasRotationAttribute(this.myType).booleanValue()) {
                switch (this.myRotation) {
                    case -90: 
                    case 90: {
                        result.setAttribute("rotation", Integer.toString(this.myRotation));
                        break;
                    }
                }
            }
            if (CollectionUtil.isNotEmpty(this.myInputPins)) {
                attrSet = doc.createAttribute("InputPinSet");
                sb = new StringBuilder();
                first = true;
                for (i = 0; i < this.nrOfPins; ++i) {
                    if (!this.myInputPins.contains(i)) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(this.myPinLocations.get(i));
                }
                attrSet.setValue(sb.toString());
                result.setAttributeNode(attrSet);
            }
            if (CollectionUtil.isNotEmpty(this.myOutputPins)) {
                attrSet = doc.createAttribute("OutputPinSet");
                sb = new StringBuilder();
                first = true;
                for (i = 0; i < this.nrOfPins; ++i) {
                    if (!this.myOutputPins.contains(i)) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(this.myPinLocations.get(i));
                }
                attrSet.setValue(sb.toString());
                result.setAttributeNode(attrSet);
            }
            if (CollectionUtil.isNotEmpty(this.myIoPins)) {
                attrSet = doc.createAttribute("BiDirPinSet");
                sb = new StringBuilder();
                first = true;
                for (i = 0; i < this.nrOfPins; ++i) {
                    if (!this.myIoPins.contains(i)) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(this.myPinLocations.get(i));
                }
                attrSet.setValue(sb.toString());
                result.setAttributeNode(attrSet);
            }
            if (this.myDriveStrength != '\u00ff' && this.myDriveStrength != '\u0000') {
                Attr drive = doc.createAttribute("FPGAPinDriveStrength");
                drive.setValue(DriveStrength.BEHAVIOR_STRINGS[this.myDriveStrength]);
                result.setAttributeNode(drive);
            }
            if (this.myPullBehavior != '\u00ff' && this.myPullBehavior != '\u0000') {
                Attr pull = doc.createAttribute("FPGAPinPullBehavior");
                pull.setValue(PullBehaviors.BEHAVIOR_STRINGS[this.myPullBehavior]);
                result.setAttributeNode(pull);
            }
            if (this.myIoStandard != '\u00ff' && this.myIoStandard != '\u0000') {
                Attr stand = doc.createAttribute("FPGAPinIOStandard");
                stand.setValue(IoStandards.BEHAVIOR_STRINGS[this.myIoStandard]);
                result.setAttributeNode(stand);
            }
            if (this.myActivityLevel != '\u00ff' && this.myActivityLevel != '\u0001') {
                Attr act = doc.createAttribute("ActivityLevel");
                act.setValue(PinActivity.BEHAVIOR_STRINGS[this.myActivityLevel]);
                result.setAttributeNode(act);
            }
            return result;
        }
        catch (Exception e) {
            logger.error("Exceptions not handled yet in GetDocumentElement(), but got an exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String getDisplayString() {
        return this.myLabel == null ? this.myType.name() : this.myLabel;
    }

    public void setLabel(String label) {
        this.myLabel = label;
    }

    public char getDrive() {
        return this.myDriveStrength;
    }

    public void setDrive(char drive) {
        this.myDriveStrength = drive;
    }

    public char getIoStandard() {
        return this.myIoStandard;
    }

    public void setIOStandard(char IoStandard) {
        this.myIoStandard = IoStandard;
    }

    public int getNrOfPins() {
        return this.nrOfPins;
    }

    public char getPullBehavior() {
        return this.myPullBehavior;
    }

    public void setPullBehavior(char pull) {
        this.myPullBehavior = pull;
    }

    public BoardRectangle getRectangle() {
        return this.myRectangle;
    }

    public IoComponentTypes getType() {
        return this.myType;
    }

    public void setType(IoComponentTypes type) {
        this.myType = type;
    }

    public boolean isInput() {
        return IoComponentTypes.INPUT_COMPONENT_SET.contains((Object)this.myType);
    }

    public boolean isInputOutput() {
        return IoComponentTypes.IN_OUT_COMPONENT_SET.contains((Object)this.myType);
    }

    public boolean isKnownComponent() {
        return IoComponentTypes.KNOWN_COMPONENT_SET.contains((Object)this.myType);
    }

    public boolean isOutput() {
        return IoComponentTypes.OUTPUT_COMPONENT_SET.contains((Object)this.myType);
    }

    public boolean isPinMapped(int index) {
        if (index < 0 || index >= this.nrOfPins) {
            return true;
        }
        return this.pinIsMapped.get(index) != null;
    }

    public MapComponent getPinMap(int index) {
        if (index < 0 || index >= this.nrOfPins) {
            return null;
        }
        return this.pinIsMapped.get(index).getMap();
    }

    public int getMapPin(int index) {
        if (index < 0 || index >= this.nrOfPins) {
            return -1;
        }
        return this.pinIsMapped.get((int)index).pin;
    }

    public void set(IoComponentTypes compType, BoardRectangle rect, String loc, String pull, String active, String standard, String drive, String label) {
        this.myType = compType;
        this.myRectangle = rect;
        rect.setActiveOnHigh(active.equals(PinActivity.BEHAVIOR_STRINGS[1]));
        this.setNrOfPins(0);
        this.myPinLocations.put(0, loc);
        this.myPullBehavior = PullBehaviors.getId(pull);
        this.myActivityLevel = PinActivity.getId(active);
        this.myIoStandard = IoStandards.getId(standard);
        this.myDriveStrength = DriveStrength.getId(drive);
        this.myLabel = label;
        if (rect != null) {
            rect.setLabel(label);
        }
    }

    public void setNrOfPins(int count) {
        block5: {
            block4: {
                if (this.pinIsMapped == null) {
                    this.pinIsMapped = new ArrayList();
                }
                this.nrOfPins = count;
                if (count <= this.pinIsMapped.size()) break block4;
                for (int i = this.pinIsMapped.size(); i < count; ++i) {
                    this.pinIsMapped.add(null);
                }
                break block5;
            }
            if (count >= this.pinIsMapped.size()) break block5;
            for (int i = this.pinIsMapped.size() - 1; i >= count; --i) {
                mapType map = this.pinIsMapped.get(i);
                if (map != null) {
                    map.unmap();
                }
                this.pinIsMapped.remove(i);
            }
        }
    }

    public void unmap(int pin) {
        if (pin < 0 || pin >= this.pinIsMapped.size()) {
            return;
        }
        mapType map = this.pinIsMapped.get(pin);
        this.pinIsMapped.set(pin, null);
        if (map != null) {
            map.unmap();
        }
    }

    public MapResultClass tryInputMap(MapComponent comp, int compPin, int inpPin) {
        MapResultClass result = new MapResultClass();
        result.mapResult = false;
        result.pinId = inpPin;
        if (this.myInputPins == null || !this.myInputPins.contains(result.pinId)) {
            return this.tryIOMap(comp, compPin, inpPin);
        }
        this.unmap(result.pinId);
        mapType map = new mapType(comp, compPin);
        this.pinIsMapped.set(result.pinId, map);
        result.mapResult = true;
        return result;
    }

    public MapResultClass tryOutputMap(MapComponent comp, int compPin, int outpPin) {
        MapResultClass result = new MapResultClass();
        result.mapResult = false;
        result.pinId = outpPin + (this.myInputPins == null ? 0 : this.myInputPins.size());
        if (this.myOutputPins == null || !this.myOutputPins.contains(result.pinId)) {
            return this.tryIOMap(comp, compPin, outpPin);
        }
        this.unmap(result.pinId);
        mapType map = new mapType(comp, compPin);
        this.pinIsMapped.set(result.pinId, map);
        result.mapResult = true;
        return result;
    }

    public MapResultClass tryIOMap(MapComponent comp, int compPin, int ioPin) {
        MapResultClass result = new MapResultClass();
        result.mapResult = false;
        result.pinId = ioPin + (this.myInputPins == null ? 0 : this.myInputPins.size()) + (this.myOutputPins == null ? 0 : this.myOutputPins.size());
        if (this.myIoPins == null || !this.myIoPins.contains(result.pinId)) {
            return result;
        }
        this.unmap(result.pinId);
        mapType map = new mapType(comp, compPin);
        this.pinIsMapped.set(result.pinId, map);
        result.mapResult = true;
        return result;
    }

    public boolean tryMap(MapComponent comp, int compPin, int myPin) {
        if (myPin < 0 || myPin >= this.nrOfPins) {
            return false;
        }
        this.unmap(myPin);
        mapType map = new mapType(comp, compPin);
        this.pinIsMapped.set(myPin, map);
        return true;
    }

    public boolean updateMap(int pin, MapComponent comp) {
        if (pin < 0 || pin >= this.pinIsMapped.size()) {
            return false;
        }
        mapType map = this.pinIsMapped.get(pin);
        if (map == null) {
            return false;
        }
        map.update(comp);
        return true;
    }

    public boolean isCompletelyMappedBy(MapComponent comp) {
        for (int i = 0; i < this.nrOfPins; ++i) {
            if (this.pinIsMapped.get(i) != null) {
                if (this.pinIsMapped.get((int)i).map.equals(comp)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private int getNrOfMaps() {
        int res = 0;
        for (int i = 0; i < this.nrOfPins; ++i) {
            if (this.pinIsMapped.get(i) == null) continue;
            ++res;
        }
        return res;
    }

    public void setHighlighted() {
        if (!this.mapMode) {
            this.paintColor = 2;
        }
        this.highlighted = true;
    }

    public void unsetHighlighted() {
        if (!this.mapMode) {
            this.paintColor = 1;
        }
        this.highlighted = false;
    }

    public boolean hasInputs() {
        return CollectionUtil.isNotEmpty(this.myInputPins);
    }

    public boolean hasOutputs() {
        return CollectionUtil.isNotEmpty(this.myOutputPins);
    }

    public boolean hasIoPins() {
        return CollectionUtil.isNotEmpty(this.myIoPins);
    }

    public int nrInputs() {
        return this.myInputPins == null ? 0 : this.myInputPins.size();
    }

    public int nrOutputs() {
        return this.myOutputPins == null ? 0 : this.myOutputPins.size();
    }

    public int getNrOfIoPins() {
        return this.myIoPins == null ? 0 : this.myIoPins.size();
    }

    public Set<Integer> getInputs() {
        return this.myInputPins;
    }

    public Set<Integer> getOutputs() {
        return this.myOutputPins;
    }

    public Set<Integer> getIos() {
        return this.myIoPins;
    }

    public String getPinName(int index) {
        if (this.myInputPins != null && this.myInputPins.contains(index)) {
            return IoComponentTypes.getInputLabel(this.nrOfPins, index, this.myType);
        }
        if (this.myOutputPins != null && this.myOutputPins.contains(index)) {
            return IoComponentTypes.getOutputLabel(this.nrOfPins, this.nrOfRows, this.nrOfColumns, index, this.myType);
        }
        if (this.myIoPins != null && this.myIoPins.contains(index)) {
            return IoComponentTypes.getIoLabel(this.nrOfPins, index, this.myType);
        }
        return "" + index;
    }

    public boolean setSelectable(MapListModel.MapInfo comp) {
        this.selComp = comp;
        MapComponent map = comp.getMap();
        int connect = comp.getPin();
        this.selectedPin = -1;
        this.selectable = false;
        if (connect < 0) {
            if (map.hasInputs() && (this.hasIoPins() || this.hasInputs())) {
                this.selectable = true;
            }
            if (map.hasOutputs() && (this.hasIoPins() || this.hasOutputs())) {
                this.selectable = true;
            }
            if (map.hasIos() && this.hasIoPins()) {
                this.selectable = true;
            }
        } else {
            if (map.isInput(connect) && (this.hasIoPins() || this.hasInputs())) {
                this.selectable = true;
            }
            if (map.isOutput(connect) && (this.hasIoPins() || this.hasOutputs())) {
                this.selectable = true;
            }
            if (map.isIo(connect) && this.hasIoPins()) {
                this.selectable = true;
            }
        }
        return this.selectable;
    }

    public boolean removeSelectable() {
        boolean ret = this.selectable;
        this.selComp = null;
        this.selectable = false;
        this.selectedPin = -1;
        return ret;
    }

    public void paint(Graphics2D g, float scale) {
        if (this.mapMode) {
            if (this.partialMapArray == null) {
                this.partialMapArray = new Integer[this.myRectangle.getWidth()][this.myRectangle.getHeight()];
                IoComponentTypes.getPartialMapInfo(this.partialMapArray, this.myRectangle.getWidth(), this.myRectangle.getHeight(), this.nrOfPins, this.nrOfRows, this.nrOfColumns, this.myRotation, this.myType);
            }
            this.paintMap(g, scale);
            return;
        }
        Color PaintColor = BoardManipulator.getColor(this.paintColor);
        if (PaintColor == null) {
            return;
        }
        Color c = g.getColor();
        g.setColor(PaintColor);
        g.fillRect(AppPreferences.getScaled(this.myRectangle.getXpos(), scale), AppPreferences.getScaled(this.myRectangle.getYpos(), scale), AppPreferences.getScaled(this.myRectangle.getWidth(), scale), AppPreferences.getScaled(this.myRectangle.getHeight(), scale));
        g.setColor(c);
    }

    private void paintMap(Graphics2D gfx, float scale) {
        Color c = gfx.getColor();
        int i = this.getNrOfMaps();
        if (i > 0) {
            this.paintMapped(gfx, scale, i);
        } else {
            this.paintSelected(gfx, scale);
        }
        gfx.setColor(c);
    }

    private boolean containsMap() {
        if (this.selComp == null) {
            return false;
        }
        MapComponent com = this.selComp.getMap();
        for (int i = 0; i < this.nrOfPins; ++i) {
            if (this.pinIsMapped.get(i) == null || !this.pinIsMapped.get((int)i).map.equals(com)) continue;
            return true;
        }
        return false;
    }

    public boolean selectedPinChanged(int xPos, int Ypos) {
        Integer selPin;
        if (!this.highlighted || !this.selectable) {
            return false;
        }
        if (this.partialMapArray == null) {
            this.partialMapArray = new Integer[this.myRectangle.getWidth()][this.myRectangle.getHeight()];
            IoComponentTypes.getPartialMapInfo(this.partialMapArray, this.myRectangle.getWidth(), this.myRectangle.getHeight(), this.nrOfPins, this.nrOfRows, this.nrOfColumns, this.myRotation, this.myType);
        }
        if ((selPin = this.partialMapArray[xPos - this.myRectangle.getXpos()][Ypos - this.myRectangle.getYpos()]) != this.selectedPin) {
            this.selectedPin = selPin;
            return true;
        }
        return false;
    }

    public boolean isCompleteMap() {
        if (this.selComp == null) {
            return true;
        }
        MapComponent map = this.selComp.getMap();
        if (this.selComp.getPin() >= 0 && this.nrOfPins == 1) {
            return true;
        }
        if (map.nrInputs() == this.nrInputs() && map.nrOutputs() == this.nrOutputs() && map.nrIOs() == this.getNrOfIoPins() && this.selComp.getPin() < 0) {
            return true;
        }
        if (this.nrInputs() == 0 && this.nrOutputs() == 0 && map.nrIOs() == 0 && map.nrInputs() == this.getNrOfIoPins() && map.nrOutputs() == 0 && this.selComp.getPin() < 0) {
            return true;
        }
        return this.nrInputs() == 0 && this.nrOutputs() == 0 && map.nrIOs() == 0 && map.nrOutputs() == this.getNrOfIoPins() && map.nrInputs() == 0 && this.selComp.getPin() < 0;
    }

    public boolean tryLedArrayMap(JPanel parent) {
        int nrOfSegs;
        int selCol;
        MapComponent map = this.selComp.getMap();
        if (this.selComp.getPin() >= 0 && this.selectedPin >= 0) {
            map.unmap(this.selComp.getPin());
            return map.tryMap(this.selComp.getPin(), this, this.selectedPin);
        }
        ComponentFactory fact = map.getComponentFactory();
        if (fact instanceof DotMatrix) {
            int nrOfMatrixRows = map.getAttributeSet().getValue(DotMatrix.ATTR_MATRIX_ROWS).getWidth();
            int nrOfMatrixColumns = map.getAttributeSet().getValue(DotMatrix.ATTR_MATRIX_COLS).getWidth();
            int startRow = this.selectedPin / this.nrOfColumns;
            int startColumn = this.selectedPin % this.nrOfColumns;
            if (nrOfMatrixRows + startRow <= this.nrOfRows && nrOfMatrixColumns + startColumn <= this.nrOfColumns) {
                boolean canMap = true;
                map.unmap();
                for (int row = 0; row < nrOfMatrixRows; ++row) {
                    for (int column = 0; column < nrOfMatrixColumns; ++column) {
                        int SourcePin = row * nrOfMatrixColumns + column;
                        int MapPin = (row + startRow) * this.nrOfColumns + column + startColumn;
                        canMap &= map.tryMap(SourcePin, this, MapPin);
                    }
                }
                if (!canMap) {
                    map.unmap();
                }
                return canMap;
            }
        }
        if (fact instanceof LedBar && (selCol = this.selectedPin % this.nrOfColumns) + (nrOfSegs = map.getAttributeSet().getValue(LedBar.ATTR_MATRIX_COLS).getWidth()) <= this.nrOfColumns) {
            map.unmap();
            boolean canBeMapped = true;
            for (int i = 0; i < nrOfSegs; ++i) {
                canBeMapped &= map.tryMap(nrOfSegs - i - 1, this, this.selectedPin + i);
            }
            if (!canBeMapped) {
                map.unmap();
            }
            return canBeMapped;
        }
        if (fact instanceof RgbLed && (this.driving == '\u0005' || this.driving == '\u0003' || this.driving == '\u0004')) {
            map.unmap();
            return map.tryCompleteMap(this, this.selectedPin);
        }
        PartialMapDialog diag = new PartialMapDialog(this.selComp, this, parent);
        return diag.doit();
    }

    public boolean tryMap(JPanel parent) {
        int nrOfSwitches;
        if (!this.selectable) {
            return false;
        }
        if (this.selComp == null) {
            return false;
        }
        if (this.myType.equals((Object)IoComponentTypes.LedArray)) {
            return this.tryLedArrayMap(parent);
        }
        MapComponent map = this.selComp.getMap();
        if (this.selComp.getPin() >= 0 && this.nrOfPins == 1) {
            map.unmap(this.selComp.getPin());
            return map.tryMap(this.selComp.getPin(), this, 0);
        }
        if (this.selComp.getPin() >= 0 && this.selectedPin >= 0) {
            map.unmap(this.selComp.getPin());
            return map.tryMap(this.selComp.getPin(), this, this.selectedPin);
        }
        if (this.isCompleteMap()) {
            map.unmap();
            return map.tryMap(this);
        }
        if (this.myType.equals((Object)IoComponentTypes.DIPSwitch) && map.getComponentFactory() instanceof DipSwitch && (nrOfSwitches = map.getAttributeSet().getValue(DipSwitch.ATTR_SIZE).getWidth()) + this.selectedPin <= this.nrOfPins) {
            map.unmap();
            boolean canMap = true;
            for (int i = 0; i < nrOfSwitches; ++i) {
                canMap &= map.tryMap(i, this, i + this.selectedPin);
            }
            if (!canMap) {
                map.unmap();
            }
            return canMap;
        }
        PartialMapDialog diag = new PartialMapDialog(this.selComp, this, parent);
        return diag.doit();
    }

    private void paintMapped(Graphics2D g, float scale, int nrOfMaps) {
        int alpha;
        int x = AppPreferences.getScaled(this.myRectangle.getXpos(), scale);
        int y = AppPreferences.getScaled(this.myRectangle.getYpos(), scale);
        int width = AppPreferences.getScaled(this.myRectangle.getWidth(), scale);
        int height = AppPreferences.getScaled(this.myRectangle.getHeight(), scale);
        int n = alpha = this.highlighted && this.selectable ? 200 : 100;
        int color = this.containsMap() ? 6 : (this.selectable ? 7 : 5);
        Color col = BoardManipulator.getColor(color);
        if (col == null) {
            return;
        }
        g.setColor(new Color(col.getRed(), col.getGreen(), col.getBlue(), alpha));
        for (int i = 0; i < this.nrOfPins; ++i) {
            int n2 = !this.highlighted || !this.selectable ? 100 : (alpha = i == this.selectedPin && !this.isCompleteMap() ? 255 : 150);
            if (this.pinIsMapped.get(i) != null) {
                col = BoardManipulator.getColor(color);
                IoComponentTypes.paintPartialMap(g, i, height, width, this.nrOfPins, this.nrOfRows, this.nrOfColumns, this.myRotation, x, y, col, alpha, this.myType);
                continue;
            }
            if (!this.selectable) continue;
            col = BoardManipulator.getColor(8);
            IoComponentTypes.paintPartialMap(g, i, height, width, this.nrOfPins, this.nrOfRows, this.nrOfColumns, this.myRotation, x, y, col, alpha, this.myType);
        }
    }

    protected void paintSelected(Graphics2D g, float scale) {
        if (!this.selectable) {
            return;
        }
        int x = AppPreferences.getScaled(this.myRectangle.getXpos(), scale);
        int y = AppPreferences.getScaled(this.myRectangle.getYpos(), scale);
        int width = AppPreferences.getScaled(this.myRectangle.getWidth(), scale);
        int height = AppPreferences.getScaled(this.myRectangle.getHeight(), scale);
        int alpha = 150;
        Color col = BoardManipulator.getColor(8);
        if (col == null) {
            return;
        }
        if (this.nrOfPins == 0 && this.selectable) {
            alpha = this.highlighted ? 150 : 100;
            IoComponentTypes.paintPartialMap(g, 0, height, width, this.nrOfPins, this.nrOfRows, this.nrOfColumns, this.myRotation, x, y, col, alpha, this.myType);
        }
        for (int i = 0; i < this.nrOfPins; ++i) {
            int n = !this.highlighted ? 100 : (alpha = i == this.selectedPin && !this.isCompleteMap() ? 255 : 150);
            if (this.pinIsMapped.get(i) == null && !this.selectable) continue;
            IoComponentTypes.paintPartialMap(g, i, height, width, this.nrOfPins, this.nrOfRows, this.nrOfColumns, this.myRotation, x, y, col, alpha, this.myType);
        }
    }

    private static class mapType {
        private MapComponent map;
        private final int pin;

        public mapType(MapComponent map, int pin) {
            this.map = map;
            this.pin = pin;
        }

        public void unmap() {
            this.map.unmap(this.pin);
        }

        public void update(MapComponent map) {
            this.map = map;
        }

        public MapComponent getMap() {
            return this.map;
        }
    }

    public static class MapResultClass {
        public boolean mapResult;
        public int pinId;
    }
}

