/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.std.io.DipSwitch;
import com.cburch.logisim.std.io.ReptarLocalBus;
import com.cburch.logisim.std.io.RgbLed;
import com.cburch.logisim.std.io.SevenSegment;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.EnumSet;
import java.util.Set;

public enum IoComponentTypes {
    Led,
    Button,
    Pin,
    SevenSegment,
    SevenSegmentNoDp,
    DIPSwitch,
    RgbLed,
    LedArray,
    PortIo,
    LocalBus,
    Bus,
    Open,
    Constant,
    Unknown;

    public static final int ROTATION_ZERO = 0;
    public static final int ROTATION_CW_90 = -90;
    public static final int ROTATION_CCW_90 = 90;
    public static final Set<IoComponentTypes> KNOWN_COMPONENT_SET;
    public static final Set<IoComponentTypes> SIMPLE_INPUT_SET;
    public static final Set<IoComponentTypes> INPUT_COMPONENT_SET;
    public static final Set<IoComponentTypes> OUTPUT_COMPONENT_SET;
    public static final Set<IoComponentTypes> IN_OUT_COMPONENT_SET;

    public static IoComponentTypes getEnumFromString(String str) {
        for (IoComponentTypes elem : KNOWN_COMPONENT_SET) {
            if (!elem.name().equalsIgnoreCase(str)) continue;
            return elem;
        }
        return Unknown;
    }

    public static int getFpgaInOutRequirement(IoComponentTypes comp) {
        return switch (comp) {
            case PortIo -> 8;
            case LocalBus -> 16;
            default -> 0;
        };
    }

    public static int getFpgaInputRequirement(IoComponentTypes comp) {
        return switch (comp) {
            case Button -> 1;
            case DIPSwitch -> 8;
            case LocalBus -> 13;
            default -> 0;
        };
    }

    public static int getFpgaOutputRequirement(IoComponentTypes comp) {
        return switch (comp) {
            case Led -> 1;
            case SevenSegment -> 8;
            case SevenSegmentNoDp -> 7;
            case RgbLed -> 3;
            case LocalBus -> 2;
            case LedArray -> 16;
            default -> 0;
        };
    }

    public static boolean nrOfInputPinsConfigurable(IoComponentTypes comp) {
        return comp.equals((Object)DIPSwitch);
    }

    public static boolean nrOfOutputPinsConfigurable(IoComponentTypes comp) {
        return false;
    }

    public static boolean nrOfIoPinsConfigurable(IoComponentTypes comp) {
        return comp.equals((Object)PortIo);
    }

    public static String getInputLabel(int nrPins, int id, IoComponentTypes comp) {
        return switch (comp) {
            case DIPSwitch -> DipSwitch.getInputLabel(id);
            case LocalBus -> ReptarLocalBus.getInputLabel(id);
            default -> nrPins > 1 ? Strings.S.get("FpgaIoPins", id) : Strings.S.get("FpgaIoPin");
        };
    }

    public static Boolean hasRotationAttribute(IoComponentTypes comp) {
        return switch (comp) {
            case DIPSwitch, SevenSegment, LedArray -> true;
            default -> false;
        };
    }

    public static String getRotationString(IoComponentTypes comp, int rotation) {
        return switch (comp) {
            case DIPSwitch -> {
                switch (rotation) {
                    case -90: {
                        yield Strings.S.get("DipSwitchCW90");
                    }
                    case 90: {
                        yield Strings.S.get("DipSwitchCCW90");
                    }
                }
                yield Strings.S.get("DipSwitchZero");
            }
            case SevenSegment -> {
                switch (rotation) {
                    case -90: {
                        yield Strings.S.get("SevenSegmentCW90");
                    }
                    case 90: {
                        yield Strings.S.get("SevenSegmentCCW90");
                    }
                }
                yield Strings.S.get("SevenSegmentZero");
            }
            case LedArray -> {
                switch (rotation) {
                    case -90: {
                        yield Strings.S.get("LEDArrayCW90");
                    }
                    case 90: {
                        yield Strings.S.get("LEDArrayCCW90");
                    }
                }
                yield Strings.S.get("LEDArrayZero");
            }
            default -> Integer.toString(rotation);
        };
    }

    public static String getOutputLabel(int nrPins, int nrOfRows, int nrOfColumns, int id, IoComponentTypes comp) {
        switch (comp) {
            case SevenSegment: 
            case SevenSegmentNoDp: {
                return com.cburch.logisim.std.io.SevenSegment.getOutputLabel(id);
            }
            case RgbLed: {
                return com.cburch.logisim.std.io.RgbLed.getLabel(id);
            }
            case LocalBus: {
                return ReptarLocalBus.getOutputLabel(id);
            }
            case LedArray: {
                if (nrOfRows == 0 || nrOfColumns == 0 || id < 0 || id >= nrPins) break;
                int row = id / nrOfColumns;
                int col = id % nrOfColumns;
                return "Row_" + row + "_Col_" + col;
            }
        }
        return nrPins > 1 ? Strings.S.get("FpgaIoPins", id) : Strings.S.get("FpgaIoPin");
    }

    public static String getIoLabel(int nrPins, int id, IoComponentTypes comp) {
        return comp == LocalBus ? ReptarLocalBus.getIoLabel(id) : (nrPins > 1 ? Strings.S.get("FpgaIoPins", id) : Strings.S.get("FpgaIoPin"));
    }

    public static int getNrOfFPGAPins(IoComponentTypes comp) {
        return IoComponentTypes.getFpgaInOutRequirement(comp) + IoComponentTypes.getFpgaInputRequirement(comp) + IoComponentTypes.getFpgaOutputRequirement(comp);
    }

    private static int[][] getSevenSegmentDisplayArray(boolean hasDp) {
        boolean sa = false;
        boolean sb = true;
        int sc = 2;
        int sd = 3;
        int se = 4;
        int sf = 5;
        int sg = 6;
        int[][] indexes = new int[][]{{-1, 0, 0, -1, -1}, {5, -1, -1, 1, -1}, {5, -1, -1, 1, -1}, {-1, 6, 6, -1, -1}, {4, -1, -1, 2, -1}, {4, -1, -1, 2, -1}, {-1, 3, 3, -1, -1}};
        if (hasDp) {
            indexes[6][4] = 7;
        }
        return indexes;
    }

    public static void getPartialMapInfo(Integer[][] partialMap, int width, int height, int nrOfPins, int nrOfRows, int nrOfColumns, int mapRotation, IoComponentTypes type) {
        boolean hasDp = false;
        float part = 0.0f;
        float partX = 0.0f;
        float partY = 0.0f;
        switch (type) {
            case DIPSwitch: {
                part = switch (mapRotation) {
                    case -90, 90 -> (float)height / (float)nrOfPins;
                    default -> (float)width / (float)nrOfPins;
                };
                for (int widthIndex = 0; widthIndex < width; ++widthIndex) {
                    for (int heightIndex = 0; heightIndex < height; ++heightIndex) {
                        int pinIndex = 0;
                        pinIndex = switch (mapRotation) {
                            case 90 -> (int)((float)(height - heightIndex - 1) / part);
                            case -90 -> (int)((float)height / part);
                            default -> (int)((float)widthIndex / part);
                        };
                        partialMap[widthIndex][heightIndex] = pinIndex;
                    }
                }
                break;
            }
            case RgbLed: {
                part = (float)height / 3.0f;
                for (int w = 0; w < width; ++w) {
                    for (int h = 0; h < height; ++h) {
                        partialMap[w][h] = (int)((float)h / part);
                    }
                }
                break;
            }
            case SevenSegment: {
                hasDp = true;
            }
            case SevenSegmentNoDp: {
                int[][] indexes = IoComponentTypes.getSevenSegmentDisplayArray(hasDp);
                switch (mapRotation) {
                    case -90: 
                    case 90: {
                        partX = (float)width / 7.0f;
                        partY = (float)height / 5.0f;
                        break;
                    }
                    default: {
                        partX = (float)width / 5.0f;
                        partY = (float)height / 7.0f;
                    }
                }
                int xIndex = 0;
                int yIndex = 0;
                for (int w = 0; w < width; ++w) {
                    for (int h = 0; h < height; ++h) {
                        switch (mapRotation) {
                            case 90: {
                                xIndex = (int)((float)(height - h - 1) / partY);
                                yIndex = (int)((float)w / partX);
                                break;
                            }
                            case -90: {
                                xIndex = (int)((float)h / partY);
                                yIndex = (int)((float)(width - w - 1) / partX);
                                break;
                            }
                            default: {
                                xIndex = (int)((float)w / partX);
                                yIndex = (int)((float)h / partY);
                            }
                        }
                        partialMap[w][h] = indexes[yIndex][xIndex];
                    }
                }
                break;
            }
            case LedArray: {
                switch (mapRotation) {
                    case -90: 
                    case 90: {
                        partX = (float)width / (float)nrOfRows;
                        partY = (float)height / (float)nrOfColumns;
                        break;
                    }
                    default: {
                        partX = (float)width / (float)nrOfColumns;
                        partY = (float)height / (float)nrOfRows;
                    }
                }
                for (int w = 0; w < width; ++w) {
                    for (int h = 0; h < height; ++h) {
                        int realRow = 0;
                        int realColumn = 0;
                        switch (mapRotation) {
                            case 90: {
                                realRow = (int)((float)w / partX);
                                realColumn = (int)((float)(height - h - 1) / partY);
                                break;
                            }
                            case -90: {
                                realRow = (int)((float)(width - w - 1) / partX);
                                realColumn = (int)((float)h / partY);
                                break;
                            }
                            default: {
                                realRow = (int)((float)h / partY);
                                realColumn = (int)((float)w / partX);
                            }
                        }
                        partialMap[w][h] = realRow * nrOfColumns + realColumn;
                    }
                }
                break;
            }
            default: {
                for (int w = 0; w < width; ++w) {
                    for (int h = 0; h < height; ++h) {
                        partialMap[w][h] = -1;
                    }
                }
            }
        }
    }

    public static void paintPartialMap(Graphics2D g, int pinNr, int height, int width, int nrOfPins, int nrOfRows, int nrOfColumns, int mapRotation, int x, int y, Color col, int alpha, IoComponentTypes type) {
        g.setColor(new Color(col.getRed(), col.getGreen(), col.getBlue(), alpha));
        boolean hasDp = false;
        float part = 0.0f;
        int boxWidth = 0;
        int boxHeight = 0;
        int boxXpos = 0;
        int boxYpos = 0;
        float partX = 0.0f;
        float partY = 0.0f;
        switch (type) {
            case DIPSwitch: {
                int yPinNr = pinNr;
                switch (mapRotation) {
                    case 90: {
                        yPinNr = nrOfPins - pinNr - 1;
                    }
                    case -90: {
                        part = (float)height / (float)nrOfPins;
                        boxXpos = x;
                        boxWidth = width;
                        boxYpos = y + (int)((float)yPinNr * part);
                        boxHeight = (int)((float)(yPinNr + 1) * part) - (int)((float)yPinNr * part);
                        break;
                    }
                    default: {
                        part = (float)width / (float)nrOfPins;
                        boxXpos = x + (int)((float)pinNr * part);
                        boxYpos = y;
                        boxWidth = (int)((float)(pinNr + 1) * part) - (int)((float)pinNr * part);
                        boxHeight = height;
                    }
                }
                g.fillRect(boxXpos, boxYpos, boxWidth, boxHeight);
                break;
            }
            case RgbLed: {
                part = (float)height / 3.0f;
                int by = y + (int)((float)pinNr * part);
                int bh = (int)((float)(pinNr + 1) * part) - (int)((float)pinNr * part);
                g.fillRect(x, by, width, bh);
                break;
            }
            case SevenSegment: {
                hasDp = true;
            }
            case SevenSegmentNoDp: {
                int[][] indexes = IoComponentTypes.getSevenSegmentDisplayArray(hasDp);
                switch (mapRotation) {
                    case -90: 
                    case 90: {
                        partX = (float)width / 7.0f;
                        partY = (float)height / 5.0f;
                        break;
                    }
                    default: {
                        partX = (float)width / 5.0f;
                        partY = (float)height / 7.0f;
                    }
                }
                int realXIndex = 0;
                int realXIndexPlusOne = 0;
                int realYIndex = 0;
                int realYIndexPlusOne = 0;
                for (int xIndex = 0; xIndex < 5; ++xIndex) {
                    for (int yIndex = 0; yIndex < 7; ++yIndex) {
                        if (indexes[yIndex][xIndex] != pinNr) continue;
                        switch (mapRotation) {
                            case 90: {
                                realXIndex = yIndex;
                                realXIndexPlusOne = yIndex + 1;
                                realYIndex = 4 - xIndex;
                                realYIndexPlusOne = 5 - xIndex;
                                break;
                            }
                            case -90: {
                                realXIndex = 6 - yIndex;
                                realXIndexPlusOne = 7 - yIndex;
                                realYIndex = xIndex;
                                realYIndexPlusOne = xIndex + 1;
                                break;
                            }
                            default: {
                                realXIndex = xIndex;
                                realXIndexPlusOne = xIndex + 1;
                                realYIndex = yIndex;
                                realYIndexPlusOne = yIndex + 1;
                            }
                        }
                        boxXpos = x + (int)((float)realXIndex * partX);
                        boxYpos = y + (int)((float)realYIndex * partY);
                        boxWidth = (int)((float)realXIndexPlusOne * partX) - (int)((float)realXIndex * partX);
                        boxHeight = (int)((float)realYIndexPlusOne * partY) - (int)((float)realYIndex * partY);
                        g.fillRect(boxXpos, boxYpos, boxWidth, boxHeight);
                    }
                }
                break;
            }
            case LedArray: {
                int selectedColumn = pinNr % nrOfColumns;
                int selectedRow = pinNr / nrOfColumns;
                switch (mapRotation) {
                    case -90: 
                    case 90: {
                        partX = (float)width / (float)nrOfRows;
                        partY = (float)height / (float)nrOfColumns;
                        break;
                    }
                    default: {
                        partX = (float)width / (float)nrOfColumns;
                        partY = (float)height / (float)nrOfRows;
                    }
                }
                int xPosition = 0;
                int nextXPosition = 0;
                int yPosition = 0;
                int nextYPosition = 0;
                switch (mapRotation) {
                    case 90: {
                        xPosition = (int)((float)selectedRow * partX);
                        nextXPosition = (int)((float)(selectedRow + 1) * partX);
                        yPosition = (int)((float)(nrOfColumns - selectedColumn - 1) * partY);
                        nextYPosition = (int)((float)(nrOfColumns - selectedColumn) * partY);
                        break;
                    }
                    case -90: {
                        xPosition = (int)((float)(nrOfRows - selectedRow - 1) * partX);
                        nextXPosition = (int)((float)(nrOfRows - selectedRow) * partX);
                        yPosition = (int)((float)selectedColumn * partY);
                        nextYPosition = (int)((float)(selectedColumn + 1) * partY);
                        break;
                    }
                    default: {
                        xPosition = (int)((float)selectedColumn * partX);
                        nextXPosition = (int)((float)(selectedColumn + 1) * partX);
                        yPosition = (int)((float)selectedRow * partY);
                        nextYPosition = (int)((float)(selectedRow + 1) * partY);
                    }
                }
                boxXpos = x + xPosition;
                boxYpos = y + yPosition;
                boxWidth = nextXPosition - xPosition;
                boxHeight = nextYPosition - yPosition;
                g.fillRect(boxXpos, boxYpos, boxWidth, boxHeight);
                break;
            }
            default: {
                g.fillRect(x, y, width, height);
            }
        }
    }

    static {
        KNOWN_COMPONENT_SET = EnumSet.range(Led, LocalBus);
        SIMPLE_INPUT_SET = EnumSet.range(Led, LocalBus);
        INPUT_COMPONENT_SET = EnumSet.of(Button, Pin, DIPSwitch);
        OUTPUT_COMPONENT_SET = EnumSet.of(Led, new IoComponentTypes[]{Pin, RgbLed, SevenSegment, LedArray, SevenSegmentNoDp});
        IN_OUT_COMPONENT_SET = EnumSet.of(Pin, PortIo);
    }
}

