/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IoStandards {
    public static final String IO_ATTRIBUTE_STRING = "FPGAPinIOStandard";
    public static final char DEFAULT_STANDARD = '\u0000';
    public static final char LVCMOS12 = '\u0001';
    public static final char LVCMOS15 = '\u0002';
    public static final char LVCMOS18 = '\u0003';
    public static final char LVCMOS25 = '\u0004';
    public static final char LVCMOS33 = '\u0005';
    public static final char LVTTL = '\u0006';
    public static final char UNKNOWN = '\u00ff';
    public static final String[] BEHAVIOR_STRINGS = new String[]{"Default", "LVCMOS12", "LVCMOS15", "LVCMOS18", "LVCMOS25", "LVCMOS33", "LVTTL"};

    public static String getConstraintedIoStandard(char id) {
        return id > '\u0000' && id <= '\u0006' ? BEHAVIOR_STRINGS[id] : "";
    }

    public static char getId(String identifier) {
        char result = '\u0000';
        List<String> thelist = IoStandards.getStrings();
        Iterator<String> iter = thelist.iterator();
        result = '\u0000';
        while (iter.hasNext()) {
            if (iter.next().equals(identifier)) {
                return result;
            }
            result = (char)(result + '\u0001');
        }
        return '\u00ff';
    }

    public static List<String> getStrings() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(BEHAVIOR_STRINGS[0]);
        result.add(BEHAVIOR_STRINGS[1]);
        result.add(BEHAVIOR_STRINGS[2]);
        result.add(BEHAVIOR_STRINGS[3]);
        result.add(BEHAVIOR_STRINGS[4]);
        result.add(BEHAVIOR_STRINGS[5]);
        result.add(BEHAVIOR_STRINGS[6]);
        return result;
    }
}

