/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.circuit.CircuitMapInfo;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoComponentTypes;
import com.cburch.logisim.fpga.designrulecheck.BubbleInformationContainer;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.RgbLed;
import com.cburch.logisim.std.io.SevenSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class MapComponent {
    public static final String MAP_KEY = "key";
    public static final String COMPLETE_MAP = "map";
    public static final String OPEN_KEY = "open";
    public static final String CONSTANT_KEY = "vconst";
    public static final String PIN_MAP = "pmap";
    public static final String NO_MAP = "u";
    private static final int ONLY_IO_MAP_NAME = -2;
    private final Map<Integer, Integer> myInputBubbles = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> myOutputBubbles = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> myIoBubbles = new HashMap<Integer, Integer>();
    private final ComponentFactory myFactory;
    private final AttributeSet myAttributes;
    private final List<String> myName;
    private List<MapClass> maps = new ArrayList<MapClass>();
    private List<Boolean> opens = new ArrayList<Boolean>();
    private List<Integer> constants = new ArrayList<Integer>();
    private final List<String> pinLabels = new ArrayList<String>();
    private int nrOfPins;

    public MapComponent(List<String> name, netlistComponent comp) {
        int idx;
        int i;
        this.myFactory = comp.getComponent().getFactory();
        this.myAttributes = comp.getComponent().getAttributeSet();
        this.myName = name;
        ComponentMapInformationContainer mapInfo = comp.getMapInformationContainer();
        ArrayList<String> bName = new ArrayList<String>();
        for (int i2 = 1; i2 < name.size(); ++i2) {
            bName.add(name.get(i2));
        }
        BubbleInformationContainer BubbleInfo = comp.getGlobalBubbleId(bName);
        this.nrOfPins = 0;
        for (i = 0; i < mapInfo.getNrOfInPorts(); ++i) {
            this.maps.add(null);
            this.opens.add(false);
            this.constants.add(-1);
            idx = BubbleInfo == null ? -1 : BubbleInfo.getInputStartIndex() + i;
            this.pinLabels.add(mapInfo.getInPortLabel(i));
            this.myInputBubbles.put(this.nrOfPins++, idx);
        }
        for (i = 0; i < mapInfo.getNrOfOutPorts(); ++i) {
            this.maps.add(null);
            this.opens.add(false);
            this.constants.add(-1);
            idx = BubbleInfo == null ? -1 : BubbleInfo.getOutputStartIndex() + i;
            this.pinLabels.add(mapInfo.getOutPortLabel(i));
            this.myOutputBubbles.put(this.nrOfPins++, idx);
        }
        for (i = 0; i < mapInfo.getNrOfInOutPorts(); ++i) {
            this.maps.add(null);
            this.opens.add(false);
            this.constants.add(-1);
            idx = BubbleInfo == null ? -1 : BubbleInfo.getInOutStartIndex() + i;
            this.pinLabels.add(mapInfo.getInOutportLabel(i));
            this.myIoBubbles.put(this.nrOfPins++, idx);
        }
    }

    public ComponentFactory getComponentFactory() {
        return this.myFactory;
    }

    public AttributeSet getAttributeSet() {
        return this.myAttributes;
    }

    public int getNrOfPins() {
        return this.nrOfPins;
    }

    public boolean hasInputs() {
        return this.myInputBubbles.keySet().size() != 0;
    }

    public boolean hasOutputs() {
        return this.myOutputBubbles.keySet().size() != 0;
    }

    public boolean hasIos() {
        return this.myIoBubbles.keySet().size() != 0;
    }

    public boolean isInput(int pin) {
        return this.myInputBubbles.containsKey(pin);
    }

    public boolean isOutput(int pin) {
        return this.myOutputBubbles.containsKey(pin);
    }

    public boolean isIo(int pin) {
        return this.myIoBubbles.containsKey(pin);
    }

    public int nrInputs() {
        return this.myInputBubbles.keySet().size();
    }

    public int nrOutputs() {
        return this.myOutputBubbles.keySet().size();
    }

    public int nrIOs() {
        return this.myIoBubbles.keySet().size();
    }

    public int getIoBubblePinId(int id) {
        for (Integer key : this.myIoBubbles.keySet()) {
            if (this.myIoBubbles.get(key) != id) continue;
            return key;
        }
        return -1;
    }

    public String getPinLocation(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return null;
        }
        if (this.maps.get(pin) == null) {
            return null;
        }
        int iopin = this.maps.get(pin).getIoPin();
        return this.maps.get(pin).getIoComp().getPinLocation(iopin);
    }

    public boolean isMapped(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return false;
        }
        if (this.maps.get(pin) != null) {
            return true;
        }
        if (this.opens.get(pin).booleanValue()) {
            return true;
        }
        return this.constants.get(pin) >= 0;
    }

    public boolean isInternalMapped(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return false;
        }
        return this.isBoardMapped(pin) && this.maps.get(pin).getIoComp().getType().equals((Object)IoComponentTypes.LedArray);
    }

    public boolean isBoardMapped(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return false;
        }
        return this.maps.get(pin) != null;
    }

    public boolean isExternalInverted(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return false;
        }
        if (this.maps.get(pin) == null) {
            return false;
        }
        return this.maps.get(pin).getIoComp().getActivityLevel() == '\u0000';
    }

    public boolean requiresPullup(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return false;
        }
        if (this.maps.get(pin) == null) {
            return false;
        }
        return this.maps.get(pin).getIoComp().getPullBehavior() == '\u0001';
    }

    public FpgaIoInformationContainer getFpgaInfo(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return null;
        }
        if (this.maps.get(pin) == null) {
            return null;
        }
        return this.maps.get(pin).getIoComp();
    }

    public boolean equalsType(netlistComponent comp) {
        return this.myFactory.equals(comp.getComponent().getFactory());
    }

    public void unmap(int pin) {
        if (pin < 0 || pin >= this.maps.size()) {
            return;
        }
        if (this.myFactory instanceof RgbLed) {
            MapClass map1 = this.maps.get(0);
            MapClass map2 = this.maps.get(1);
            MapClass map3 = this.maps.get(2);
            if (map1 != null && map2 != null && map3 != null && map1.getIoComp().equals(map2.getIoComp()) && map2.getIoComp().equals(map3.getIoComp()) && this.maps.get(0).getIoPin() == this.maps.get(1).getIoPin() && this.maps.get(1).getIoPin() == this.maps.get(2).getIoPin()) {
                map1.unmap();
                map2.unmap();
                map3.unmap();
                for (int i = 0; i < 3; ++i) {
                    this.maps.set(i, null);
                    this.opens.set(i, false);
                    this.constants.set(i, -1);
                }
                return;
            }
        }
        MapClass map = this.maps.get(pin);
        this.maps.set(pin, null);
        if (map != null) {
            map.unmap();
        }
        this.opens.set(pin, false);
        this.constants.set(pin, -1);
    }

    public void unmap() {
        for (int i = 0; i < this.nrOfPins; ++i) {
            MapClass map = this.maps.get(i);
            if (map != null) {
                map.unmap();
            }
            this.opens.set(i, false);
            this.constants.set(i, -1);
        }
    }

    public void copyMapFrom(MapComponent comp) {
        if (comp.nrOfPins != this.nrOfPins || !comp.myFactory.equals(this.myFactory)) {
            comp.unmap();
            return;
        }
        this.maps = comp.maps;
        this.opens = comp.opens;
        this.constants = comp.constants;
        for (int i = 0; i < this.nrOfPins; ++i) {
            MapClass map = this.maps.get(i);
            if (map == null || map.update(this)) continue;
            this.unmap(i);
        }
    }

    public void tryMap(CircuitMapInfo cmap, List<FpgaIoInformationContainer> IOcomps) {
        if (cmap.isOpen()) {
            if (cmap.isSinglePin()) {
                int pin = cmap.getPinId();
                if (pin < 0 || pin >= this.nrOfPins) {
                    return;
                }
                this.unmap(pin);
                this.constants.set(pin, -1);
                this.opens.set(pin, true);
            } else {
                for (int i = 0; i < this.nrOfPins; ++i) {
                    this.unmap(i);
                    this.constants.set(i, -1);
                    this.opens.set(i, true);
                }
            }
        } else if (cmap.isConst()) {
            if (cmap.isSinglePin()) {
                int pin = cmap.getPinId();
                if (pin < 0 || pin >= this.nrOfPins) {
                    return;
                }
                this.unmap(pin);
                this.opens.set(pin, false);
                this.constants.set(pin, cmap.getConstValue().intValue() & 1);
            } else {
                long mask = 1L;
                Long val = cmap.getConstValue();
                for (int i = 0; i < this.nrOfPins; ++i) {
                    this.unmap(i);
                    this.opens.set(i, false);
                    int value = (val & mask) == 0L ? 0 : 1;
                    this.constants.set(i, value);
                    mask <<= 1;
                }
            }
        }
        if (cmap.getPinMaps() == null) {
            BoardRectangle rect = cmap.getRectangle();
            if (rect == null) {
                return;
            }
            for (FpgaIoInformationContainer comp : IOcomps) {
                if (!comp.getRectangle().isPointInside(rect.getXpos(), rect.getYpos()).booleanValue()) continue;
                if (cmap.isSinglePin()) {
                    this.tryMap(cmap.getPinId(), comp, cmap.getIoId());
                } else {
                    this.tryMap(comp);
                }
                break;
            }
        } else {
            List<CircuitMapInfo> pmaps = cmap.getPinMaps();
            if (pmaps.size() != this.nrOfPins) {
                return;
            }
            if (this.myFactory instanceof RgbLed) {
                boolean isPinMapped = true;
                for (int i = 0; i < this.nrOfPins; ++i) {
                    isPinMapped &= pmaps.get(i).isSinglePin();
                }
                if (isPinMapped) {
                    BoardRectangle rect1 = pmaps.get(0).getRectangle();
                    BoardRectangle rect2 = pmaps.get(1).getRectangle();
                    BoardRectangle rect3 = pmaps.get(2).getRectangle();
                    if (rect1.equals(rect2) && rect2.equals(rect3)) {
                        int iomap1 = pmaps.get(0).getIoId();
                        int iomap2 = pmaps.get(1).getIoId();
                        int iomap3 = pmaps.get(2).getIoId();
                        if (iomap1 == iomap2 && iomap2 == iomap3) {
                            for (FpgaIoInformationContainer comp : IOcomps) {
                                if (!comp.getRectangle().isPointInside(rect1.getXpos(), rect1.getYpos()).booleanValue()) continue;
                                this.tryCompleteMap(comp, iomap1);
                                return;
                            }
                        }
                    }
                }
            }
            for (int i = 0; i < this.nrOfPins; ++i) {
                this.opens.set(i, false);
                this.constants.set(i, -1);
                if (this.maps.get(i) != null) {
                    this.maps.get(i).unmap();
                }
                if (pmaps.get(i) == null) continue;
                if (pmaps.get(i).isOpen()) {
                    this.opens.set(i, true);
                    continue;
                }
                if (pmaps.get(i).isConst()) {
                    this.constants.set(i, pmaps.get(i).getConstValue().intValue());
                    continue;
                }
                if (!pmaps.get(i).isSinglePin()) continue;
                this.tryMap(pmaps.get(i), IOcomps);
            }
        }
    }

    public boolean tryCompleteMap(FpgaIoInformationContainer comp, int compPin) {
        MapClass map = new MapClass(comp, compPin);
        if (!comp.tryMap(this, 0, compPin)) {
            return false;
        }
        for (int i = 0; i < this.nrOfPins; ++i) {
            this.maps.set(i, map);
            this.opens.set(i, false);
            this.constants.set(i, -1);
        }
        return true;
    }

    public boolean tryMap(int myPin, FpgaIoInformationContainer comp, int compPin) {
        if (myPin < 0 || myPin >= this.nrOfPins) {
            return false;
        }
        MapClass map = new MapClass(comp, compPin);
        if (!comp.tryMap(this, myPin, compPin)) {
            return false;
        }
        this.maps.set(myPin, map);
        this.opens.set(myPin, false);
        this.constants.set(myPin, -1);
        return true;
    }

    public boolean tryMap(String PinKey, CircuitMapInfo cmap, List<FpgaIoInformationContainer> IOcomps) {
        String[] parts = PinKey.split("#");
        String number = null;
        if (parts.length != 2) {
            return false;
        }
        if (parts[1].contains("Pin")) {
            number = parts[1].substring(3);
        } else if (parts[1].contains("Button")) {
            number = parts[1].substring(6);
        } else {
            int id = 0;
            for (String key : SevenSegment.getLabels()) {
                if (parts[1].equals(key)) {
                    number = Integer.toString(id);
                }
                ++id;
            }
        }
        if (number != null) {
            try {
                int pinId = Integer.parseUnsignedInt(number);
                for (FpgaIoInformationContainer comp : IOcomps) {
                    if (!comp.getRectangle().isPointInside(cmap.getRectangle().getXpos(), cmap.getRectangle().getYpos()).booleanValue()) continue;
                    return this.tryMap(pinId, comp, 0);
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean tryMap(FpgaIoInformationContainer comp) {
        int i;
        ArrayList<MapClass> oldmaps = new ArrayList<MapClass>();
        ArrayList<Boolean> oldOpens = new ArrayList<Boolean>();
        ArrayList<Integer> oldConstants = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.nrOfPins; ++i2) {
            oldmaps.add(this.maps.get(i2));
            oldOpens.add(this.opens.get(i2));
            oldConstants.add(this.constants.get(i2));
        }
        boolean success = true;
        for (i = 0; i < this.nrOfPins; ++i) {
            MapClass newMap = new MapClass(comp, -1);
            MapClass oldMap = this.maps.get(i);
            if (oldMap != null) {
                oldMap.unmap();
            }
            if (this.myInputBubbles.containsKey(i)) {
                FpgaIoInformationContainer.MapResultClass res = comp.tryInputMap(this, i, i);
                success &= res.mapResult;
                newMap.setIOPin(res.pinId);
            } else if (this.myOutputBubbles.containsKey(i)) {
                int outputid = i - (this.myInputBubbles == null ? 0 : this.myInputBubbles.size());
                res = comp.tryOutputMap(this, i, outputid);
                success &= res.mapResult;
                newMap.setIOPin(res.pinId);
            } else if (this.myIoBubbles.containsKey(i)) {
                int ioid = i - (this.myInputBubbles == null ? 0 : this.myInputBubbles.size()) - (this.myOutputBubbles == null ? 0 : this.myOutputBubbles.size());
                res = comp.tryIOMap(this, i, ioid);
                success &= res.mapResult;
                newMap.setIOPin(res.pinId);
            } else {
                success = false;
                break;
            }
            if (!success) continue;
            this.maps.set(i, newMap);
            this.opens.set(i, false);
            this.constants.set(i, -1);
        }
        if (!success) {
            for (i = 0; i < this.nrOfPins && this.maps != null; ++i) {
                MapClass map;
                if (this.maps != null && this.maps.get(i) != null) {
                    this.maps.get(i).unmap();
                }
                if ((map = (MapClass)oldmaps.get(i)) != null && this.tryMap(i, map.getIoComp(), map.getIoPin())) {
                    this.maps.set(i, map);
                }
                this.opens.set(i, (Boolean)oldOpens.get(i));
                this.constants.set(i, (Integer)oldConstants.get(i));
            }
        }
        return success;
    }

    public boolean tryConstantMap(int pin, long value) {
        if (pin < 0) {
            long maskinp = 1L;
            boolean change = false;
            for (int i = 0; i < this.nrOfPins; ++i) {
                if (!this.myInputBubbles.containsKey(i)) continue;
                if (this.maps.get(i) != null) {
                    this.maps.get(i).unmap();
                }
                this.maps.set(i, null);
                this.constants.set(i, (value & maskinp) == 0L ? 0 : 1);
                this.opens.set(i, false);
                maskinp <<= 1;
                change = true;
            }
            return change;
        }
        if (this.myInputBubbles.containsKey(pin)) {
            if (this.maps.get(pin) != null) {
                this.maps.get(pin).unmap();
            }
            this.maps.set(pin, null);
            this.constants.set(pin, (int)(value & 1L));
            this.opens.set(pin, false);
            return true;
        }
        return false;
    }

    public boolean tryOpenMap(int pin) {
        if (pin < 0) {
            for (int i = 0; i < this.nrOfPins; ++i) {
                if (!this.myOutputBubbles.containsKey(i) && !this.myIoBubbles.containsKey(i)) continue;
                if (this.maps.get(i) != null) {
                    this.maps.get(i).unmap();
                }
                this.maps.set(i, null);
                this.constants.set(i, -1);
                this.opens.set(i, true);
            }
            return true;
        }
        if (this.myOutputBubbles.containsKey(pin) || this.myIoBubbles.containsKey(pin)) {
            if (this.maps.get(pin) != null) {
                this.maps.get(pin).unmap();
            }
            this.maps.set(pin, null);
            this.constants.set(pin, -1);
            this.opens.set(pin, true);
            return true;
        }
        return false;
    }

    public boolean hasMap() {
        for (int i = 0; i < this.nrOfPins; ++i) {
            if (this.opens.get(i).booleanValue()) {
                return true;
            }
            if (this.constants.get(i) >= 0) {
                return true;
            }
            if (this.maps.get(i) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isNotMapped() {
        for (int i = 0; i < this.nrOfPins; ++i) {
            if (this.opens.get(i).booleanValue()) {
                return false;
            }
            if (this.constants.get(i) >= 0) {
                return false;
            }
            if (this.maps.get(i) == null) continue;
            return false;
        }
        return true;
    }

    public boolean isOpenMapped(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return true;
        }
        return this.opens.get(pin);
    }

    public boolean isConstantMapped(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return false;
        }
        return this.constants.get(pin) >= 0;
    }

    public boolean isZeroConstantMap(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return true;
        }
        return this.constants.get(pin) == 0;
    }

    public boolean isCompleteMap(boolean bothSides) {
        FpgaIoInformationContainer io = null;
        int nrConstants = 0;
        int nrOpens = 0;
        int nrMaps = 0;
        for (int i = 0; i < this.nrOfPins; ++i) {
            if (this.opens.get(i).booleanValue()) {
                ++nrOpens;
                continue;
            }
            if (this.constants.get(i) >= 0) {
                ++nrConstants;
                continue;
            }
            if (this.maps.get(i) != null) {
                ++nrMaps;
                if (io == null) {
                    io = this.maps.get((int)i).IOcomp;
                    continue;
                }
                if (io.equals(this.maps.get((int)i).IOcomp)) continue;
                return false;
            }
            return false;
        }
        if (nrOpens != 0 && nrOpens == this.nrOfPins) {
            return true;
        }
        if (nrConstants != 0 && nrConstants == this.nrOfPins) {
            return true;
        }
        if (nrMaps != 0 && nrMaps == this.nrOfPins) {
            return !bothSides || io.isCompletelyMappedBy(this);
        }
        return false;
    }

    public String getHdlString(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (int i = 1; i < this.myName.size(); ++i) {
            s.append(i == 1 ? "" : "_").append(this.myName.get(i));
        }
        s.append(s.length() == 0 ? "" : "_").append(this.pinLabels.get(pin));
        return s.toString();
    }

    public String getHdlSignalName(int pin) {
        if (pin < 0 || pin >= this.nrOfPins) {
            return null;
        }
        if (this.myInputBubbles.containsKey(pin) && this.myInputBubbles.get(pin) >= 0) {
            return "s_logisimInputBubbles" + Hdl.bracketOpen() + this.myInputBubbles.get(pin) + Hdl.bracketClose();
        }
        if (this.myOutputBubbles.containsKey(pin) && this.myOutputBubbles.get(pin) >= 0) {
            return "s_logisimOutputBubbles" + Hdl.bracketOpen() + this.myOutputBubbles.get(pin) + Hdl.bracketClose();
        }
        StringBuilder s = new StringBuilder();
        s.append("s_");
        for (int i = 1; i < this.myName.size(); ++i) {
            s.append(i == 1 ? "" : "_").append(this.myName.get(i));
        }
        if (this.nrOfPins > 1) {
            s.append(Hdl.bracketOpen()).append(pin).append(Hdl.bracketClose());
        }
        return s.toString();
    }

    public String getDisplayString(int pin) {
        StringBuilder s = new StringBuilder();
        for (int i = 1; i < this.myName.size(); ++i) {
            s.append("/").append(this.myName.get(i));
        }
        if (pin >= 0) {
            if (pin < this.nrOfPins) {
                s.append("#").append(this.pinLabels.get(pin));
            } else {
                s.append("#unknown").append(pin);
            }
            if (this.opens.get(pin).booleanValue()) {
                s.append("->").append(Strings.S.get("MapOpen"));
            }
            if (this.constants.get(pin) >= 0) {
                s.append("->").append(this.constants.get(pin) & 1);
            }
        } else {
            boolean outAllOpens = this.nrOutputs() > 0;
            boolean ioAllOpens = this.nrIOs() > 0;
            boolean inpAllConst = this.nrInputs() > 0;
            boolean ioAllConst = ioAllOpens;
            long inpConst = 0L;
            long ioConst = 0L;
            String open = Strings.S.get("MapOpen");
            for (int i = this.nrOfPins - 1; i >= 0; --i) {
                if (this.myInputBubbles.containsKey(i)) {
                    inpAllConst &= this.constants.get(i) >= 0;
                    inpConst <<= 1;
                    inpConst |= (long)(this.constants.get(i) & 1);
                }
                if (this.myOutputBubbles.containsKey(i)) {
                    outAllOpens &= this.opens.get(i).booleanValue();
                }
                if (!this.myIoBubbles.containsKey(i)) continue;
                ioAllOpens &= this.opens.get(i).booleanValue();
                ioAllConst &= this.constants.get(i) >= 0;
                ioConst <<= 1;
                ioConst |= (long)(this.constants.get(i) & 1);
            }
            if (pin == -2) {
                return s.toString();
            }
            if (outAllOpens || ioAllOpens || inpAllConst || ioAllConst) {
                s.append("->");
            }
            boolean addcomma = false;
            if (inpAllConst) {
                s.append("0x").append(Long.toHexString(inpConst));
                addcomma = true;
            }
            if (outAllOpens) {
                if (addcomma) {
                    s.append(",");
                } else {
                    addcomma = true;
                }
                s.append(open);
            }
            if (ioAllOpens) {
                if (addcomma) {
                    s.append(",");
                } else {
                    addcomma = true;
                }
                s.append(open);
            }
            if (ioAllConst) {
                if (addcomma) {
                    s.append(",");
                } else {
                    addcomma = true;
                }
                s.append("0x").append(Long.toHexString(ioConst));
            }
        }
        return s.toString();
    }

    public void getMapElement(Element Map2) throws DOMException {
        if (!this.hasMap()) {
            return;
        }
        Map2.setAttribute(MAP_KEY, this.getDisplayString(-2));
        if (this.isCompleteMap(true)) {
            if (this.opens.get(0).booleanValue()) {
                Map2.setAttribute(OPEN_KEY, OPEN_KEY);
            } else if (this.constants.get(0) >= 0) {
                long value = 0L;
                for (int i = this.nrOfPins - 1; i >= 0; --i) {
                    value <<= 1;
                    value += (long)this.constants.get(i).intValue();
                }
                Map2.setAttribute(CONSTANT_KEY, Long.toString(value));
            } else {
                BoardRectangle rect = this.maps.get((int)0).IOcomp.getRectangle();
                Map2.setAttribute(COMPLETE_MAP, rect.getXpos() + "," + rect.getYpos());
            }
        } else {
            StringBuilder s = new StringBuilder();
            boolean first = true;
            for (int i = 0; i < this.nrOfPins; ++i) {
                if (first) {
                    first = false;
                } else {
                    s.append(",");
                }
                if (this.opens.get(i).booleanValue()) {
                    s.append(OPEN_KEY);
                    continue;
                }
                if (this.constants.get(i) >= 0) {
                    s.append(this.constants.get(i));
                    continue;
                }
                if (this.maps.get(i) != null) {
                    MapClass map = this.maps.get(i);
                    s.append(map.IOcomp.getRectangle().getXpos()).append("_").append(map.IOcomp.getRectangle().getYpos()).append("_").append(map.pin);
                    continue;
                }
                s.append(NO_MAP);
            }
            Map2.setAttribute(PIN_MAP, s.toString());
        }
    }

    public static void getComplexMap(Element Map2, CircuitMapInfo cmap) throws DOMException {
        List<CircuitMapInfo> pinmaps = cmap.getPinMaps();
        if (pinmaps != null) {
            StringBuilder s = new StringBuilder();
            boolean first = true;
            for (CircuitMapInfo pinmap : pinmaps) {
                if (first) {
                    first = false;
                } else {
                    s.append(",");
                }
                if (pinmap == null) {
                    s.append(NO_MAP);
                    continue;
                }
                if (pinmap.isConst()) {
                    s.append(pinmap.getConstValue());
                    continue;
                }
                if (pinmap.isOpen()) {
                    s.append(OPEN_KEY);
                    continue;
                }
                if (pinmap.isSinglePin()) {
                    s.append(pinmap.getRectangle().getXpos()).append("_").append(pinmap.getRectangle().getYpos()).append("_").append(pinmap.getIoId());
                    continue;
                }
                s.append(NO_MAP);
            }
            Map2.setAttribute(PIN_MAP, s.toString());
        } else {
            BoardRectangle br = cmap.getRectangle();
            if (br == null) {
                return;
            }
            Map2.setAttribute(COMPLETE_MAP, br.getXpos() + "," + br.getYpos());
        }
    }

    public static CircuitMapInfo getMapInfo(Element map) throws DOMException {
        if (map.hasAttribute(COMPLETE_MAP)) {
            String[] xy = map.getAttribute(COMPLETE_MAP).split(",");
            if (xy.length != 2) {
                return null;
            }
            try {
                int x = Integer.parseUnsignedInt(xy[0]);
                int y = Integer.parseUnsignedInt(xy[1]);
                return new CircuitMapInfo(x, y);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (map.hasAttribute(PIN_MAP)) {
            String[] maps = map.getAttribute(PIN_MAP).split(",");
            CircuitMapInfo complexI = new CircuitMapInfo();
            for (String s : maps) {
                if (s.equals(NO_MAP)) {
                    complexI.addPinMap(null);
                    continue;
                }
                if (s.equals(OPEN_KEY)) {
                    complexI.addPinMap(new CircuitMapInfo());
                    continue;
                }
                if (s.contains("_")) {
                    String[] parts = s.split("_");
                    if (parts.length != 3) {
                        return null;
                    }
                    try {
                        int x = Integer.parseUnsignedInt(parts[0]);
                        int y = Integer.parseUnsignedInt(parts[1]);
                        int pin = Integer.parseUnsignedInt(parts[2]);
                        complexI.addPinMap(x, y, pin);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                try {
                    long c = Long.parseUnsignedLong(s);
                    complexI.addPinMap(new CircuitMapInfo(c));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return complexI;
        }
        return null;
    }

    private static class MapClass {
        private final FpgaIoInformationContainer IOcomp;
        private Integer pin;

        public MapClass(FpgaIoInformationContainer IOcomp, Integer pin) {
            this.IOcomp = IOcomp;
            this.pin = pin;
        }

        public void unmap() {
            this.IOcomp.unmap(this.pin);
        }

        public boolean update(MapComponent comp) {
            return this.IOcomp.updateMap(this.pin, comp);
        }

        public FpgaIoInformationContainer getIoComp() {
            return this.IOcomp;
        }

        public int getIoPin() {
            return this.pin;
        }

        public void setIOPin(int value) {
            this.pin = value;
        }
    }
}

