/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.designrulecheck;

public class BubbleInformationContainer {
    private int myInBubblesStartIndex;
    private int myInBubblesEndIndex;
    private int myInOutBubblesStartIndex;
    private int myInOutBubblesEndIndex;
    private int myOutBubblesStartIndex;
    private int myOutBubblesEndIndex;

    public int getInOutEndIndex() {
        return this.myInOutBubblesEndIndex;
    }

    public int getInOutStartIndex() {
        return this.myInOutBubblesStartIndex;
    }

    public int getInputEndIndex() {
        return this.myInBubblesEndIndex;
    }

    public int getInputStartIndex() {
        return this.myInBubblesStartIndex;
    }

    public int getOutputEndIndex() {
        return this.myOutBubblesEndIndex;
    }

    public int getOutputStartIndex() {
        return this.myOutBubblesStartIndex;
    }

    public boolean hasInOutBubbles() {
        return this.myInOutBubblesStartIndex >= 0 && this.myInOutBubblesEndIndex >= 0;
    }

    public boolean hasInputBubbles() {
        return this.myInBubblesStartIndex >= 0 && this.myInBubblesEndIndex >= 0;
    }

    public boolean hasOutputBubbles() {
        return this.myOutBubblesStartIndex >= 0 && this.myOutBubblesEndIndex >= 0;
    }

    public int nrOfInOutBubbles() {
        if (this.myInOutBubblesStartIndex < 0 || this.myInOutBubblesEndIndex < 0) {
            return 0;
        }
        return this.myInOutBubblesEndIndex - this.myInOutBubblesStartIndex + 1;
    }

    public int nrOfInputBubbles() {
        if (this.myInBubblesStartIndex < 0 || this.myInBubblesEndIndex < 0) {
            return 0;
        }
        return this.myInBubblesEndIndex - this.myInBubblesStartIndex + 1;
    }

    public int nrOfOutputBubbles() {
        if (this.myOutBubblesStartIndex < 0 || this.myOutBubblesEndIndex < 0) {
            return 0;
        }
        return this.myOutBubblesEndIndex - this.myOutBubblesStartIndex + 1;
    }

    public void setInOutBubblesInformation(int startIndex, int endIndex) {
        this.myInOutBubblesStartIndex = startIndex;
        this.myInOutBubblesEndIndex = endIndex;
    }

    public void setInputBubblesInformation(int startIndex, int endIndex) {
        this.myInBubblesStartIndex = startIndex;
        this.myInBubblesEndIndex = endIndex;
    }

    public void setOutputBubblesInformation(int startIndex, int endIndex) {
        this.myOutBubblesStartIndex = startIndex;
        this.myOutBubblesEndIndex = endIndex;
    }
}

