/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.designrulecheck;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.Splitter;
import com.cburch.logisim.circuit.SplitterAttributes;
import com.cburch.logisim.circuit.SplitterFactory;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.designrulecheck.ClockSourceContainer;
import com.cburch.logisim.fpga.designrulecheck.ClockTreeFactory;
import com.cburch.logisim.fpga.designrulecheck.ConnectionEnd;
import com.cburch.logisim.fpga.designrulecheck.ConnectionPoint;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.designrulecheck.Net;
import com.cburch.logisim.fpga.designrulecheck.SimpleDrcContainer;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.wiring.Clock;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.std.wiring.Probe;
import com.cburch.logisim.std.wiring.Tunnel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;

public class Netlist {
    private String circuitName;
    private final ArrayList<Net> myNets = new ArrayList();
    private final ArrayList<netlistComponent> mySubCircuits = new ArrayList();
    private final ArrayList<netlistComponent> myComponents = new ArrayList();
    private final ArrayList<netlistComponent> myClockGenerators = new ArrayList();
    private final ArrayList<netlistComponent> myInOutPorts = new ArrayList();
    private final ArrayList<netlistComponent> myInputPorts = new ArrayList();
    private final ArrayList<netlistComponent> myOutputPorts = new ArrayList();
    private final ArrayList<Component> mySplitters = new ArrayList();
    private Integer localNrOfInportBubbles;
    private Integer localNrOfOutportBubbles;
    private Integer localNrOfInOutBubbles;
    private final ClockTreeFactory myClockInformation = new ClockTreeFactory();
    private final Circuit myCircuit;
    private int drcStatus;
    private final Set<Wire> wires = new HashSet<Wire>();
    private ArrayList<String> currentHierarchyLevel;
    public static final int DRC_REQUIRED = 4;
    public static final int DRC_PASSED = 0;
    public static final int ANNOTATE_REQUIRED = 1;
    public static final int DRC_ERROR = 2;
    public static final Color DRC_INSTANCE_MARK_COLOR = Color.RED;
    public static final Color DRC_LABEL_MARK_COLOR = Color.MAGENTA;
    public static final Color DRC_WIRE_MARK_COLOR = Color.RED;

    public Netlist(Circuit ThisCircuit) {
        this.myCircuit = ThisCircuit;
        this.clear();
    }

    public void cleanClockTree(ClockSourceContainer ClockSources) {
        this.myClockInformation.clean();
        this.myClockInformation.setSourceContainer(ClockSources);
        for (netlistComponent sub : this.mySubCircuits) {
            SubcircuitFactory subFact = (SubcircuitFactory)sub.getComponent().getFactory();
            subFact.getSubcircuit().getNetList().cleanClockTree(ClockSources);
        }
    }

    public void clear() {
        for (netlistComponent subcirc : this.mySubCircuits) {
            SubcircuitFactory subFact = (SubcircuitFactory)subcirc.getComponent().getFactory();
            subFact.getSubcircuit().getNetList().clear();
        }
        this.drcStatus = 4;
        this.myNets.clear();
        this.mySubCircuits.clear();
        this.myComponents.clear();
        this.myClockGenerators.clear();
        this.myInputPorts.clear();
        this.myInOutPorts.clear();
        this.myOutputPorts.clear();
        this.mySplitters.clear();
        this.localNrOfInportBubbles = 0;
        this.localNrOfOutportBubbles = 0;
        this.localNrOfInOutBubbles = 0;
        if (this.currentHierarchyLevel == null) {
            this.currentHierarchyLevel = new ArrayList();
        } else {
            this.currentHierarchyLevel.clear();
        }
    }

    public String getName() {
        if (this.myCircuit != null) {
            return this.myCircuit.getName();
        }
        return "Unknown";
    }

    public void constructHierarchyTree(Set<String> circuits, ArrayList<String> name, Integer gInputId, Integer gOutputId, Integer gInOutId) {
        if (circuits == null) {
            circuits = new HashSet<String>();
        }
        this.localNrOfInportBubbles = 0;
        this.localNrOfOutportBubbles = 0;
        this.localNrOfInOutBubbles = 0;
        for (netlistComponent comp : this.mySubCircuits) {
            boolean firstTime;
            SubcircuitFactory subFactory = (SubcircuitFactory)comp.getComponent().getFactory();
            ArrayList<String> names = new ArrayList<String>(name);
            names.add(CorrectLabel.getCorrectLabel(comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
            boolean bl = firstTime = !circuits.contains(subFactory.getName());
            if (firstTime) {
                circuits.add(subFactory.getName());
                subFactory.getSubcircuit().getNetList().constructHierarchyTree(circuits, names, gInputId, gOutputId, gInOutId);
            }
            int subInputBubbles = subFactory.getSubcircuit().getNetList().getNumberOfInputBubbles();
            int subInOutBubbles = subFactory.getSubcircuit().getNetList().numberOfInOutBubbles();
            int subOutputBubbles = subFactory.getSubcircuit().getNetList().numberOfOutputBubbles();
            comp.setLocalBubbleID(this.localNrOfInportBubbles, subInputBubbles, this.localNrOfOutportBubbles, subOutputBubbles, this.localNrOfInOutBubbles, subInOutBubbles);
            this.localNrOfInportBubbles = this.localNrOfInportBubbles + subInputBubbles;
            this.localNrOfInOutBubbles = this.localNrOfInOutBubbles + subInOutBubbles;
            this.localNrOfOutportBubbles = this.localNrOfOutportBubbles + subOutputBubbles;
            comp.addGlobalBubbleId(names, gInputId, subInputBubbles, gOutputId, subOutputBubbles, gInOutId, subInOutBubbles);
            if (!firstTime) {
                subFactory.getSubcircuit().getNetList().enumerateGlobalBubbleTree(names, gInputId, gOutputId, gInOutId);
            }
            gInputId = gInputId + subInputBubbles;
            gInOutId = gInOutId + subInOutBubbles;
            gOutputId = gOutputId + subOutputBubbles;
        }
        for (netlistComponent comp : this.myComponents) {
            if (comp.getMapInformationContainer() == null) continue;
            ArrayList<String> myHierarchyName = new ArrayList<String>(name);
            myHierarchyName.add(CorrectLabel.getCorrectLabel(comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
            int subInputBubbles = comp.getMapInformationContainer().getNrOfInPorts();
            int subInOutBubbles = comp.getMapInformationContainer().getNrOfInOutPorts();
            int subOutputBubbles = comp.getMapInformationContainer().getNrOfOutPorts();
            comp.setLocalBubbleID(this.localNrOfInportBubbles, subInputBubbles, this.localNrOfOutportBubbles, subOutputBubbles, this.localNrOfInOutBubbles, subInOutBubbles);
            this.localNrOfInportBubbles = this.localNrOfInportBubbles + subInputBubbles;
            this.localNrOfInOutBubbles = this.localNrOfInOutBubbles + subInOutBubbles;
            this.localNrOfOutportBubbles = this.localNrOfOutportBubbles + subOutputBubbles;
            comp.addGlobalBubbleId(myHierarchyName, gInputId, subInputBubbles, gOutputId, subOutputBubbles, gInOutId, subInOutBubbles);
            gInputId = gInputId + subInputBubbles;
            gInOutId = gInOutId + subInOutBubbles;
            gOutputId = gOutputId + subOutputBubbles;
        }
    }

    public int designRuleCheckResult(boolean isTopLevel, ArrayList<String> sheetNames) {
        ArrayList<String> compNames = new ArrayList<String>();
        HashMap<String, Component> labels = new HashMap<String, Component>();
        ArrayList<SimpleDrcContainer> drc = new ArrayList<SimpleDrcContainer>();
        if (isTopLevel) {
            this.clear();
        }
        if (this.drcStatus == 0) {
            return 0;
        }
        this.drcStatus = 0;
        if (this.myCircuit.getName().isEmpty()) {
            Reporter.report.addFatalError(Strings.S.get("EmptyNamedSheet"));
            this.drcStatus |= 2;
        }
        if (sheetNames.contains(this.myCircuit.getName())) {
            Reporter.report.addFatalError(Strings.S.get("MultipleSheetSameName", this.myCircuit.getName()));
            this.drcStatus |= 2;
        } else {
            sheetNames.add(this.myCircuit.getName());
        }
        ArrayList<Circuit> handledCircuits = new ArrayList<Circuit>();
        for (Component component : this.myCircuit.getNonWires()) {
            SubcircuitFactory factory;
            Circuit subCircuit;
            ComponentFactory componentFactory = component.getFactory();
            if (!(componentFactory instanceof SubcircuitFactory) || handledCircuits.contains(subCircuit = (factory = (SubcircuitFactory)componentFactory).getSubcircuit())) continue;
            handledCircuits.add(subCircuit);
            if (subCircuit.getNetList().designRuleCheckResult(false, sheetNames) == 0) continue;
            this.drcStatus = 4;
            return 2;
        }
        for (Component component : this.myCircuit.getNonWires()) {
            String compName = component.getFactory().getHDLName(component.getAttributeSet());
            if (compNames.contains(compName)) continue;
            compNames.add(compName);
        }
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("HDL_noLabel"), 3, 1));
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("HDL_CompNameIsLabel"), 3, 3));
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("HDL_LabelInvalid"), 3, 3));
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("HDL_DuplicatedLabels"), 3, 3));
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("HDL_Tristate"), 3, 1));
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("HDL_unsupported"), 3, 1));
        for (Component component : this.myCircuit.getNonWires()) {
            if (!component.getFactory().isHDLSupportedComponent(component.getAttributeSet())) {
                ((SimpleDrcContainer)drc.get(5)).addMarkComponent(component);
                this.drcStatus |= 2;
            }
            if (component.getFactory().requiresNonZeroLabel()) {
                String label = CorrectLabel.getCorrectLabel(component.getAttributeSet().getValue(StdAttr.LABEL)).toUpperCase();
                String componentName = component.getFactory().getHDLName(component.getAttributeSet());
                if (label.isEmpty()) {
                    ((SimpleDrcContainer)drc.get(0)).addMarkComponent(component);
                    this.drcStatus |= 1;
                } else {
                    if (compNames.contains(label)) {
                        ((SimpleDrcContainer)drc.get(1)).addMarkComponent(component);
                        this.drcStatus |= 2;
                    }
                    if (!CorrectLabel.isCorrectLabel(label)) {
                        ((SimpleDrcContainer)drc.get(2)).addMarkComponent(component);
                        this.drcStatus |= 2;
                    }
                    if (labels.containsKey(label)) {
                        ((SimpleDrcContainer)drc.get(3)).addMarkComponent(component);
                        ((SimpleDrcContainer)drc.get(3)).addMarkComponent(labels.get(label));
                        this.drcStatus |= 2;
                    } else {
                        labels.put(label, component);
                    }
                }
                ComponentFactory componentFactory = component.getFactory();
                if (componentFactory instanceof SubcircuitFactory) {
                    SubcircuitFactory sub = (SubcircuitFactory)componentFactory;
                    if (label.equals(componentName.toUpperCase())) {
                        ((SimpleDrcContainer)drc.get(1)).addMarkComponent(component);
                        this.drcStatus |= 2;
                    }
                    if (!CorrectLabel.isCorrectLabel(component.getFactory().getName(), Strings.S.get("FoundBadComponent", component.getFactory().getName(), this.myCircuit.getName()))) {
                        this.drcStatus |= 2;
                    }
                    this.localNrOfInportBubbles = this.localNrOfInportBubbles + sub.getSubcircuit().getNetList().getNumberOfInputBubbles();
                    this.localNrOfOutportBubbles = this.localNrOfOutportBubbles + sub.getSubcircuit().getNetList().numberOfOutputBubbles();
                    this.localNrOfInOutBubbles = this.localNrOfInOutBubbles + sub.getSubcircuit().getNetList().numberOfInOutBubbles();
                }
            }
            if (!component.getFactory().hasThreeStateDrivers(component.getAttributeSet())) continue;
            ((SimpleDrcContainer)drc.get(4)).addMarkComponent(component);
            this.drcStatus |= 2;
        }
        for (SimpleDrcContainer simpleDrcContainer : drc) {
            if (!simpleDrcContainer.isDrcInfoPresent()) continue;
            Reporter.report.addError(simpleDrcContainer);
        }
        drc.clear();
        if (this.drcStatus != 0) {
            return this.drcStatus;
        }
        Reporter.report.addInfo(Strings.S.get("BuildingNetlistFor", this.myCircuit.getName()));
        if (!this.generateNetlist()) {
            this.clear();
            this.drcStatus = 2;
            return this.drcStatus;
        }
        if (this.netlistHasShortCircuits()) {
            this.clear();
            this.drcStatus = 2;
            return this.drcStatus;
        }
        this.netlistHasSinksWithoutSource();
        for (netlistComponent netlistComponent2 : this.myComponents) {
            boolean openInputs = false;
            for (int j = 0; j < netlistComponent2.nrOfEnds(); ++j) {
                if (!netlistComponent2.isEndInput(j) || netlistComponent2.isEndConnected(j)) continue;
                openInputs = true;
            }
            if (!openInputs || AppPreferences.SupressOpenPinWarnings.get().booleanValue()) continue;
            SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_UnconnectedInputs"), 1, 1);
            warn.addMarkComponent(netlistComponent2.getComponent());
            Reporter.report.addWarning(warn);
        }
        for (netlistComponent netlistComponent3 : this.mySubCircuits) {
            boolean openInputs = false;
            for (int j = 0; j < netlistComponent3.nrOfEnds(); ++j) {
                if (!netlistComponent3.isEndInput(j) || netlistComponent3.isEndConnected(j)) continue;
                openInputs = true;
            }
            if (!openInputs || AppPreferences.SupressOpenPinWarnings.get().booleanValue()) continue;
            SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_UnconnectedInputs"), 2, 1);
            warn.addMarkComponent(netlistComponent3.getComponent());
            Reporter.report.addWarning(warn);
        }
        for (netlistComponent netlistComponent4 : this.myInputPorts) {
            boolean openInputs = false;
            for (int j = 0; j < netlistComponent4.nrOfEnds(); ++j) {
                if (netlistComponent4.isEndConnected(j)) continue;
                openInputs = true;
            }
            if (!openInputs || AppPreferences.SupressOpenPinWarnings.get().booleanValue()) continue;
            SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_UnconnectedInput"), 1, 1);
            warn.addMarkComponent(netlistComponent4.getComponent());
            Reporter.report.addWarning(warn);
        }
        for (netlistComponent netlistComponent5 : this.myOutputPorts) {
            boolean openOutputs = false;
            for (int j = 0; j < netlistComponent5.nrOfEnds(); ++j) {
                if (netlistComponent5.isEndConnected(j)) continue;
                openOutputs = true;
            }
            if (!openOutputs || AppPreferences.SupressOpenPinWarnings.get().booleanValue()) continue;
            SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_UnconnectedOutput"), 1, 1);
            warn.addMarkComponent(netlistComponent5.getComponent());
            Reporter.report.addWarning(warn);
        }
        if (isTopLevel) {
            if (!this.detectClockTree()) {
                this.drcStatus = 2;
                return this.drcStatus;
            }
            this.constructHierarchyTree(null, new ArrayList<String>(), 0, 0, 0);
            int ports = this.getNumberOfInputPorts() + this.numberOfOutputPorts() + this.localNrOfInportBubbles + this.localNrOfOutportBubbles + this.localNrOfInOutBubbles;
            if (ports == 0) {
                Reporter.report.addFatalError(Strings.S.get("TopLevelNoIO", this.myCircuit.getName()));
                this.drcStatus = 2;
                return this.drcStatus;
            }
            if (!this.detectGatedClocks()) {
                this.drcStatus = 2;
                return this.drcStatus;
            }
        }
        Reporter.report.addInfo(Strings.S.get("CircuitInfoString", this.myCircuit.getName(), this.numberOfNets(), this.numberOfBusses()));
        Reporter.report.addInfo(Strings.S.get("DRCPassesString", this.myCircuit.getName()));
        this.drcStatus = 0;
        return this.drcStatus;
    }

    private boolean detectClockTree() {
        ClockSourceContainer clockSources = this.myClockInformation.getSourceContainer();
        this.cleanClockTree(clockSources);
        ArrayList<Netlist> hierarchyNetlists = new ArrayList<Netlist>();
        hierarchyNetlists.add(this);
        return this.markClockSourceComponents(new ArrayList<String>(), hierarchyNetlists, clockSources);
    }

    private void enumerateGlobalBubbleTree(ArrayList<String> hierarchyname, int startInputID, int startOutputID, int startInOutID) {
        for (netlistComponent comp : this.mySubCircuits) {
            SubcircuitFactory sub = (SubcircuitFactory)comp.getComponent().getFactory();
            ArrayList<String> myHierarchyName = new ArrayList<String>(hierarchyname);
            myHierarchyName.add(CorrectLabel.getCorrectLabel(comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
            sub.getSubcircuit().getNetList().enumerateGlobalBubbleTree(myHierarchyName, startInputID + comp.getLocalBubbleInputStartId(), startOutputID + comp.getLocalBubbleOutputStartId(), startInOutID + comp.getLocalBubbleInOutStartId());
        }
        for (netlistComponent comp : this.myComponents) {
            if (comp.getMapInformationContainer() == null) continue;
            ArrayList<String> myHierarchyName = new ArrayList<String>(hierarchyname);
            myHierarchyName.add(CorrectLabel.getCorrectLabel(comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
            int subInputBubbles = comp.getMapInformationContainer().getNrOfInPorts();
            int subInOutBubbles = comp.getMapInformationContainer().getNrOfInOutPorts();
            int subOutputBubbles = comp.getMapInformationContainer().getNrOfOutPorts();
            comp.addGlobalBubbleId(myHierarchyName, startInputID + comp.getLocalBubbleInputStartId(), subInputBubbles, startOutputID + comp.getLocalBubbleOutputStartId(), subOutputBubbles, startInOutID, subInOutBubbles);
        }
    }

    private Net findConnectedNet(Location loc) {
        for (Net current : this.myNets) {
            if (!current.contains(loc)) continue;
            return current;
        }
        return null;
    }

    private boolean generateNetlist() {
        byte b;
        SplitterAttributes sattrs;
        boolean bl;
        ArrayList<SimpleDrcContainer> drc = new ArrayList<SimpleDrcContainer>();
        boolean errors = false;
        this.circuitName = this.myCircuit.getName();
        JProgressBar progress = Reporter.report.getProgressBar();
        int curMax = 0;
        int curVal = 0;
        String curStr = "";
        if (progress != null) {
            curMax = progress.getMaximum();
            curVal = progress.getValue();
            curStr = progress.getString();
            progress.setMaximum(7);
            progress.setString(Strings.S.get("NetListBuild", this.circuitName, 1));
        }
        this.wires.clear();
        this.wires.addAll(this.myCircuit.getWires());
        while (this.wires.size() != 0) {
            Net newNet = new Net();
            this.getNet(null, newNet);
            if (newNet.isEmpty()) continue;
            this.myNets.add(newNet);
        }
        Set<Component> components = this.myCircuit.getNonWires();
        HashSet<Location> outputsList = new HashSet<Location>();
        HashSet<Location> inputsList = new HashSet<Location>();
        HashSet<Component> tunnelList = new HashSet<Component>();
        this.mySplitters.clear();
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_IOError"), 3, 1));
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_BitwidthError"), 3, 4));
        for (Component component : components) {
            boolean ignore = false;
            if (component.getFactory() instanceof Probe) continue;
            if (component.getFactory() instanceof SplitterFactory) {
                this.mySplitters.add(component);
                ignore = true;
            }
            if (component.getFactory() instanceof Tunnel) {
                tunnelList.add(component);
                ignore = true;
            }
            List<EndData> ends = component.getEnds();
            Iterator<EndData> iterator = ends.iterator();
            while (iterator.hasNext()) {
                EndData end = iterator.next();
                if (!(ignore || end.isInput() && end.isOutput())) {
                    if (end.isOutput()) {
                        outputsList.add(end.getLocation());
                    } else {
                        inputsList.add(end.getLocation());
                    }
                }
                int width = end.getWidth().getWidth();
                Location loc = end.getLocation();
                for (Net thisNet : this.myNets) {
                    if (!thisNet.contains(loc) || thisNet.setWidth(width)) continue;
                    ((SimpleDrcContainer)drc.get(1)).addMarkComponents(thisNet.getWires());
                }
            }
        }
        for (SimpleDrcContainer simpleDrcContainer : drc) {
            if (!simpleDrcContainer.isDrcInfoPresent()) continue;
            errors = true;
            Reporter.report.addError(simpleDrcContainer);
        }
        if (errors) {
            return false;
        }
        if (progress != null) {
            progress.setValue(1);
            progress.setString(Strings.S.get("NetListBuild", this.circuitName, 2));
        }
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetAdd_ComponentWidthMismatch"), 3, 1));
        HashMap<Location, Integer> points = new HashMap<Location, Integer>();
        for (Component comp : components) {
            for (EndData end : comp.getEnds()) {
                Location loc = end.getLocation();
                if (points.containsKey(loc)) {
                    boolean newNet = true;
                    for (Net net : this.myNets) {
                        if (!net.contains(loc)) continue;
                        newNet = false;
                    }
                    if (!newNet) continue;
                    Integer bitWidth = (Integer)points.get(loc);
                    if (bitWidth.intValue() == end.getWidth().getWidth()) {
                        this.myNets.add(new Net(loc, bitWidth));
                        continue;
                    }
                    ((SimpleDrcContainer)drc.get(0)).addMarkComponent(comp);
                    continue;
                }
                points.put(loc, end.getWidth().getWidth());
            }
        }
        if (((SimpleDrcContainer)drc.get(0)).isDrcInfoPresent()) {
            Reporter.report.addError(drc.get(0));
            return false;
        }
        if (progress != null) {
            progress.setValue(2);
            progress.setString(Strings.S.get("NetListBuild", this.circuitName, 3));
        }
        boolean bl2 = false;
        for (Component comp : tunnelList) {
            List<EndData> ends = comp.getEnds();
            for (EndData end : ends) {
                for (Net thisNet : this.myNets) {
                    if (!thisNet.contains(end.getLocation())) continue;
                    thisNet.addTunnel(comp.getAttributeSet().getValue(StdAttr.LABEL));
                    bl = true;
                }
            }
        }
        drc.clear();
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetMerge_BitWidthError"), 3, 4));
        if (bl) {
            ListIterator<Net> netIterator = this.myNets.listIterator();
            while (netIterator.hasNext()) {
                Net thisNet = netIterator.next();
                if (!thisNet.hasTunnel() || this.myNets.indexOf(thisNet) >= this.myNets.size() - 1) continue;
                boolean merged = false;
                ListIterator<Net> searchIterator = this.myNets.listIterator(this.myNets.indexOf(thisNet) + 1);
                while (searchIterator.hasNext() && !merged) {
                    Net searchNet = searchIterator.next();
                    for (String name : thisNet.getTunnelNames()) {
                        if (!searchNet.containsTunnel(name) || merged) continue;
                        merged = true;
                        if (searchNet.merge(thisNet)) continue;
                        ((SimpleDrcContainer)drc.get(0)).addMarkComponents(searchNet.getWires());
                        ((SimpleDrcContainer)drc.get(0)).addMarkComponents(thisNet.getWires());
                    }
                }
                if (!merged) continue;
                netIterator.remove();
            }
        }
        if (((SimpleDrcContainer)drc.get(0)).isDrcInfoPresent()) {
            Reporter.report.addError(drc.get(0));
            return false;
        }
        if (progress != null) {
            progress.setValue(3);
            progress.setString(Strings.S.get("NetListBuild", this.circuitName, 4));
        }
        Iterator<Component> mySplitIter = this.mySplitters.listIterator();
        while (mySplitIter.hasNext()) {
            Component thisSplitter = (Component)mySplitIter.next();
            if (this.mySplitters.indexOf(thisSplitter) >= this.mySplitters.size() - 1) continue;
            boolean dupeFound = false;
            ListIterator<Component> searchIter = this.mySplitters.listIterator(this.mySplitters.indexOf(thisSplitter) + 1);
            while (searchIter.hasNext() && !dupeFound) {
                Component SearchSplitter = searchIter.next();
                if (!SearchSplitter.getLocation().equals(thisSplitter.getLocation())) continue;
                dupeFound = true;
                for (int i = 0; i < SearchSplitter.getEnds().size(); ++i) {
                    if (SearchSplitter.getEnd(i).getLocation().equals(thisSplitter.getEnd(i).getLocation())) continue;
                    dupeFound = false;
                }
            }
            if (!dupeFound) continue;
            SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_duplicatedSplitter"), 2, 1);
            warn.addMarkComponent(thisSplitter);
            Reporter.report.addWarning(warn);
            mySplitIter.remove();
        }
        drc.clear();
        ListIterator<Net> netIterator = this.myNets.listIterator();
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_emptynets"), 1, 4));
        while (netIterator.hasNext()) {
            Net wire = (Net)netIterator.next();
            if (wire.getBitWidth() != 0) continue;
            ((SimpleDrcContainer)drc.get(0)).addMarkComponents(wire.getWires());
            netIterator.remove();
        }
        if (((SimpleDrcContainer)drc.get(0)).isDrcInfoPresent()) {
            Reporter.report.addWarning(drc.get(0));
        }
        mySplitIter = this.mySplitters.iterator();
        drc.clear();
        drc.add(new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_ShortCircuit"), 3, 4));
        errors = false;
        while (mySplitIter.hasNext()) {
            Component mySplitter = mySplitIter.next();
            int busWidth = mySplitter.getEnd(0).getWidth().getWidth();
            List<EndData> myEnds = mySplitter.getEnds();
            int maxFanoutWidth = 0;
            int index = -1;
            for (int i = 1; i < myEnds.size(); ++i) {
                int width = mySplitter.getEnd(i).getWidth().getWidth();
                if (width <= maxFanoutWidth) continue;
                maxFanoutWidth = width;
                index = i;
            }
            if (busWidth != maxFanoutWidth) continue;
            Net busnet = null;
            Net connectedNet = null;
            Location busLoc = mySplitter.getEnd(0).getLocation();
            Location connectedLoc = mySplitter.getEnd(index).getLocation();
            boolean issueWarning = false;
            for (Net currentNet : this.myNets) {
                if (currentNet.contains(busLoc)) {
                    if (busnet != null) {
                        Reporter.report.addFatalErrorFmt("BUG: Multiple bus nets found for a single splitter\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                        return false;
                    }
                    busnet = currentNet;
                }
                if (!currentNet.contains(connectedLoc)) continue;
                if (connectedNet != null) {
                    Reporter.report.addFatalErrorFmt("BUG: Multiple nets found for a single splitter split connection\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                    return false;
                }
                connectedNet = currentNet;
            }
            if (connectedNet != null) {
                if (busnet != null) {
                    if (!busnet.merge(connectedNet)) {
                        Reporter.report.addFatalErrorFmt("BUG: Splitter bus merge error\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                        return false;
                    }
                    this.myNets.remove(connectedNet);
                } else {
                    issueWarning = true;
                }
            } else {
                issueWarning = true;
            }
            if (issueWarning) {
                SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_NoSplitterConnection"), 2, 1);
                warn.addMarkComponent(mySplitter);
                Reporter.report.addWarning(warn);
            }
            mySplitIter.remove();
        }
        if (progress != null) {
            progress.setValue(4);
            progress.setString(Strings.S.get("NetListBuild", this.circuitName, 5));
        }
        for (Component comp : this.mySplitters) {
            List<EndData> ends = comp.getEnds();
            EndData combinedEnd = ends.get(0);
            int rootNet = -1;
            for (int i = 0; i < this.myNets.size() && rootNet < 0; ++i) {
                if (!this.myNets.get(i).contains(combinedEnd.getLocation())) continue;
                rootNet = i;
            }
            if (rootNet < 0) {
                Reporter.report.addFatalErrorFmt("BUG: Splitter without a bus connection\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                this.clear();
                return false;
            }
            ArrayList<Integer> connections = new ArrayList<Integer>();
            for (int i = 1; i < ends.size(); ++i) {
                EndData thisEnd = ends.get(i);
                int connectedNet = -1;
                for (int j = 0; j < this.myNets.size() && connectedNet < 1; ++j) {
                    if (!this.myNets.get(j).contains(thisEnd.getLocation())) continue;
                    connectedNet = j;
                }
                connections.add(connectedNet);
            }
            boolean unconnectedEnds = false;
            boolean connectedUnknownEnds = false;
            sattrs = (SplitterAttributes)comp.getAttributeSet();
            for (int i = 1; i < ends.size(); ++i) {
                Integer connectedNet = (Integer)connections.get(i - 1);
                if (connectedNet >= 0) {
                    connectedUnknownEnds |= sattrs.isNoConnect(i);
                    if (!this.myNets.get(connectedNet).setParent(this.myNets.get(rootNet))) {
                        this.myNets.get(connectedNet).forceRootNet();
                    }
                    byte[] busBitConnection = ((Splitter)comp).getEndpoints();
                    for (b = 0; b < busBitConnection.length; b = (byte)((byte)(b + 1))) {
                        if (busBitConnection[b] != i) continue;
                        this.myNets.get(connectedNet).addParentBit(b);
                    }
                    continue;
                }
                unconnectedEnds = true;
            }
            if (unconnectedEnds) {
                SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_NoSplitterEndConnections"), 1, 1);
                warn.addMarkComponent(comp);
                Reporter.report.addWarning(warn);
            }
            if (!connectedUnknownEnds) continue;
            SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_NoEndSplitterConnections"), 2, 1);
            warn.addMarkComponent(comp);
            Reporter.report.addWarning(warn);
        }
        if (progress != null) {
            progress.setValue(5);
            progress.setString(Strings.S.get("NetListBuild", this.circuitName, 6));
        }
        for (Net thisNet : this.myNets) {
            if (!thisNet.isRootNet()) continue;
            thisNet.initializeSourceSinks();
        }
        for (Component comp : components) {
            if (comp.getFactory() instanceof SubcircuitFactory) {
                if (this.processSubcircuit(comp)) continue;
                this.clear();
                return false;
            }
            if (!(comp.getFactory() instanceof Pin) && !comp.getAttributeSet().containsAttribute(StdAttr.MAPINFO) && comp.getFactory().getHDLGenerator(comp.getAttributeSet()) == null || this.processNormalComponent(comp)) continue;
            this.clear();
            return false;
        }
        if (progress != null) {
            progress.setValue(6);
            progress.setString(Strings.S.get("NetListBuild", this.circuitName, 7));
        }
        for (Net thisNet : this.myNets) {
            if (!thisNet.isForcedRootNet()) continue;
            for (int bit = 0; bit < thisNet.getBitWidth(); ++bit) {
                for (Component comp : this.mySplitters) {
                    List<EndData> ends = comp.getEnds();
                    EndData combinedEnd = ends.get(0);
                    int connectedBus = -1;
                    sattrs = (SplitterAttributes)comp.getAttributeSet();
                    for (int i = 0; i < this.myNets.size() && connectedBus < 0; ++i) {
                        if (!this.myNets.get(i).contains(combinedEnd.getLocation())) continue;
                        connectedBus = i;
                    }
                    if (connectedBus < 0) {
                        Reporter.report.addFatalErrorFmt("BUG: This is embarasing as this should never happen\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                        this.clear();
                        return false;
                    }
                    for (int endId = 1; endId < ends.size(); ++endId) {
                        if (sattrs.isNoConnect(endId) || !thisNet.contains(ends.get(endId).getLocation())) continue;
                        byte[] busBitConnection = ((Splitter)comp).getEndpoints();
                        ArrayList<Byte> indexBits = new ArrayList<Byte>();
                        for (b = 0; b < busBitConnection.length; b = (byte)(b + 1)) {
                            if (busBitConnection[b] != endId) continue;
                            indexBits.add(b);
                        }
                        byte connectedBusIndex = (Byte)indexBits.get(bit);
                        Net rootBus = this.myNets.get(connectedBus);
                        while (!rootBus.isRootNet()) {
                            connectedBusIndex = rootBus.getBit(connectedBusIndex);
                            rootBus = rootBus.getParent();
                        }
                        ConnectionPoint solderPoint = new ConnectionPoint(comp);
                        solderPoint.setParentNet(rootBus, connectedBusIndex);
                        boolean isSink = true;
                        if (!thisNet.hasBitSource(bit) && this.hasHiddenSource(thisNet, (byte)bit, rootBus, connectedBusIndex, this.mySplitters, new HashSet<String>(), comp)) {
                            isSink = false;
                        }
                        if (isSink) {
                            thisNet.addSinkNet(bit, solderPoint);
                            continue;
                        }
                        thisNet.addSourceNet(bit, solderPoint);
                    }
                }
            }
        }
        if (progress != null) {
            progress.setMaximum(curMax);
            progress.setValue(curVal);
            progress.setString(curStr);
        }
        return true;
    }

    public List<Component> getAllClockSources() {
        return this.myClockInformation.getSourceContainer().getSources();
    }

    public List<Net> getAllNets() {
        return this.myNets;
    }

    public Circuit getCircuit() {
        return this.myCircuit;
    }

    public String getCircuitName() {
        return this.circuitName;
    }

    public int getClockSourceId(List<String> hierarchyLevel, Net whichNet, Byte bitId) {
        return this.myClockInformation.getClockSourceId(hierarchyLevel, whichNet, bitId);
    }

    public int getClockSourceId(Component comp) {
        return this.myClockInformation.getClockSourceId(comp);
    }

    public List<netlistComponent> getClockSources() {
        return this.myClockGenerators;
    }

    public List<String> getCurrentHierarchyLevel() {
        return this.currentHierarchyLevel;
    }

    public int getEndIndex(netlistComponent comp, String pinLabel, boolean isOutputPort) {
        String label = CorrectLabel.getCorrectLabel(pinLabel);
        SubcircuitFactory subFactory = (SubcircuitFactory)comp.getComponent().getFactory();
        for (int end = 0; end < comp.nrOfEnds(); ++end) {
            if (comp.getEnd(end).isOutputEnd() != isOutputPort || comp.getEnd(end).get((byte)0).getChildsPortIndex() != subFactory.getSubcircuit().getNetList().getPortInfo(label)) continue;
            return end;
        }
        return -1;
    }

    private List<ConnectionPoint> getHiddenSinks(Net thisNet, Byte bitIndex, List<Component> splitters, Set<String> handledNets, Boolean isSourceNet) {
        ArrayList<ConnectionPoint> result = new ArrayList<ConnectionPoint>();
        String netId = this.myNets.indexOf(thisNet) + "-" + bitIndex;
        if (handledNets.contains(netId)) {
            return result;
        }
        handledNets.add(netId);
        if (thisNet.hasBitSinks(bitIndex.byteValue()) && !isSourceNet.booleanValue() && thisNet.isRootNet()) {
            result.addAll(thisNet.getBitSinks(bitIndex.byteValue()));
        }
        for (Component currentSplitter : splitters) {
            List<EndData> ends = currentSplitter.getEnds();
            SplitterAttributes splitterAttrs = (SplitterAttributes)currentSplitter.getAttributeSet();
            for (int end = 0; end < ends.size(); end = (int)((byte)(end + 1))) {
                if (end > 0 && splitterAttrs.isNoConnect(end) || !thisNet.contains(ends.get(end).getLocation())) continue;
                byte[] busBitConnection = ((Splitter)currentSplitter).getEndpoints();
                if (end == 0) {
                    byte splitterEnd = busBitConnection[bitIndex];
                    Byte netIndex = 0;
                    for (int index = 0; index < bitIndex; ++index) {
                        if (busBitConnection[index] != splitterEnd) continue;
                        Byte by = netIndex;
                        netIndex = (byte)(netIndex + 1);
                    }
                    Net slaveNet = null;
                    for (Net thisnet : this.myNets) {
                        if (!thisnet.contains(ends.get(splitterEnd).getLocation())) continue;
                        slaveNet = thisnet;
                    }
                    if (slaveNet == null) continue;
                    result.addAll(this.getHiddenSinks(slaveNet, netIndex, splitters, handledNets, false));
                    continue;
                }
                ArrayList<Byte> rootIndices = new ArrayList<Byte>();
                for (byte b = 0; b < busBitConnection.length; b = (byte)(b + 1)) {
                    if (busBitConnection[b] != end) continue;
                    rootIndices.add(b);
                }
                Net rootNet = null;
                for (Net thisnet : this.myNets) {
                    if (!thisnet.contains(currentSplitter.getEnd(0).getLocation())) continue;
                    rootNet = thisnet;
                }
                if (rootNet == null) continue;
                result.addAll(this.getHiddenSinks(rootNet, (Byte)rootIndices.get(bitIndex.byteValue()), splitters, handledNets, false));
            }
        }
        return result;
    }

    public netlistComponent getInOutPin(int index) {
        return index < 0 || index >= this.myInOutPorts.size() ? null : this.myInOutPorts.get(index);
    }

    public netlistComponent getInOutPort(int Index) {
        return Index < 0 || Index >= this.myInOutPorts.size() ? null : this.myInOutPorts.get(Index);
    }

    public netlistComponent getInputPin(int index) {
        return index < 0 || index >= this.myInputPorts.size() ? null : this.myInputPorts.get(index);
    }

    public netlistComponent getInputPort(int Index) {
        return Index < 0 || Index >= this.myInputPorts.size() ? null : this.myInputPorts.get(Index);
    }

    public Map<ArrayList<String>, netlistComponent> getMappableResources(List<String> hierarchy, boolean toplevel) {
        ArrayList<String> myHierarchyName;
        HashMap<ArrayList<String>, netlistComponent> components = new HashMap<ArrayList<String>, netlistComponent>();
        for (netlistComponent comp : this.mySubCircuits) {
            SubcircuitFactory sub = (SubcircuitFactory)comp.getComponent().getFactory();
            ArrayList<String> MyHierarchyName = new ArrayList<String>(hierarchy);
            MyHierarchyName.add(CorrectLabel.getCorrectLabel(comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
            components.putAll(sub.getSubcircuit().getNetList().getMappableResources(MyHierarchyName, false));
        }
        for (netlistComponent comp : this.myComponents) {
            if (comp.getMapInformationContainer() == null) continue;
            myHierarchyName = new ArrayList<String>(hierarchy);
            myHierarchyName.add(CorrectLabel.getCorrectLabel(comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
            components.put(myHierarchyName, comp);
        }
        if (toplevel) {
            for (netlistComponent comp : this.myInputPorts) {
                myHierarchyName = new ArrayList<String>(hierarchy);
                myHierarchyName.add(CorrectLabel.getCorrectLabel(comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
                components.put(myHierarchyName, comp);
            }
            for (netlistComponent comp : this.myInOutPorts) {
                myHierarchyName = new ArrayList<String>(hierarchy);
                myHierarchyName.add(CorrectLabel.getCorrectLabel(comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
                components.put(myHierarchyName, comp);
            }
            for (netlistComponent comp : this.myOutputPorts) {
                myHierarchyName = new ArrayList<String>(hierarchy);
                myHierarchyName.add(CorrectLabel.getCorrectLabel(comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
                components.put(myHierarchyName, comp);
            }
        }
        return components;
    }

    private void getNet(Wire wire, Net thisNet) {
        Iterator<Wire> myIterator = this.wires.iterator();
        ArrayList<Wire> matchedWires = new ArrayList<Wire>();
        Wire compWire = wire;
        while (myIterator.hasNext()) {
            Wire thisWire = myIterator.next();
            if (compWire == null) {
                compWire = thisWire;
                thisNet.add(thisWire);
                myIterator.remove();
                continue;
            }
            if (!thisWire.sharesEnd(compWire)) continue;
            matchedWires.add(thisWire);
            thisNet.add(thisWire);
            myIterator.remove();
        }
        for (Wire matched : matchedWires) {
            this.getNet(matched, thisNet);
        }
        matchedWires.clear();
    }

    public Integer getNetId(Net selectedNet) {
        return this.myNets.indexOf(selectedNet);
    }

    public ConnectionPoint getNetlistConnectionForSubCircuit(String label, int PortIndex, byte bitindex) {
        for (netlistComponent search : this.mySubCircuits) {
            String circuitLabel = CorrectLabel.getCorrectLabel(search.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
            if (!circuitLabel.equals(label)) continue;
            for (int i = 0; i < search.nrOfEnds(); ++i) {
                ConnectionEnd thisEnd = search.getEnd(i);
                if (!thisEnd.isOutputEnd() || bitindex >= thisEnd.getNrOfBits() || thisEnd.get(bitindex).getChildsPortIndex() != PortIndex) continue;
                return thisEnd.get(bitindex);
            }
        }
        return null;
    }

    public ConnectionPoint getNetlistConnectionForSubCircuitInput(String label, int portIndex, byte bitIndex) {
        for (netlistComponent search : this.mySubCircuits) {
            String circuitLabel = CorrectLabel.getCorrectLabel(search.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
            if (!circuitLabel.equals(label)) continue;
            for (int i = 0; i < search.nrOfEnds(); ++i) {
                ConnectionEnd thisEnd = search.getEnd(i);
                if (thisEnd.isOutputEnd() || bitIndex >= thisEnd.getNrOfBits() || thisEnd.get(bitIndex).getChildsPortIndex() != portIndex) continue;
                return thisEnd.get(bitIndex);
            }
        }
        return null;
    }

    public List<netlistComponent> getNormalComponents() {
        return this.myComponents;
    }

    public netlistComponent getOutputPin(int index) {
        return index < 0 || index >= this.myOutputPorts.size() ? null : this.myOutputPorts.get(index);
    }

    public int getPortInfo(String label) {
        String comp;
        String source = CorrectLabel.getCorrectLabel(label);
        for (netlistComponent inPort : this.myInputPorts) {
            comp = CorrectLabel.getCorrectLabel(inPort.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
            if (!comp.equals(source)) continue;
            return this.myInputPorts.indexOf(inPort);
        }
        for (netlistComponent inOutPort : this.myInOutPorts) {
            comp = CorrectLabel.getCorrectLabel(inOutPort.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
            if (!comp.equals(source)) continue;
            return this.myInOutPorts.indexOf(inOutPort);
        }
        for (netlistComponent outPort : this.myOutputPorts) {
            comp = CorrectLabel.getCorrectLabel(outPort.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
            if (!comp.equals(source)) continue;
            return this.myOutputPorts.indexOf(outPort);
        }
        return -1;
    }

    private Net getRootNet(Net child) {
        if (child == null) {
            return null;
        }
        if (child.isRootNet()) {
            return child;
        }
        Net rootNet = child.getParent();
        while (!rootNet.isRootNet()) {
            rootNet = rootNet.getParent();
        }
        return rootNet;
    }

    private byte getRootNetIndex(Net child, byte bitIndex) {
        if (child == null || bitIndex < 0 || bitIndex > child.getBitWidth()) {
            return -1;
        }
        if (child.isRootNet()) {
            return bitIndex;
        }
        Net rootNet = child.getParent();
        byte rootIndex = child.getBit(bitIndex);
        while (!rootNet.isRootNet()) {
            rootIndex = rootNet.getBit(rootIndex);
            rootNet = rootNet.getParent();
        }
        return rootIndex;
    }

    public Set<Splitter> getSplitters() {
        HashSet<Splitter> splitters = new HashSet<Splitter>();
        for (Component comp : this.myCircuit.getNonWires()) {
            if (!(comp.getFactory() instanceof SplitterFactory)) continue;
            splitters.add((Splitter)comp);
        }
        return splitters;
    }

    public ArrayList<netlistComponent> getSubCircuits() {
        return this.mySubCircuits;
    }

    private SourceInfo getHiddenSource(Net srcNet, Byte srcBitIndex, Net thisNet, Byte bitIndex, List<Component> splitters, Set<String> handledNets, Set<Wire> segments, Component splitterToIgnore) {
        String netId;
        if (srcNet != null) {
            netId = this.myNets.indexOf(srcNet) + "-" + srcBitIndex;
            if (handledNets.contains(netId)) {
                return null;
            }
            handledNets.add(netId);
        }
        if (handledNets.contains(netId = this.myNets.indexOf(thisNet) + "-" + bitIndex)) {
            return null;
        }
        handledNets.add(netId);
        segments.addAll(thisNet.getWires());
        if (thisNet.hasBitSource(bitIndex.byteValue())) {
            List<ConnectionPoint> sources = thisNet.getBitSources(bitIndex.byteValue());
            if (sources.size() != 1) {
                Reporter.report.addFatalErrorFmt("BUG: Found multiple sources\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return null;
            }
            return new SourceInfo(sources.get(0), bitIndex);
        }
        for (Component splitter : splitters) {
            if (splitter.equals(splitterToIgnore)) continue;
            List<EndData> ends = splitter.getEnds();
            for (int end = 0; end < ends.size(); ++end) {
                SourceInfo ret;
                if (!thisNet.contains(ends.get(end).getLocation())) continue;
                byte[] busBitConnection = ((Splitter)splitter).getEndpoints();
                if (end == 0) {
                    SourceInfo ret2;
                    byte splitterEnd = busBitConnection[bitIndex];
                    Byte netIndex = 0;
                    for (int index = 0; index < bitIndex; ++index) {
                        if (busBitConnection[index] != splitterEnd) continue;
                        Byte by = netIndex;
                        netIndex = (byte)(netIndex + 1);
                    }
                    Object slaveNet = null;
                    for (Net thisnet : this.myNets) {
                        if (!thisnet.contains(ends.get(splitterEnd).getLocation())) continue;
                        slaveNet = thisnet;
                    }
                    if (slaveNet == null || (ret2 = this.getHiddenSource(null, (byte)0, (Net)slaveNet, netIndex, splitters, handledNets, segments, splitter)) == null) continue;
                    return ret2;
                }
                ArrayList<Byte> rootIndices = new ArrayList<Byte>();
                for (byte b = 0; b < busBitConnection.length; b = (byte)(b + 1)) {
                    if (busBitConnection[b] != end) continue;
                    rootIndices.add(b);
                }
                Net rootNet = null;
                for (Net thisnet : this.myNets) {
                    if (!thisnet.contains(splitter.getEnd(0).getLocation())) continue;
                    rootNet = thisnet;
                }
                if (rootNet == null || (ret = this.getHiddenSource(null, (byte)0, rootNet, (Byte)rootIndices.get(bitIndex.byteValue()), splitters, handledNets, segments, splitter)) == null) continue;
                return ret;
            }
        }
        return null;
    }

    private boolean hasHiddenSource(Net fannoutNet, Byte fannoutBitIndex, Net combinedNet, Byte combinedBitIndex, List<Component> splitterList, Set<String> handledNets, Component ignoreSplitter) {
        String netId;
        if (fannoutNet != null) {
            netId = this.myNets.indexOf(fannoutNet) + "-" + fannoutBitIndex;
            if (handledNets.contains(netId)) {
                return false;
            }
            handledNets.add(netId);
        }
        if (handledNets.contains(netId = this.myNets.indexOf(combinedNet) + "-" + combinedBitIndex)) {
            return false;
        }
        handledNets.add(netId);
        if (combinedNet.hasBitSource(combinedBitIndex.byteValue())) {
            return true;
        }
        for (Component currentSplitter : splitterList) {
            if (currentSplitter.equals(ignoreSplitter)) continue;
            List<EndData> ends = currentSplitter.getEnds();
            for (int end = 0; end < ends.size(); ++end) {
                if (!combinedNet.contains(ends.get(end).getLocation())) continue;
                byte[] busBitConnection = ((Splitter)currentSplitter).getEndpoints();
                if (end == 0) {
                    byte splitterEnd = busBitConnection[combinedBitIndex];
                    Byte netIndex = 0;
                    for (int index = 0; index < combinedBitIndex; ++index) {
                        if (busBitConnection[index] != splitterEnd) continue;
                        Byte by = netIndex;
                        netIndex = (byte)(netIndex + 1);
                    }
                    Net slaveNet = null;
                    for (Net thisnet : this.myNets) {
                        if (!thisnet.contains(ends.get(splitterEnd).getLocation())) continue;
                        slaveNet = thisnet;
                    }
                    if (slaveNet == null || !this.hasHiddenSource(null, (byte)0, slaveNet, netIndex, splitterList, handledNets, currentSplitter)) continue;
                    return true;
                }
                ArrayList<Byte> rootIndices = new ArrayList<Byte>();
                for (byte b = 0; b < busBitConnection.length; b = (byte)(b + 1)) {
                    if (busBitConnection[b] != end) continue;
                    rootIndices.add(b);
                }
                Net rootNet = null;
                for (Net thisnet : this.myNets) {
                    if (!thisnet.contains(currentSplitter.getEnd(0).getLocation())) continue;
                    rootNet = thisnet;
                }
                if (rootNet == null || !this.hasHiddenSource(null, (byte)0, rootNet, (Byte)rootIndices.get(combinedBitIndex.byteValue()), splitterList, handledNets, currentSplitter)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContinuesBus(netlistComponent comp, int endIndex) {
        boolean continuesBus = true;
        if (endIndex < 0 || endIndex >= comp.nrOfEnds()) {
            return true;
        }
        ConnectionEnd connInfo = comp.getEnd(endIndex);
        int nrOfBits = connInfo.getNrOfBits();
        if (nrOfBits == 1) {
            return true;
        }
        Net connectedNet = connInfo.get((byte)0).getParentNet();
        Byte connectedNetIndex = connInfo.get((byte)0).getParentNetBitIndex();
        for (int i = 1; i < nrOfBits && continuesBus; ++i) {
            if (connectedNet != connInfo.get((byte)i).getParentNet()) {
                continuesBus = false;
            }
            if (connectedNetIndex + 1 != connInfo.get((byte)i).getParentNetBitIndex()) {
                continuesBus = false;
                continue;
            }
            Byte by = connectedNetIndex;
            connectedNetIndex = (byte)(connectedNetIndex + 1);
        }
        return continuesBus;
    }

    public boolean isValid() {
        return this.drcStatus == 0;
    }

    public void markClockNet(List<String> hierarchyNames, int clockSourceId, ConnectionPoint connection, boolean isPinClockSource) {
        this.myClockInformation.addClockNet(hierarchyNames, clockSourceId, connection, isPinClockSource);
    }

    public boolean markClockSourceComponents(List<String> hierarchyNames, List<Netlist> hierarchyNetlists, ClockSourceContainer clockSources) {
        for (netlistComponent sub : this.mySubCircuits) {
            SubcircuitFactory subFact = (SubcircuitFactory)sub.getComponent().getFactory();
            ArrayList<String> newHierarchyNames = new ArrayList<String>(hierarchyNames);
            newHierarchyNames.add(CorrectLabel.getCorrectLabel(sub.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
            ArrayList<Netlist> newHierarchyNetlists = new ArrayList<Netlist>(hierarchyNetlists);
            newHierarchyNetlists.add(subFact.getSubcircuit().getNetList());
            if (subFact.getSubcircuit().getNetList().markClockSourceComponents(newHierarchyNames, newHierarchyNetlists, clockSources)) continue;
            return false;
        }
        for (Component comp : this.myCircuit.getNonWires()) {
            if (!comp.getFactory().requiresGlobalClock()) continue;
            clockSources.setRequiresFpgaGlobalClock();
        }
        for (netlistComponent clockSource : this.myClockGenerators) {
            if (clockSource.nrOfEnds() != 1) {
                Reporter.report.addFatalErrorFmt("BUG: Found a clock source with more than 1 connection\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return false;
            }
            ConnectionEnd clockConnection = clockSource.getEnd(0);
            if (clockConnection.getNrOfBits() != 1) {
                Reporter.report.addFatalErrorFmt("BUG: Found a clock source with a bus as output\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return false;
            }
            ConnectionPoint solderPoint = clockConnection.get((byte)0);
            if (solderPoint.getParentNet() == null) continue;
            int clockid = clockSources.getClockId(clockSource.getComponent());
            this.myClockInformation.addClockSource(hierarchyNames, clockid, solderPoint);
            if (this.traceClockNet(solderPoint.getParentNet(), solderPoint.getParentNetBitIndex(), clockid, false, hierarchyNames, hierarchyNetlists)) continue;
            return false;
        }
        return true;
    }

    public boolean netlistHasShortCircuits() {
        boolean ret = false;
        for (Net net : this.myNets) {
            if (!net.isRootNet()) continue;
            if (net.hasShortCircuit()) {
                SimpleDrcContainer error = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_ShortCircuit"), 3, 4);
                error.addMarkComponents(net.getWires());
                Reporter.report.addError(error);
                ret = true;
                continue;
            }
            if (net.getBitWidth() != 1 || net.getSourceNets(0).size() <= 1) continue;
            List<ConnectionPoint> sourceNets = net.getSourceNets(0);
            HashMap<Component, Integer> sourceConnections = new HashMap<Component, Integer>();
            HashSet<Wire> segments = new HashSet<Wire>(net.getWires());
            boolean foundShortCrcuit = false;
            SimpleDrcContainer error = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_ShortCircuit"), 3, 5);
            for (ConnectionPoint sourceNet : sourceNets) {
                Net connectedNet = sourceNet.getParentNet();
                byte bitIndex = sourceNet.getParentNetBitIndex();
                if (!this.hasHiddenSource(net, (byte)0, connectedNet, bitIndex, this.mySplitters, new HashSet<String>(), null)) continue;
                SourceInfo source = this.getHiddenSource(net, (byte)0, connectedNet, bitIndex, this.mySplitters, new HashSet<String>(), segments, null);
                if (source == null) {
                    return true;
                }
                Component comp = source.getSource().getComp();
                for (Wire seg : segments) {
                    error.addMarkComponent(seg);
                }
                error.addMarkComponent(comp);
                Integer index = source.getIndex();
                foundShortCrcuit |= sourceConnections.containsKey(comp) && sourceConnections.get(comp) != index || sourceConnections.keySet().size() > 0;
                sourceConnections.put(comp, index);
            }
            if (foundShortCrcuit) {
                ret = true;
                Reporter.report.addError(error);
                continue;
            }
            net.cleanupSourceNets(0);
        }
        return ret;
    }

    public boolean netlistHasSinksWithoutSource() {
        HashSet<ConnectionPoint> mySinks = new HashSet<ConnectionPoint>();
        for (Net thisNet : this.myNets) {
            if (!thisNet.isRootNet()) continue;
            mySinks.addAll(thisNet.getSinks());
        }
        for (Net thisNet : this.myNets) {
            if (!thisNet.isRootNet()) continue;
            for (int i = 0; i < thisNet.getBitWidth(); ++i) {
                if (!thisNet.hasBitSource(i)) continue;
                boolean hasSink = false;
                List<ConnectionPoint> sinks = thisNet.getBitSinks(i);
                hasSink |= !sinks.isEmpty();
                sinks.forEach(mySinks::remove);
                List<ConnectionPoint> hiddenSinkNets = this.getHiddenSinks(thisNet, (byte)i, this.mySplitters, new HashSet<String>(), true);
                boolean bl = !hiddenSinkNets.isEmpty();
                hiddenSinkNets.forEach(mySinks::remove);
                if (hasSink |= bl) continue;
                SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_SourceWithoutSink"), 1, 4);
                warn.addMarkComponents(thisNet.getWires());
                Reporter.report.addWarning(warn);
            }
        }
        if (mySinks.size() != 0) {
            for (ConnectionPoint sink : mySinks) {
                SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_UnsourcedSink"), 2, 5);
                warn.addMarkComponents(sink.getParentNet().getWires());
                if (sink.getComp() != null) {
                    warn.addMarkComponent(sink.getComp());
                }
                Reporter.report.addWarning(warn);
            }
        }
        return false;
    }

    public int numberOfBusses() {
        int nrOfBusses = 0;
        for (Net thisNet : this.myNets) {
            if (!thisNet.isRootNet() || !thisNet.isBus()) continue;
            ++nrOfBusses;
        }
        return nrOfBusses;
    }

    public int numberOfClockTrees() {
        return this.myClockInformation.getSourceContainer().getNrofSources();
    }

    public int numberOfInOutBubbles() {
        return this.localNrOfInOutBubbles;
    }

    public int numberOfInOutPortBits() {
        int count = 0;
        for (netlistComponent inp : this.myInOutPorts) {
            count += inp.getEnd(0).getNrOfBits();
        }
        return count;
    }

    public int numberOfInOutPorts() {
        return this.myInOutPorts.size();
    }

    public int getNumberOfInputBubbles() {
        return this.localNrOfInportBubbles;
    }

    public int getNumberOfInputPortBits() {
        int count = 0;
        for (netlistComponent inPort : this.myInputPorts) {
            count += inPort.getEnd(0).getNrOfBits();
        }
        return count;
    }

    public int getNumberOfInputPorts() {
        return this.myInputPorts.size();
    }

    public int numberOfNets() {
        int nrOfNets = 0;
        for (Net thisNet : this.myNets) {
            if (!thisNet.isRootNet() || thisNet.isBus()) continue;
            ++nrOfNets;
        }
        return nrOfNets;
    }

    public int numberOfOutputBubbles() {
        return this.localNrOfOutportBubbles;
    }

    public int numberOfOutputPortBits() {
        int count = 0;
        for (netlistComponent outPort : this.myOutputPorts) {
            count += outPort.getEnd(0).getNrOfBits();
        }
        return count;
    }

    public int numberOfOutputPorts() {
        return this.myOutputPorts.size();
    }

    private boolean processNormalComponent(Component comp) {
        netlistComponent normalComponent = new netlistComponent(comp);
        for (EndData thisPin : comp.getEnds()) {
            Net connection = this.findConnectedNet(thisPin.getLocation());
            if (connection == null) continue;
            int pinId = comp.getEnds().indexOf(thisPin);
            boolean pinIsSink = thisPin.isInput();
            ConnectionEnd thisEnd = normalComponent.getEnd(pinId);
            Net rootNet = this.getRootNet(connection);
            if (rootNet == null) {
                Reporter.report.addFatalErrorFmt("BUG: Unable to find a root net for a normal component\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return false;
            }
            for (int bitid = 0; bitid < thisPin.getWidth().getWidth(); ++bitid) {
                byte rootNetBitIndex = this.getRootNetIndex(connection, (byte)bitid);
                if (rootNetBitIndex < 0) {
                    Reporter.report.addFatalErrorFmt("BUG:  Unable to find a root-net bit-index for a normal component\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                    return false;
                }
                ConnectionPoint thisSolderPoint = thisEnd.get((byte)bitid);
                thisSolderPoint.setParentNet(rootNet, rootNetBitIndex);
                if (pinIsSink) {
                    rootNet.addSink(rootNetBitIndex, thisSolderPoint);
                    continue;
                }
                rootNet.addSource(rootNetBitIndex, thisSolderPoint);
            }
        }
        if (comp.getFactory() instanceof Clock) {
            this.myClockGenerators.add(normalComponent);
        } else if (comp.getFactory() instanceof Pin) {
            if (comp.getEnd(0).isInput()) {
                this.myOutputPorts.add(normalComponent);
            } else {
                this.myInputPorts.add(normalComponent);
            }
        } else {
            this.myComponents.add(normalComponent);
        }
        return true;
    }

    private boolean processSubcircuit(Component comp) {
        netlistComponent subCircuit = new netlistComponent(comp);
        SubcircuitFactory subFactory = (SubcircuitFactory)comp.getFactory();
        Instance[] subPins = ((CircuitAttributes)comp.getAttributeSet()).getPinInstances();
        Netlist subNetlist = subFactory.getSubcircuit().getNetList();
        for (EndData thisPin : comp.getEnds()) {
            Net connection = this.findConnectedNet(thisPin.getLocation());
            int pinId = comp.getEnds().indexOf(thisPin);
            int subPortIndex = subNetlist.getPortInfo(subPins[pinId].getAttributeValue(StdAttr.LABEL));
            if (subPortIndex < 0) {
                Reporter.report.addFatalErrorFmt("BUG:  Unable to find pin in sub-circuit\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return false;
            }
            if (connection != null) {
                boolean pinIsSink = thisPin.isInput();
                Net rootNet = this.getRootNet(connection);
                if (rootNet == null) {
                    Reporter.report.addFatalErrorFmt("BUG:  Unable to find a root net for sub-circuit\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                    return false;
                }
                for (byte bitid = 0; bitid < thisPin.getWidth().getWidth(); bitid = (byte)(bitid + 1)) {
                    byte rootNetBitIndex = this.getRootNetIndex(connection, bitid);
                    if (rootNetBitIndex < 0) {
                        Reporter.report.addFatalErrorFmt("BUG:  Unable to find a root-net bit-index for sub-circuit\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                        return false;
                    }
                    subCircuit.getEnd(pinId).get(bitid).setParentNet(rootNet, rootNetBitIndex);
                    if (pinIsSink) {
                        rootNet.addSink(rootNetBitIndex, subCircuit.getEnd(pinId).get(bitid));
                    } else {
                        rootNet.addSource(rootNetBitIndex, subCircuit.getEnd(pinId).get(bitid));
                    }
                    subCircuit.getEnd(pinId).get(bitid).setChildsPortIndex(subPortIndex);
                }
                continue;
            }
            for (byte bitid = 0; bitid < thisPin.getWidth().getWidth(); bitid = (byte)(bitid + 1)) {
                subCircuit.getEnd(pinId).get(bitid).setChildsPortIndex(subPortIndex);
            }
        }
        this.mySubCircuits.add(subCircuit);
        return true;
    }

    public String projName() {
        return this.myCircuit.getProjName();
    }

    public boolean requiresGlobalClockConnection() {
        return this.myClockInformation.getSourceContainer().getRequiresFpgaGlobalClock();
    }

    public void setCurrentHierarchyLevel(List<String> level) {
        this.currentHierarchyLevel.clear();
        this.currentHierarchyLevel.addAll(level);
    }

    private boolean traceDownSubcircuit(ConnectionPoint point, int clockSourceId, List<String> hierarchyNames, List<Netlist> hierarchyNetlists) {
        if (point.getChildsPortIndex() < 0) {
            Reporter.report.addFatalErrorFmt("BUG: Subcircuit port is not annotated!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
            return false;
        }
        SubcircuitFactory sub = (SubcircuitFactory)point.getComp().getFactory();
        netlistComponent inputPort = sub.getSubcircuit().getNetList().getInputPin(point.getChildsPortIndex());
        if (inputPort == null) {
            Reporter.report.addFatalErrorFmt("BUG: Unable to find Subcircuit input port!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
            return false;
        }
        netlistComponent subCirc = this.getSubCirc(point.getComp());
        if (subCirc == null) {
            Reporter.report.addFatalErrorFmt("BUG: Unable to find Subcircuit!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
            return false;
        }
        byte bitindex = subCirc.getConnectionBitIndex(point.getParentNet(), point.getParentNetBitIndex());
        if (bitindex < 0) {
            Reporter.report.addFatalErrorFmt("BUG: Unable to find the bit index of a Subcircuit input port!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
            return false;
        }
        ConnectionPoint subClockNet = inputPort.getEnd(0).get(bitindex);
        if (subClockNet.getParentNet() != null) {
            ArrayList<String> newHierarchyNames = new ArrayList<String>(hierarchyNames);
            String label = CorrectLabel.getCorrectLabel(subCirc.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
            newHierarchyNames.add(label);
            ArrayList<Netlist> newHierarchyNetlists = new ArrayList<Netlist>(hierarchyNetlists);
            newHierarchyNetlists.add(sub.getSubcircuit().getNetList());
            sub.getSubcircuit().getNetList().markClockNet(newHierarchyNames, clockSourceId, subClockNet, true);
            return sub.getSubcircuit().getNetList().traceClockNet(subClockNet.getParentNet(), subClockNet.getParentNetBitIndex(), clockSourceId, true, newHierarchyNames, newHierarchyNetlists);
        }
        return true;
    }

    public boolean traceClockNet(Net clockNet, byte clockNetBitIndex, int clockSourceId, boolean isPinSource, List<String> hierarchyNames, List<Netlist> hierarchyNetlists) {
        List<ConnectionPoint> hiddenComps = this.getHiddenSinks(clockNet, clockNetBitIndex, this.mySplitters, new HashSet<String>(), false);
        for (ConnectionPoint point : hiddenComps) {
            this.markClockNet(hierarchyNames, clockSourceId, point, isPinSource);
            if (point.getComp().getFactory() instanceof SubcircuitFactory && !this.traceDownSubcircuit(point, clockSourceId, hierarchyNames, hierarchyNetlists)) {
                return false;
            }
            if (hierarchyNames.isEmpty() || !(point.getComp().getFactory() instanceof Pin)) continue;
            netlistComponent outputPort = this.getOutPort(point.getComp());
            if (outputPort == null) {
                Reporter.report.addFatalErrorFmt("BUG: Could not find an output port!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return false;
            }
            byte bitIndex = outputPort.getConnectionBitIndex(point.getParentNet(), point.getParentNetBitIndex());
            ConnectionPoint subClockNet = hierarchyNetlists.get(hierarchyNetlists.size() - 2).getNetlistConnectionForSubCircuit(hierarchyNames.get(hierarchyNames.size() - 1), this.myOutputPorts.indexOf(outputPort), bitIndex);
            if (subClockNet == null) {
                Reporter.report.addFatalErrorFmt("BUG: Could not find a sub-circuit connection in overlying hierarchy level!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return false;
            }
            if (subClockNet.getParentNet() == null) continue;
            ArrayList<String> newHierarchyNames = new ArrayList<String>(hierarchyNames);
            newHierarchyNames.remove(newHierarchyNames.size() - 1);
            ArrayList<Netlist> newHierarchyNetlists = new ArrayList<Netlist>(hierarchyNetlists);
            newHierarchyNetlists.remove(newHierarchyNetlists.size() - 1);
            hierarchyNetlists.get(hierarchyNetlists.size() - 2).markClockNet(newHierarchyNames, clockSourceId, subClockNet, true);
            if (hierarchyNetlists.get(hierarchyNetlists.size() - 2).traceClockNet(subClockNet.getParentNet(), subClockNet.getParentNetBitIndex(), clockSourceId, true, newHierarchyNames, newHierarchyNetlists)) continue;
            return false;
        }
        return true;
    }

    private netlistComponent getSubCirc(Component comp) {
        for (netlistComponent current : this.mySubCircuits) {
            if (!current.getComponent().equals(comp)) continue;
            return current;
        }
        return null;
    }

    private netlistComponent getOutPort(Component comp) {
        for (netlistComponent current : this.myOutputPorts) {
            if (!current.getComponent().equals(comp)) continue;
            return current;
        }
        return null;
    }

    private boolean detectGatedClocks() {
        ArrayList<Netlist> root = new ArrayList<Netlist>();
        boolean suppress = AppPreferences.SupressGatedClockWarnings.getBoolean();
        root.add(this);
        HashMap<String, Map<netlistComponent, Circuit>> notGatedSet = new HashMap<String, Map<netlistComponent, Circuit>>();
        HashMap<String, Map<netlistComponent, Circuit>> gatedSet = new HashMap<String, Map<netlistComponent, Circuit>>();
        this.setCurrentHierarchyLevel(new ArrayList<String>());
        this.getGatedClockComponents(root, null, notGatedSet, gatedSet, new HashSet<netlistComponent>());
        for (String key : notGatedSet.keySet()) {
            SimpleDrcContainer warn;
            if (!gatedSet.containsKey(key) || suppress) continue;
            Reporter.report.addSevereWarning(Strings.S.get("NetList_CircuitGatedNotGated"));
            Reporter.report.addWarningIncrement(Strings.S.get("NetList_TraceListBegin"));
            Map<netlistComponent, Circuit> instances = notGatedSet.get(key);
            for (netlistComponent comp : instances.keySet()) {
                warn = new SimpleDrcContainer(instances.get(comp), Strings.S.get("NetList_CircuitNotGated"), 1, 1, true);
                warn.addMarkComponent(comp.getComponent());
                Reporter.report.addWarning(warn);
            }
            instances = gatedSet.get(key);
            for (netlistComponent comp : instances.keySet()) {
                comp.setIsGatedInstance();
                warn = new SimpleDrcContainer(instances.get(comp), Strings.S.get("NetList_CircuitGated"), 1, 1, true);
                warn.addMarkComponent(comp.getComponent());
                Reporter.report.addWarning(warn);
            }
            Reporter.report.addWarningIncrement(Strings.S.get("NetList_TraceListEnd"));
        }
        return true;
    }

    public void getGatedClockComponents(List<Netlist> hierarchyNetlists, netlistComponent subCircuit, Map<String, Map<netlistComponent, Circuit>> notGatedSet, Map<String, Map<netlistComponent, Circuit>> gatedSet, Set<netlistComponent> warnedComponents) {
        for (netlistComponent subCirc : this.mySubCircuits) {
            SubcircuitFactory sub = (SubcircuitFactory)subCirc.getComponent().getFactory();
            ArrayList<String> newHierarchyNames = new ArrayList<String>(this.getCurrentHierarchyLevel());
            newHierarchyNames.add(CorrectLabel.getCorrectLabel(subCirc.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
            ArrayList<Netlist> newHierarchyNetlists = new ArrayList<Netlist>(hierarchyNetlists);
            newHierarchyNetlists.add(sub.getSubcircuit().getNetList());
            sub.getSubcircuit().getNetList().setCurrentHierarchyLevel(newHierarchyNames);
            sub.getSubcircuit().getNetList().getGatedClockComponents(newHierarchyNetlists, subCirc, notGatedSet, gatedSet, warnedComponents);
        }
        boolean gatedClock = false;
        ArrayList<SourceInfo> pinSources = new ArrayList<SourceInfo>();
        ArrayList<Set<Wire>> pinWires = new ArrayList<Set<Wire>>();
        ArrayList<Set<netlistComponent>> pinGatedComponents = new ArrayList<Set<netlistComponent>>();
        ArrayList<SourceInfo> nonPinSources = new ArrayList<SourceInfo>();
        ArrayList<Set<Wire>> nonPinWires = new ArrayList<Set<Wire>>();
        ArrayList<Set<netlistComponent>> nonPinGatedComponents = new ArrayList<Set<netlistComponent>>();
        for (netlistComponent comp : this.myComponents) {
            int[] clockPins;
            ComponentFactory fact = comp.getComponent().getFactory();
            if (!fact.checkForGatedClocks(comp)) continue;
            for (int clockPin : clockPins = fact.clockPinIndex(comp)) {
                gatedClock |= this.hasGatedClock(comp, clockPin, pinSources, pinWires, pinGatedComponents, nonPinSources, nonPinWires, nonPinGatedComponents, warnedComponents);
            }
        }
        String myName = CorrectLabel.getCorrectLabel(this.circuitName);
        if (hierarchyNetlists.size() > 1) {
            if (gatedClock && pinSources.isEmpty()) {
                gatedClock = false;
                this.warningForGatedClock(nonPinSources, nonPinGatedComponents, nonPinWires, warnedComponents, hierarchyNetlists, Strings.S.get("NetList_GatedClock"));
            }
            if (gatedClock && !pinSources.isEmpty() && !AppPreferences.SupressGatedClockWarnings.getBoolean()) {
                for (int i = 0; i < pinSources.size(); ++i) {
                    Reporter.report.addSevereWarning(Strings.S.get("NetList_GatedClock"));
                    Reporter.report.addWarningIncrement(Strings.S.get("NetList_TraceListBegin"));
                    SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_GatedClockSink"), 1, 5, true);
                    warn.addMarkComponents(pinWires.get(i));
                    for (netlistComponent comp : pinGatedComponents.get(i)) {
                        warn.addMarkComponent(comp.getComponent());
                    }
                    Reporter.report.addWarning(warn);
                    this.warningTraceForGatedClock(pinSources.get(i).getSource(), pinSources.get(i).getIndex(), hierarchyNetlists, this.currentHierarchyLevel);
                    Reporter.report.addWarningIncrement(Strings.S.get("NetList_TraceListEnd"));
                }
            }
            if (gatedClock) {
                if (gatedSet.containsKey(myName)) {
                    gatedSet.get(myName).put(subCircuit, hierarchyNetlists.get(hierarchyNetlists.size() - 2).getCircuit());
                } else {
                    HashMap<netlistComponent, Circuit> newList = new HashMap<netlistComponent, Circuit>();
                    newList.put(subCircuit, hierarchyNetlists.get(hierarchyNetlists.size() - 2).getCircuit());
                    gatedSet.put(myName, newList);
                }
            } else if (notGatedSet.containsKey(myName)) {
                notGatedSet.get(myName).put(subCircuit, hierarchyNetlists.get(hierarchyNetlists.size() - 2).getCircuit());
            } else {
                HashMap<netlistComponent, Circuit> newList = new HashMap<netlistComponent, Circuit>();
                newList.put(subCircuit, hierarchyNetlists.get(hierarchyNetlists.size() - 2).getCircuit());
                notGatedSet.put(myName, newList);
            }
        } else {
            this.warningForGatedClock(nonPinSources, nonPinGatedComponents, nonPinWires, warnedComponents, hierarchyNetlists, Strings.S.get("NetList_GatedClock"));
            this.warningForGatedClock(pinSources, pinGatedComponents, pinWires, warnedComponents, hierarchyNetlists, Strings.S.get("NetList_PossibleGatedClock"));
        }
    }

    private boolean hasGatedClock(netlistComponent comp, int clockPinIndex, List<SourceInfo> pinSources, List<Set<Wire>> pinWires, List<Set<netlistComponent>> pinGatedComponents, List<SourceInfo> nonPinSources, List<Set<Wire>> nonPinWires, List<Set<netlistComponent>> nonPinGatedComponents, Set<netlistComponent> warnedComponents) {
        boolean isGatedClock = false;
        String clockNetName = Hdl.getClockNetName(comp, clockPinIndex, this);
        if (clockNetName.isEmpty()) {
            ConnectionPoint connection = comp.getEnd(clockPinIndex).get((byte)0);
            Net connectedNet = connection.getParentNet();
            Byte connectedNetindex = connection.getParentNetBitIndex();
            boolean hasSource = false;
            if (connectedNet != null) {
                isGatedClock = true;
                HashSet<Wire> segments = new HashSet<Wire>();
                SourceInfo source = this.getHiddenSource(null, (byte)0, connectedNet, connectedNetindex, this.mySplitters, new HashSet<String>(), segments, null);
                boolean bl = hasSource = source != null;
                if (hasSource) {
                    ConnectionPoint sourceCon = source.getSource();
                    if (sourceCon.getComp().getFactory() instanceof Pin) {
                        int index = this.getEntryIndex(pinSources, sourceCon, (int)connectedNetindex);
                        if (index < 0) {
                            pinSources.add(source);
                            pinWires.add(segments);
                            HashSet<netlistComponent> comps = new HashSet<netlistComponent>();
                            comps.add(comp);
                            comps.add(new netlistComponent(sourceCon.getComp()));
                            pinGatedComponents.add(comps);
                        } else {
                            pinGatedComponents.get(index).add(comp);
                        }
                    } else {
                        int index = this.getEntryIndex(nonPinSources, sourceCon, (int)connectedNetindex);
                        if (index < 0) {
                            nonPinSources.add(source);
                            nonPinWires.add(segments);
                            HashSet<netlistComponent> comps = new HashSet<netlistComponent>();
                            comps.add(comp);
                            nonPinGatedComponents.add(comps);
                        } else {
                            nonPinGatedComponents.get(index).add(comp);
                        }
                    }
                }
            }
            if (!hasSource && !warnedComponents.contains(comp)) {
                SimpleDrcContainer warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_NoClockConnection"), 2, 1);
                warn.addMarkComponent(comp.getComponent());
                Reporter.report.addWarning(warn);
                warnedComponents.add(comp);
            }
        }
        return isGatedClock;
    }

    private int getEntryIndex(List<SourceInfo> searchList, ConnectionPoint connection, Integer index) {
        int result = -1;
        for (int i = 0; i < searchList.size(); ++i) {
            SourceInfo thisEntry = searchList.get(i);
            if (!thisEntry.getSource().equals(connection) || !thisEntry.getIndex().equals(index)) continue;
            result = i;
        }
        return result;
    }

    private void warningTraceForGatedClock(ConnectionPoint sourcePoint, int index, List<Netlist> hierarchyNetlists, List<String> hierarchyNames) {
        Object subNet;
        Component comp = sourcePoint.getComp();
        if (comp.getFactory() instanceof Pin) {
            if (hierarchyNames.isEmpty()) {
                return;
            }
            int idx = -1;
            for (int i = 0; i < this.myInputPorts.size(); ++i) {
                if (!this.myInputPorts.get(i).getComponent().equals(comp)) continue;
                idx = i;
            }
            if (idx < 0) {
                Reporter.report.addFatalErrorFmt("BUG: Could not find port!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return;
            }
            subNet = hierarchyNetlists.get(hierarchyNetlists.size() - 2).getNetlistConnectionForSubCircuitInput(hierarchyNames.get(hierarchyNames.size() - 1), idx, (byte)index);
            if (subNet == null) {
                Reporter.report.addFatalErrorFmt("BUG: Could not find a sub-circuit connection in overlying hierarchy level!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return;
            }
            if (((ConnectionPoint)subNet).getParentNet() != null) {
                ArrayList<String> newHierarchyNames = new ArrayList<String>(hierarchyNames);
                newHierarchyNames.remove(newHierarchyNames.size() - 1);
                ArrayList<Netlist> newHierarchyNetlists = new ArrayList<Netlist>(hierarchyNetlists);
                newHierarchyNetlists.remove(newHierarchyNetlists.size() - 1);
                Netlist subNetList = hierarchyNetlists.get(hierarchyNetlists.size() - 2);
                Net newNet = ((ConnectionPoint)subNet).getParentNet();
                Byte newNetIndex = ((ConnectionPoint)subNet).getParentNetBitIndex();
                HashSet<Wire> segments = new HashSet<Wire>();
                SourceInfo source = subNetList.getHiddenSource(null, (byte)0, newNet, newNetIndex, subNetList.mySplitters, new HashSet<String>(), segments, null);
                if (source == null) {
                    Reporter.report.addFatalErrorFmt("BUG: Unable to find source in sub-circuit!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                    return;
                }
                ComponentFactory sfac = source.getSource().getComp().getFactory();
                if (sfac instanceof Pin || sfac instanceof SubcircuitFactory) {
                    warn = new SimpleDrcContainer(subNetList.getCircuit(), Strings.S.get("NetList_GatedClockInt"), 1, 4, true);
                    warn.addMarkComponents(segments);
                    Reporter.report.addWarning(warn);
                    subNetList.warningTraceForGatedClock(source.getSource(), source.getIndex(), newHierarchyNetlists, newHierarchyNames);
                } else {
                    warn = new SimpleDrcContainer(subNetList.getCircuit(), Strings.S.get("NetList_GatedClockSource"), 1, 4, true);
                    warn.addMarkComponents(segments);
                    Reporter.report.addWarning(warn);
                }
            }
        }
        if ((subNet = comp.getFactory()) instanceof SubcircuitFactory) {
            SubcircuitFactory sub = (SubcircuitFactory)subNet;
            if (sourcePoint.getChildsPortIndex() < 0) {
                Reporter.report.addFatalErrorFmt("BUG: Subcircuit port is not annotated!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return;
            }
            netlistComponent outputPort = sub.getSubcircuit().getNetList().getOutputPin(sourcePoint.getChildsPortIndex());
            if (outputPort == null) {
                Reporter.report.addFatalErrorFmt("BUG: Unable to find Subcircuit output port!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return;
            }
            Net connectedNet = sourcePoint.getParentNet();
            netlistComponent subCirc = null;
            for (netlistComponent circ : this.mySubCircuits) {
                if (!circ.getComponent().equals(sourcePoint.getComp())) continue;
                subCirc = circ;
            }
            if (subCirc == null) {
                Reporter.report.addFatalErrorFmt("BUG: Unable to find Subcircuit!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return;
            }
            byte bitIndex = subCirc.getConnectionBitIndex(connectedNet, (byte)index);
            if (bitIndex < 0) {
                Reporter.report.addFatalErrorFmt("BUG: Unable to find the bit index of a Subcircuit output port!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                return;
            }
            ConnectionPoint subNet2 = outputPort.getEnd(0).get(bitIndex);
            if (subNet2.getParentNet() != null) {
                Netlist subNetList = sub.getSubcircuit().getNetList();
                ArrayList<String> newHierarchyNames = new ArrayList<String>(hierarchyNames);
                newHierarchyNames.add(CorrectLabel.getCorrectLabel(subCirc.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
                ArrayList<Netlist> newHierarchyNetlists = new ArrayList<Netlist>(hierarchyNetlists);
                newHierarchyNetlists.add(subNetList);
                Net newNet = subNet2.getParentNet();
                Byte newNetIndex = subNet2.getParentNetBitIndex();
                HashSet<Wire> segments = new HashSet<Wire>();
                SourceInfo source = subNetList.getHiddenSource(null, (byte)0, newNet, newNetIndex, subNetList.mySplitters, new HashSet<String>(), segments, null);
                if (source == null) {
                    Reporter.report.addFatalErrorFmt("BUG: Unable to find source in sub-circuit!\n ==> %s:%d\n", this.getClass().getName().replace(".", "/"), Thread.currentThread().getStackTrace()[2].getLineNumber());
                    return;
                }
                ComponentFactory sfac = source.getSource().getComp().getFactory();
                if (sfac instanceof Pin || sfac instanceof SubcircuitFactory) {
                    SimpleDrcContainer warn = new SimpleDrcContainer(subNetList.getCircuit(), Strings.S.get("NetList_GatedClockInt"), 1, 4, true);
                    warn.addMarkComponents(segments);
                    Reporter.report.addWarning(warn);
                    subNetList.warningTraceForGatedClock(source.getSource(), source.getIndex(), newHierarchyNetlists, newHierarchyNames);
                } else {
                    SimpleDrcContainer warn = new SimpleDrcContainer(subNetList.getCircuit(), Strings.S.get("NetList_GatedClockSource"), 1, 4, true);
                    warn.addMarkComponents(segments);
                    Reporter.report.addWarning(warn);
                }
            }
        }
    }

    private void warningForGatedClock(List<SourceInfo> sources, List<Set<netlistComponent>> components, List<Set<Wire>> wires, Set<netlistComponent> warnedComponents, List<Netlist> hierarchyNetlists, String warning) {
        if (AppPreferences.SupressGatedClockWarnings.getBoolean()) {
            return;
        }
        for (int i = 0; i < sources.size(); ++i) {
            boolean alreadyWarned = false;
            for (netlistComponent comp : components.get(i)) {
                alreadyWarned |= warnedComponents.contains(comp);
            }
            if (alreadyWarned) continue;
            if (sources.get(i).getSource().getComp().getFactory() instanceof SubcircuitFactory) {
                Reporter.report.addSevereWarning(Strings.S.get("NetList_GatedClock"));
                Reporter.report.addWarningIncrement(Strings.S.get("NetList_TraceListBegin"));
                warn = new SimpleDrcContainer(this.myCircuit, Strings.S.get("NetList_GatedClockSink"), 1, 5, true);
                warn.addMarkComponents(wires.get(i));
                for (netlistComponent comp : components.get(i)) {
                    warn.addMarkComponent(comp.getComponent());
                }
                Reporter.report.addWarning(warn);
                this.warningTraceForGatedClock(sources.get(i).getSource(), sources.get(i).getIndex(), hierarchyNetlists, this.currentHierarchyLevel);
                Reporter.report.addWarningIncrement(Strings.S.get("NetList_TraceListEnd"));
            } else {
                warn = new SimpleDrcContainer(this.myCircuit, warning, 2, 5);
                for (netlistComponent comp : components.get(i)) {
                    warn.addMarkComponent(comp.getComponent());
                }
                warn.addMarkComponents(wires.get(i));
                Reporter.report.addWarning(warn);
            }
            warnedComponents.addAll((Collection<netlistComponent>)components.get(i));
        }
    }

    public static boolean isFlipFlop(AttributeSet attrs) {
        if (attrs.containsAttribute(StdAttr.EDGE_TRIGGER)) {
            return true;
        }
        if (attrs.containsAttribute(StdAttr.TRIGGER)) {
            return attrs.getValue(StdAttr.TRIGGER) == StdAttr.TRIG_FALLING || attrs.getValue(StdAttr.TRIGGER) == StdAttr.TRIG_RISING;
        }
        return false;
    }

    private static class SourceInfo {
        private final ConnectionPoint source;
        private final byte index;

        public SourceInfo(ConnectionPoint source, byte index) {
            this.source = source;
            this.index = index;
        }

        public Integer getIndex() {
            return this.index;
        }

        public ConnectionPoint getSource() {
            return this.source;
        }
    }

    public static class NetInfo {
        private final Net theNet;
        private final byte bitIndex;

        public NetInfo(Net concernedNet, byte index) {
            this.theNet = concernedNet;
            this.bitIndex = index;
        }

        public Byte getIndex() {
            return this.bitIndex;
        }

        public Net getNet() {
            return this.theNet;
        }
    }
}

