/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.download;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.download.Download;
import com.cburch.logisim.fpga.download.DownloadBase;
import com.cburch.logisim.fpga.download.VendorDownload;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.settings.VendorSoftware;
import com.cburch.logisim.util.LineBuffer;
import com.cburch.logisim.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AlteraDownload
implements VendorDownload {
    private final VendorSoftware alteraVendor = VendorSoftware.getSoftware('\u0000');
    private final String scriptPath;
    private final String projectPath;
    private final String sandboxPath;
    private final Netlist rootNetList;
    private MappableResourcesContainer mapInfo;
    private final BoardInformation boardInfo;
    private final List<String> entities;
    private final List<String> architectures;
    private final String hdlType;
    private String cablename;
    private final boolean writeToFlash;
    private static final String alteraTclFile = "AlteraDownload.tcl";
    private static final String AlteraCofFile = "AlteraFlash.cof";

    public AlteraDownload(String projectPath, Netlist rootNetList, BoardInformation boardInfo, List<String> entities, List<String> architectures, String hdlType, boolean writeToFlash) {
        this.projectPath = projectPath;
        this.sandboxPath = DownloadBase.getDirectoryLocation(projectPath, DownloadBase.SANDBOX_PATH);
        this.scriptPath = DownloadBase.getDirectoryLocation(projectPath, DownloadBase.SCRIPT_PATH);
        this.rootNetList = rootNetList;
        this.boardInfo = boardInfo;
        this.entities = entities;
        this.architectures = architectures;
        this.hdlType = hdlType;
        this.writeToFlash = writeToFlash;
        this.cablename = "";
    }

    @Override
    public void setMapableResources(MappableResourcesContainer resources) {
        this.mapInfo = resources;
    }

    @Override
    public int getNumberOfStages() {
        return 3;
    }

    @Override
    public String getStageMessage(int stage) {
        return switch (stage) {
            case 0 -> Strings.S.get("AlteraProject");
            case 1 -> Strings.S.get("AlteraOptimize");
            case 2 -> Strings.S.get("AlteraSyntPRBit");
            default -> "Unknown, bizare";
        };
    }

    @Override
    public ProcessBuilder performStep(int stage) {
        return switch (stage) {
            case 0 -> this.stage0Project();
            case 1 -> this.stage1Optimize();
            case 2 -> this.stage2SprBit();
            default -> null;
        };
    }

    @Override
    public boolean readyForDownload() {
        boolean SofFile = new File(this.sandboxPath + "logisimTopLevelShell.sof").exists();
        boolean PofFile = new File(this.sandboxPath + "logisimTopLevelShell.pof").exists();
        return SofFile || PofFile;
    }

    @Override
    public ProcessBuilder downloadToBoard() {
        if (this.writeToFlash && !this.doFlashing()) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.alteraVendor.getBinaryPath(1));
        command.add("-c");
        command.add(this.cablename);
        command.add("-m");
        command.add("jtag");
        command.add("-o");
        if (new File(this.sandboxPath + "logisimTopLevelShell.sof").exists()) {
            command.add("P;logisimTopLevelShell.sof@" + this.boardInfo.fpga.getFpgaJTAGChainPosition());
        } else {
            command.add("P;logisimTopLevelShell.pof@" + this.boardInfo.fpga.getFpgaJTAGChainPosition());
        }
        ProcessBuilder down = new ProcessBuilder(command);
        down.directory(new File(this.sandboxPath));
        return down;
    }

    private ProcessBuilder stage0Project() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.alteraVendor.getBinaryPath(0));
        command.add("-t");
        command.add(this.scriptPath.replace(this.projectPath, ".." + File.separator) + alteraTclFile);
        ProcessBuilder stage0 = new ProcessBuilder(command);
        stage0.directory(new File(this.sandboxPath));
        return stage0;
    }

    private ProcessBuilder stage1Optimize() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.alteraVendor.getBinaryPath(2));
        command.add("logisimTopLevelShell");
        command.add("--optimize=area");
        ProcessBuilder stage1 = new ProcessBuilder(command);
        stage1.directory(new File(this.sandboxPath));
        return stage1;
    }

    private ProcessBuilder stage2SprBit() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.alteraVendor.getBinaryPath(0));
        command.add("--flow");
        command.add("compile");
        command.add("logisimTopLevelShell");
        ProcessBuilder stage2 = new ProcessBuilder(command);
        stage2.directory(new File(this.sandboxPath));
        return stage2;
    }

    @Override
    public boolean createDownloadScripts() {
        File scriptFile = FileWriter.getFilePointer(this.scriptPath, alteraTclFile);
        if (scriptFile == null) {
            scriptFile = new File(this.scriptPath + alteraTclFile);
            return scriptFile.exists();
        }
        String fileType = this.hdlType.equals("VHDL") ? "VHDL_FILE" : "VERILOG_FILE";
        LineBuffer contents = LineBuffer.getBuffer();
        contents.pair("topLevelName", "logisimTopLevelShell").pair("fileType", fileType).pair("clock", "fpgaGlobalClock");
        contents.add("# Load Quartus II Tcl Project package\npackage require ::quartus::project\n\nset need_to_close_project 0\nset make_assignments 1\n\n# Check that the right project is open\nif {[is_project_open]} {\n    if {[string compare $quartus(project) \"{{topLevelName}}\"]} {\n        puts \"Project {{topLevelName}} is not open\"\n        set make_assignments 0\n    }\n} else {\n    # Only open if not already open\n    if {[project_exists {{topLevelName}}]} {\n        project_open -revision {{topLevelName}} {{topLevelName}}\n    } else {\n        project_new -revision {{topLevelName}} {{topLevelName}}\n    }\n    set need_to_close_project 1\n}\n# Make assignments\nif {$make_assignments} {\n").add(AlteraDownload.getAlteraAssignments(this.boardInfo)).add("\n    # Include all entities and gates\n\n");
        for (String entity : this.entities) {
            contents.add("    set_global_assignment -name {{fileType}} \"{{1}}\"", entity);
        }
        for (String architecture : this.architectures) {
            contents.add("    set_global_assignment -name {{fileType}} \"{{1}}\"", architecture);
        }
        contents.add("");
        contents.add("    # Map fpga_clk and ionets to fpga pins");
        if (this.rootNetList.numberOfClockTrees() > 0 || this.rootNetList.requiresGlobalClockConnection()) {
            contents.add("    set_location_assignment {{1}} -to {{clock}}", this.boardInfo.fpga.getClockPinLocation());
        }
        contents.add(this.getPinLocStrings()).add("    # Commit assignments\n    export_assignments\n\n    # Close project\n    if {$need_to_close_project} {\n        project_close\n    }\n}\n");
        return FileWriter.writeContents(scriptFile, contents.get());
    }

    private List<String> getPinLocStrings() {
        LineBuffer contents = LineBuffer.getBuffer();
        for (ArrayList<String> key : this.mapInfo.getMappableResources().keySet()) {
            MapComponent map = this.mapInfo.getMappableResources().get(key);
            for (int i = 0; i < map.getNrOfPins(); ++i) {
                if (!map.isMapped(i) || map.isOpenMapped(i) || map.isConstantMapped(i) || map.isInternalMapped(i)) continue;
                LineBuffer.Pairs pairs = new LineBuffer.Pairs().pair("pinLoc", map.getPinLocation(i)).pair("inv", map.isExternalInverted(i) ? "n_" : "").pair("hdlStr", map.getHdlString(i));
                contents.add("set_location_assignment {{pinLoc}} -to {{inv}}{{hdlStr}}", pairs);
                if (!map.requiresPullup(i)) continue;
                contents.add("set_instance_assignment -name WEAK_PULL_UP_RESISTOR ON -to {{inv}}{{hdlStr}}", pairs);
            }
        }
        Map<String, String> ledArrayMap = DownloadBase.getLedArrayMaps(this.mapInfo, this.rootNetList, this.boardInfo);
        for (String key : ledArrayMap.keySet()) {
            contents.add("set_location_assignment {{1}} -to {{2}}", ledArrayMap.get(key), key);
        }
        return contents.getWithIndent(4);
    }

    private static List<String> getAlteraAssignments(BoardInformation currentBoard) {
        String[] pkg = currentBoard.fpga.getPackage().split(" ");
        char currentBehavior = currentBoard.fpga.getUnusedPinsBehavior();
        String behavior = switch (currentBehavior) {
            case '\u0001' -> "PULLUP";
            case '\u0002' -> "PULLDOWN";
            case '\u0000' -> "TRI-STATED";
            default -> throw new IllegalStateException("Unexpected value: " + currentBehavior);
        };
        return LineBuffer.getBuffer().pair("assignName", "set_global_assignment -name").add("{{assignName}} FAMILY \"{{1}}\"", currentBoard.fpga.getTechnology()).add("{{assignName}} DEVICE {{1}}", currentBoard.fpga.getPart()).add("{{assignName}} DEVICE_FILTER_PACKAGE {{1}}", pkg[0]).add("{{assignName}} DEVICE_FILTER_PIN_COUNT {{1}}", pkg[1]).add("{{assignName}} RESERVE_ALL_UNUSED_PINS \"AS INPUT {{1}}\"", behavior).add("{{assignName}} FMAX_REQUIREMENT \"{{1}}\"", Download.getClockFrequencyString(currentBoard)).add("{{assignName}} RESERVE_NCEO_AFTER_CONFIGURATION \"USE AS REGULAR IO\"").add("{{assignName}} CYCLONEII_RESERVE_NCEO_AFTER_CONFIGURATION \"USE AS REGULAR IO\"").getWithIndent();
    }

    @Override
    public boolean isBoardConnected() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.alteraVendor.getBinaryPath(1));
        command.add("--list");
        ProcessBuilder detect = new ProcessBuilder(command);
        detect.directory(new File(this.sandboxPath));
        ArrayList<String> response = new ArrayList<String>();
        try {
            Reporter.report.print("");
            Reporter.report.print("===");
            Reporter.report.print("===> " + Strings.S.get("AlteraDetectDevice"));
            Reporter.report.print("===");
            if (Download.execute(detect, response) != null) {
                return false;
            }
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
        List<String> devices = this.getDevices(response);
        if (devices == null) {
            return false;
        }
        if (devices.size() == 1) {
            this.cablename = devices.get(0);
            return true;
        }
        String selection = Download.chooseBoard(devices);
        if (selection == null) {
            return false;
        }
        this.cablename = selection;
        return true;
    }

    private List<String> getDevices(ArrayList<String> lines) {
        ArrayList<String> dev = new ArrayList<String>();
        for (String line : lines) {
            int n;
            if (!line.matches("^" + (n = dev.size() + 1) + "\\) .*")) continue;
            line = line.replaceAll("^" + n + "\\) ", "");
            dev.add(line.trim());
        }
        return dev.isEmpty() ? null : dev;
    }

    private boolean doFlashing() {
        if (!this.createCofFile()) {
            Reporter.report.addError(Strings.S.get("AlteraFlashError"));
            return false;
        }
        if (!this.createJicFile()) {
            Reporter.report.addError(Strings.S.get("AlteraFlashError"));
            return false;
        }
        if (!this.loadProgrammerSoftware()) {
            Reporter.report.addError(Strings.S.get("AlteraFlashError"));
            return false;
        }
        if (!this.flashDevice()) {
            Reporter.report.addError(Strings.S.get("AlteraFlashError"));
            return false;
        }
        return true;
    }

    private boolean flashDevice() {
        String jicFile = "logisimTopLevelShell.jic";
        Reporter.report.print("==>");
        Reporter.report.print("==> " + Strings.S.get("AlteraFlash"));
        Reporter.report.print("==>");
        if (!new File(this.sandboxPath + "logisimTopLevelShell.jic").exists()) {
            Reporter.report.addError(Strings.S.get("AlteraFlashError", "logisimTopLevelShell.jic"));
            return false;
        }
        LineBuffer command = LineBuffer.getBuffer();
        command.add(this.alteraVendor.getBinaryPath(1)).add("-c").add(this.cablename).add("-m").add("jtag").add("-o").add("P;{{1}}", "logisimTopLevelShell.jic");
        ProcessBuilder prog = new ProcessBuilder(command.get());
        prog.directory(new File(this.sandboxPath));
        try {
            String result = Download.execute(prog, null);
            if (result != null) {
                Reporter.report.addFatalError(Strings.S.get("AlteraFlashFailure"));
                return false;
            }
        }
        catch (IOException | InterruptedException e) {
            Reporter.report.addFatalError(Strings.S.get("AlteraFlashFailure"));
            return false;
        }
        return true;
    }

    private boolean loadProgrammerSoftware() {
        String FpgaDevice = this.stripPackageSpeedSuffix();
        String ProgrammerSofFile = new File(VendorSoftware.getToolPath('\u0000')).getParent() + File.separator + "common" + File.separator + "devinfo" + File.separator + "programmer" + File.separator + "sfl_" + FpgaDevice.toLowerCase() + ".sof";
        Reporter.report.print("==>");
        Reporter.report.print("==> " + Strings.S.get("AlteraProgSof"));
        Reporter.report.print("==>");
        if (!new File(ProgrammerSofFile).exists()) {
            Reporter.report.addError(Strings.S.get("AlteraProgSofError", ProgrammerSofFile));
            return false;
        }
        LineBuffer command = LineBuffer.getBuffer();
        command.add(this.alteraVendor.getBinaryPath(1)).add("-c").add(this.cablename).add("-m").add("jtag").add("-o").add("P;{{1}}", ProgrammerSofFile);
        ProcessBuilder prog = new ProcessBuilder(command.get());
        prog.directory(new File(this.sandboxPath));
        try {
            String result = Download.execute(prog, null);
            if (result != null) {
                Reporter.report.addFatalError(Strings.S.get("AlteraProgSofFailure"));
                return false;
            }
        }
        catch (IOException | InterruptedException e) {
            Reporter.report.addFatalError(Strings.S.get("AlteraProgSofFailure"));
            return false;
        }
        return true;
    }

    private String stripPackageSpeedSuffix() {
        String FpgaDevice = this.boardInfo.fpga.getPart();
        int index = FpgaDevice.indexOf("F");
        return FpgaDevice.substring(0, index);
    }

    private boolean createJicFile() {
        if (!new File(this.scriptPath + AlteraCofFile).exists()) {
            Reporter.report.addError(Strings.S.get("AlteraNoCof"));
            return false;
        }
        Reporter.report.print("==>");
        Reporter.report.print("==> " + Strings.S.get("AlteraJicFile"));
        Reporter.report.print("==>");
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.alteraVendor.getBinaryPath(3));
        command.add("-c");
        command.add((this.scriptPath + AlteraCofFile).replace(this.projectPath, "../"));
        ProcessBuilder jic = new ProcessBuilder(command);
        jic.directory(new File(this.sandboxPath));
        try {
            String result = Download.execute(jic, null);
            if (result != null) {
                Reporter.report.addFatalError(Strings.S.get("AlteraJicFileError"));
                return false;
            }
        }
        catch (IOException | InterruptedException e) {
            Reporter.report.addFatalError(Strings.S.get("AlteraJicFileError"));
            return false;
        }
        return true;
    }

    private boolean createCofFile() {
        if (!new File(this.sandboxPath + "logisimTopLevelShell.sof").exists()) {
            Reporter.report.addFatalError(Strings.S.get("AlteraNoSofFile"));
            return false;
        }
        Reporter.report.print("==>");
        Reporter.report.print("==> " + Strings.S.get("AlteraCofFile"));
        Reporter.report.print("==>");
        try {
            DocumentBuilderFactory docFactory = XmlUtil.getHardenedBuilderFactory();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document cofFile = docBuilder.newDocument();
            cofFile.setXmlStandalone(true);
            Element rootElement = cofFile.createElement("cof");
            cofFile.appendChild(rootElement);
            this.addElement("eprom_name", this.boardInfo.fpga.getFlashName(), rootElement, cofFile);
            this.addElement("flash_loader_device", this.stripPackageSpeedSuffix(), rootElement, cofFile);
            this.addElement("output_filename", this.sandboxPath + "logisimTopLevelShell.jic", rootElement, cofFile);
            this.addElement("n_pages", "1", rootElement, cofFile);
            this.addElement("width", "1", rootElement, cofFile);
            this.addElement("mode", "7", rootElement, cofFile);
            Element sofData = cofFile.createElement("sof_data");
            rootElement.appendChild(sofData);
            this.addElement("user_name", "Page_0", sofData, cofFile);
            this.addElement("page_flags", "1", sofData, cofFile);
            Element bitFile = cofFile.createElement("bit0");
            sofData.appendChild(bitFile);
            this.addElement("sof_filename", this.sandboxPath + "logisimTopLevelShell.sof", bitFile, cofFile);
            this.addElement("version", "10", rootElement, cofFile);
            this.addElement("create_cvp_file", "0", rootElement, cofFile);
            this.addElement("create_hps_iocsr", "0", rootElement, cofFile);
            this.addElement("auto_create_rpd", "0", rootElement, cofFile);
            this.addElement("rpd_little_endian", "1", rootElement, cofFile);
            Element options = cofFile.createElement("options");
            rootElement.appendChild(options);
            this.addElement("map_file", "0", options, cofFile);
            Element advancedOptions = cofFile.createElement("advanced_options");
            rootElement.appendChild(advancedOptions);
            this.addElement("ignore_epcs_id_check", "2", advancedOptions, cofFile);
            this.addElement("ignore_condone_check", "2", advancedOptions, cofFile);
            this.addElement("plc_adjustment", "0", advancedOptions, cofFile);
            this.addElement("post_chain_bitstream_pad_bytes", "-1", advancedOptions, cofFile);
            this.addElement("post_device_bitstream_pad_bytes", "-1", advancedOptions, cofFile);
            this.addElement("bitslice_pre_padding", "1", advancedOptions, cofFile);
            TransformerFactory transformerFac = TransformerFactory.newInstance();
            Transformer transformer = transformerFac.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "US-ASCII");
            transformer.setOutputProperty("standalone", "yes");
            DOMSource source = new DOMSource(cofFile);
            StreamResult result = new StreamResult(new File(this.scriptPath + AlteraCofFile));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException | TransformerException e) {
            Reporter.report.addError(Strings.S.get("AlteraErrorCof"));
            return false;
        }
        return true;
    }

    private void addElement(String elementName, String elementValue, Element root, Document doc) {
        Element namedElement = doc.createElement(elementName);
        namedElement.appendChild(doc.createTextNode(elementValue));
        root.appendChild(namedElement);
    }
}

