/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.download;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoComponentTypes;
import com.cburch.logisim.fpga.data.LedArrayDriving;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.TickComponentHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.ToplevelHdlGeneratorFactory;
import com.cburch.logisim.fpga.settings.VendorSoftware;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class DownloadBase {
    protected Project myProject;
    protected BoardInformation myBoardInformation = null;
    protected MappableResourcesContainer myMappableResources;
    static final String[] HDLPaths = new String[]{"Verilog".toLowerCase(), "VHDL".toLowerCase(), "scripts", "sandbox", "ucf", "xdc"};
    public static final Integer VERILOG_SOURCE_PATH = 0;
    public static final Integer VHDL_SOURCE_PATH = 1;
    public static final Integer SCRIPT_PATH = 2;
    public static final Integer SANDBOX_PATH = 3;
    public static final Integer UCF_PATH = 4;
    public static final Integer XDC_PATH = 5;

    protected boolean isVendorSoftwarePresent() {
        return VendorSoftware.toolsPresent(this.myBoardInformation.fpga.getVendor(), VendorSoftware.getToolPath(this.myBoardInformation.fpga.getVendor()));
    }

    protected boolean mapDesign(String circuitName) {
        LogisimFile myFile = this.myProject.getLogisimFile();
        Circuit rootSheet = myFile.getCircuit(circuitName);
        if (rootSheet == null) {
            Reporter.report.addError("INTERNAL ERROR: Circuit not found ?!?");
            return false;
        }
        if (this.myBoardInformation == null) {
            Reporter.report.addError("INTERNAL ERROR: No board information available ?!?");
            return false;
        }
        Map<String, ArrayList<Integer>> boardComponents = this.myBoardInformation.getComponents();
        Reporter.report.addInfo("The Board " + this.myBoardInformation.getBoardName() + " has:");
        for (String key : boardComponents.keySet()) {
            Reporter.report.addInfo(boardComponents.get(key).size() + " " + key + "(s)");
        }
        this.myMappableResources = rootSheet.getBoardMap(this.myBoardInformation.getBoardName());
        if (this.myMappableResources == null) {
            this.myMappableResources = new MappableResourcesContainer(this.myBoardInformation, rootSheet);
        } else {
            this.myMappableResources.updateMapableComponents();
        }
        return true;
    }

    protected boolean mapDesignCheckIOs() {
        if (this.myMappableResources.isCompletelyMapped()) {
            return true;
        }
        int confirm = OptionPane.showConfirmDialog(this.myProject.getFrame(), Strings.S.get("FpgaNotCompleteMap"), Strings.S.get("FpgaIncompleteMap"), 0);
        return confirm == 0;
    }

    protected boolean performDrc(String circuitName, String HDLType) {
        Circuit root = this.myProject.getLogisimFile().getCircuit(circuitName);
        ArrayList<String> sheetNames = new ArrayList<String>();
        int drcResult = 0;
        if (root == null) {
            drcResult |= 2;
        } else {
            root.getNetList().clear();
            drcResult = root.getNetList().designRuleCheckResult(true, sheetNames);
        }
        return drcResult == 0;
    }

    protected String getProjDir(String selectedCircuit) {
        String projectDir = AppPreferences.FPGA_Workspace.get() + File.separator + this.myProject.getLogisimFile().getName();
        if (!projectDir.endsWith(File.separator)) {
            projectDir = projectDir + File.separator;
        }
        projectDir = projectDir + CorrectLabel.getCorrectLabel(selectedCircuit) + File.separator;
        return projectDir;
    }

    protected boolean writeHDL(String selectedCircuit, Double frequency) {
        ToplevelHdlGeneratorFactory top;
        if (!this.genDirectory(AppPreferences.FPGA_Workspace.get() + File.separator + this.myProject.getLogisimFile().getName())) {
            Reporter.report.addFatalError("Unable to create directory: \"" + AppPreferences.FPGA_Workspace.get() + File.separator + this.myProject.getLogisimFile().getName() + "\"");
            return false;
        }
        String projectDir = this.getProjDir(selectedCircuit);
        Circuit rootSheet = this.myProject.getLogisimFile().getCircuit(selectedCircuit);
        if (!this.cleanDirectory(projectDir)) {
            Reporter.report.addFatalError("Unable to cleanup old project files in directory: \"" + projectDir + "\"");
            return false;
        }
        if (!this.genDirectory(projectDir)) {
            Reporter.report.addFatalError("Unable to create directory: \"" + projectDir + "\"");
            return false;
        }
        for (String hdlPath : HDLPaths) {
            if (this.genDirectory(projectDir + hdlPath)) continue;
            Reporter.report.addFatalError("Unable to create directory: \"" + projectDir + hdlPath + "\"");
            return false;
        }
        HashSet<String> generatedHDLComponents = new HashSet<String>();
        HdlGeneratorFactory worker = rootSheet.getSubcircuitFactory().getHDLGenerator(rootSheet.getStaticAttributes());
        if (worker == null) {
            Reporter.report.addFatalError("Internal error on HDL generation, null pointer exception");
            return false;
        }
        if (!worker.generateAllHDLDescriptions(generatedHDLComponents, projectDir, null)) {
            return false;
        }
        if (rootSheet.getNetList().numberOfClockTrees() > 0) {
            TickComponentHdlGeneratorFactory ticker = new TickComponentHdlGeneratorFactory(this.myBoardInformation.fpga.getClockFrequency(), frequency);
            if (!Hdl.writeEntity(projectDir + ticker.getRelativeDirectory(), ticker.getEntity(rootSheet.getNetList(), null, "logisimTickGenerator"), "logisimTickGenerator")) {
                return false;
            }
            if (!Hdl.writeArchitecture(projectDir + ticker.getRelativeDirectory(), ticker.getArchitecture(rootSheet.getNetList(), null, "logisimTickGenerator"), "logisimTickGenerator")) {
                return false;
            }
            HdlGeneratorFactory clockGen = rootSheet.getNetList().getAllClockSources().get(0).getFactory().getHDLGenerator(rootSheet.getNetList().getAllClockSources().get(0).getAttributeSet());
            String compName = rootSheet.getNetList().getAllClockSources().get(0).getFactory().getHDLName(null);
            if (!Hdl.writeEntity(projectDir + clockGen.getRelativeDirectory(), clockGen.getEntity(rootSheet.getNetList(), null, compName), compName)) {
                return false;
            }
            if (!Hdl.writeArchitecture(projectDir + clockGen.getRelativeDirectory(), clockGen.getArchitecture(rootSheet.getNetList(), null, compName), compName)) {
                return false;
            }
        }
        if ((top = new ToplevelHdlGeneratorFactory(this.myBoardInformation.fpga.getClockFrequency(), frequency, rootSheet, this.myMappableResources)).hasLedArray()) {
            for (String type : LedArrayDriving.DRIVING_STRINGS) {
                if (!top.hasLedArrayType(type)) continue;
                worker = LedArrayGenericHdlGeneratorFactory.getSpecificHDLGenerator(type);
                String name = LedArrayGenericHdlGeneratorFactory.getSpecificHDLName(type);
                if (worker == null || name == null) continue;
                if (!Hdl.writeEntity(projectDir + worker.getRelativeDirectory(), worker.getEntity(rootSheet.getNetList(), null, name), name)) {
                    return false;
                }
                if (Hdl.writeArchitecture(projectDir + worker.getRelativeDirectory(), worker.getArchitecture(rootSheet.getNetList(), null, name), name)) continue;
                return false;
            }
        }
        if (!Hdl.writeEntity(projectDir + top.getRelativeDirectory(), top.getEntity(rootSheet.getNetList(), null, "logisimTopLevelShell"), "logisimTopLevelShell")) {
            return false;
        }
        return Hdl.writeArchitecture(projectDir + top.getRelativeDirectory(), top.getArchitecture(rootSheet.getNetList(), null, "logisimTopLevelShell"), "logisimTopLevelShell");
    }

    protected boolean genDirectory(String dirPath) {
        try {
            File dir = new File(dirPath);
            return dir.exists() ? true : dir.mkdirs();
        }
        catch (Exception e) {
            Reporter.report.addFatalError("Could not check/create directory :" + dirPath);
            return false;
        }
    }

    protected void getVhdlFiles(String sourcePath, String path, ArrayList<String> entities, ArrayList<String> behaviors, String type) {
        File[] files;
        File dir = new File(path);
        for (File thisFile : files = dir.listFiles()) {
            String architectureMask;
            if (thisFile.isDirectory()) {
                if (path.endsWith(File.separator)) {
                    this.getVhdlFiles(sourcePath, path + thisFile.getName(), entities, behaviors, type);
                    continue;
                }
                this.getVhdlFiles(sourcePath, path + File.separator + thisFile.getName(), entities, behaviors, type);
                continue;
            }
            String entityMask = type.equals("VHDL") ? "_entity.vhd" : ".v";
            String string = architectureMask = type.equals("VHDL") ? "_behavior.vhd" : "#not_searched#";
            if (thisFile.getName().endsWith(entityMask)) {
                entities.add((path + File.separator + thisFile.getName()).replace("\\", "/"));
                continue;
            }
            if (!thisFile.getName().endsWith(architectureMask)) continue;
            behaviors.add((path + File.separator + thisFile.getName()).replace("\\", "/"));
        }
    }

    public static String getDirectoryLocation(String projectBase, int identifier) {
        String base;
        String string = base = projectBase.endsWith(File.separator) ? projectBase : projectBase + File.separator;
        if (identifier >= HDLPaths.length) {
            return null;
        }
        return base + HDLPaths[identifier] + File.separator;
    }

    private boolean cleanDirectory(String dir) {
        try {
            File thisDir = new File(dir);
            if (!thisDir.exists()) {
                return true;
            }
            for (File theFiles : thisDir.listFiles()) {
                if (!(theFiles.isDirectory() ? !this.cleanDirectory(theFiles.getPath()) : !theFiles.delete())) continue;
                return false;
            }
            return thisDir.delete();
        }
        catch (Exception e) {
            Reporter.report.addFatalError("Could not remove directory tree :" + dir);
            return false;
        }
    }

    public static Map<String, String> getLedArrayMaps(MappableResourcesContainer maps, Netlist nets, BoardInformation board) {
        HashMap<String, String> ledArrayMaps = new HashMap<String, String>();
        boolean hasMappedClockedArray = false;
        for (FpgaIoInformationContainer comp : maps.getIoComponentInformation().getComponents()) {
            if (!comp.getType().equals((Object)IoComponentTypes.LedArray) || !comp.hasMap()) continue;
            hasMappedClockedArray |= LedArrayGenericHdlGeneratorFactory.requiresClock(comp.getArrayDriveMode());
            for (int pin = 0; pin < comp.getExternalPinCount(); ++pin) {
                ledArrayMaps.put(LedArrayGenericHdlGeneratorFactory.getExternalSignalName(comp.getArrayDriveMode(), comp.getNrOfRows(), comp.getNrOfColumns(), comp.getArrayId(), pin), comp.getPinLocation(pin));
            }
        }
        if (hasMappedClockedArray && nets.numberOfClockTrees() == 0 && !nets.requiresGlobalClockConnection()) {
            ledArrayMaps.put("fpgaGlobalClock", board.fpga.getClockPinLocation());
        }
        return ledArrayMaps;
    }
}

