/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.download;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoStandards;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.download.DownloadBase;
import com.cburch.logisim.fpga.download.VendorDownload;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.settings.VendorSoftware;
import com.cburch.logisim.util.LineBuffer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class VivadoDownload
implements VendorDownload {
    private final VendorSoftware vivadoVendor = VendorSoftware.getSoftware('\u0002');
    private final String scriptPath;
    private final String sandboxPath;
    private final String xdcPath;
    private final String vivadoProjectPath;
    private final Netlist rootNetList;
    private MappableResourcesContainer mapInfo;
    private final BoardInformation boardInfo;
    private final List<String> entities;
    private final List<String> architectures;
    private static String bitStreamPath;
    private static final String CREATE_PROJECT_TCL = "vivadoCreateProject.tcl";
    private static final String GENERATE_BITSTREAM_FILE = "vivadoGenerateBitStream.tcl";
    private static final String LOAD_BITSTEAM_FILE = "vivadoLoadBitStream.tcl";
    private static final String XDC_FILE = "vivadoConstraints.xdc";
    private static final String VIVADO_PROJECT_NAME = "vp";

    public VivadoDownload(String projectPath, Netlist rootNetList, BoardInformation boardInfo, List<String> entities, List<String> architectures) {
        this.sandboxPath = DownloadBase.getDirectoryLocation(projectPath, DownloadBase.SANDBOX_PATH);
        this.scriptPath = DownloadBase.getDirectoryLocation(projectPath, DownloadBase.SCRIPT_PATH);
        this.xdcPath = DownloadBase.getDirectoryLocation(projectPath, DownloadBase.XDC_PATH);
        this.rootNetList = rootNetList;
        this.boardInfo = boardInfo;
        this.entities = entities;
        this.architectures = architectures;
        this.vivadoProjectPath = this.sandboxPath + File.separator + VIVADO_PROJECT_NAME;
        bitStreamPath = this.vivadoProjectPath + File.separator + "vp.runs" + File.separator + "impl_1" + File.separator + "logisimTopLevelShell.bit";
        bitStreamPath = bitStreamPath.replace("\\", "/");
    }

    @Override
    public int getNumberOfStages() {
        return 2;
    }

    @Override
    public String getStageMessage(int stage) {
        return switch (stage) {
            case 0 -> Strings.S.get("VivadoProject");
            case 1 -> Strings.S.get("VivadoBitstream");
            default -> "Unknown";
        };
    }

    @Override
    public ProcessBuilder performStep(int stage) {
        return switch (stage) {
            case 0 -> this.stage0Project();
            case 1 -> this.stage1Bit();
            default -> null;
        };
    }

    @Override
    public boolean readyForDownload() {
        return new File(bitStreamPath).exists();
    }

    @Override
    public ProcessBuilder downloadToBoard() {
        LineBuffer command = LineBuffer.getBuffer();
        command.add(this.vivadoVendor.getBinaryPath(0)).add("-mode").add("batch").add("-source").add(this.scriptPath + File.separator + LOAD_BITSTEAM_FILE);
        ProcessBuilder stage0 = new ProcessBuilder(command.get());
        stage0.directory(new File(this.sandboxPath));
        return stage0;
    }

    @Override
    public boolean createDownloadScripts() {
        File createProjectFile = FileWriter.getFilePointer(this.scriptPath, CREATE_PROJECT_TCL);
        File xdcFile = FileWriter.getFilePointer(this.xdcPath, XDC_FILE);
        File generateBitstreamFile = FileWriter.getFilePointer(this.scriptPath, GENERATE_BITSTREAM_FILE);
        File loadBitstreamFile = FileWriter.getFilePointer(this.scriptPath, LOAD_BITSTEAM_FILE);
        if (createProjectFile == null || xdcFile == null || generateBitstreamFile == null || loadBitstreamFile == null) {
            createProjectFile = new File(this.scriptPath + CREATE_PROJECT_TCL);
            xdcFile = new File(this.xdcPath, XDC_FILE);
            generateBitstreamFile = new File(this.scriptPath, GENERATE_BITSTREAM_FILE);
            loadBitstreamFile = new File(this.scriptPath, LOAD_BITSTEAM_FILE);
            return createProjectFile.exists() && xdcFile.exists() && generateBitstreamFile.exists() && loadBitstreamFile.exists();
        }
        ArrayList<String> contents = new ArrayList<String>();
        contents.add("create_project vp \"" + this.vivadoProjectPath.replace("\\", "/") + "\"");
        contents.add("set_property part " + this.boardInfo.fpga.getPart() + this.boardInfo.fpga.getPackage() + this.boardInfo.fpga.getSpeedGrade() + " [current_project]");
        contents.add("set_property target_language VHDL [current_project]");
        for (String entity : this.entities) {
            contents.add("add_files \"" + entity + "\"");
        }
        for (String architecture : this.architectures) {
            contents.add("add_files \"" + architecture + "\"");
        }
        contents.add("add_files -fileset constrs_1 \"" + xdcFile.getAbsolutePath().replace("\\", "/") + "\"");
        contents.add("exit");
        if (!FileWriter.writeContents(createProjectFile, contents)) {
            return false;
        }
        contents.clear();
        if (this.rootNetList.numberOfClockTrees() > 0 || this.rootNetList.requiresGlobalClockConnection()) {
            String clockPin = this.boardInfo.fpga.getClockPinLocation();
            String clockSignal = "fpgaGlobalClock";
            String getPortsString = " [get_ports {fpgaGlobalClock}]";
            contents.add("set_property PACKAGE_PIN " + clockPin + " [get_ports {fpgaGlobalClock}]");
            if (this.boardInfo.fpga.getClockStandard() != '\u0000' && this.boardInfo.fpga.getClockStandard() != '\u00ff') {
                String clockIoStandard = IoStandards.BEHAVIOR_STRINGS[this.boardInfo.fpga.getClockStandard()];
                contents.add("    set_property IOSTANDARD " + clockIoStandard + " [get_ports {fpgaGlobalClock}]");
            }
            long clockFrequency = this.boardInfo.fpga.getClockFrequency();
            double clockPeriod = 1.0E9 / (double)clockFrequency;
            contents.add("    create_clock -add -name sys_clk_pin -period " + String.format(Locale.US, "%.2f", clockPeriod) + " -waveform {0 " + String.format("%1$,.0f", clockPeriod / 2.0) + "}  [get_ports {fpgaGlobalClock}]");
            contents.add("");
        }
        contents.addAll(this.getPinLocStrings());
        if (!FileWriter.writeContents(xdcFile, contents)) {
            return false;
        }
        contents.clear();
        Object openProjectPath = this.vivadoProjectPath + File.separator + "vp.xpr";
        openProjectPath = ((String)openProjectPath).replace("\\", "/");
        contents.add("open_project -verbose " + (String)openProjectPath);
        contents.add("update_compile_order -fileset sources_1");
        contents.add("launch_runs synth_1");
        contents.add("wait_on_run synth_1");
        contents.add("launch_runs impl_1 -to_step write_bitstream -jobs 8");
        contents.add("wait_on_run impl_1");
        contents.add("exit");
        if (!FileWriter.writeContents(generateBitstreamFile, contents)) {
            return false;
        }
        contents.clear();
        String jtagPos = String.valueOf(this.boardInfo.fpga.getFpgaJTAGChainPosition());
        String lindex = "[lindex [get_hw_devices] " + jtagPos + "]";
        contents.add("open_hw");
        contents.add("connect_hw_server");
        contents.add("open_hw_target");
        contents.add("set_property PROGRAM.FILE {" + bitStreamPath + "} " + lindex);
        contents.add("current_hw_device " + lindex);
        contents.add("refresh_hw_device -update_hw_probes false " + lindex);
        contents.add("program_hw_device " + lindex);
        contents.add("close_hw");
        contents.add("exit");
        return FileWriter.writeContents(loadBitstreamFile, contents);
    }

    private List<String> getPinLocStrings() {
        LineBuffer contents = LineBuffer.getBuffer();
        for (ArrayList<String> key : this.mapInfo.getMappableResources().keySet()) {
            MapComponent map = this.mapInfo.getMappableResources().get(key);
            for (int i = 0; i < map.getNrOfPins(); ++i) {
                char ioStandard;
                if (!map.isMapped(i) || map.isOpenMapped(i) || map.isConstantMapped(i) || map.isInternalMapped(i)) continue;
                String netName = (map.isExternalInverted(i) ? "n_" : "") + map.getHdlString(i);
                contents.add("set_property PACKAGE_PIN {{1}} [get_ports {{{2}}}]", map.getPinLocation(i), netName);
                FpgaIoInformationContainer info = map.getFpgaInfo(i);
                if (info == null || (ioStandard = info.getIoStandard()) == '\u00ff' || ioStandard == '\u0000') continue;
                contents.add("    set_property IOSTANDARD {{1}} [get_ports {{{2}}}]", IoStandards.getConstraintedIoStandard(info.getIoStandard()), netName);
            }
        }
        Map<String, String> LedArrayMap = DownloadBase.getLedArrayMaps(this.mapInfo, this.rootNetList, this.boardInfo);
        for (String key : LedArrayMap.keySet()) {
            contents.add("set_property PACKAGE_PIN {{1}} [get_ports {{{2}}}]", key, LedArrayMap.get(key));
        }
        return contents.get();
    }

    @Override
    public void setMapableResources(MappableResourcesContainer resources) {
        this.mapInfo = resources;
    }

    private ProcessBuilder stage0Project() {
        LineBuffer command = LineBuffer.getBuffer();
        command.add(this.vivadoVendor.getBinaryPath(0)).add("-mode").add("batch").add("-source").add(this.scriptPath + File.separator + CREATE_PROJECT_TCL);
        ProcessBuilder stage0 = new ProcessBuilder(command.get());
        stage0.directory(new File(this.sandboxPath));
        return stage0;
    }

    private ProcessBuilder stage1Bit() {
        LineBuffer command = LineBuffer.getBuffer();
        command.add(this.vivadoVendor.getBinaryPath(0)).add("-mode").add("batch").add("-source").add(this.scriptPath + File.separator + GENERATE_BITSTREAM_FILE);
        ProcessBuilder stage1 = new ProcessBuilder(command.get());
        stage1.directory(new File(this.sandboxPath));
        return stage1;
    }

    @Override
    public boolean isBoardConnected() {
        return true;
    }
}

