/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.file;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageXmlFactory {
    static final Logger logger = LoggerFactory.getLogger(ImageXmlFactory.class);
    private String[] CodeTable;
    private StringBuilder AsciiStream;
    private final String[] InitialCodeTable = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "(", ")", "+a", "+b", "+c", "+d", "+e", "+f", "+g", "+h", "+i", "+j", "+k", "+l", "+m", "+n", "+o", "+p", "+q", "+r", "+s", "+t", "+u", "+v", "+w", "+x", "+y", "+z", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "+0", "+1", "+2", "+3", "+4", "+5", "+6", "+7", "+8", "+9", "+(", "+)", "-a", "-b", "-c", "-d", "-e", "-f", "-g", "-h", "-i", "-j", "-k", "-l", "-m", "-n", "-o", "-p", "-q", "-r", "-s", "-t", "-u", "-v", "-w", "-x", "-y", "-z", "-A", "-B", "-C", "-D", "-E", "-F", "-G", "-H", "-I", "-J", "-K", "-L", "-M", "-N", "-O", "-P", "-Q", "-R", "-S", "-T", "-U", "-V", "-W", "-X", "-Y", "-Z", "-0", "-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-(", "-)", "=a", "=b", "=c", "=d", "=e", "=f", "=g", "=h", "=i", "=j", "=k", "=l", "=m", "=n", "=o", "=p", "=q", "=r", "=s", "=t", "=u", "=v", "=w", "=x", "=y", "=z", "=A", "=B", "=C", "=D", "=E", "=F", "=G", "=H", "=I", "=J", "=K", "=L", "=M", "=N", "=O", "=P", "=Q", "=R", "=S", "=T", "=U", "=V", "=W", "=X", "=Y", "=Z", "=0", "=1", "=2", "=3", "=4", "=5", "=6", "=7", "=8", "=9", "=(", "=)"};
    private final char V2_Identifier = (char)64;

    private String[] createCodeTable(byte[] stream) {
        int i;
        String[] result = new String[256];
        Long[] ocurances = new Long[256];
        int[] index = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            ocurances[i2] = 0L;
            index[i2] = i2;
        }
        for (byte b : stream) {
            Long[] longArray = ocurances;
            int n = b + 128;
            Long l = longArray[n];
            longArray[n] = longArray[n] + 1L;
        }
        boolean swapped = true;
        while (swapped) {
            swapped = false;
            for (i = 0; i < 255; ++i) {
                if (ocurances[i] >= ocurances[i + 1]) continue;
                swapped = true;
                int temp = index[i];
                index[i] = index[i + 1];
                index[i + 1] = temp;
                long swap = ocurances[i];
                ocurances[i] = ocurances[i + 1];
                ocurances[i + 1] = swap;
            }
        }
        for (i = 0; i < 256; ++i) {
            result[index[i]] = this.InitialCodeTable[i];
        }
        return result;
    }

    public void createStream(Image BoardPicture) {
        BufferedImage result = new BufferedImage(740, 400, 5);
        Graphics2D g2 = result.createGraphics();
        int width = BoardPicture.getWidth(null);
        int hight = BoardPicture.getHeight(null);
        PixelGrabber pixelGrabber = new PixelGrabber(BoardPicture, 0, 0, width, hight, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception e) {
            logger.error("PixelGrabber exception: {}", (Object)e.getMessage());
        }
        ColorModel color_model = pixelGrabber.getColorModel();
        Object object = pixelGrabber.getPixels();
        if (object instanceof byte[]) {
            byte[] thePixels = (byte[])object;
            int index = 0;
            for (int y = 0; y < hight; ++y) {
                for (int x = 0; x < width; ++x) {
                    Color PixCol = new Color(color_model.getRed(thePixels[index]), color_model.getGreen(thePixels[index]), color_model.getBlue(thePixels[index++]));
                    g2.setColor(PixCol);
                    g2.fillRect(x, y, 1, 1);
                }
            }
        } else {
            int[] the_pixels = (int[])pixelGrabber.getPixels();
            int index = 0;
            for (int y = 0; y < hight; ++y) {
                for (int x = 0; x < width; ++x) {
                    Color PixCol = new Color(color_model.getRed(the_pixels[index]), color_model.getGreen(the_pixels[index]), color_model.getBlue(the_pixels[index++]));
                    g2.setColor(PixCol);
                    g2.fillRect(x, y, 1, 1);
                }
            }
        }
        ByteArrayOutputStream blaat = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)result, "jpg", blaat);
        }
        catch (IOException e) {
            logger.error("JPEG Writer exception: {}", (Object)e.getMessage());
        }
        byte[] data = blaat.toByteArray();
        this.CodeTable = this.createCodeTable(data);
        this.AsciiStream = new StringBuilder();
        this.AsciiStream.append('@');
        for (byte datum : data) {
            String code = this.CodeTable[datum + 128];
            this.AsciiStream.append(code);
        }
    }

    public String getCodeTable() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.CodeTable.length; ++i) {
            if (i != 0) {
                result.append(" ");
            }
            result.append(this.CodeTable[i]);
        }
        return result.toString();
    }

    public String getCompressedString() {
        return this.AsciiStream.toString();
    }

    public BufferedImage getPicture(int width, int height) {
        boolean jpegCompressed;
        if (this.AsciiStream == null) {
            return null;
        }
        if (this.CodeTable == null) {
            return null;
        }
        if (this.CodeTable.length != 256) {
            return null;
        }
        BufferedImage result = null;
        HashMap<String, Integer> CodeLookupTable = new HashMap<String, Integer>();
        for (int i = 0; i < this.CodeTable.length; ++i) {
            CodeLookupTable.put(this.CodeTable[i], i);
        }
        int index = 0;
        HashSet<String> TwoCodes = new HashSet<String>();
        TwoCodes.add("-");
        TwoCodes.add("+");
        TwoCodes.add("=");
        boolean bl = jpegCompressed = this.AsciiStream.charAt(0) == '@';
        if (jpegCompressed) {
            ++index;
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
            while (index < this.AsciiStream.length()) {
                if (TwoCodes.contains(this.AsciiStream.substring(index, index + 1))) {
                    bytestream.write((byte)((Integer)CodeLookupTable.get(this.AsciiStream.substring(index, index + 2)) - 128));
                    index += 2;
                    continue;
                }
                bytestream.write((byte)((Integer)CodeLookupTable.get(this.AsciiStream.substring(index, index + 1)) - 128));
                ++index;
            }
            try {
                bytestream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ByteArrayInputStream instream = new ByteArrayInputStream(bytestream.toByteArray());
            try {
                result = ImageIO.read(instream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            result = new BufferedImage(width, height, 5);
            Graphics2D g2 = result.createGraphics();
            g2.setBackground(Color.BLACK);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    String CurBlueComp;
                    String CurGreenComp;
                    String CurRedComp;
                    if (TwoCodes.contains(this.AsciiStream.substring(index, index + 1))) {
                        CurRedComp = this.AsciiStream.substring(index, index + 2);
                        index += 2;
                    } else {
                        CurRedComp = this.AsciiStream.substring(index, index + 1);
                        ++index;
                    }
                    if (TwoCodes.contains(this.AsciiStream.substring(index, index + 1))) {
                        CurGreenComp = this.AsciiStream.substring(index, index + 2);
                        index += 2;
                    } else {
                        CurGreenComp = this.AsciiStream.substring(index, index + 1);
                        ++index;
                    }
                    if (TwoCodes.contains(this.AsciiStream.substring(index, index + 1))) {
                        CurBlueComp = this.AsciiStream.substring(index, index + 2);
                        index += 2;
                    } else {
                        CurBlueComp = this.AsciiStream.substring(index, index + 1);
                        ++index;
                    }
                    if (!(CodeLookupTable.containsKey(CurRedComp) && CodeLookupTable.containsKey(CurGreenComp) && CodeLookupTable.containsKey(CurBlueComp))) {
                        return null;
                    }
                    Color PixCol = new Color((Integer)CodeLookupTable.get(CurRedComp), (Integer)CodeLookupTable.get(CurGreenComp), (Integer)CodeLookupTable.get(CurBlueComp));
                    g2.setColor(PixCol);
                    g2.fillRect(x, y, 1, 1);
                }
            }
        }
        return result;
    }

    public void setCodeTable(String[] Table) {
        this.CodeTable = (String[])Table.clone();
    }

    public void setCompressedString(String stream) {
        this.AsciiStream = new StringBuilder();
        this.AsciiStream.append(stream);
    }
}

