/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.contracts.BaseComponentListenerContract;
import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.ComponentMapParser;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.fpga.file.XmlFileFilter;
import com.cburch.logisim.fpga.gui.BoardManipulator;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.LocaleListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMapDialog
implements ActionListener,
BaseWindowListenerContract,
LocaleListener,
BaseComponentListenerContract {
    static final Logger logger = LoggerFactory.getLogger(ComponentMapDialog.class);
    private final JDialog panel;
    private final JFrame parent;
    private final JButton doneButton = new JButton();
    private final JButton saveButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton loadButton = new JButton();
    private final JLabel unmappedText = new JLabel();
    private final JLabel mappedText = new JLabel();
    private final JLabel commandText = new JLabel();
    private final JScrollPane unmappedPane;
    private final JScrollPane mappedPane;
    private final BoardManipulator boardPicture;
    private final BoardInformation boardInfo;
    private String oldDirectory = "";
    private final MappableResourcesContainer mappableComponents;
    private final Object lock = new Object();
    private boolean canceled = true;

    public ComponentMapDialog(JFrame parentFrame, String projectPath, BoardInformation board, MappableResourcesContainer mappable) {
        this.oldDirectory = new File(projectPath).getParent();
        if (this.oldDirectory == null) {
            this.oldDirectory = "";
        } else if (this.oldDirectory.length() != 0 && !this.oldDirectory.endsWith(File.separator)) {
            this.oldDirectory = this.oldDirectory + File.separator;
        }
        this.parent = parentFrame;
        if (this.parent != null) {
            this.parent.addWindowListener(this);
        }
        this.boardInfo = board;
        this.mappableComponents = mappable;
        this.panel = new JDialog(parentFrame);
        this.panel.addWindowListener(this);
        this.panel.setResizable(false);
        this.panel.setAlwaysOnTop(true);
        this.panel.setDefaultCloseOperation(1);
        GridBagLayout thisLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.panel.setLayout(thisLayout);
        this.boardPicture = new BoardManipulator(this.panel, parentFrame, mappable);
        this.boardPicture.addComponentListener(this);
        c.gridx = 0;
        this.unmappedText.setHorizontalAlignment(0);
        this.unmappedText.setPreferredSize(new Dimension(this.boardPicture.getWidth() / 3, AppPreferences.getScaled(25)));
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.gridwidth = 1;
        this.panel.add((Component)this.unmappedText, c);
        this.mappedText.setHorizontalAlignment(0);
        this.mappedText.setPreferredSize(new Dimension(this.boardPicture.getWidth() / 3, AppPreferences.getScaled(25)));
        c.gridx = 1;
        this.panel.add((Component)this.mappedText, c);
        this.commandText.setHorizontalAlignment(0);
        this.commandText.setPreferredSize(new Dimension(this.boardPicture.getWidth() / 3, AppPreferences.getScaled(25)));
        c.gridx = 2;
        this.panel.add((Component)this.commandText, c);
        c.gridy = 1;
        this.panel.add((Component)this.boardPicture.getUnmapOneButton(), c);
        c.gridy = 2;
        this.panel.add((Component)this.boardPicture.getUnmapAllButton(), c);
        this.loadButton.setActionCommand("Load");
        this.loadButton.addActionListener(this);
        this.loadButton.setEnabled(true);
        c.gridy = 3;
        this.panel.add((Component)this.loadButton, c);
        this.saveButton.setActionCommand("Save");
        this.saveButton.addActionListener(this);
        this.saveButton.setEnabled(true);
        c.gridy = 4;
        this.panel.add((Component)this.saveButton, c);
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setEnabled(true);
        c.gridy = 5;
        this.panel.add((Component)this.cancelButton, c);
        this.doneButton.setActionCommand("Done");
        this.doneButton.addActionListener(this);
        c.gridy = 6;
        this.panel.add((Component)this.doneButton, c);
        c.gridy = 7;
        this.panel.add((Component)this.boardPicture.getZoomSlider(), c);
        this.unmappedPane = new JScrollPane(this.boardPicture.getUnmappedList());
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 7;
        this.panel.add((Component)this.unmappedPane, c);
        this.mappedPane = new JScrollPane(this.boardPicture.getMappedList());
        c.gridx = 1;
        c.gridheight = 7;
        this.panel.add((Component)this.mappedPane, c);
        c.gridx = 0;
        c.gridheight = 1;
        c.gridy = 8;
        c.gridwidth = 3;
        c.fill = 1;
        this.panel.add((Component)this.boardPicture, c);
        this.panel.setLocationRelativeTo(null);
        this.panel.setVisible(true);
        this.localeChanged();
        int ScreenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int ScreenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int ImageWidth = this.boardPicture.getWidth();
        int ImageHeight = this.boardPicture.getHeight();
        int ImageXBorder = this.panel.getWidth() - ImageWidth;
        int ImageYBorder = this.panel.getHeight() - ImageHeight;
        int zoomX = (ScreenWidth -= ImageXBorder) * 100 / ImageWidth;
        int zoomY = (ScreenHeight -= ImageYBorder + (ImageYBorder >> 2)) * 100 / ImageHeight;
        this.boardPicture.setMaxZoom(Math.min(zoomX, zoomY));
    }

    public boolean run() {
        Thread t = new Thread(() -> {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    logger.error("Bug: unable to wait for lock");
                }
            }
        });
        t.start();
        this.cancelButton.setEnabled(true);
        try {
            t.join();
        }
        catch (InterruptedException e) {
            logger.error("Bug: unable to join");
        }
        this.panel.setVisible(false);
        this.panel.dispose();
        this.boardPicture.cleanup();
        return !this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "Done": {
                this.canceled = false;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                    break;
                }
            }
            case "Save": {
                this.save();
                break;
            }
            case "Load": {
                this.load();
                this.mappableComponents.markChanged();
                break;
            }
            case "Cancel": {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                    break;
                }
            }
        }
    }

    private void load() {
        JFileChooser fc = new JFileChooser(this.oldDirectory);
        fc.setFileSelectionMode(2);
        fc.setDialogTitle("Choose XML board description file to use");
        fc.setFileFilter(XmlFileFilter.XML_FILTER);
        fc.setAcceptAllFileFilterUsed(false);
        this.panel.setVisible(false);
        int retVal = fc.showOpenDialog(null);
        if (retVal == 0) {
            File file = fc.getSelectedFile();
            String fileName = file.getName();
            String absoluteFileName = file.getPath();
            this.oldDirectory = absoluteFileName.substring(0, absoluteFileName.length() - fileName.length());
            ComponentMapParser parse = new ComponentMapParser(file, this.mappableComponents, this.boardInfo);
            int result = parse.parseFile();
            if (result == 0) {
                this.panel.setVisible(true);
                this.boardPicture.update();
            } else {
                OptionPane.showMessageDialog(null, parse.getError(result), "Error", 0);
                this.panel.setVisible(true);
            }
        }
    }

    private void save() {
        this.panel.setVisible(false);
        this.mappableComponents.save();
        OptionPane.showMessageDialog(null, Strings.S.get("BoarMapFileSaved"), "", 1);
        this.panel.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent e) {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    @Override
    public void localeChanged() {
        this.panel.setTitle(Strings.S.get("BoardMapTitle"));
        this.unmappedText.setText(Strings.S.get("BoardMapUnmapped"));
        this.unmappedText.setToolTipText(Strings.S.get("BoardMapUMTooltip"));
        this.mappedText.setText(Strings.S.get("BoardMapMapped"));
        this.commandText.setText(Strings.S.get("BoardMapActions"));
        this.loadButton.setText(Strings.S.get("BoardMapLoad"));
        this.saveButton.setText(Strings.S.get("BoardMapSave"));
        this.cancelButton.setText(Strings.S.get("FpgaBoardCancel"));
        this.doneButton.setText(Strings.S.get("FpgaBoardDone"));
        this.panel.pack();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.unmappedText.setPreferredSize(new Dimension(this.boardPicture.getWidth() / 3, AppPreferences.getScaled(25)));
        this.mappedText.setPreferredSize(new Dimension(this.boardPicture.getWidth() / 3, AppPreferences.getScaled(25)));
        this.commandText.setPreferredSize(new Dimension(this.boardPicture.getWidth() / 3, AppPreferences.getScaled(25)));
        this.panel.pack();
    }
}

