/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.gui.menu.MenuSimulate;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.LocaleListener;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FpgaClockPanel
extends JPanel
implements ActionListener,
LocaleListener {
    private static final long serialVersionUID = 1L;
    private final Project myProject;
    private Circuit rootSheet;
    private final JLabel freqLabel = new JLabel();
    private final JLabel divLabel = new JLabel();
    private final JComboBox<String> frequenciesList = new JComboBox();
    private final JTextField divider = new JTextField();
    private double FPGAClockFrequency;

    public FpgaClockPanel(Project proj) {
        this.myProject = proj;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createStrokeBorder(new BasicStroke(2.0f)), Strings.S.get("FpgaFreqTitle")));
        JPanel pan1 = new JPanel();
        pan1.setLayout(new BorderLayout());
        pan1.add((Component)this.freqLabel, "North");
        pan1.add(this.frequenciesList, "South");
        this.frequenciesList.addActionListener(this);
        this.frequenciesList.setActionCommand("frequency");
        this.frequenciesList.setEditable(true);
        for (String freq : MenuSimulate.getTickFrequencyStrings()) {
            this.frequenciesList.addItem(freq);
        }
        this.frequenciesList.setSelectedIndex(0);
        this.add((Component)pan1, "West");
        pan1 = new JPanel();
        pan1.setLayout(new BorderLayout());
        pan1.add((Component)this.divLabel, "North");
        this.divider.addActionListener(this);
        this.divider.setActionCommand("divider");
        pan1.add((Component)this.divider, "South");
        this.add((Component)pan1, "Center");
        this.localeChanged();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.freqLabel.setEnabled(enabled);
        this.divLabel.setEnabled(enabled);
        this.frequenciesList.setEnabled(enabled);
        this.divider.setEnabled(enabled);
    }

    public void updateFrequencyList(String circuitName) {
        Circuit newTopCircuit = this.myProject.getLogisimFile().getCircuit(circuitName);
        if (newTopCircuit == null || newTopCircuit == this.rootSheet) {
            return;
        }
        this.rootSheet = newTopCircuit;
        double savedDownloadFrequency = this.rootSheet.getDownloadFrequency();
        double savedSimFrequency = this.rootSheet.getTickFrequency();
        double selectedFrequency = savedDownloadFrequency > 0.0 ? savedDownloadFrequency : savedSimFrequency;
        for (int i = 0; i < MenuSimulate.SUPPORTED_TICK_FREQUENCIES.length; ++i) {
            if (!MenuSimulate.SUPPORTED_TICK_FREQUENCIES[i].equals(selectedFrequency)) continue;
            this.frequenciesList.setSelectedIndex(i);
            this.recalculateFrequency();
            return;
        }
        this.setSelectedFrequency(selectedFrequency);
    }

    private void setSelectedFrequency(double freq) {
        if (freq <= 0.0) {
            return;
        }
        if (this.rootSheet != null) {
            double savedDownloadFrequency = this.rootSheet.getDownloadFrequency();
            double savedSimFrequency = this.rootSheet.getTickFrequency();
            if (savedDownloadFrequency > 0.0 && freq != savedDownloadFrequency || freq != savedSimFrequency && freq != savedDownloadFrequency) {
                this.rootSheet.setDownloadFrequency(freq);
            }
        }
        for (int i = 0; i < MenuSimulate.SUPPORTED_TICK_FREQUENCIES.length; ++i) {
            if (MenuSimulate.SUPPORTED_TICK_FREQUENCIES[i] != freq) continue;
            this.frequenciesList.setSelectedIndex(i);
            return;
        }
        StringBuilder extention = new StringBuilder();
        extention.append(" ");
        double work = freq;
        if (work > 1000000.0) {
            extention.append("M");
            work /= 1000000.0;
        }
        if (work > 1000.0) {
            extention.append("k");
            work /= 1000.0;
        }
        extention.append("Hz");
        DecimalFormat df = new DecimalFormat("#.#####");
        df.setRoundingMode(RoundingMode.HALF_UP);
        String tick = df.format(work) + extention;
        this.frequenciesList.setSelectedItem(tick);
    }

    public void setFpgaClockFrequency(long frequency) {
        this.FPGAClockFrequency = frequency;
        this.recalculateFrequency();
    }

    public double getTickFrequency() {
        String TickIndex = this.frequenciesList.getSelectedItem().toString().trim().toUpperCase();
        int i = 0;
        StringBuilder number = new StringBuilder();
        while (i < TickIndex.length() && (TickIndex.charAt(i) == '.' || Character.isDigit(TickIndex.charAt(i)))) {
            number.append(TickIndex.charAt(i++));
        }
        int extention = 0;
        while (i < TickIndex.length()) {
            if (TickIndex.charAt(i) == 'K' || TickIndex.charAt(i) == 'M') {
                extention = TickIndex.charAt(i);
            }
            ++i;
        }
        double d = Double.parseDouble(number.toString());
        return d * (switch (extention) {
            case 75 -> 1000.0;
            case 77 -> 1000000.0;
            default -> 1.0;
        });
    }

    private void recalculateFrequency() {
        double freq = this.getTickFrequency();
        double divider = this.FPGAClockFrequency / freq;
        long longDivider = (long)divider;
        if (longDivider <= 1L) {
            longDivider = 2L;
        }
        if ((longDivider & 1L) != 0L) {
            ++longDivider;
        }
        double corfreq = this.FPGAClockFrequency / (double)longDivider;
        this.divider.setText(Long.toString(longDivider >> 1));
        this.setSelectedFrequency(corfreq);
    }

    private void recalculateDivider() {
        double corfreq;
        long divider = 0L;
        try {
            divider = Long.parseUnsignedLong(this.divider.getText());
        }
        catch (NumberFormatException e) {
            this.recalculateFrequency();
            return;
        }
        if ((divider <<= 1) <= 1L) {
            divider = 2L;
        }
        if ((corfreq = this.FPGAClockFrequency / (double)divider) < 1.0E-5) {
            this.recalculateFrequency();
            return;
        }
        this.setSelectedFrequency(corfreq);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("frequency")) {
            this.recalculateFrequency();
        } else if (e.getActionCommand().equals("divider")) {
            this.recalculateDivider();
        }
    }

    @Override
    public void localeChanged() {
        this.freqLabel.setText(Strings.S.get("FpgaFreqFrequency"));
        this.divLabel.setText(Strings.S.get("FpgaFreqDivider"));
    }
}

