/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.download.Download;
import com.cburch.logisim.fpga.file.BoardReaderClass;
import com.cburch.logisim.fpga.gui.BoardIcon;
import com.cburch.logisim.fpga.gui.FpgaClockPanel;
import com.cburch.logisim.fpga.gui.FpgaReportTabbedPane;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.settings.VendorSoftware;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.icons.ProjectAddIcon;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.StringGetter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class FpgaCommander
implements ActionListener,
LibraryListener,
ProjectListener,
CircuitListener,
BaseWindowListenerContract,
LocaleListener,
PreferenceChangeListener {
    public static final int FONT_SIZE = 12;
    private final JFrame panel;
    private final JLabel textMainCircuit = new JLabel();
    private final JLabel boardPic = new JLabel();
    private BoardIcon boardIcon = null;
    private final JButton annotateButton = new JButton();
    private final JButton validateButton = new JButton();
    private final JComboBox<String> circuitsList = new JComboBox();
    private final JComboBox<StringGetter> annotationList = new JComboBox();
    private final JComboBox<StringGetter> actionCommands = new JComboBox();
    private final JButton ToolPath = new JButton();
    private final JButton Settings = new JButton();
    private final JButton StopButton = new JButton();
    private final JProgressBar Progress = new JProgressBar();
    private final FpgaReportTabbedPane ReporterGui;
    private Download downloader;
    public static final String STOP_REQUESTED = "stop";
    private final JPanel BoardSelectionPanel = new JPanel();
    private final FpgaClockPanel FrequencyPanel;
    private final Project MyProject;
    private BoardInformation MyBoardInformation = null;

    @Override
    public void preferenceChange(PreferenceChangeEvent pce) {
        String property = pce.getKey();
        if (property.equals(AppPreferences.SelectedBoard.getIdentifier())) {
            this.MyBoardInformation = new BoardReaderClass(AppPreferences.Boards.getSelectedBoardFileName()).getBoardInformation();
            this.MyBoardInformation.setBoardName(AppPreferences.SelectedBoard.get());
            this.boardIcon = new BoardIcon(this.MyBoardInformation.getImage());
            this.boardPic.setIcon(this.boardIcon);
            this.boardPic.repaint();
            this.FrequencyPanel.setFpgaClockFrequency(this.MyBoardInformation.fpga.getClockFrequency());
            this.handleHdlOnly();
        }
    }

    @Override
    public void libraryChanged(LibraryEvent event) {
        if (event.getAction() == 0 || event.getAction() == 1) {
            this.rebuildCircuitSelection();
        }
    }

    @Override
    public void projectChanged(ProjectEvent event) {
        if (event.getAction() == 1) {
            Circuit circ = event.getCircuit();
            if (circ != null) {
                this.setCurrentSheet(circ.getName());
            }
        } else if (event.getAction() == 0) {
            this.rebuildCircuitSelection();
        }
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        int act = event.getAction();
        if (act == 0) {
            this.rebuildCircuitSelection();
        }
        this.ReporterGui.clearDrcTrace();
    }

    private void rebuildBoardSelectionPanel() {
        this.BoardSelectionPanel.removeAll();
        this.BoardSelectionPanel.setLayout(new GridBagLayout());
        this.BoardSelectionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createStrokeBorder(new BasicStroke(2.0f)), Strings.S.get("FpgaGuiBoardSelect")));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        this.MyBoardInformation = new BoardReaderClass(AppPreferences.Boards.getSelectedBoardFileName()).getBoardInformation();
        this.MyBoardInformation.setBoardName(AppPreferences.SelectedBoard.get());
        this.boardIcon = new BoardIcon(this.MyBoardInformation.getImage());
        JComboBox<String> selector = AppPreferences.Boards.boardSelector();
        selector.setPreferredSize(new Dimension(this.boardIcon.getIconWidth(), AppPreferences.getScaled(20)));
        this.BoardSelectionPanel.add(selector, c);
        ++c.gridy;
        this.boardPic.setIcon(this.boardIcon);
        this.BoardSelectionPanel.add((Component)this.boardPic, c);
        if (this.MyBoardInformation != null && !VendorSoftware.toolsPresent(this.MyBoardInformation.fpga.getVendor(), VendorSoftware.getToolPath(this.MyBoardInformation.fpga.getVendor()))) {
            ++c.gridy;
            this.BoardSelectionPanel.add((Component)this.ToolPath, c);
        }
        this.FrequencyPanel.setFpgaClockFrequency(this.MyBoardInformation.fpga.getClockFrequency());
    }

    private void setBoardSelectionEnabled(boolean enabled) {
        AppPreferences.Boards.boardSelector().setEnabled(enabled);
        this.ToolPath.setEnabled(enabled);
    }

    private JPanel getProgressBar() {
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createStrokeBorder(new BasicStroke(2.0f)), Strings.S.get("FpgaGuiProgress")));
        this.Progress.setStringPainted(true);
        pan.add((Component)this.Progress, "Center");
        this.StopButton.setEnabled(false);
        this.StopButton.setActionCommand(STOP_REQUESTED);
        this.StopButton.addActionListener(this);
        ProjectAddIcon bi = new ProjectAddIcon(true);
        bi.setDeselect(true);
        this.StopButton.setIcon(bi);
        pan.add((Component)this.StopButton, "East");
        return pan;
    }

    private JPanel getAnnotationWindow() {
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createStrokeBorder(new BasicStroke(2.0f)), Strings.S.get("FpgaGuiAnnotationMethod")));
        this.annotationList.addItem(Strings.S.getter("FpgaGuiRelabelAll"));
        this.annotationList.addItem(Strings.S.getter("FpgaGuiRelabelEmpty"));
        this.annotationList.setSelectedIndex(1);
        pan.add(this.annotationList, "North");
        this.annotateButton.setActionCommand("annotate");
        this.annotateButton.addActionListener(this);
        pan.add((Component)this.annotateButton, "Center");
        return pan;
    }

    private void setAnnotationWindowEnabled(boolean enabled) {
        this.annotationList.setEnabled(enabled);
        this.annotateButton.setEnabled(enabled);
    }

    private JPanel getExecuteWindow() {
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createStrokeBorder(new BasicStroke(2.0f)), Strings.S.get("FpgaGuiExecution")));
        JPanel pan1 = new JPanel();
        pan1.setLayout(new BorderLayout());
        pan1.add((Component)this.textMainCircuit, "West");
        this.rebuildCircuitSelection();
        this.MyProject.addProjectListener(this);
        this.MyProject.getLogisimFile().addLibraryListener(this);
        this.circuitsList.setActionCommand("mainCircuit");
        this.circuitsList.addActionListener(this);
        pan1.add(this.circuitsList, "Center");
        pan.add((Component)pan1, "North");
        this.validateButton.setActionCommand("Download");
        this.validateButton.addActionListener(this);
        pan.add(this.actionCommands, "Center");
        pan.add((Component)this.validateButton, "South");
        return pan;
    }

    private void setExecuteWindowEnabled(boolean enabled) {
        this.circuitsList.setEnabled(enabled);
        this.textMainCircuit.setEnabled(enabled);
        this.actionCommands.setEnabled(enabled);
        this.validateButton.setEnabled(enabled);
    }

    public FpgaCommander(Project Main2) {
        this.MyProject = Main2;
        String circuitName = Main2.getCurrentCircuit().getName();
        this.FrequencyPanel = new FpgaClockPanel(Main2);
        this.ToolPath.setActionCommand("ToolPath");
        this.ToolPath.addActionListener(this);
        this.MyProject.getFrame().addWindowListener(this);
        this.FrequencyPanel.updateFrequencyList(circuitName);
        this.rebuildBoardSelectionPanel();
        this.panel = new JFrame();
        this.panel.setResizable(false);
        this.panel.setAlwaysOnTop(false);
        this.panel.setDefaultCloseOperation(1);
        this.panel.addWindowListener(this);
        GridBagConstraints c = new GridBagConstraints();
        this.panel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 2;
        this.panel.add((Component)this.FrequencyPanel, c);
        ++c.gridy;
        this.panel.add((Component)this.getAnnotationWindow(), c);
        ++c.gridy;
        this.panel.add((Component)this.getExecuteWindow(), c);
        JPanel pan1 = new JPanel();
        pan1.setLayout(new BorderLayout());
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 3;
        pan1.add((Component)this.BoardSelectionPanel, "South");
        this.Settings.setActionCommand("Settings");
        this.Settings.addActionListener(this);
        pan1.add((Component)this.Settings, "North");
        this.panel.add((Component)pan1, c);
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        this.panel.add((Component)this.getProgressBar(), c);
        this.ReporterGui = new FpgaReportTabbedPane(this.MyProject);
        c.gridy = 4;
        this.panel.add((Component)this.ReporterGui, c);
        this.panel.setLocationRelativeTo(null);
        this.panel.setVisible(false);
        AppPreferences.getPrefs().addPreferenceChangeListener(this);
        Reporter.report.setGuiLogger(this.ReporterGui);
        Reporter.report.setProgressBar(this.Progress);
        this.localeChanged();
        this.updateCircuitBoard(circuitName);
    }

    public FpgaReportTabbedPane getReporterGui() {
        return this.ReporterGui;
    }

    private void updateCircuitBoard(String circuitName) {
        Circuit circuit = this.MyProject.getLogisimFile().getCircuit(circuitName);
        if (circuit != null && !AppPreferences.Boards.getSelectedBoardFileName().equals(circuit.getDownloadBoard())) {
            String boardName = circuit.getDownloadBoard();
            int boardIndex = AppPreferences.Boards.getBoardNames().indexOf(boardName);
            if (boardIndex >= 0) {
                AppPreferences.Boards.boardSelector().setSelectedIndex(boardIndex + 1);
            }
        }
    }

    private void handleHdlOnly() {
        this.rebuildBoardSelectionPanel();
        int sel = this.actionCommands.getItemCount() == 0 ? 1 : this.actionCommands.getSelectedIndex();
        int nrItems = 1;
        this.actionCommands.removeAllItems();
        this.actionCommands.addItem(Strings.S.getter("FpgaGuiHdlOnly"));
        this.ToolPath.setText(Strings.S.get("FpgaGuiToolpath", VendorSoftware.getVendorString(this.MyBoardInformation.fpga.getVendor())));
        if (this.MyBoardInformation != null && VendorSoftware.toolsPresent(this.MyBoardInformation.fpga.getVendor(), VendorSoftware.getToolPath(this.MyBoardInformation.fpga.getVendor()))) {
            this.actionCommands.addItem(Strings.S.getter("FpgaGuiSyntAndD"));
            ++nrItems;
            this.actionCommands.addItem(Strings.S.getter("FpgaGuiDownload"));
            ++nrItems;
            if (this.MyBoardInformation.fpga.isFlashDefined()) {
                this.actionCommands.addItem(Strings.S.getter("FpgaGuiWriteFlash"));
            }
        }
        if (sel == 0 && nrItems > 1) {
            sel = 1;
        }
        if (sel < nrItems) {
            this.actionCommands.setSelectedIndex(sel);
        } else {
            this.actionCommands.setSelectedIndex(0);
        }
        this.panel.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("annotate")) {
            this.annotate(this.annotationList.getSelectedIndex() == 0);
        } else if (e.getActionCommand().equals("Settings")) {
            PreferencesFrame.showFPGAPreferences();
        } else if (e.getActionCommand().equals("ToolPath")) {
            FpgaCommander.selectToolPath(this.MyBoardInformation.fpga.getVendor());
            this.handleHdlOnly();
        } else if (e.getActionCommand().equals(STOP_REQUESTED)) {
            if (this.downloader != null) {
                this.downloader.stop();
            }
            ((ProjectAddIcon)this.StopButton.getIcon()).setDeselect(true);
            this.StopButton.setEnabled(false);
        } else if (e.getActionCommand().equals("Download")) {
            this.setExecuteWindowEnabled(false);
            this.setAnnotationWindowEnabled(false);
            this.setBoardSelectionEnabled(false);
            this.FrequencyPanel.setEnabled(false);
            ((ProjectAddIcon)this.StopButton.getIcon()).setDeselect(false);
            this.StopButton.setEnabled(true);
            this.ReporterGui.clearAllMessages();
            boolean writeFlash = this.actionCommands.getSelectedIndex() == 3;
            boolean HdlOnly = this.actionCommands.getSelectedIndex() == 0;
            boolean DownloadOnly = this.actionCommands.getSelectedIndex() >= 2;
            this.downloader = new Download(this.MyProject, this.circuitsList.getSelectedItem().toString(), this.FrequencyPanel.getTickFrequency(), this.MyBoardInformation, "", writeFlash, DownloadOnly, HdlOnly, this.Progress, this.panel);
            this.downloader.addListener(this);
            this.downloader.doDownload();
        } else if (e.getSource() instanceof Download) {
            this.setExecuteWindowEnabled(true);
            this.setAnnotationWindowEnabled(true);
            this.setBoardSelectionEnabled(true);
            this.FrequencyPanel.setEnabled(true);
            ((ProjectAddIcon)this.StopButton.getIcon()).setDeselect(true);
            this.StopButton.setEnabled(false);
            this.Progress.setString(Strings.S.get("FpgaGuiIdle"));
            this.Progress.setValue(0);
        } else if (e.getActionCommand().equals("mainCircuit") && this.circuitsList.getSelectedItem() != null) {
            String circuitName = this.circuitsList.getSelectedItem().toString();
            this.FrequencyPanel.updateFrequencyList(circuitName);
            this.updateCircuitBoard(circuitName);
        }
    }

    private void annotate(boolean ClearExistingLabels) {
        this.ReporterGui.clearAllMessages();
        String CircuitName = this.circuitsList.getSelectedItem().toString();
        Circuit root = this.MyProject.getLogisimFile().getCircuit(CircuitName);
        if (root != null) {
            if (ClearExistingLabels) {
                root.clearAnnotationLevel();
            }
            root.annotate(ClearExistingLabels, false);
            Reporter.report.addInfo(Strings.S.get("FpgaGuiAnnotationDone"));
            this.MyProject.setForcedDirty();
            this.MyProject.repaintCanvas();
        }
    }

    private void rebuildCircuitSelection() {
        this.circuitsList.removeAllItems();
        this.localeChanged();
        int i = 0;
        for (Circuit thisone : this.MyProject.getLogisimFile().getCircuits()) {
            this.circuitsList.addItem(thisone.getName());
            thisone.removeCircuitListener(this);
            thisone.addCircuitListener(this);
            if (this.MyProject.getCurrentCircuit() != null && thisone.getName().equals(this.MyProject.getCurrentCircuit().getName())) {
                this.circuitsList.setSelectedIndex(i);
            }
            ++i;
        }
    }

    public static void selectToolPath(char vendor) {
        Object ToolPath = VendorSoftware.getToolPath(vendor);
        if (ToolPath == null) {
            return;
        }
        JFileChooser fc = new JFileChooser((String)ToolPath);
        fc.setFileSelectionMode(1);
        File test = new File((String)ToolPath);
        if (test.exists()) {
            fc.setSelectedFile(test);
        }
        fc.setDialogTitle(VendorSoftware.VENDORS[vendor] + " " + Strings.S.get("FpgaGuiSoftwareSelect"));
        boolean ok = false;
        do {
            int retval;
            if ((retval = fc.showOpenDialog(null)) == 0) {
                File file = fc.getSelectedFile();
                ToolPath = file.getPath();
                if (!((String)ToolPath).endsWith(File.separator)) {
                    ToolPath = (String)ToolPath + File.separator;
                }
                if (VendorSoftware.setToolPath(vendor, (String)ToolPath)) {
                    ok = true;
                    continue;
                }
                OptionPane.showMessageDialog(null, Strings.S.get("FpgaToolsNotFound", ToolPath), Strings.S.get("FpgaGuiSoftwareSelect"), 0);
                continue;
            }
            ok = true;
        } while (!ok);
    }

    private void setCurrentSheet(String Name2) {
        for (int i = 0; i < this.circuitsList.getItemCount(); ++i) {
            if (!this.circuitsList.getItemAt(i).equals(Name2)) continue;
            this.circuitsList.setSelectedIndex(i);
            this.circuitsList.repaint();
            return;
        }
    }

    public void showGui() {
        if (!this.panel.isVisible()) {
            this.panel.setVisible(true);
        } else {
            this.panel.setVisible(false);
            this.panel.setVisible(true);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.ReporterGui.closeOpenWindows();
        if (e.getSource().equals(this.MyProject.getFrame()) && this.panel.isVisible()) {
            this.panel.setVisible(false);
        }
    }

    @Override
    public void localeChanged() {
        this.textMainCircuit.setText(Strings.S.get("FpgaGuiMainCircuit"));
        this.panel.setTitle(Strings.S.get("FpgaGuiTitle") + " " + this.MyProject.getLogisimFile().getName());
        this.annotationList.repaint();
        this.validateButton.setText(Strings.S.get("FpgaGuiExecute"));
        this.annotateButton.setText(Strings.S.get("FpgaGuiAnnotate"));
        this.Settings.setText(Strings.S.get("FpgaGuiSettings"));
        this.Progress.setString(Strings.S.get("FpgaGuiIdle"));
        this.handleHdlOnly();
    }
}

