/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.logisim.fpga.Strings;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class HdlColorRenderer
extends JLabel
implements TableCellRenderer {
    public static final String NO_SUPPORT_STRING = "HDL_NOT_SUPPORTED";
    public static final String SUPPORT_STRING = "HDL_SUPPORTED";
    public static final String UNKNOWN_STRING = "HDL_UNKNOWN";
    public static final String REQUIRED_FIELD_STRING = ">_HDL_REQUIRED_FIELD_<";
    private static final ArrayList<String> CorrectStrings = new ArrayList();
    Border border = null;

    public HdlColorRenderer() {
        this.setOpaque(true);
        CorrectStrings.clear();
        CorrectStrings.add(NO_SUPPORT_STRING);
        CorrectStrings.add(UNKNOWN_STRING);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object Info2, boolean isSelected, boolean hasFocus, int row, int column) {
        if (row == 0) {
            Color newColor;
            String value = (String)Info2;
            boolean passive = value.equals(NO_SUPPORT_STRING);
            Color color = newColor = passive ? Color.red : Color.green;
            if (value.equals(UNKNOWN_STRING)) {
                newColor = table.getGridColor();
            }
            if (column == 1) {
                this.setBackground(newColor);
            }
            this.setForeground(Color.black);
            if (column == 0) {
                this.setText(value);
            } else if (value.equals(NO_SUPPORT_STRING)) {
                this.setText(Strings.S.get("FPGANotSupported"));
            } else if (value.equals(SUPPORT_STRING)) {
                this.setText(Strings.S.get("FPGASupported"));
            } else {
                this.setText(Strings.S.get("FPGAUnknown"));
            }
            this.setHorizontalAlignment(0);
        } else {
            String myInfo = (String)Info2;
            if (myInfo != null && myInfo.equals(REQUIRED_FIELD_STRING)) {
                this.setBackground(Color.YELLOW);
                this.setForeground(Color.BLUE);
                this.setText("HDL Required");
                this.setHorizontalAlignment(0);
                this.setBorder(null);
            } else if (myInfo != null && myInfo.contains("#") && myInfo.indexOf(35) == 0 && (myInfo.length() == 7 || myInfo.length() == 9)) {
                int red = Integer.valueOf(myInfo.substring(1, 3), 16);
                int green = Integer.valueOf(myInfo.substring(3, 5), 16);
                int blue = Integer.valueOf(myInfo.substring(5, 7), 16);
                int alpha = myInfo.length() == 7 ? 255 : Integer.valueOf(myInfo.substring(7, 9), 16);
                this.setBackground(new Color(red, green, blue, alpha));
                this.setText("");
                this.setBorder(null);
            } else {
                Color newColor = isSelected ? Color.lightGray : Color.white;
                this.setBackground(newColor);
                this.setForeground(Color.black);
                this.setText((String)Info2);
                this.setHorizontalAlignment(2);
                this.setBorder(null);
            }
        }
        return this;
    }
}

