/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.HdlParameters;
import com.cburch.logisim.fpga.hdlgenerator.HdlPorts;
import com.cburch.logisim.fpga.hdlgenerator.HdlTypes;
import com.cburch.logisim.fpga.hdlgenerator.HdlWires;
import com.cburch.logisim.fpga.hdlgenerator.Vhdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.LineBuffer;
import com.cburch.logisim.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class AbstractHdlGeneratorFactory
implements HdlGeneratorFactory {
    private final String subDirectoryName;
    protected final HdlParameters myParametersList = new HdlParameters();
    protected final HdlWires myWires = new HdlWires();
    protected final HdlPorts myPorts = new HdlPorts();
    protected final HdlTypes myTypedWires = new HdlTypes();
    protected boolean getWiresPortsDuringHDLWriting = false;

    public AbstractHdlGeneratorFactory() {
        String className = this.getClass().toString().replace('.', ':').replace(' ', ':');
        String[] parts = className.split(":");
        if (parts.length < 2) {
            throw new ExceptionInInitializerError("Cannot read class path!");
        }
        this.subDirectoryName = parts[parts.length - 2];
    }

    public AbstractHdlGeneratorFactory(String subDirectory) {
        this.subDirectoryName = subDirectory;
    }

    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
    }

    @Override
    public boolean generateAllHDLDescriptions(Set<String> handledComponents, String workingDirectory, List<String> hierarchy) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> getArchitecture(Netlist theNetlist, AttributeSet attrs, String componentName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        if (this.getWiresPortsDuringHDLWriting) {
            this.myWires.removeWires();
            this.myTypedWires.clear();
            this.myPorts.removePorts();
            this.getGenerationTimeWiresPorts(theNetlist, attrs);
        }
        contents.add(FileWriter.getGenerateRemark(componentName, theNetlist.projName()));
        if (Hdl.isVhdl()) {
            LineBuffer components;
            contents.addVhdlKeywords().add("{{architecture}} platformIndependent {{of}} {{1}} {{is}} ", componentName).empty();
            if (this.myTypedWires.getNrOfTypes() > 0) {
                contents.addRemarkBlock("Here all private types are defined").add(this.myTypedWires.getTypeDefinitions()).empty();
            }
            if (!(components = this.getComponentDeclarationSection(theNetlist, attrs)).isEmpty()) {
                contents.addRemarkBlock("Here all used components are defined", 3).add(components.getWithIndent()).empty();
            }
            Map<String, String> typedWires = this.myTypedWires.getTypedWires();
            HashMap<String, String> mySignals = new HashMap<String, String>();
            int maxNameLength = 0;
            for (String string : this.myWires.wireKeySet()) {
                maxNameLength = Math.max(maxNameLength, string.length());
                mySignals.put(string, this.getTypeIdentifier(this.myWires.get(string), attrs));
            }
            for (String string : this.myWires.registerKeySet()) {
                maxNameLength = Math.max(maxNameLength, string.length());
                mySignals.put(string, this.getTypeIdentifier(this.myWires.get(string), attrs));
            }
            for (String string : typedWires.keySet()) {
                maxNameLength = Math.max(maxNameLength, string.length());
                mySignals.put(string, typedWires.get(string));
            }
            if (maxNameLength > 0) {
                contents.addRemarkBlock("All used signals are defined here");
            }
            TreeSet sortedSignals = new TreeSet(mySignals.keySet());
            for (String signal : sortedSignals) {
                contents.add("   {{signal}} {{1}}{{2}} : {{3}};", signal, " ".repeat(maxNameLength - signal.length()), mySignals.get(signal));
            }
            if (maxNameLength > 0) {
                contents.empty();
            }
            contents.add("{{begin}}").add(this.getModuleFunctionality(theNetlist, attrs).getWithIndent()).add("{{end}} platformIndependent;");
        } else {
            Map<String, String> typedWires;
            List<String> regs;
            List<String> wires;
            ArrayList<String> arrayList;
            ArrayList<String> outputs;
            String preamble = String.format("module %s( ", componentName);
            String indenting = " ".repeat(preamble.length());
            LineBuffer body = LineBuffer.getHdlBuffer();
            if (this.myPorts.isEmpty()) {
                contents.add(preamble + " );");
            } else {
                TreeSet<String> ports = new TreeSet<String>(this.myPorts.keySet());
                for (String string : this.myPorts.keySet()) {
                    if (!this.myPorts.isClock(string)) continue;
                    ports.add(this.myPorts.getTickName(string));
                }
                boolean first = true;
                int n = ports.size();
                for (String port : ports) {
                    void var10_26;
                    String end = --var10_26 == false ? " );" : ",";
                    contents.add("{{1}}{{2}}{{3}}", first ? preamble : indenting, port, end);
                    first = false;
                }
            }
            if (!this.myParametersList.isEmpty(attrs)) {
                body.empty().addRemarkBlock("Here all module parameters are defined with a dummy value");
                TreeSet<String> parameters = new TreeSet<String>();
                for (Integer n : this.myParametersList.keySet(attrs)) {
                    String paramName = this.myParametersList.isPresentedByInteger(n, attrs) ? this.myParametersList.get(n, attrs) : String.format("[64:0] %s", this.myParametersList.get(n, attrs));
                    parameters.add(paramName);
                }
                for (String string : parameters) {
                    body.add(String.format("parameter %s = 1;", string));
                }
            }
            if (this.myTypedWires.getNrOfTypes() > 0) {
                body.empty().addRemarkBlock("Here all private types are defined").add(this.myTypedWires.getTypeDefinitions());
            }
            ArrayList<String> inputs = this.myPorts.keySet("input");
            for (String string : this.myPorts.keySet("input")) {
                if (!this.myPorts.isClock(string)) continue;
                inputs.add(this.myPorts.getTickName(string));
            }
            if (!inputs.isEmpty()) {
                body.empty().addRemarkBlock("The inputs are defined here");
                if (!this.getVerilogSignalSet("input", inputs, attrs, true, body)) {
                    return null;
                }
            }
            if (!(outputs = this.myPorts.keySet("output")).isEmpty()) {
                body.empty().addRemarkBlock("The outputs are defined here");
                if (!this.getVerilogSignalSet("output", outputs, attrs, true, body)) {
                    return null;
                }
            }
            if (!(arrayList = this.myPorts.keySet("inout")).isEmpty()) {
                body.empty().addRemarkBlock("The inouts are defined here");
                if (!this.getVerilogSignalSet("inout", arrayList, attrs, true, body)) {
                    return null;
                }
            }
            if (!(wires = this.myWires.wireKeySet()).isEmpty()) {
                body.empty().addRemarkBlock("The wires are defined here");
                if (!this.getVerilogSignalSet("wire", wires, attrs, false, body)) {
                    return null;
                }
            }
            if (!(regs = this.myWires.registerKeySet()).isEmpty()) {
                body.empty().addRemarkBlock("The registers are defined here");
                if (!this.getVerilogSignalSet("reg", regs, attrs, false, body)) {
                    return null;
                }
            }
            if (!(typedWires = this.myTypedWires.getTypedWires()).isEmpty()) {
                body.empty().addRemarkBlock("The type defined signals are defined here");
                TreeSet<String> sortedWires = new TreeSet<String>(typedWires.keySet());
                int maxNameLength = 0;
                for (String wire : sortedWires) {
                    maxNameLength = Math.max(maxNameLength, typedWires.get(wire).length());
                }
                for (String wire : sortedWires) {
                    String typeName = typedWires.get(wire);
                    body.add(LineBuffer.format("{{1}}{{2}} {{3}};", typeName, " ".repeat(maxNameLength - typeName.length()), wire));
                }
            }
            body.empty().addRemarkBlock("The module functionality is described here").add(this.getModuleFunctionality(theNetlist, attrs));
            contents.add(body.getWithIndent()).add("endmodule");
        }
        return contents.get();
    }

    public LineBuffer getComponentDeclarationSection(Netlist theNetlist, AttributeSet attrs) {
        return LineBuffer.getHdlBuffer();
    }

    @Override
    public LineBuffer getComponentInstantiation(Netlist theNetlist, AttributeSet attrs, String componentName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        if (Hdl.isVhdl()) {
            contents.add(this.getVHDLBlackBox(theNetlist, attrs, componentName, false));
        }
        return contents;
    }

    @Override
    public LineBuffer getComponentMap(Netlist nets, Long componentId, Object componentInfo, String name) {
        String string;
        LineBuffer contents = LineBuffer.getHdlBuffer();
        TreeMap<String, String> parameterMap = new TreeMap<String, String>();
        Map<String, String> portMap = this.getPortMap(nets, componentInfo);
        if (componentInfo instanceof netlistComponent) {
            netlistComponent comp = (netlistComponent)componentInfo;
            string = comp.getComponent().getFactory().getHDLName(((netlistComponent)componentInfo).getComponent().getAttributeSet());
        } else {
            string = name;
        }
        String componentHdlName = string;
        String compName = StringUtil.isNotEmpty(name) ? name : componentHdlName;
        String thisInstanceIdentifier = this.getInstanceIdentifier(componentInfo, componentId);
        StringBuilder oneLine = new StringBuilder();
        if (componentInfo == null) {
            parameterMap.putAll(this.myParametersList.getMaps(null));
        } else if (componentInfo instanceof netlistComponent) {
            netlistComponent comp = (netlistComponent)componentInfo;
            AttributeSet attrs = comp.getComponent().getAttributeSet();
            parameterMap.putAll(this.myParametersList.getMaps(attrs));
        }
        int tabLength = 0;
        boolean first = true;
        if (Hdl.isVhdl()) {
            String preamble;
            int maxNameLength;
            contents.addVhdlKeywords().add("{{1}} : {{2}}", thisInstanceIdentifier, compName);
            if (!parameterMap.isEmpty()) {
                maxNameLength = 0;
                for (String generic : parameterMap.keySet()) {
                    maxNameLength = Math.max(maxNameLength, generic.length());
                }
                int currentGeneric = 0;
                TreeSet genericNames = new TreeSet(parameterMap.keySet());
                int nrOfGenerics = genericNames.size();
                for (String generic : genericNames) {
                    preamble = currentGeneric == 0 ? "{{generic}} {{map}} (" : " ".repeat(13);
                    contents.add("   {{1}} {{2}}{{3}} => {{4}}{{5}}", preamble, generic, " ".repeat(Math.max(0, maxNameLength - generic.length())), parameterMap.get(generic), currentGeneric == nrOfGenerics - 1 ? " )" : ",");
                    ++currentGeneric;
                }
            }
            if (!portMap.isEmpty()) {
                maxNameLength = 0;
                for (String port : portMap.keySet()) {
                    maxNameLength = Math.max(maxNameLength, port.length());
                }
                int currentPort = 0;
                TreeSet<String> portNames = new TreeSet<String>(portMap.keySet());
                int nrOfPorts = portNames.size();
                for (String port : portNames) {
                    preamble = currentPort == 0 ? "{{port}} {{map}} (" : " ".repeat(10);
                    contents.add("   {{1}} {{2}}{{3}} => {{4}}{{5}}", preamble, port, " ".repeat(Math.max(0, maxNameLength - port.length())), portMap.get(port), currentPort == nrOfPorts - 1 ? " );" : ",");
                    ++currentPort;
                }
            }
        } else {
            oneLine.append(compName);
            if (!parameterMap.isEmpty()) {
                oneLine.append(" #(");
                tabLength = oneLine.length();
                first = true;
                for (String parameter : parameterMap.keySet()) {
                    if (!first) {
                        oneLine.append(",");
                        contents.add(oneLine.toString());
                        oneLine.setLength(0);
                        oneLine.append(" ".repeat(tabLength));
                    } else {
                        first = false;
                    }
                    oneLine.append(".").append(parameter).append("(").append((String)parameterMap.get(parameter)).append(")");
                }
                oneLine.append(")");
                contents.add(oneLine.toString());
                oneLine.setLength(0);
            }
            oneLine.append("   ").append(thisInstanceIdentifier).append(" (");
            if (!portMap.isEmpty()) {
                tabLength = oneLine.length();
                first = true;
                for (String port : portMap.keySet()) {
                    if (!first) {
                        oneLine.append(",");
                        contents.add(oneLine.toString());
                        oneLine.setLength(0);
                        oneLine.append(" ".repeat(tabLength));
                    } else {
                        first = false;
                    }
                    oneLine.append(".").append(port).append("(");
                    String MappedSignal = portMap.get(port);
                    if (!MappedSignal.contains(",")) {
                        oneLine.append(MappedSignal);
                    } else {
                        String[] vectorList = MappedSignal.split(",");
                        oneLine.append("{");
                        int tabSize = oneLine.length();
                        for (int vectorEntries = 0; vectorEntries < vectorList.length; ++vectorEntries) {
                            oneLine.append(vectorList[vectorEntries].replace("}", "").replace("{", ""));
                            if (vectorEntries < vectorList.length - 1) {
                                contents.add(oneLine + ",");
                                oneLine.setLength(0);
                                oneLine.append(" ".repeat(tabSize));
                                continue;
                            }
                            oneLine.append("}");
                        }
                    }
                    oneLine.append(")");
                }
            }
            oneLine.append(");");
            contents.add(oneLine.toString());
        }
        return contents;
    }

    @Override
    public List<String> getEntity(Netlist theNetlist, AttributeSet attrs, String componentName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        if (Hdl.isVhdl()) {
            contents.add(FileWriter.getGenerateRemark(componentName, theNetlist.projName())).add(Hdl.getExtendedLibrary()).add(this.getVHDLBlackBox(theNetlist, attrs, componentName, true));
        }
        return contents.get();
    }

    private String getInstanceIdentifier(Object componentInfo, Long componentId) {
        String label;
        netlistComponent comp;
        AttributeSet attrs;
        if (componentInfo instanceof netlistComponent && (attrs = (comp = (netlistComponent)componentInfo).getComponent().getAttributeSet()).containsAttribute(StdAttr.LABEL) && StringUtil.isNotEmpty(label = attrs.getValue(StdAttr.LABEL))) {
            return CorrectLabel.getCorrectLabel(label);
        }
        return LineBuffer.format("{{1}}_{{2}}", this.subDirectoryName.toUpperCase(), componentId.toString());
    }

    @Override
    public LineBuffer getInlinedCode(Netlist nets, Long componentId, netlistComponent componentInfo, String circuitName) {
        throw new IllegalAccessError("BUG: Inline code not supported");
    }

    public LineBuffer getModuleFunctionality(Netlist netlist, AttributeSet attrs) {
        return LineBuffer.getHdlBuffer();
    }

    public Map<String, String> getPortMap(Netlist nets, Object mapInfo) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (mapInfo instanceof netlistComponent) {
            netlistComponent componentInfo = (netlistComponent)mapInfo;
            if (!this.myPorts.isEmpty()) {
                String compName = componentInfo.getComponent().getFactory().getDisplayName();
                AttributeSet attrs = componentInfo.getComponent().getAttributeSet();
                if (this.getWiresPortsDuringHDLWriting) {
                    this.myWires.removeWires();
                    this.myTypedWires.clear();
                    this.myPorts.removePorts();
                    this.getGenerationTimeWiresPorts(nets, componentInfo.getComponent().getAttributeSet());
                }
                for (String port : this.myPorts.keySet()) {
                    if (this.myPorts.isClock(port)) {
                        int clockIndex;
                        String clockNetName;
                        AttributeOption clockAttr;
                        boolean gatedClock = false;
                        boolean hasClock = true;
                        AttributeOption attributeOption = clockAttr = attrs.containsAttribute(StdAttr.EDGE_TRIGGER) ? attrs.getValue(StdAttr.EDGE_TRIGGER) : attrs.getValue(StdAttr.TRIGGER);
                        if (clockAttr == null) {
                            clockAttr = StdAttr.TRIG_RISING;
                        }
                        boolean activeLow = StdAttr.TRIG_LOW.equals(clockAttr) || StdAttr.TRIG_FALLING.equals(clockAttr);
                        int compPinId = this.myPorts.getComponentPortId(port);
                        if (!componentInfo.isEndConnected(compPinId)) {
                            Reporter.report.addSevereWarning(String.format("Component \"%s\" in circuit \"%s\" has no clock connection!", compName, nets.getCircuitName()));
                            hasClock = false;
                        }
                        if (StringUtil.isNullOrEmpty(clockNetName = Hdl.getClockNetName(componentInfo, compPinId, nets))) {
                            Reporter.report.addSevereWarning(String.format("Component \"%s\" in circuit \"%s\" has a gated clock connection!", compName, nets.getCircuitName()));
                            gatedClock = true;
                        }
                        if (hasClock && !gatedClock && Netlist.isFlipFlop(attrs)) {
                            if (nets.requiresGlobalClockConnection()) {
                                result.put(this.myPorts.getTickName(port), LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", clockNetName, 4));
                            } else {
                                clockIndex = activeLow ? 3 : 2;
                                result.put(this.myPorts.getTickName(port), LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", clockNetName, clockIndex));
                            }
                            result.put("clock", LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", clockNetName, 4));
                            continue;
                        }
                        if (!hasClock) {
                            result.put(this.myPorts.getTickName(port), Hdl.zeroBit());
                            result.put("clock", Hdl.zeroBit());
                            continue;
                        }
                        result.put(this.myPorts.getTickName(port), Hdl.oneBit());
                        if (!gatedClock) {
                            clockIndex = activeLow ? 1 : 0;
                            result.put("clock", LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", clockNetName, clockIndex));
                            continue;
                        }
                        result.put("clock", Hdl.getNetName(componentInfo, compPinId, true, nets));
                        continue;
                    }
                    if (this.myPorts.isFixedMapped(port)) {
                        String fixedMap = this.myPorts.getFixedMap(port);
                        if ("fixed_pull_down".equals(fixedMap)) {
                            result.put(port, Hdl.getConstantVector(0L, this.myPorts.get(port, attrs)));
                            continue;
                        }
                        if ("fixed_pull_up".equals(fixedMap)) {
                            result.put(port, Hdl.getConstantVector(-1L, this.myPorts.get(port, attrs)));
                            continue;
                        }
                        result.put(port, fixedMap);
                        continue;
                    }
                    result.putAll(Hdl.getNetMap(port, this.myPorts.doPullDownOnFloat(port), componentInfo, this.myPorts.getComponentPortId(port), nets));
                }
            }
        }
        return result;
    }

    @Override
    public String getRelativeDirectory() {
        String mainDirectory = AppPreferences.HdlType.get().toLowerCase();
        StringBuilder directoryName = new StringBuilder();
        directoryName.append(mainDirectory);
        if (!mainDirectory.endsWith(File.separator)) {
            directoryName.append(File.separator);
        }
        if (!this.subDirectoryName.isEmpty()) {
            directoryName.append(this.subDirectoryName);
            if (!this.subDirectoryName.endsWith(File.separator)) {
                directoryName.append(File.separator);
            }
        }
        return directoryName.toString();
    }

    private List<String> getVHDLBlackBox(Netlist theNetlist, AttributeSet attrs, String componentName, Boolean isEntity) {
        LineBuffer contents = LineBuffer.getHdlBuffer().addVhdlKeywords();
        int maxNameLength = 0;
        if (this.getWiresPortsDuringHDLWriting) {
            this.myWires.removeWires();
            this.myTypedWires.clear();
            this.myPorts.removePorts();
            this.getGenerationTimeWiresPorts(theNetlist, attrs);
        }
        contents.add(isEntity != false ? "{{entity}} {{1}} {{is}}" : "{{component}} {{1}}", componentName);
        if (!this.myParametersList.isEmpty(attrs)) {
            HashMap<Object, Boolean> myParameters = new HashMap<Object, Boolean>();
            for (Integer generic : this.myParametersList.keySet(attrs)) {
                String parameterName = this.myParametersList.get(generic, attrs);
                maxNameLength = Math.max(maxNameLength, parameterName.length());
                myParameters.put(parameterName, this.myParametersList.isPresentedByInteger(generic, attrs));
            }
            ++maxNameLength;
            TreeSet myGenerics = new TreeSet(myParameters.keySet());
            int currentGenericId = 0;
            for (String thisGeneric : myGenerics) {
                if (currentGenericId == 0) {
                    contents.add("   {{generic}} ( {{1}}{{2}}: {{3}}{{4}};", thisGeneric, " ".repeat(Math.max(0, maxNameLength - thisGeneric.length())), (Boolean)myParameters.get(thisGeneric) != false ? "{{integer}}" : "std_logic_vector", currentGenericId == myGenerics.size() - 1 ? " )" : "");
                } else {
                    contents.add("             {{1}}{{2}}: {{3}}{{4}};", thisGeneric, " ".repeat(Math.max(0, maxNameLength - thisGeneric.length())), (Boolean)myParameters.get(thisGeneric) != false ? "{{integer}}" : "std_logic_vector", currentGenericId == myGenerics.size() - 1 ? " )" : "");
                }
                ++currentGenericId;
            }
        }
        if (!this.myPorts.isEmpty()) {
            maxNameLength = 0;
            int nrOfEntries = this.myPorts.keySet().size();
            TreeSet<String> tickers = new TreeSet<String>();
            for (String portName : this.myPorts.keySet()) {
                maxNameLength = Math.max(maxNameLength, portName.length());
                if (!this.myPorts.isClock(portName)) continue;
                String tickerName = this.myPorts.getTickName(portName);
                maxNameLength = Math.max(maxNameLength, tickerName.length());
                tickers.add(tickerName);
                ++nrOfEntries;
            }
            ++maxNameLength;
            int nrOfPortBits = 0;
            boolean firstEntry = true;
            int currentEntry = 0;
            String direction = !this.myPorts.keySet("inout").isEmpty() ? Vhdl.getVhdlKeyword("IN   ") : Vhdl.getVhdlKeyword("IN ");
            TreeSet<String> myInputs = new TreeSet<String>(this.myPorts.keySet("input"));
            myInputs.addAll(tickers);
            for (String string : myInputs) {
                nrOfPortBits = this.myPorts.contains(string) ? this.myPorts.get(string, attrs) : 1;
                String type = this.getTypeIdentifier(nrOfPortBits, attrs);
                firstEntry = this.addPortEntry(contents, firstEntry, nrOfEntries, currentEntry, string, direction, type, maxNameLength);
                ++currentEntry;
            }
            direction = Vhdl.getVhdlKeyword("INOUT");
            TreeSet<String> myInOuts = new TreeSet<String>(this.myPorts.keySet("inout"));
            for (String inout : myInOuts) {
                nrOfPortBits = this.myPorts.get(inout, attrs);
                String type = this.getTypeIdentifier(nrOfPortBits, attrs);
                firstEntry = this.addPortEntry(contents, firstEntry, nrOfEntries, currentEntry, inout, direction, type, maxNameLength);
                ++currentEntry;
            }
            direction = !this.myPorts.keySet("inout").isEmpty() ? Vhdl.getVhdlKeyword("OUT  ") : Vhdl.getVhdlKeyword("OUT");
            TreeSet<String> treeSet = new TreeSet<String>(this.myPorts.keySet("output"));
            for (String output : treeSet) {
                nrOfPortBits = this.myPorts.get(output, attrs);
                String type = this.getTypeIdentifier(nrOfPortBits, attrs);
                firstEntry = this.addPortEntry(contents, firstEntry, nrOfEntries, currentEntry, output, direction, type, maxNameLength);
                ++currentEntry;
            }
        }
        if (isEntity.booleanValue()) {
            contents.add("{{end}} {{entity}} {{1}};", componentName);
        } else {
            contents.add("{{end}} {{component}};");
        }
        return contents.getWithIndent(isEntity != false ? 0 : 1);
    }

    private boolean addPortEntry(LineBuffer contents, boolean firstEntry, int nrOfEntries, int currentEntry, String name, String direction, String type, int maxLength) {
        String fmt = firstEntry ? "   {{port}} ( {{1}}{{2}}: {{3}} {{4}}{{5}};" : "          {{1}}{{2}}: {{3}} {{4}}{{5}};";
        contents.add(fmt, name, " ".repeat(maxLength - name.length()), direction, type, currentEntry == nrOfEntries - 1 ? " )" : "");
        return false;
    }

    private String getTypeIdentifier(int nrOfBits, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().addVhdlKeywords();
        if (nrOfBits < 0) {
            if (!this.myParametersList.containsKey(nrOfBits, attrs)) {
                throw new IllegalArgumentException("Generic parameter not specified in the parameters list");
            }
            contents.add("std_logic_vector( ({{1}} - 1) {{downto}} 0 )", this.myParametersList.get(nrOfBits, attrs));
        } else if (nrOfBits == 0) {
            contents.add("std_logic_vector( 0 {{downto}} 0 )");
        } else if (nrOfBits > 1) {
            contents.add("std_logic_vector( {{1}} {{downto}} 0 )", nrOfBits - 1);
        } else {
            contents.add("std_logic");
        }
        return contents.get(0);
    }

    private boolean getVerilogSignalSet(String preamble, List<String> signals, AttributeSet attrs, boolean isPort, LineBuffer contents) {
        if (signals.isEmpty()) {
            return true;
        }
        HashMap<String, String> signalSet = new HashMap<String, String>();
        for (String input : signals) {
            int nrOfBits;
            int n = isPort ? (this.myPorts.contains(input) ? this.myPorts.get(input, attrs) : 1) : (nrOfBits = this.myWires.get(input));
            if (nrOfBits < 0) {
                if (this.myParametersList.containsKey(nrOfBits, attrs)) {
                    signalSet.put(input, String.format("%s [%s-1:0]", preamble, this.myParametersList.get(nrOfBits, attrs)));
                    continue;
                }
                Reporter.report.addFatalError("Internal Error, Parameter not present in HDL generation, your HDL code will not work!");
                return false;
            }
            if (nrOfBits == 0) {
                signalSet.put(input, String.format("%s [0:0]", preamble));
                continue;
            }
            if (nrOfBits > 1) {
                signalSet.put(input, String.format("%s [%d:0]", preamble, nrOfBits - 1));
                continue;
            }
            signalSet.put(input, preamble);
        }
        TreeSet sortedSignals = new TreeSet(signalSet.keySet());
        int maxNameLength = 0;
        for (String signal : sortedSignals) {
            maxNameLength = Math.max(maxNameLength, ((String)signalSet.get(signal)).length());
        }
        for (String signal : sortedSignals) {
            String type = (String)signalSet.get(signal);
            contents.add(LineBuffer.format("{{1}}{{2}} {{3}};", type, " ".repeat(maxNameLength - type.length()), signal));
        }
        return true;
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return true;
    }

    @Override
    public boolean isOnlyInlined() {
        return false;
    }
}

