/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.NegateAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HdlParameters {
    public static final int MAP_DEFAULT = 0;
    public static final int MAP_CONSTANT = 1;
    public static final int MAP_OFFSET = 2;
    public static final int MAP_MULTIPLY = 3;
    public static final int MAP_ATTRIBUTE_OPTION = 4;
    public static final int MAP_LN2 = 5;
    public static final int MAP_INT_ATTRIBUTE = 6;
    public static final int MAP_GATE_INPUT_BUBLE = 7;
    public static final int MAP_POW2 = 8;
    private final List<ParameterInfo> myParameters = new ArrayList<ParameterInfo>();

    public HdlParameters add(String name, int id) {
        this.myParameters.add(new ParameterInfo(name, id));
        return this;
    }

    public HdlParameters add(String name, int id, int type, Object ... args) {
        this.myParameters.add(new ParameterInfo(name, id, type, args));
        return this;
    }

    public HdlParameters addVector(String name, int id, int type, Object ... args) {
        ParameterInfo newParameter = new ParameterInfo(name, id, type, args);
        newParameter.setVectorRepresentation();
        this.myParameters.add(newParameter);
        return this;
    }

    public HdlParameters addBusOnly(String name, int id) {
        this.myParameters.add(new ParameterInfo(true, name, id));
        return this;
    }

    public HdlParameters addBusOnly(Attribute<BitWidth> checkAttr, String name, int id) {
        this.myParameters.add(new ParameterInfo(true, checkAttr, name, id));
        return this;
    }

    public boolean containsKey(int id, AttributeSet attrs) {
        for (ParameterInfo parameter : this.myParameters) {
            if (id != parameter.getParameterId(attrs)) continue;
            return true;
        }
        return false;
    }

    public String get(int id, AttributeSet attrs) {
        for (ParameterInfo parameter : this.myParameters) {
            if (id != parameter.getParameterId(attrs)) continue;
            return parameter.getParameterString(attrs);
        }
        return null;
    }

    public int getNumberOfVectorBits(int id, AttributeSet attrs) {
        for (ParameterInfo parameter : this.myParameters) {
            if (id != parameter.getParameterId(attrs)) continue;
            return parameter.getNumberOfVectorBits(attrs);
        }
        throw new UnsupportedOperationException("Parameter not found");
    }

    public boolean isPresentedByInteger(int id, AttributeSet attrs) {
        for (ParameterInfo parameter : this.myParameters) {
            if (id != parameter.getParameterId(attrs)) continue;
            return parameter.isRepresentedByInteger();
        }
        return true;
    }

    public Map<String, String> getMaps(AttributeSet attrs) {
        TreeMap<String, String> contents = new TreeMap<String, String>();
        for (ParameterInfo parameter : this.myParameters) {
            String value;
            if (!parameter.isUsed(attrs) || (value = parameter.getParameterValue(attrs)).isEmpty()) continue;
            contents.put(parameter.getParameterString(attrs), value);
        }
        return contents;
    }

    public boolean isEmpty(AttributeSet attrs) {
        int count = 0;
        for (ParameterInfo parameter : this.myParameters) {
            if (!parameter.isUsed(attrs)) continue;
            ++count;
        }
        return count == 0;
    }

    public List<Integer> keySet(AttributeSet attrs) {
        ArrayList<Integer> keySet = new ArrayList<Integer>();
        for (ParameterInfo parameter : this.myParameters) {
            if (!parameter.isUsed(attrs)) continue;
            keySet.add(parameter.getParameterId(attrs));
        }
        return keySet;
    }

    private static class ParameterInfo {
        private final boolean isOnlyUsedForBusses;
        private boolean isIntParameter = true;
        private final String parameterName;
        private final int parameterId;
        private int myMapType = 0;
        private long parameterValue = -1L;
        private long multiplyValue = 1L;
        private long offsetValue = 0L;
        private final List<Attribute<?>> attributesList = new ArrayList();
        private Map<AttributeOption, Integer> attributeOptionMap = new HashMap<AttributeOption, Integer>();
        private final Attribute<BitWidth> attributeToCheckForBus;

        public ParameterInfo(String name, int id) {
            this(false, StdAttr.WIDTH, name, id);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ParameterInfo(String name, int id, int type, Object ... args) {
            this(false, StdAttr.WIDTH, name, id);
            this.myMapType = type;
            switch (type) {
                case 1: {
                    this.parameterValue = this.getCorrectIntValue(args);
                    return;
                }
                case 2: {
                    this.offsetValue = this.getCorrectIntValue(args);
                    return;
                }
                case 3: {
                    if (args.length == 2) {
                        for (int arg = 0; arg < 2; ++arg) {
                            Object object = args[arg];
                            if (!(object instanceof Attribute)) {
                                throw new IllegalArgumentException("Mutliply map Type: argument needs to be an Attribute<?>");
                            }
                            Attribute attr = (Attribute)object;
                            this.attributesList.add(attr);
                        }
                        return;
                    }
                    this.multiplyValue = this.getCorrectIntValue(args);
                    if (this.multiplyValue != 0L) return;
                    throw new NumberFormatException("multiply value cannot be zero");
                }
                case 4: {
                    if (args.length != 2) {
                        throw new IllegalArgumentException("Attribute map Type requires 2 argument");
                    }
                    Iterator iterator = args[0];
                    if (!(iterator instanceof Attribute)) {
                        throw new IllegalArgumentException("Attribute map Type: first argument needs to be an Attribute<?>");
                    }
                    Attribute arg0 = (Attribute)((Object)iterator);
                    iterator = args[1];
                    if (!(iterator instanceof Map)) {
                        throw new IllegalArgumentException("Attribute map Type: second argument needs to be an Map<?,?>");
                    }
                    Map map = (Map)((Object)iterator);
                    if (map.isEmpty()) {
                        throw new IllegalArgumentException("Attribute map Type: Map<?,?> cannot be empty");
                    }
                    for (Object key : map.keySet()) {
                        if (!(key instanceof AttributeOption)) {
                            throw new IllegalArgumentException("Attribute map Type: Map<?,?> keys need to be an AttributeOption");
                        }
                        if (map.get(key) instanceof Integer) continue;
                        throw new IllegalArgumentException("Attribute map Type: Map<?,?> value need to be an Integer");
                    }
                    this.attributesList.add(arg0);
                    this.attributeOptionMap = (Map)args[1];
                    return;
                }
                case 6: {
                    if (args.length == 2) {
                        if (!(args[1] instanceof Integer)) throw new IllegalArgumentException("Attribute map Type requires only 1 argument");
                        this.offsetValue = ((Integer)args[1]).intValue();
                        if (this.offsetValue < 0L) {
                            throw new NumberFormatException("Integer value must be positive");
                        }
                    } else if (args.length != 1) {
                        throw new IllegalArgumentException("Attribute map Type requires only 1 argument");
                    }
                    this.attributesList.add((Attribute)args[0]);
                    return;
                }
                case 5: 
                case 8: {
                    for (Object arg : args) {
                        if (arg instanceof Integer) {
                            this.offsetValue = ((Integer)arg).intValue();
                            if (this.offsetValue >= 0L) continue;
                            throw new NumberFormatException("Integer value must be positive");
                        }
                        if (!(arg instanceof Attribute)) {
                            throw new IllegalArgumentException("Bits required map Type: argument needs to be an Attribute<?>");
                        }
                        this.attributesList.add((Attribute)arg);
                    }
                    return;
                }
                default: {
                    return;
                }
            }
        }

        public ParameterInfo(boolean forBusOnly, String name, int id) {
            this(forBusOnly, StdAttr.WIDTH, name, id);
        }

        public ParameterInfo(boolean forBusOnly, Attribute<BitWidth> checkAttr, String name, int id) {
            this.isOnlyUsedForBusses = forBusOnly;
            this.parameterName = name;
            this.parameterId = id;
            this.attributeToCheckForBus = checkAttr;
        }

        public boolean isUsed(AttributeSet attrs) {
            int nrOfBits = attrs != null && attrs.containsAttribute(this.attributeToCheckForBus) ? attrs.getValue(this.attributeToCheckForBus).getWidth() : 0;
            return !this.isOnlyUsedForBusses || nrOfBits > 1;
        }

        public int getParameterId(AttributeSet attrs) {
            return this.isUsed(attrs) ? this.parameterId : 0;
        }

        public String getParameterString(AttributeSet attrs) {
            return this.isUsed(attrs) ? this.parameterName : null;
        }

        public String getParameterValue(AttributeSet attrs) {
            long totalValue = 0L;
            long selectedValue = 0L;
            String noReqAttrExMsg = "Component has not the required attribute";
            String notAnIntExMsg = "Requested attribute is not an Integer";
            switch (this.myMapType) {
                case 1: {
                    selectedValue = this.parameterValue;
                    break;
                }
                case 4: {
                    if (!attrs.containsAttribute(this.attributesList.get(0))) {
                        throw new UnsupportedOperationException("Component has not the required attribute");
                    }
                    Object value = attrs.getValue(this.attributesList.get(0));
                    if (!(value instanceof AttributeOption)) {
                        throw new UnsupportedOperationException("Requested attribute is not an attributeOption");
                    }
                    if (!this.attributeOptionMap.containsKey(value)) {
                        throw new UnsupportedOperationException("Map does not contain the requested attributeOption");
                    }
                    selectedValue = this.attributeOptionMap.get(value).intValue();
                    break;
                }
                case 8: {
                    for (Attribute<?> attr : this.attributesList) {
                        if (!attrs.containsAttribute(attr)) {
                            throw new UnsupportedOperationException("Component has not the required attribute");
                        }
                        Object intValue = attrs.getValue(attr);
                        if (intValue instanceof Integer) {
                            totalValue += (long)((Integer)intValue).intValue();
                            continue;
                        }
                        if (intValue instanceof BitWidth) {
                            BitWidth bitWidth = (BitWidth)intValue;
                            totalValue += (long)bitWidth.getWidth();
                            continue;
                        }
                        throw new UnsupportedOperationException("Requested attribute is not an Integer");
                    }
                    selectedValue = (long)Math.pow(totalValue, 2.0);
                    break;
                }
                case 5: {
                    for (Attribute<?> attr : this.attributesList) {
                        if (!attrs.containsAttribute(attr)) {
                            throw new UnsupportedOperationException("Component has not the required attribute");
                        }
                        Object intValue = attrs.getValue(attr);
                        if (intValue instanceof Integer) {
                            totalValue += (long)((Integer)intValue).intValue();
                            continue;
                        }
                        if (intValue instanceof BitWidth) {
                            BitWidth bitWidth = (BitWidth)intValue;
                            totalValue += (long)bitWidth.getWidth();
                            continue;
                        }
                        throw new UnsupportedOperationException("Requested attribute is not an Integer");
                    }
                    double logValue = Math.log(totalValue) / Math.log(2.0);
                    selectedValue = (long)Math.ceil(logValue) + this.offsetValue;
                    break;
                }
                case 6: {
                    if (!attrs.containsAttribute(this.attributesList.get(0))) {
                        throw new UnsupportedOperationException("Component has not the required attribute");
                    }
                    Object intValue = attrs.getValue(this.attributesList.get(0));
                    if (intValue instanceof Integer) {
                        selectedValue = (long)((Integer)intValue).intValue() + this.offsetValue;
                        break;
                    }
                    if (intValue instanceof Long) {
                        selectedValue = (Long)intValue + this.offsetValue;
                        break;
                    }
                    if (intValue instanceof BitWidth) {
                        BitWidth bitWidth = (BitWidth)intValue;
                        selectedValue = (long)bitWidth.getWidth() + this.offsetValue;
                        break;
                    }
                    throw new UnsupportedOperationException("Requested attribute is not an Integer");
                }
                case 7: {
                    if (!attrs.containsAttribute(GateAttributes.ATTR_INPUTS)) {
                        throw new UnsupportedOperationException("Component has not the required attribute");
                    }
                    Integer nrOfInputs = attrs.getValue(GateAttributes.ATTR_INPUTS);
                    long bubbleMask = 0L;
                    long mask = 1L;
                    for (int i = 0; i < nrOfInputs; ++i) {
                        int realIndex = Hdl.isVhdl() ? nrOfInputs - i - 1 : i;
                        Boolean inputIsInverted = attrs.getValue(new NegateAttribute(realIndex, null));
                        if (Boolean.TRUE.equals(inputIsInverted)) {
                            bubbleMask |= mask;
                        }
                        mask <<= 1;
                    }
                    selectedValue = bubbleMask;
                    break;
                }
                case 3: {
                    if (this.attributesList.isEmpty()) {
                        selectedValue = (long)attrs.getValue(this.attributeToCheckForBus).getWidth() * this.multiplyValue + this.offsetValue;
                        break;
                    }
                    selectedValue = 1L;
                    for (Attribute<?> attr : this.attributesList) {
                        if (!attrs.containsAttribute(attr)) continue;
                        Object attrValue = attrs.getValue(attr);
                        if (attrValue instanceof Integer) {
                            Integer intVal = (Integer)attrValue;
                            selectedValue *= (long)intVal.intValue();
                            continue;
                        }
                        if (attrValue instanceof Long) {
                            Long longVal = (Long)attrValue;
                            selectedValue *= longVal.longValue();
                            continue;
                        }
                        if (attrValue instanceof BitWidth) {
                            BitWidth width = (BitWidth)attrValue;
                            selectedValue *= (long)width.getWidth();
                            continue;
                        }
                        throw new UnsupportedOperationException("Requested attribute is not an Integer or Long");
                    }
                    break;
                }
                default: {
                    selectedValue = (long)attrs.getValue(this.attributeToCheckForBus).getWidth() * this.multiplyValue + this.offsetValue;
                }
            }
            return this.isIntParameter ? Integer.toString((int)selectedValue) : Hdl.getConstantVector(selectedValue, this.getNumberOfVectorBits(attrs));
        }

        public boolean isRepresentedByInteger() {
            return this.isIntParameter;
        }

        public void setVectorRepresentation() {
            this.isIntParameter = false;
        }

        public int getNumberOfVectorBits(AttributeSet attrs) {
            if (this.isIntParameter) {
                throw new UnsupportedOperationException("Parameter is not a bit vector!");
            }
            int nrOfVectorBits = -1;
            if (this.myMapType == 7) {
                if (!attrs.containsAttribute(GateAttributes.ATTR_INPUTS)) {
                    throw new UnsupportedOperationException("Component has not the required attribute");
                }
                nrOfVectorBits = attrs.getValue(GateAttributes.ATTR_INPUTS);
            }
            if (this.offsetValue > 0L) {
                nrOfVectorBits = (int)this.offsetValue;
            }
            if (nrOfVectorBits < 0) {
                if (attrs.containsAttribute(this.attributeToCheckForBus)) {
                    nrOfVectorBits = attrs.getValue(this.attributeToCheckForBus).getWidth();
                } else {
                    throw new UnsupportedOperationException("Cannot determine the number of bits required for the vector");
                }
            }
            return nrOfVectorBits;
        }

        private long getCorrectIntValue(Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException("Map Type requires a single argument");
            }
            long value = 0L;
            Object object = args[0];
            if (object instanceof Integer) {
                Integer intVal = (Integer)object;
                value = intVal.intValue();
            } else {
                object = args[0];
                if (object instanceof Long) {
                    Long longVal = (Long)object;
                    value = longVal;
                } else {
                    throw new IllegalArgumentException("Map Type requires an Integer or Long");
                }
            }
            if (value < 0L) {
                throw new NumberFormatException("Integer/long value must not be negative");
            }
            return value;
        }
    }
}

