/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.util.LineBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HdlTypes {
    private final Map<Integer, HdlType> myTypes = new HashMap<Integer, HdlType>();
    private final Map<String, Integer> myWires = new HashMap<String, Integer>();

    public HdlTypes addEnum(int identifier, String name) {
        this.myTypes.put(identifier, new HdlEnum(name));
        return this;
    }

    public HdlTypes addEnumEntry(int identifier, String entry) {
        if (!this.myTypes.containsKey(identifier)) {
            throw new IllegalArgumentException("Enum type not contained in array");
        }
        HdlEnum myEnum = (HdlEnum)this.myTypes.get(identifier);
        myEnum.add(entry);
        return this;
    }

    public HdlTypes addArray(int identifier, String name, String genericBitWidth, int nrOfEntries) {
        this.myTypes.put(identifier, new HdlArray(name, genericBitWidth, nrOfEntries));
        return this;
    }

    public HdlTypes addArray(int identifier, String name, int nrOfBits, int nrOfEntries) {
        this.myTypes.put(identifier, new HdlArray(name, nrOfBits, nrOfEntries));
        return this;
    }

    public HdlTypes addWire(String name, int typeIdentifier) {
        this.myWires.put(name, typeIdentifier);
        return this;
    }

    public int getNrOfTypes() {
        return this.myTypes.keySet().size();
    }

    public List<String> getTypeDefinitions() {
        LineBuffer defs = LineBuffer.getHdlBuffer();
        for (Integer entry : this.myTypes.keySet()) {
            defs.add(this.myTypes.get(entry).getTypeDefinition());
        }
        return defs.getWithIndent();
    }

    public Map<String, String> getTypedWires() {
        HashMap<String, String> contents = new HashMap<String, String>();
        for (String wire : this.myWires.keySet()) {
            Integer typeId = this.myWires.get(wire);
            if (!this.myTypes.containsKey(typeId)) {
                throw new IllegalArgumentException("Enum or array type not contained in array");
            }
            contents.put(wire, this.myTypes.get(typeId).getTypeName());
        }
        return contents;
    }

    public void clear() {
        this.myTypes.clear();
        this.myWires.clear();
    }

    private static class HdlEnum
    implements HdlType {
        private final List<String> myEntries = new ArrayList<String>();
        private final String myTypeName;

        public HdlEnum(String name) {
            this.myTypeName = name;
        }

        public HdlEnum add(String entry) {
            for (int item = 0; item < this.myEntries.size(); ++item) {
                if (this.myEntries.get(item).compareTo(entry) <= 0) continue;
                this.myEntries.add(item, entry);
                return this;
            }
            this.myEntries.add(entry);
            return this;
        }

        @Override
        public String getTypeDefinition() {
            StringBuilder contents = new StringBuilder();
            if (Hdl.isVhdl()) {
                contents.append(LineBuffer.formatVhdl("{{type}} {{1}} {{is}} (", this.myTypeName));
            } else {
                contents.append("typedef enum { ");
            }
            boolean first = true;
            for (String entry : this.myEntries) {
                if (first) {
                    first = false;
                } else {
                    contents.append(", ");
                }
                contents.append(entry);
            }
            if (Hdl.isVhdl()) {
                contents.append(");");
            } else {
                contents.append(String.format("} %s;", this.myTypeName));
            }
            return contents.toString();
        }

        @Override
        public String getTypeName() {
            return this.myTypeName;
        }
    }

    private static class HdlArray
    implements HdlType {
        private final String myTypeName;
        private final String myGenericBitWidth;
        private final int myBitWidth;
        private final int myNrOfEntries;

        public HdlArray(String name, String genericBitWidth, int nrOfEntries) {
            this.myTypeName = name;
            this.myGenericBitWidth = genericBitWidth;
            this.myBitWidth = -1;
            this.myNrOfEntries = nrOfEntries;
        }

        public HdlArray(String name, int nrOfBits, int nrOfEntries) {
            this.myTypeName = name;
            this.myGenericBitWidth = null;
            this.myBitWidth = nrOfBits;
            this.myNrOfEntries = nrOfEntries;
        }

        @Override
        public String getTypeDefinition() {
            StringBuilder contents = new StringBuilder();
            if (Hdl.isVhdl()) {
                contents.append(LineBuffer.formatVhdl("{{type}} {{1}} {{is}} {{array}} ( {{2}} {{downto}} 0 ) {{of}} std_logic_vector( ", this.myTypeName, this.myNrOfEntries)).append(this.myGenericBitWidth == null ? Integer.toString(this.myBitWidth - 1) : String.format("%s - 1", this.myGenericBitWidth)).append(LineBuffer.formatVhdl(" {{downto}} 0);", new Object[0]));
            } else {
                contents.append("typedef logic [").append(this.myGenericBitWidth == null ? Integer.toString(this.myBitWidth - 1) : String.format("%s - 1", this.myGenericBitWidth)).append(String.format(":0] %s [%d:0];", this.myTypeName, this.myNrOfEntries));
            }
            return contents.toString();
        }

        @Override
        public String getTypeName() {
            return this.myTypeName;
        }
    }

    private static interface HdlType {
        public String getTypeDefinition();

        public String getTypeName();
    }
}

