/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.util.LineBuffer;
import java.util.SortedMap;
import java.util.TreeMap;

public class TickComponentHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private final long fpgaClockFrequency;
    private final double tickFrequency;
    private static final String RELOAD_VALUE_STRING = "reloadValue";
    private static final Integer RELOAD_VALUE_ID = -1;
    private static final String NR_OF_COUNTER_BITS_STRING = "nrOfBits";
    private static final Integer NR_OF_COUNTER_BITS_ID = -2;
    public static final String FPGA_CLOCK = "fpgaGlobalClock";
    public static final String FPGA_TICK = "s_fpgaTick";
    public static final String HDL_IDENTIFIER = "logisimTickGenerator";
    public static final String HDL_DIRECTORY = "base";

    public TickComponentHdlGeneratorFactory(long fpga_clock_frequency, double tick_frequency) {
        super(HDL_DIRECTORY);
        this.fpgaClockFrequency = fpga_clock_frequency;
        this.tickFrequency = tick_frequency;
        double reloadValueAcc = (double)this.fpgaClockFrequency / this.tickFrequency;
        long reloadValue = (long)reloadValueAcc;
        int nrOfBits = 0;
        if (reloadValue > Integer.MAX_VALUE | reloadValue < 0L) {
            reloadValue = Integer.MAX_VALUE;
        }
        for (long calcValue = reloadValue; calcValue != 0L; calcValue /= 2L) {
            ++nrOfBits;
        }
        this.myParametersList.add(RELOAD_VALUE_STRING, RELOAD_VALUE_ID, 1, (int)reloadValue).add(NR_OF_COUNTER_BITS_STRING, NR_OF_COUNTER_BITS_ID, 1, nrOfBits);
        this.myWires.addWire("s_tickNext", 1).addWire("s_countNext", NR_OF_COUNTER_BITS_ID).addRegister("s_tickReg", 1).addRegister("s_countReg", NR_OF_COUNTER_BITS_ID);
        this.myPorts.add("input", "FPGAClock", 1, FPGA_CLOCK).add("output", "FPGATick", 1, FPGA_TICK);
    }

    public SortedMap<String, String> getPortMap(Netlist nets, Object mapInfo) {
        TreeMap<String, String> res = new TreeMap<String, String>();
        for (String port : this.myPorts.keySet()) {
            res.put(port, this.myPorts.getFixedMap(port));
        }
        return res;
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("nrOfCounterBits", NR_OF_COUNTER_BITS_STRING).add("").addRemarkBlock("Here the output is defined").add(TheNetlist.requiresGlobalClockConnection() ? "{{assign}} FPGATick {{=}} '1';" : "{{assign}} FPGATick {{=}} s_tickReg;").add("").addRemarkBlock("Here the update logic is defined");
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("s_tickNext   <= '1' {{when}} s_countReg = std_logic_vector(to_unsigned(0, {{nrOfCounterBits}})) {{else}} '0';\ns_countNext  <= ({{others}} => '0') {{when}} s_tickReg /= '0' {{and}} s_tickReg /= '1' {{else}} -- For simulation only!\n                std_logic_vector(to_unsigned((reloadValue-1), {{nrOfCounterBits}})) {{when}} s_tickNext = '1' {{else}}\n                std_logic_vector(unsigned(s_countReg)-1);\n").empty();
        } else {
            contents.add("assign s_tickNext  = (s_countReg == 0) ? 1'b1 : 1'b0;\nassign s_countNext = (s_countReg == 0) ? reloadValue-1 : s_countReg-1;\n").empty().addRemarkBlock("Here the simulation only initial is defined").add("initial\nbegin\n   s_countReg = 0;\n   s_tickReg  = 1'b0;\nend\n").empty();
        }
        contents.addRemarkBlock("Here the flipflops are defined");
        if (Hdl.isVhdl()) {
            contents.add("makeFlipFlops : {{process}}(FPGAClock) {{is}}\n{{begin}}\n   {{if}} (rising_edge(FPGAClock)) {{then}}\n      s_tickReg  <= s_tickNext;\n      s_countReg <= s_countNext;\n   {{end}} {{if}};\n{{end}} {{process}} makeFlipFlops;\n").empty();
        } else {
            contents.add("always @(posedge FPGAClock)\nbegin\n    s_countReg <= s_countNext;\n    s_tickReg  <= s_tickNext;\nend\n").empty();
        }
        return contents;
    }
}

