/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitHdlGeneratorFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoComponentTypes;
import com.cburch.logisim.fpga.data.LedArrayDriving;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.TickComponentHdlGeneratorFactory;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;

public class ToplevelHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private final long fpgaClockFrequency;
    private final double tickFrequency;
    private final Circuit myCircuit;
    private final MappableResourcesContainer myIOComponents;
    private final boolean requiresFPGAClock;
    private final boolean hasLedArray;
    private final ArrayList<FpgaIoInformationContainer> myLedArrays;
    private final HashMap<String, Boolean> ledArrayTypesUsed;
    public static final String HDL_DIRECTORY = "toplevel";

    public ToplevelHdlGeneratorFactory(long fpgaClock, double tickClock, Circuit topLevel, MappableResourcesContainer ioComponents) {
        super(HDL_DIRECTORY);
        int nrOfBits;
        this.fpgaClockFrequency = fpgaClock;
        this.tickFrequency = tickClock;
        this.myCircuit = topLevel;
        this.myIOComponents = ioComponents;
        boolean hasScanningLedArray = false;
        boolean hasLedArray = false;
        Netlist nets = topLevel.getNetList();
        HashMap<String, Boolean> ledArrayTypesUsed = new HashMap<String, Boolean>();
        ArrayList<FpgaIoInformationContainer> ledArrays = new ArrayList<FpgaIoInformationContainer>();
        int nrOfClockTrees = nets.numberOfClockTrees();
        int nrOfInputBubbles = nets.getNumberOfInputBubbles();
        int nrOfInOutBubbles = nets.numberOfInOutBubbles();
        int nrOfOutputBubbles = nets.numberOfOutputBubbles();
        int nrOfInputPorts = nets.getNumberOfInputPorts();
        int nrOfInOutPorts = nets.numberOfInOutPorts();
        int nrOfOutputPorts = nets.numberOfOutputPorts();
        for (FpgaIoInformationContainer comp : this.myIOComponents.getIoComponentInformation().getComponents()) {
            if (!comp.getType().equals((Object)IoComponentTypes.LedArray) || !comp.hasMap()) continue;
            ledArrayTypesUsed.put(LedArrayDriving.getStrings().get(comp.getArrayDriveMode()), true);
            ledArrays.add(comp);
            comp.setArrayId(ledArrays.indexOf(comp));
            hasLedArray = true;
            if (comp.getArrayDriveMode() == '\u0000' || comp.getArrayDriveMode() == '\u0003') continue;
            hasScanningLedArray = true;
        }
        this.requiresFPGAClock = hasScanningLedArray;
        this.hasLedArray = hasLedArray;
        this.ledArrayTypesUsed = ledArrayTypesUsed;
        this.myLedArrays = ledArrays;
        if (nrOfClockTrees > 0) {
            this.myWires.addWire("s_fpgaTick", 1);
            for (int clockId = 0; clockId < nrOfClockTrees; ++clockId) {
                this.myWires.addWire(String.format("s_%s%d", "logisimClockTree", clockId), 5);
            }
        }
        if (nrOfInputBubbles > 0) {
            this.myWires.addWire(String.format("s_%s", "logisimInputBubbles"), nrOfInputBubbles > 1 ? nrOfInputBubbles : 0);
        }
        if (nrOfInOutBubbles > 0) {
            this.myWires.addWire(String.format("s_%s", "logisimInOutBubbles"), nrOfInOutBubbles > 1 ? nrOfInOutBubbles : 0);
        }
        if (nrOfOutputBubbles > 0) {
            this.myWires.addWire(String.format("s_%s", "logisimOutputBubbles"), nrOfOutputBubbles > 1 ? nrOfOutputBubbles : 0);
        }
        if (nrOfInputPorts > 0) {
            for (int input = 0; input < nrOfInputPorts; ++input) {
                String inputName = String.format("s_%s", CorrectLabel.getCorrectLabel(nets.getInputPin(input).getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
                nrOfBits = nets.getInputPin(input).getComponent().getEnd(0).getWidth().getWidth();
                this.myWires.addWire(inputName, nrOfBits);
            }
        }
        if (nrOfInOutPorts > 0) {
            for (int inout = 0; inout < nrOfInOutPorts; ++inout) {
                String ioName = String.format("s_%s", CorrectLabel.getCorrectLabel(nets.getInOutPin(inout).getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
                nrOfBits = nets.getInOutPin(inout).getComponent().getEnd(0).getWidth().getWidth();
                this.myWires.addWire(ioName, nrOfBits);
            }
        }
        if (nrOfOutputPorts > 0) {
            for (int output = 0; output < nrOfOutputPorts; ++output) {
                String outputName = String.format("s_%s", CorrectLabel.getCorrectLabel(nets.getOutputPin(output).getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
                nrOfBits = nets.getOutputPin(output).getComponent().getEnd(0).getWidth().getWidth();
                this.myWires.addWire(outputName, nrOfBits);
            }
        }
        for (FpgaIoInformationContainer ledArray : this.myLedArrays) {
            this.myWires.addAllWires(LedArrayGenericHdlGeneratorFactory.getInternalSignals(ledArray.getArrayDriveMode(), ledArray.getNrOfRows(), ledArray.getNrOfColumns(), this.myLedArrays.indexOf(ledArray)));
            SortedMap<String, Integer> ports = LedArrayGenericHdlGeneratorFactory.getExternalSignals(ledArray.getArrayDriveMode(), ledArray.getNrOfRows(), ledArray.getNrOfColumns(), this.myLedArrays.indexOf(ledArray));
            for (String port : ports.keySet()) {
                this.myPorts.add("output", port, (int)((Integer)ports.get(port)), null);
            }
        }
        if (nrOfClockTrees > 0 || nets.requiresGlobalClockConnection() || this.requiresFPGAClock) {
            this.myPorts.add("input", "fpgaGlobalClock", 1, null);
        }
        for (String in : this.myIOComponents.getMappedInputPinNames()) {
            this.myPorts.add("input", in, 1, null);
        }
        for (String io : this.myIOComponents.getMappedOutputPinNames()) {
            this.myPorts.add("output", io, 1, null);
        }
        for (String io : this.myIOComponents.getMappedIoPinNames()) {
            this.myPorts.add("inout", io, 1, null);
        }
    }

    public boolean hasLedArray() {
        return this.hasLedArray;
    }

    public boolean hasLedArrayType(String type) {
        if (!this.ledArrayTypesUsed.containsKey(type)) {
            return false;
        }
        return this.ledArrayTypesUsed.get(type);
    }

    @Override
    public LineBuffer getComponentDeclarationSection(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer components = LineBuffer.getHdlBuffer();
        int nrOfClockTrees = theNetlist.numberOfClockTrees();
        if (nrOfClockTrees > 0) {
            TickComponentHdlGeneratorFactory ticker = new TickComponentHdlGeneratorFactory(this.fpgaClockFrequency, this.tickFrequency);
            components.add(ticker.getComponentInstantiation(theNetlist, null, "logisimTickGenerator")).empty();
            HdlGeneratorFactory clockWorker = theNetlist.getAllClockSources().get(0).getFactory().getHDLGenerator(theNetlist.getAllClockSources().get(0).getAttributeSet());
            components.add(clockWorker.getComponentInstantiation(theNetlist, theNetlist.getAllClockSources().get(0).getAttributeSet(), theNetlist.getAllClockSources().get(0).getFactory().getHDLName(theNetlist.getAllClockSources().get(0).getAttributeSet()))).empty();
        }
        for (String type : LedArrayDriving.DRIVING_STRINGS) {
            if (!this.hasLedArrayType(type)) continue;
            AbstractHdlGeneratorFactory worker = LedArrayGenericHdlGeneratorFactory.getSpecificHDLGenerator(type);
            String name = LedArrayGenericHdlGeneratorFactory.getSpecificHDLName(type);
            if (worker == null || name == null) continue;
            components.add(worker.getComponentInstantiation(theNetlist, null, name)).empty();
        }
        CircuitHdlGeneratorFactory worker = new CircuitHdlGeneratorFactory(this.myCircuit);
        components.add(worker.getComponentInstantiation(theNetlist, null, CorrectLabel.getCorrectLabel(this.myCircuit.getName())));
        return components;
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        HashMap<String, String> wires = new HashMap<String, String>();
        int nrOfClockTrees = theNetlist.numberOfClockTrees();
        for (ArrayList<String> key : this.myIOComponents.getMappableResources().keySet()) {
            MapComponent comp = this.myIOComponents.getMappableResources().get(key);
            wires.putAll(ToplevelHdlGeneratorFactory.getToplevelWires(comp));
        }
        if (!wires.isEmpty()) {
            contents.empty().addRemarkBlock("All signal adaptations are performed here");
            Hdl.addAllWiresSorted(contents, wires);
        }
        if (nrOfClockTrees > 0) {
            contents.empty().addRemarkBlock("The clock tree components are defined here");
            long index = 0L;
            TickComponentHdlGeneratorFactory ticker = new TickComponentHdlGeneratorFactory(this.fpgaClockFrequency, this.tickFrequency);
            contents.add(ticker.getComponentMap(null, index++, null, "logisimTickGenerator")).empty();
            for (Component clockGen : theNetlist.getAllClockSources()) {
                netlistComponent thisClock = new netlistComponent(clockGen);
                contents.add(clockGen.getFactory().getHDLGenerator(thisClock.getComponent().getAttributeSet()).getComponentMap(theNetlist, index++, thisClock, ""));
            }
        }
        contents.empty().addRemarkBlock("The toplevel component is connected here");
        CircuitHdlGeneratorFactory dut = new CircuitHdlGeneratorFactory(this.myCircuit);
        contents.add(dut.getComponentMap(theNetlist, 0L, this.myIOComponents, CorrectLabel.getCorrectLabel(this.myCircuit.getName())));
        if (this.hasLedArray) {
            contents.empty().addRemarkBlock("The Led arrays are connected here");
            for (FpgaIoInformationContainer array : this.myLedArrays) {
                contents.add(LedArrayGenericHdlGeneratorFactory.getComponentMap(array.getArrayDriveMode(), array.getNrOfRows(), array.getNrOfColumns(), this.myLedArrays.indexOf(array), this.fpgaClockFrequency, array.getActivityLevel() == '\u0000'));
                contents.add(LedArrayGenericHdlGeneratorFactory.getArrayConnections(array, this.myLedArrays.indexOf(array)));
            }
        }
        return contents;
    }

    private static Map<String, String> getToplevelWires(MapComponent component) {
        HashMap<String, String> wires = new HashMap<String, String>();
        if (component.getNrOfPins() <= 0) {
            Reporter.report.addError("BUG: Found a component with no pins. Please report this occurance!");
            return wires;
        }
        for (int i = 0; i < component.getNrOfPins(); ++i) {
            String operator;
            String preamble = component.isExternalInverted(i) ? "n_" : "";
            String string = operator = component.isExternalInverted(i) ? Hdl.notOperator() : "";
            if (component.isInternalMapped(i) || component.isIo(i)) continue;
            if (!component.isMapped(i)) {
                if (component.isOutput(i)) continue;
                wires.put(component.getHdlSignalName(i), Hdl.zeroBit());
                continue;
            }
            if (component.isInput(i)) {
                String destination = component.getHdlSignalName(i);
                if (component.isConstantMapped(i)) {
                    wires.put(destination, component.isZeroConstantMap(i) ? Hdl.zeroBit() : Hdl.oneBit());
                    continue;
                }
                wires.put(destination, LineBuffer.formatHdl("{{1}}{{2}}{{3}}", operator, preamble, component.getHdlString(i)));
                continue;
            }
            if (component.isOpenMapped(i)) continue;
            wires.put(LineBuffer.formatHdl("{{1}}{{2}}", preamble, component.getHdlString(i)), LineBuffer.formatHdl("{{1}}{{2}}", operator, component.getHdlSignalName(i)));
        }
        return wires;
    }
}

