/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.prefs;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.gui.FpgaCommander;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.Softwares;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class SoftwaresOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final MyListener myListener = new MyListener();
    private final JCheckBox questaValidationCheckBox = new JCheckBox();
    private final JLabel questaPathLabel = new JLabel();
    private final JTextField questaPathField = new JTextField(40);
    private final JButton questaPathButton = new JButton();
    private final JLabel quartusPathLabel = new JLabel();
    private final JTextField quartusPathField = new JTextField(40);
    private final JButton quartusPathButton = new JButton();
    private final JLabel isePathLabel = new JLabel();
    private final JTextField isePathField = new JTextField(40);
    private final JButton isePathButton = new JButton();
    private final JLabel vivadoPathLabel = new JLabel();
    private final JTextField vivadoPathField = new JTextField(40);
    private final JButton vivadoPathButton = new JButton();

    public SoftwaresOptions(PreferencesFrame window) {
        super(window);
        this.questaValidationCheckBox.addActionListener(this.myListener);
        this.questaPathButton.addActionListener(this.myListener);
        this.quartusPathButton.addActionListener(this.myListener);
        this.isePathButton.addActionListener(this.myListener);
        this.vivadoPathButton.addActionListener(this.myListener);
        AppPreferences.getPrefs().addPreferenceChangeListener(this.myListener);
        JSeparator sep = new JSeparator(0);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        c.insets = new Insets(2, 4, 4, 2);
        c.anchor = 512;
        int gridY = 0;
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)new JSeparator(0), c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 3;
        c.fill = 0;
        this.add((Component)this.questaValidationCheckBox, c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)sep, c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 3;
        c.fill = 0;
        this.add((Component)this.questaPathLabel, c);
        c.gridx = 0;
        c.gridy = gridY;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.questaPathField, c);
        c.gridx = 2;
        c.gridy = gridY++;
        c.fill = 0;
        this.add((Component)this.questaPathButton, c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)new JSeparator(0), c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.quartusPathLabel, c);
        c.gridx = 0;
        c.gridy = gridY;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.quartusPathField, c);
        c.gridx = 2;
        c.gridy = gridY++;
        c.fill = 0;
        this.add((Component)this.quartusPathButton, c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)new JSeparator(0), c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.isePathLabel, c);
        c.gridx = 0;
        c.gridy = gridY;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.isePathField, c);
        c.gridx = 2;
        c.gridy = gridY++;
        c.fill = 0;
        this.add((Component)this.isePathButton, c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)new JSeparator(0), c);
        c.gridx = 0;
        c.gridy = gridY++;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.vivadoPathLabel, c);
        c.gridx = 0;
        c.gridy = gridY;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.vivadoPathField, c);
        c.gridx = 2;
        c.gridy = gridY++;
        c.fill = 0;
        this.add((Component)this.vivadoPathButton, c);
        this.questaValidationCheckBox.setSelected(AppPreferences.QUESTA_VALIDATION.getBoolean());
        this.quartusPathField.setText(AppPreferences.QuartusToolPath.get());
        this.quartusPathField.setEditable(false);
        this.isePathField.setText(AppPreferences.ISEToolPath.get());
        this.isePathField.setEditable(false);
        this.vivadoPathField.setText(AppPreferences.VivadoToolPath.get());
        this.vivadoPathField.setEditable(false);
        this.questaPathField.setText(AppPreferences.QUESTA_PATH.get());
        this.questaPathField.setEditable(false);
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("softwaresHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("softwaresTitle");
    }

    @Override
    public void localeChanged() {
        this.questaValidationCheckBox.setText(Strings.S.get("softwaresQuestaValidationLabel"));
        this.questaPathButton.setText(Strings.S.get("softwaresQuestaPathButton"));
        this.questaPathLabel.setText(Strings.S.get("softwaresQuestaPathLabel"));
        this.quartusPathButton.setText(Strings.S.get("softwaresQuestaPathButton"));
        this.quartusPathLabel.setText(Strings.S.get("QuartusToolPath"));
        this.isePathButton.setText(Strings.S.get("softwaresQuestaPathButton"));
        this.isePathLabel.setText(Strings.S.get("ISEToolPath"));
        this.vivadoPathButton.setText(Strings.S.get("softwaresQuestaPathButton"));
        this.vivadoPathLabel.setText(Strings.S.get("VivadoToolPath"));
    }

    private class MyListener
    implements ActionListener,
    PreferenceChangeListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == SoftwaresOptions.this.questaPathButton) {
                Softwares.setQuestaPath(SoftwaresOptions.this.getPreferencesFrame());
            } else if (source == SoftwaresOptions.this.questaValidationCheckBox) {
                AppPreferences.QUESTA_VALIDATION.setBoolean(SoftwaresOptions.this.questaValidationCheckBox.isSelected());
            } else if (source == SoftwaresOptions.this.quartusPathButton) {
                FpgaCommander.selectToolPath('\u0000');
            } else if (source == SoftwaresOptions.this.isePathButton) {
                FpgaCommander.selectToolPath('\u0001');
            } else if (source == SoftwaresOptions.this.vivadoPathButton) {
                FpgaCommander.selectToolPath('\u0002');
            }
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent pce) {
            String property = pce.getKey();
            if (property.equals(AppPreferences.QUESTA_PATH.getIdentifier())) {
                SoftwaresOptions.this.questaPathField.setText(AppPreferences.QUESTA_PATH.get());
            } else if (property.equals(AppPreferences.QUESTA_VALIDATION.getIdentifier())) {
                SoftwaresOptions.this.questaValidationCheckBox.setSelected(AppPreferences.QUESTA_VALIDATION.getBoolean());
            } else if (property.equals(AppPreferences.QuartusToolPath.getIdentifier())) {
                SoftwaresOptions.this.quartusPathField.setText(AppPreferences.QuartusToolPath.get());
            } else if (property.equals(AppPreferences.ISEToolPath.getIdentifier())) {
                SoftwaresOptions.this.isePathField.setText(AppPreferences.ISEToolPath.get());
            } else if (property.equals(AppPreferences.VivadoToolPath.getIdentifier())) {
                SoftwaresOptions.this.vivadoPathField.setText(AppPreferences.VivadoToolPath.get());
            }
        }
    }
}

