/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.settings;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BoardList {
    private static final String boardResourcePath = "resources" + File.separator + "logisim" + File.separator + "boards";
    private final ArrayList<String> definedBoards = new ArrayList();

    public static String getBoardName(String boardIdentifier) {
        String[] parts = boardIdentifier.contains("url:") ? boardIdentifier.split("/") : boardIdentifier.split(Pattern.quote(File.separator));
        return parts[parts.length - 1].replace(".xml", "");
    }

    private static Collection<String> getBoards(Pattern pattern, String match, String element) {
        ArrayList<String> ret = new ArrayList<String>();
        File file = new File(element);
        if (file.isDirectory()) {
            ret.addAll(BoardList.getBoardsfromDirectory(pattern, match, file));
        } else {
            ret.addAll(BoardList.getBoardsfromJar(pattern, match, file));
        }
        return ret;
    }

    private static Collection<String> getBoardsfromDirectory(Pattern pattern, String match, File dir) {
        File[] fileList;
        ArrayList<String> ret = new ArrayList<String>();
        for (File file : fileList = dir.listFiles()) {
            if (file.isDirectory()) {
                ret.addAll(BoardList.getBoardsfromDirectory(pattern, match, file));
                continue;
            }
            try {
                boolean accept;
                String fileName = file.getCanonicalPath();
                boolean bl = accept = pattern.matcher(fileName).matches() && fileName.contains(match);
                if (!accept) continue;
                ret.add("file:" + fileName);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return ret;
    }

    private static Collection<String> getBoardsfromJar(Pattern pattern, String match, File dir) {
        ZipFile zf;
        match = match.replaceAll("\\\\", "/");
        ArrayList<String> ret = new ArrayList<String>();
        try {
            zf = new ZipFile(dir);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches() && fileName.contains(match);
            if (!accept) continue;
            ret.add("url:" + fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return ret;
    }

    public BoardList() {
        String classPath = System.getProperty("java.class.path", File.pathSeparator);
        String[] classPathElements = classPath.split(Pattern.quote(File.pathSeparator));
        Pattern pattern = Pattern.compile(".*.xml");
        for (String element : classPathElements) {
            this.definedBoards.addAll(BoardList.getBoards(pattern, boardResourcePath, element));
        }
    }

    public boolean addExternalBoard(String fileName) {
        if (!this.definedBoards.contains(fileName)) {
            this.definedBoards.add(fileName);
            return true;
        }
        return false;
    }

    public boolean removeExternalBoard(String fileName) {
        if (this.definedBoards.contains(fileName)) {
            this.definedBoards.remove(fileName);
            return true;
        }
        return false;
    }

    public String getBoardFilePath(String boardName) {
        if (boardName == null) {
            return null;
        }
        for (String board : this.definedBoards) {
            if (!BoardList.getBoardName(board).equals(boardName)) continue;
            return board;
        }
        return null;
    }

    public List<String> getBoardNames() {
        SortedArrayList<String> ret = new SortedArrayList<String>();
        for (String board : this.definedBoards) {
            ret.insertSorted(BoardList.getBoardName(board));
        }
        return ret;
    }

    private static class SortedArrayList<T>
    extends ArrayList<T> {
        private SortedArrayList() {
        }

        public void insertSorted(T value) {
            this.add(value);
            Comparable cmp = (Comparable)value;
            for (int i = this.size() - 1; i > 0 && cmp.compareTo(this.get(i - 1)) < 0; --i) {
                Collections.swap(this, i, i - 1);
            }
        }
    }
}

