/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.actions.ModelAction;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.undo.UndoAction;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.appear.AppearanceElement;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import java.util.HashMap;
import java.util.Map;

public class CanvasActionAdapter
extends Action {
    private final Circuit circuit;
    private final UndoAction canvasAction;

    public CanvasActionAdapter(Circuit circuit, UndoAction action) {
        this.circuit = circuit;
        this.canvasAction = action;
    }

    private boolean affectsPorts() {
        UndoAction undoAction = this.canvasAction;
        if (undoAction instanceof ModelAction) {
            ModelAction action = (ModelAction)undoAction;
            for (CanvasObject obj : action.getObjects()) {
                if (!(obj instanceof AppearanceElement)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doIt(Project proj) {
        if (this.affectsPorts()) {
            ActionTransaction xn = new ActionTransaction(true);
            xn.execute();
        } else {
            this.canvasAction.doIt();
        }
    }

    @Override
    public String getName() {
        return this.canvasAction.getName();
    }

    @Override
    public void undo(Project proj) {
        if (this.affectsPorts()) {
            ActionTransaction xn = new ActionTransaction(false);
            xn.execute();
        } else {
            this.canvasAction.undo();
        }
    }

    private class ActionTransaction
    extends CircuitTransaction {
        private final boolean forward;

        ActionTransaction(boolean forward) {
            this.forward = forward;
        }

        @Override
        protected Map<Circuit, Integer> getAccessedCircuits() {
            HashMap<Circuit, Integer> accessMap = new HashMap<Circuit, Integer>();
            for (Circuit supercirc : CanvasActionAdapter.this.circuit.getCircuitsUsingThis()) {
                accessMap.put(supercirc, READ_WRITE);
            }
            return accessMap;
        }

        @Override
        protected void run(CircuitMutator mutator) {
            if (this.forward) {
                CanvasActionAdapter.this.canvasAction.doIt();
            } else {
                CanvasActionAdapter.this.canvasAction.undo();
            }
        }
    }
}

