/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.util.ZOrder;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.appear.AppearanceCanvas;
import com.cburch.logisim.gui.appear.Clipboard;
import com.cburch.logisim.gui.appear.ClipboardContents;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import java.util.ArrayList;
import java.util.Map;

public class ClipboardActions
extends Action {
    private final boolean remove;
    private final AppearanceCanvas canvas;
    private final CanvasModel canvasModel;
    private final Map<CanvasObject, Integer> affected;
    private final ClipboardContents newClipboard;
    private ClipboardContents oldClipboard;

    private ClipboardActions(boolean remove, AppearanceCanvas canvas) {
        this.remove = remove;
        this.canvas = canvas;
        this.canvasModel = canvas.getModel();
        ArrayList<CanvasObject> contents = new ArrayList<CanvasObject>();
        Direction anchorFacing = null;
        Location anchorLocation = null;
        ArrayList<CanvasObject> aff = new ArrayList<CanvasObject>();
        for (CanvasObject obj : canvas.getSelection().getSelected()) {
            if (obj.canRemove()) {
                aff.add(obj);
                contents.add(obj.clone());
                continue;
            }
            if (!(obj instanceof AppearanceAnchor)) continue;
            AppearanceAnchor anchor = (AppearanceAnchor)obj;
            anchorFacing = anchor.getFacingDirection();
            anchorLocation = anchor.getLocation();
        }
        contents.trimToSize();
        this.affected = ZOrder.getZIndex(aff, this.canvasModel);
        this.newClipboard = new ClipboardContents(contents, anchorLocation, anchorFacing);
    }

    public static Action copy(AppearanceCanvas canvas) {
        return new ClipboardActions(false, canvas);
    }

    public static Action cut(AppearanceCanvas canvas) {
        return new ClipboardActions(true, canvas);
    }

    @Override
    public void doIt(Project proj) {
        this.oldClipboard = Clipboard.get();
        Clipboard.set(this.newClipboard);
        if (this.remove) {
            this.canvasModel.removeObjects(this.affected.keySet());
        }
    }

    @Override
    public String getName() {
        return this.remove ? Strings.S.get("cutSelectionAction") : Strings.S.get("copySelectionAction");
    }

    @Override
    public void undo(Project proj) {
        if (this.remove) {
            this.canvasModel.addObjects(this.affected);
            this.canvas.getSelection().clearSelected();
            this.canvas.getSelection().setSelected(this.affected.keySet(), true);
        }
        Clipboard.set(this.oldClipboard);
    }
}

