/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.toolbar.ToolbarClickableItem;
import com.cburch.draw.tools.DrawingAttributeSet;
import com.cburch.logisim.gui.appear.AppearanceCanvas;
import com.cburch.logisim.gui.appear.AppearanceView;
import com.cburch.logisim.gui.appear.ShowStateDialog;
import com.cburch.logisim.gui.icons.ShowStateIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;

public class ShowStateTool
implements ToolbarClickableItem {
    private final AppearanceView view;
    private final AppearanceCanvas canvas;
    private final Icon icon;
    private final Icon pressed;

    public ShowStateTool(AppearanceView view, AppearanceCanvas canvas, DrawingAttributeSet attrs) {
        this.view = view;
        this.canvas = canvas;
        this.icon = new ShowStateIcon(false);
        this.pressed = new ShowStateIcon(true);
    }

    @Override
    public Dimension getDimension(Object orientation) {
        return new Dimension(this.icon.getIconWidth() + 8, this.icon.getIconHeight() + 8);
    }

    @Override
    public String getToolTip() {
        return "Select state to be shown";
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void clicked() {
        ShowStateDialog w = new ShowStateDialog(this.view.getFrame(), this.canvas);
        Point p = this.view.getFrame().getLocation();
        p.translate(80, 50);
        w.setLocation(p);
        w.setVisible(true);
    }

    @Override
    public void paintIcon(Component destination, Graphics gfx) {
        this.icon.paintIcon(destination, gfx, 4, 4);
    }

    @Override
    public void paintPressedIcon(Component destination, Graphics gfx) {
        this.pressed.paintIcon(destination, gfx, 4, 4);
    }
}

