/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.chrono;

import com.cburch.draw.toolbar.Toolbar;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.chrono.LeftPanel;
import com.cburch.logisim.gui.chrono.RightPanel;
import com.cburch.logisim.gui.log.LogFrame;
import com.cburch.logisim.gui.log.LogPanel;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.gui.log.Signal;
import com.cburch.logisim.gui.log.SignalInfo;
import com.cburch.logisim.gui.main.SimulationToolbarModel;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.PrintHandler;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class ChronoPanel
extends LogPanel
implements Model.Listener {
    private static final long serialVersionUID = 1L;
    public static final int HEADER_HEIGHT = 20;
    public static final int SIGNAL_HEIGHT = 30;
    public static final int GAP = 2;
    public static final int INITIAL_SPLIT = 150;
    private Model model;
    private RightPanel rightPanel;
    private LeftPanel leftPanel;
    private JScrollPane leftScroll;
    private JScrollPane rightScroll;
    private JSplitPane splitPane;
    private static final Color PLAIN_BG = new Color(187, 187, 187);
    private static final Color PLAIN_HI = ChronoPanel.darker(PLAIN_BG);
    private static final Color PLAIN_LINE = Color.BLACK;
    private static final Color PLAIN_ERR = new Color(219, 157, 157);
    private static final Color PLAIN_ERRLINE = Color.BLACK;
    private static final Color PLAIN_UNK = new Color(234, 170, 108);
    private static final Color PLAIN_UNKLINE = Color.BLACK;
    private static final Color SPOT_BG = new Color(170, 255, 170);
    private static final Color SPOT_HI = ChronoPanel.darker(SPOT_BG);
    private static final Color SPOT_LINE = Color.BLACK;
    private static final Color SPOT_ERR = new Color(249, 118, 118);
    private static final Color SPOT_ERRLINE = Color.BLACK;
    private static final Color SPOT_UNK = new Color(234, 152, 73);
    private static final Color SPOT_UNKLINE = Color.BLACK;
    private final Color selectBg;
    private final Color selectHi;
    private static final Color SELECT_LINE = Color.BLACK;
    private static final Color SELECT_ERR = new Color(229, 128, 128);
    private static final Color SELECT_ERRLINE = Color.BLACK;
    private static final Color SELECT_UNK = new Color(238, 153, 68);
    private static final Color SELECT_UNKLINE = Color.BLACK;
    private static final Color[] SPOT = new Color[]{SPOT_BG, SPOT_HI, SPOT_LINE, SPOT_ERR, SPOT_ERRLINE, SPOT_UNK, SPOT_UNKLINE};
    private static final Color[] PLAIN = new Color[]{PLAIN_BG, PLAIN_HI, PLAIN_LINE, PLAIN_ERR, PLAIN_ERRLINE, PLAIN_UNK, PLAIN_UNKLINE};
    private final Color[] selectColors;
    final EditHandler editHandler = new EditHandler(){

        @Override
        public void computeEnabled() {
            boolean empty = ChronoPanel.this.model.getSignalCount() == 0;
            boolean sel = !empty && !ChronoPanel.this.leftPanel.getSelectionModel().isSelectionEmpty();
            this.setEnabled(LogisimMenuBar.CUT, sel);
            this.setEnabled(LogisimMenuBar.COPY, sel);
            this.setEnabled(LogisimMenuBar.PASTE, true);
            this.setEnabled(LogisimMenuBar.DELETE, sel);
            this.setEnabled(LogisimMenuBar.DUPLICATE, false);
            this.setEnabled(LogisimMenuBar.SELECT_ALL, !empty);
            this.setEnabled(LogisimMenuBar.RAISE, sel);
            this.setEnabled(LogisimMenuBar.LOWER, sel);
            this.setEnabled(LogisimMenuBar.RAISE_TOP, sel);
            this.setEnabled(LogisimMenuBar.LOWER_BOTTOM, sel);
            this.setEnabled(LogisimMenuBar.ADD_CONTROL, false);
            this.setEnabled(LogisimMenuBar.REMOVE_CONTROL, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object action = e.getSource();
            ChronoPanel.this.leftPanel.getActionMap().get(action).actionPerformed(e);
        }
    };
    final PrintHandler printHandler = new PrintHandler(){

        @Override
        public Dimension getExportImageSize() {
            Dimension l = ChronoPanel.this.leftPanel.getPreferredSize();
            Dimension r = ChronoPanel.this.rightPanel.getPreferredSize();
            int width = l.width + 3 + r.width;
            int height = 20 + l.height;
            return new Dimension(width, height);
        }

        @Override
        public void paintExportImage(BufferedImage img, Graphics2D g) {
            Dimension l = ChronoPanel.this.leftPanel.getPreferredSize();
            Dimension r = ChronoPanel.this.rightPanel.getPreferredSize();
            g.setClip(0, 0, l.width, 20);
            ChronoPanel.this.leftPanel.getTableHeader().print(g);
            g.setClip(l.width + 3, 0, r.width, 20);
            g.translate(l.width + 3, 0);
            ChronoPanel.this.rightPanel.getTimelineHeader().print(g);
            g.translate(-(l.width + 3), 0);
            g.setClip(0, 20, l.width, l.height);
            g.translate(0, 20);
            ChronoPanel.this.leftPanel.print(g);
            g.translate(0, -20);
            g.setClip(l.width + 3, 20, r.width, l.height);
            g.translate(l.width + 3, 20);
            ChronoPanel.this.rightPanel.print(g);
            g.translate(-(l.width + 3), -20);
        }

        @Override
        public int print(Graphics2D g, PageFormat pf, int pageNum, double w, double h) {
            if (pageNum != 0) {
                return 1;
            }
            FontMetrics fm = g.getFontMetrics();
            Dimension d = this.getExportImageSize();
            double headerHeight = (double)fm.getHeight() * 1.5;
            double scale = 1.0;
            if ((double)d.width > w || (double)d.height > h - headerHeight) {
                scale = Math.min(w / (double)d.width, (h - headerHeight) / (double)d.height);
            }
            GraphicsUtil.drawText(g, Strings.S.get("ChronoPrintTitle", ChronoPanel.this.model.getCircuit().getName(), ChronoPanel.this.getProject().getLogisimFile().getDisplayName()), (int)(w / 2.0), 0, 0, -1);
            g.translate(0.0, (double)fm.getHeight() * 1.5);
            g.scale(scale, scale);
            this.paintExportImage(null, g);
            return 0;
        }
    };

    public ChronoPanel(LogFrame logFrame) {
        super(logFrame);
        this.selectBg = UIManager.getDefaults().getColor("List.selectionBackground");
        this.selectHi = ChronoPanel.darker(this.selectBg);
        this.selectColors = new Color[]{this.selectBg, this.selectHi, SELECT_LINE, SELECT_ERR, SELECT_ERRLINE, SELECT_UNK, SELECT_UNKLINE};
        this.setModel(logFrame.getModel());
        this.configure();
        this.resplit();
        this.editHandler.computeEnabled();
    }

    private void configure() {
        this.setLayout(new BorderLayout());
        LogFrame logFrame = this.getLogFrame();
        SimulationToolbarModel simTools = new SimulationToolbarModel(this.getProject(), logFrame.getMenuListener());
        Toolbar toolbar = new Toolbar(simTools);
        JPanel toolpanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        toolpanel.setLayout(gb);
        gc.fill = 0;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.gridy = 0;
        gc.gridx = 0;
        gb.setConstraints(toolbar, gc);
        toolpanel.add(toolbar);
        JButton b = logFrame.makeSelectionButton();
        b.setFont(b.getFont().deriveFont(10.0f));
        Insets insets = gc.insets;
        gc.insets = new Insets(2, 0, 2, 0);
        gc.gridx = 1;
        gb.setConstraints(b, gc);
        toolpanel.add(b);
        gc.insets = insets;
        Component filler = Box.createHorizontalGlue();
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 2;
        gb.setConstraints(filler, gc);
        toolpanel.add(filler);
        this.add((Component)toolpanel, "North");
        this.splitPane = new JSplitPane(1);
        this.splitPane.setDividerSize(5);
        this.splitPane.setResizeWeight(0.0);
        this.add("Center", this.splitPane);
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "ClearSelection");
        actionMap.put("ClearSelection", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("chrono clear");
                ChronoPanel.this.leftPanel.clearSelection();
            }
        });
    }

    private void resplit() {
        int p;
        this.leftPanel = new LeftPanel(this);
        this.leftScroll = new JScrollPane(this.leftPanel, 22, 32);
        int n = p = this.rightScroll == null ? 0 : this.rightScroll.getHorizontalScrollBar().getValue();
        if (this.rightPanel == null) {
            this.rightPanel = new RightPanel(this, this.leftPanel.getSelectionModel());
        }
        this.rightScroll = new JScrollPane(this.rightPanel, 22, 32);
        this.leftScroll.getVerticalScrollBar().setUI(null);
        this.leftScroll.getVerticalScrollBar().setModel(this.rightScroll.getVerticalScrollBar().getModel());
        MouseAdapter zoomer = new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    e.consume();
                    ChronoPanel.this.rightPanel.zoom(e.getWheelRotation() > 0 ? -1 : 1, e.getPoint().x);
                } else {
                    e.getComponent().getParent().dispatchEvent(e);
                }
            }
        };
        this.leftPanel.addMouseWheelListener(zoomer);
        this.rightPanel.addMouseWheelListener(zoomer);
        this.leftPanel.getTableHeader().addMouseWheelListener(zoomer);
        this.rightPanel.getTimelineHeader().addMouseWheelListener(zoomer);
        this.splitPane.setLeftComponent(this.leftScroll);
        this.splitPane.setRightComponent(this.rightScroll);
        this.leftScroll.setWheelScrollingEnabled(true);
        this.rightScroll.setWheelScrollingEnabled(true);
        this.setSignalCursorX(Integer.MAX_VALUE);
        this.rightScroll.getHorizontalScrollBar().setValue(p);
        this.leftPanel.getSelectionModel().addListSelectionListener(e -> this.editHandler.computeEnabled());
    }

    public LeftPanel getLeftPanel() {
        return this.leftPanel;
    }

    public RightPanel getRightPanel() {
        return this.rightPanel;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.rightScroll == null ? null : this.rightScroll.getVerticalScrollBar();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.rightScroll == null ? null : this.rightScroll.getHorizontalScrollBar();
    }

    public JViewport getRightViewport() {
        return this.rightScroll == null ? null : this.rightScroll.getViewport();
    }

    public int getVisibleSignalsWidth() {
        return this.splitPane.getRightComponent().getWidth();
    }

    @Override
    public String getTitle() {
        return Strings.S.get("ChronoTitle");
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("ChronoTitle");
    }

    @Override
    public void modelChanged(Model oldModel, Model newModel) {
        this.setModel(newModel);
        this.rightPanel.setModel(newModel);
        this.leftPanel.setModel(newModel);
        this.editHandler.computeEnabled();
    }

    public void changeSpotlight(Signal s) {
        Signal old = this.model.setSpotlight(s);
        if (old == s) {
            return;
        }
        this.rightPanel.changeSpotlight(old, s);
        this.leftPanel.changeSpotlight(old, s);
    }

    public void setSignalCursorX(int posX) {
        this.rightPanel.setSignalCursorX(posX);
        this.leftPanel.updateSignalValues();
    }

    @Override
    public void signalsExtended(Model.Event event) {
        this.leftPanel.updateSignalValues();
        this.rightPanel.updateWaveforms(true);
    }

    @Override
    public void signalsReset(Model.Event event) {
        this.setSignalCursorX(Integer.MAX_VALUE);
        this.rightPanel.updateWaveforms(true);
    }

    @Override
    public void historyLimitChanged(Model.Event event) {
        this.setSignalCursorX(Integer.MAX_VALUE);
        this.rightPanel.updateWaveforms(false);
    }

    @Override
    public void selectionChanged(Model.Event event) {
        this.leftPanel.updateSignals();
        this.rightPanel.updateSignals();
        this.editHandler.computeEnabled();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public void setModel(Model newModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = newModel;
        if (this.model == null) {
            return;
        }
        this.model.addModelListener(this);
    }

    public Color[] rowColors(SignalInfo item, boolean isSelected) {
        if (isSelected) {
            return this.selectColors;
        }
        Signal spotlight = this.model.getSpotlight();
        return spotlight != null && spotlight.info == item ? SPOT : PLAIN;
    }

    private static Color darker(Color c) {
        if (c == null) {
            return null;
        }
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float s = 0.8f;
        return (double)hsb[1] == 0.0 ? Color.getHSBColor(hsb[0], hsb[1] + hsb[1], hsb[2] * 0.8f) : Color.getHSBColor(hsb[0], 1.0f - (1.0f - hsb[1]) * 0.8f, hsb[2]);
    }

    @Override
    public EditHandler getEditHandler() {
        return this.editHandler;
    }

    @Override
    public PrintHandler getPrintHandler() {
        return this.printHandler;
    }
}

