/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.chrono;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.chrono.ChronoPanel;
import com.cburch.logisim.gui.chrono.PopupMenu;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.gui.log.Signal;
import com.cburch.logisim.gui.log.SignalInfo;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LeftPanel
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final Border rowInsets = BorderFactory.createMatteBorder(2, 0, 2, 0, Color.WHITE);
    private final ChronoPanel chronoPanel;
    private Model model;
    private final SignalTableModel tableModel;

    public LeftPanel(final ChronoPanel chronoPanel) {
        this.chronoPanel = chronoPanel;
        this.model = chronoPanel.getModel();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.tableModel = new SignalTableModel();
        this.setModel(this.tableModel);
        this.setShowGrid(false);
        this.setDefaultRenderer(SignalInfo.class, new SignalRenderer());
        this.setDefaultRenderer(Signal.class, new ValueRenderer());
        this.setSelectionMode(2);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = LeftPanel.this.rowAtPoint(e.getPoint());
                if (row >= 0 && e.getComponent() instanceof JTable) {
                    chronoPanel.changeSpotlight(LeftPanel.this.model.getSignal(row));
                } else {
                    chronoPanel.changeSpotlight(null);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                if (!(e.getComponent() instanceof JTable)) {
                    return;
                }
                Signal.List signals = LeftPanel.this.getSelectedValuesList();
                if (signals.size() == 0 && (row = LeftPanel.this.rowAtPoint(e.getPoint())) >= 0 && row < LeftPanel.this.model.getSignalCount()) {
                    signals.add(LeftPanel.this.model.getSignal(row));
                }
                PopupMenu m = new PopupMenu(chronoPanel, signals);
                m.doPop(e);
            }
        });
        this.getSelectionModel().addListSelectionListener(e -> {
            int a = e.getFirstIndex();
            int b = e.getLastIndex();
            chronoPanel.getRightPanel().updateSelected(a, b);
        });
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setTransferHandler(new SignalTransferHandler());
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("ClearSelection", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.clearSelection();
            }
        });
        actionMap.put(LogisimMenuBar.DELETE, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.removeSelected();
            }
        });
        actionMap.put(LogisimMenuBar.SELECT_ALL, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.selectAll();
            }
        });
        actionMap.put(LogisimMenuBar.CUT, TransferHandler.getCutAction());
        actionMap.put(LogisimMenuBar.COPY, TransferHandler.getCopyAction());
        actionMap.put(LogisimMenuBar.PASTE, TransferHandler.getPasteAction());
        actionMap.put(LogisimMenuBar.RAISE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.raiseOrLower(-1);
            }
        });
        actionMap.put(LogisimMenuBar.LOWER, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.raiseOrLower(1);
            }
        });
        actionMap.put(LogisimMenuBar.RAISE_TOP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.raiseOrLower(-2);
            }
        });
        actionMap.put(LogisimMenuBar.LOWER_BOTTOM, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.raiseOrLower(2);
            }
        });
        int nameWidth = 0;
        int valueWidth = 0;
        TableCellRenderer render = this.getDefaultRenderer(String.class);
        int n = this.model.getSignalCount();
        for (int i = -1; i < n; ++i) {
            String val;
            String name;
            if (i < 0) {
                name = this.tableModel.getColumnName(0);
                val = this.tableModel.getColumnName(1);
            } else {
                Signal s = this.model.getSignal(i);
                name = s.getName();
                val = s.getFormattedMaxValue();
            }
            Component c = render.getTableCellRendererComponent(this, name, false, false, i, 0);
            nameWidth = Math.max(nameWidth, c.getPreferredSize().width);
            c = render.getTableCellRendererComponent(this, val, false, false, i, 1);
            valueWidth = Math.max(valueWidth, c.getPreferredSize().width);
        }
        this.setRowHeight(30);
        TableColumn col = this.getColumnModel().getColumn(0);
        col.setMinWidth(20);
        col.setPreferredWidth(nameWidth + 10);
        col = this.getColumnModel().getColumn(1);
        col.setMinWidth(20);
        col.setPreferredWidth(valueWidth + 10);
        this.setFillsViewportHeight(true);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        JTableHeader header = this.getTableHeader();
        Dimension d = header.getPreferredSize();
        d.height = 20;
        header.setPreferredSize(d);
        this.requestFocusInWindow();
    }

    public void setModel(Model m) {
        this.model = m;
        this.updateSignals();
    }

    public void changeSpotlight(Signal oldSignal, Signal newSignal) {
        if (oldSignal != null) {
            this.tableModel.fireTableRowsUpdated(oldSignal.idx, oldSignal.idx);
        }
        if (newSignal != null) {
            this.tableModel.fireTableRowsUpdated(newSignal.idx, newSignal.idx);
        }
    }

    public void updateSignals() {
        this.tableModel.fireTableDataChanged();
    }

    public void updateSignalValues() {
        for (int row = 0; row < this.model.getSignalCount(); ++row) {
            this.tableModel.fireTableCellUpdated(row, 1);
        }
    }

    Signal.List getSelectedValuesList() {
        int[] sel;
        Signal.List signals = new Signal.List();
        for (int i : sel = this.getSelectedRows()) {
            signals.add(this.model.getSignal(i));
        }
        return signals;
    }

    void setSelectedRows(Signal.List signals) {
        this.clearSelection();
        for (Signal s : signals) {
            int i = this.model.indexOf(s.info);
            if (i < 0) continue;
            this.addRowSelectionInterval(i, i);
        }
    }

    void raiseOrLower(int d) {
        Signal.List sel = this.getSelectedValuesList();
        int first = Integer.MAX_VALUE;
        int last = -1;
        for (Signal s : sel) {
            first = Math.min(first, s.idx);
            last = Math.max(last, s.idx);
        }
        if (last == -1) {
            return;
        }
        switch (d) {
            case -2: {
                this.model.addOrMoveSignals(sel, 0);
                break;
            }
            case -1: {
                this.model.addOrMoveSignals(sel, Math.max(0, first - 1));
                break;
            }
            case 1: {
                this.model.addOrMoveSignals(sel, Math.min(this.model.getSignalCount(), last + 2));
                break;
            }
            default: {
                this.model.addOrMoveSignals(sel, this.model.getSignalCount());
            }
        }
        this.setSelectedRows(sel);
    }

    void removeSelected() {
        int idx = 0;
        Signal.List signals = this.getSelectedValuesList();
        SignalInfo.List items = new SignalInfo.List();
        for (Signal s : signals) {
            items.add(s.info);
            idx = Math.max(idx, s.idx);
        }
        int count = this.model.remove(items);
        if (count > 0 && this.model.getSignalCount() > 0) {
            idx = Math.min(idx + 1 - count, this.model.getSignalCount() - 1);
            this.setRowSelectionInterval(idx, idx);
        }
        this.repaint();
    }

    private class SignalTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private SignalTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? Strings.S.get("SignalName") : Strings.S.get("SignalValue");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int col) {
            return col == 0 ? SignalInfo.class : Signal.class;
        }

        @Override
        public int getRowCount() {
            return LeftPanel.this.model.getSignalCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return col == 0 ? LeftPanel.this.model.getSignal((int)row).info : LeftPanel.this.model.getSignal(row);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class SignalRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private SignalRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (!(value instanceof SignalInfo)) {
                return null;
            }
            Component ret = super.getTableCellRendererComponent(table, value, false, false, row, col);
            if (ret instanceof JLabel) {
                JLabel label = (JLabel)ret;
                if (value instanceof SignalInfo) {
                    SignalInfo item = (SignalInfo)value;
                    label.setBorder(rowInsets);
                    label.setBackground(LeftPanel.this.chronoPanel.rowColors(item, isSelected)[0]);
                    label.setIcon(item.icon);
                }
            }
            return ret;
        }
    }

    private class ValueRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (!(value instanceof Signal)) {
                return null;
            }
            Signal s = (Signal)value;
            String txt = s.getFormattedValue(LeftPanel.this.chronoPanel.getRightPanel().getCurrentTime());
            Component ret = super.getTableCellRendererComponent(table, txt, false, false, row, col);
            if (ret instanceof JLabel) {
                JLabel label = (JLabel)ret;
                label.setBorder(rowInsets);
                label.setIcon(null);
                label.setBackground(LeftPanel.this.chronoPanel.rowColors(s.info, isSelected)[0]);
                label.setHorizontalAlignment(0);
            }
            return ret;
        }
    }

    private class SignalTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        Signal.List removing = null;

        private SignalTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent comp) {
            return 2;
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            this.removing = LeftPanel.this.getSelectedValuesList();
            if (this.removing.size() == 0) {
                this.removing = null;
            }
            return this.removing;
        }

        @Override
        public void exportDone(JComponent comp, Transferable trans, int action) {
            if (this.removing == null) {
                return;
            }
            ArrayList<SignalInfo> items = new ArrayList<SignalInfo>();
            for (Signal s : this.removing) {
                items.add(s.info);
            }
            this.removing = null;
            LeftPanel.this.model.remove(items);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(Signal.List.dataFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            this.removing = null;
            try {
                boolean change;
                Signal.List incoming = (Signal.List)support.getTransferable().getTransferData(Signal.List.dataFlavor);
                int newIdx = LeftPanel.this.model.getSignalCount();
                if (support.isDrop()) {
                    try {
                        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
                        newIdx = Math.min(newIdx, dl.getRow());
                    }
                    catch (ClassCastException dl) {}
                } else {
                    int[] sel = LeftPanel.this.getSelectedRows();
                    if (sel != null && sel.length > 0) {
                        newIdx = 0;
                        for (int i : sel) {
                            newIdx = Math.max(newIdx, i + 1);
                        }
                    }
                }
                if (change = LeftPanel.this.model.addOrMoveSignals(incoming, newIdx)) {
                    LeftPanel.this.setSelectedRows(incoming);
                }
                return change;
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

