/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.fpga.gui.HdlColorRenderer;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.AttrTableModel;
import com.cburch.logisim.gui.generic.AttrTableModelEvent;
import com.cburch.logisim.gui.generic.AttrTableModelListener;
import com.cburch.logisim.gui.generic.AttrTableModelRow;
import com.cburch.logisim.gui.generic.AttrTableSetException;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.JDialogOk;
import com.cburch.logisim.util.JInputComponent;
import com.cburch.logisim.util.JInputDialog;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class AttrTable
extends JPanel
implements LocaleListener {
    private static final AttrTableModel NULL_ATTR_MODEL = new NullAttrModel();
    private final Window parent;
    private final JLabel title;
    private final JTable table;
    private final TableModelAdapter tableModel;
    private final CellEditor editor = new CellEditor();
    private boolean titleEnabled;

    public AttrTable(Window parent) {
        super(new BorderLayout());
        this.parent = parent;
        this.titleEnabled = true;
        this.title = new TitleLabel();
        this.title.setHorizontalAlignment(0);
        this.title.setVerticalAlignment(0);
        this.tableModel = new TableModelAdapter(parent, NULL_ATTR_MODEL);
        this.table = new JTable(this.tableModel);
        this.table.setDefaultEditor(Object.class, this.editor);
        this.table.setTableHeader(null);
        this.table.setRowHeight(AppPreferences.getScaled(20));
        Font baseFont = this.title.getFont();
        int titleSize = Math.round((float)baseFont.getSize() * 1.2f);
        Font titleFont = baseFont.deriveFont(AppPreferences.getScaled((float)titleSize)).deriveFont(1);
        this.title.setFont(titleFont);
        Color bgColor = new Color(240, 240, 240);
        this.setBackground(bgColor);
        this.table.setBackground(bgColor);
        this.table.setDefaultRenderer(String.class, new HdlColorRenderer());
        JPanel propPanel = new JPanel(new BorderLayout(0, 0));
        JScrollPane tableScroll = new JScrollPane(this.table);
        propPanel.add((Component)this.title, "First");
        propPanel.add((Component)tableScroll, "Center");
        this.add((Component)propPanel, "Center");
        LocaleManager.addLocaleListener(this);
        this.localeChanged();
    }

    public AttrTableModel getAttrTableModel() {
        return this.tableModel.attrModel;
    }

    public void setAttrTableModel(AttrTableModel value) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.tableModel.setAttrTableModel(value == null ? NULL_ATTR_MODEL : value);
        this.updateTitle();
    }

    public boolean getTitleEnabled() {
        return this.titleEnabled;
    }

    public void setTitleEnabled(boolean value) {
        this.titleEnabled = value;
        this.updateTitle();
    }

    @Override
    public void localeChanged() {
        this.updateTitle();
        this.tableModel.fireTableChanged();
    }

    private void updateTitle() {
        if (this.titleEnabled) {
            String text = this.tableModel.attrModel.getTitle();
            if (text == null) {
                this.title.setVisible(false);
            } else {
                this.title.setText(text);
                this.title.setVisible(true);
            }
        } else {
            this.title.setVisible(false);
        }
    }

    private class CellEditor
    implements TableCellEditor,
    FocusListener,
    ActionListener {
        final LinkedList<CellEditorListener> listeners = new LinkedList();
        AttrTableModelRow currentRow;
        AttrTableModelRow[] currentRows;
        int[] currentRowIndexes;
        Component currentEditor;
        boolean multiEditActive = false;

        private CellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listeners.add(l);
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void fireEditingCanceled() {
            int col = AttrTable.this.table.getEditingColumn();
            ChangeEvent e = new ChangeEvent(AttrTable.this);
            for (CellEditorListener l : new ArrayList<CellEditorListener>(this.listeners)) {
                l.editingCanceled(e);
            }
            if (this.multiEditActive) {
                Object value = this.getCellEditorValue();
                for (int r : this.currentRowIndexes) {
                    if (r == AttrTable.this.table.getEditingRow()) continue;
                    AttrTable.this.table.setValueAt(value, r, col);
                }
            }
        }

        public void fireEditingStopped() {
            ChangeEvent e = new ChangeEvent(AttrTable.this);
            for (CellEditorListener l : new ArrayList<CellEditorListener>(this.listeners)) {
                l.editingStopped(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component dst = e.getOppositeComponent();
            if (dst != null) {
                for (Component p = dst; p != null && !(p instanceof Window); p = p.getParent()) {
                    if (p != AttrTable.this) continue;
                    return;
                }
                AttrTable.this.editor.stopCellEditing();
            }
        }

        @Override
        public Object getCellEditorValue() {
            Component comp = this.currentEditor;
            if (comp instanceof JTextField) {
                JTextField field = (JTextField)comp;
                return field.getText();
            }
            if (comp instanceof JComboBox) {
                JComboBox box = (JComboBox)comp;
                return box.getSelectedItem();
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int columnIndex) {
            Component editor;
            AttrTableModel attrModel = AttrTable.this.tableModel.attrModel;
            AttrTableModelRow row = attrModel.getRow(rowIndex);
            AttrTableModelRow[] rows = null;
            int[] rowIndexes = null;
            this.multiEditActive = false;
            if (columnIndex == 0 || rowIndex == 0) {
                return new JLabel(row.getLabel());
            }
            if (this.currentEditor != null) {
                this.currentEditor.transferFocus();
            }
            if ((editor = row.getEditor(AttrTable.this.parent)) instanceof JComboBox) {
                JComboBox box = (JComboBox)editor;
                box.addActionListener(this);
                editor.addFocusListener(this);
                rowIndexes = table.getSelectedRows();
                if (isSelected && rowIndexes.length > 1) {
                    this.multiEditActive = true;
                    rows = new AttrTableModelRow[rowIndexes.length];
                    for (int i = 0; i < rowIndexes.length; ++i) {
                        rows[i] = attrModel.getRow(rowIndexes[i]);
                        if (row.multiEditCompatible(rows[i])) continue;
                        this.multiEditActive = false;
                        rowIndexes = null;
                        rows = null;
                        break;
                    }
                } else {
                    rowIndexes = null;
                }
            } else if (editor instanceof JInputDialog) {
                JInputDialog dlog = (JInputDialog)((Object)editor);
                dlog.setVisible(true);
                Object retVal = dlog.getValue();
                try {
                    row.setValue(AttrTable.this.parent, retVal);
                }
                catch (AttrTableSetException e) {
                    OptionPane.showMessageDialog(AttrTable.this.parent, e.getMessage(), Strings.S.get("attributeChangeInvalidTitle"), 2);
                }
                editor = null;
            } else if (editor instanceof JInputComponent) {
                JInputComponent input = (JInputComponent)((Object)editor);
                MyDialog dialog = new MyDialog(input);
                dialog.setVisible(true);
                Object retVal = dialog.getValue();
                try {
                    row.setValue(AttrTable.this.parent, retVal);
                }
                catch (AttrTableSetException e) {
                    OptionPane.showMessageDialog(AttrTable.this.parent, e.getMessage(), Strings.S.get("attributeChangeInvalidTitle"), 2);
                }
                editor = null;
            } else {
                editor.addFocusListener(this);
            }
            this.currentRow = row;
            this.currentRows = rows;
            this.currentRowIndexes = rowIndexes;
            this.currentEditor = editor;
            return editor;
        }

        public boolean isEditing(AttrTableModelRow row) {
            if (this.currentRow == row) {
                return true;
            }
            if (this.currentRows == null) {
                return false;
            }
            for (AttrTableModelRow r : this.currentRows) {
                if (r != row) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.remove(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return !this.multiEditActive;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }
    }

    private static class TitleLabel
    extends JLabel {
        private TitleLabel() {
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension ret = super.getMinimumSize();
            return new Dimension(1, ret.height);
        }
    }

    private class TableModelAdapter
    implements TableModel,
    AttrTableModelListener {
        final Window parent;
        final LinkedList<TableModelListener> listeners;
        AttrTableModel attrModel;

        TableModelAdapter(Window parent, AttrTableModel attrModel) {
            this.parent = parent;
            this.listeners = new LinkedList();
            this.attrModel = attrModel;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void attrStructureChanged(AttrTableModelEvent e) {
            if (e.getSource() != this.attrModel) {
                this.attrModel.removeAttrTableModelListener(this);
                return;
            }
            TableCellEditor ed = AttrTable.this.table.getCellEditor();
            if (ed != null) {
                ed.cancelCellEditing();
            }
            this.fireTableChanged();
        }

        @Override
        public void attrTitleChanged(AttrTableModelEvent e) {
            if (e.getSource() != this.attrModel) {
                this.attrModel.removeAttrTableModelListener(this);
                return;
            }
            AttrTable.this.updateTitle();
        }

        @Override
        public void attrValueChanged(AttrTableModelEvent e) {
            CellEditor cellEd;
            if (e.getSource() != this.attrModel) {
                this.attrModel.removeAttrTableModelListener(this);
                return;
            }
            int row = e.getRowIndex();
            TableCellEditor ed = AttrTable.this.table.getCellEditor();
            if (row >= 0 && ed instanceof CellEditor && (cellEd = (CellEditor)ed).isEditing(this.attrModel.getRow(row))) {
                ed.cancelCellEditing();
            }
            this.fireTableChanged();
        }

        void fireTableChanged() {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener l : new ArrayList<TableModelListener>(this.listeners)) {
                l.tableChanged(e);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Attribute";
            }
            return "Value";
        }

        @Override
        public int getRowCount() {
            return this.attrModel.getRowCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? this.attrModel.getRow(rowIndex).getLabel() : this.attrModel.getRow(rowIndex).getValue();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0 && this.attrModel.getRow(rowIndex).isValueEditable() && rowIndex > 0;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        void setAttrTableModel(AttrTableModel value) {
            if (this.attrModel != value) {
                this.attrModel.removeAttrTableModelListener(this);
                this.attrModel = value;
                this.attrModel.addAttrTableModelListener(this);
                this.fireTableChanged();
            }
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex > 0) {
                try {
                    this.attrModel.getRow(rowIndex).setValue(this.parent, value);
                }
                catch (AttrTableSetException e) {
                    OptionPane.showMessageDialog(this.parent, e.getMessage(), Strings.S.get("attributeChangeInvalidTitle"), 2);
                }
            }
        }
    }

    private static class NullAttrModel
    implements AttrTableModel {
        private NullAttrModel() {
        }

        @Override
        public void addAttrTableModelListener(AttrTableModelListener listener) {
        }

        @Override
        public AttrTableModelRow getRow(int rowIndex) {
            return null;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public void removeAttrTableModelListener(AttrTableModelListener listener) {
        }
    }

    private static class MyDialog
    extends JDialogOk {
        JInputComponent input;
        Object value;

        public MyDialog(JInputComponent input) {
            super(Strings.S.get("attributeDialogTitle"));
            this.configure(input);
        }

        private void configure(JInputComponent input) {
            this.input = input;
            this.value = input.getValue();
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            if (input instanceof JFileChooser) {
                JFileChooser chooser = (JFileChooser)((Object)input);
                chooser.setControlButtonsAreShown(false);
            }
            p.add((Component)((JComponent)((Object)input)), "Center");
            this.getContentPane().add((Component)p, "Center");
            this.pack();
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public void okClicked() {
            this.value = this.input.getValue();
        }
    }
}

