/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.contracts.BaseComponentListenerContract;
import com.cburch.logisim.gui.generic.CanvasPaneContents;
import com.cburch.logisim.gui.generic.ZoomModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class CanvasPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private final CanvasPaneContents contents;
    private final Listener listener;
    private final ZoomListener zoomListener;
    private ZoomModel zoomModel;

    public CanvasPane(CanvasPaneContents contents) {
        super((Component)((Object)contents));
        this.contents = contents;
        this.listener = new Listener();
        this.zoomListener = new ZoomListener();
        this.zoomModel = null;
        this.addComponentListener(this.listener);
        this.setWheelScrollingEnabled(false);
        this.addMouseWheelListener(this.zoomListener);
        contents.setCanvasPane(this);
    }

    public Dimension getViewportSize() {
        Dimension size = new Dimension();
        this.getViewport().getSize(size);
        return size;
    }

    public double getZoomFactor() {
        ZoomModel model = this.zoomModel;
        return model == null ? 1.0 : model.getZoomFactor();
    }

    public void setZoomModel(ZoomModel model) {
        ZoomModel oldModel = this.zoomModel;
        if (oldModel != null) {
            oldModel.removePropertyChangeListener("zoom", this.listener);
            oldModel.removePropertyChangeListener("center", this.listener);
        }
        this.zoomModel = model;
        if (model != null) {
            model.addPropertyChangeListener("zoom", this.listener);
            model.addPropertyChangeListener("center", this.listener);
        }
    }

    public Dimension supportPreferredSize(int width, int height) {
        double zoom = this.getZoomFactor();
        if (zoom != 1.0) {
            width = (int)Math.ceil((double)width * zoom);
            height = (int)Math.ceil((double)height * zoom);
        }
        Dimension minSize = this.getViewportSize();
        if (minSize.width > width) {
            width = minSize.width;
        }
        if (minSize.height > height) {
            height = minSize.height;
        }
        return new Dimension(width, height);
    }

    public int supportScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unit = this.supportScrollableUnitIncrement(visibleRect, orientation, direction);
        return direction == 1 ? visibleRect.height / unit * unit : visibleRect.width / unit * unit;
    }

    public int supportScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)Math.round(10.0 * this.getZoomFactor());
    }

    private class Listener
    implements BaseComponentListenerContract,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            CanvasPane.this.contents.recomputeSize();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("zoom")) {
                Double oldZoom = (Double)e.getOldValue();
                Rectangle r = CanvasPane.this.getViewport().getViewRect();
                double cx = (double)(r.x + r.width / 2) / oldZoom;
                double cy = (double)(r.y + r.height / 2) / oldZoom;
                Double newZoom = (Double)e.getNewValue();
                r = CanvasPane.this.getViewport().getViewRect();
                int hv = (int)(cx * newZoom) - r.width / 2;
                int vv = (int)(cy * newZoom) - r.height / 2;
                CanvasPane.this.getHorizontalScrollBar().setValue(hv);
                CanvasPane.this.getVerticalScrollBar().setValue(vv);
                CanvasPane.this.contents.recomputeSize();
            } else if (prop.equals("center")) {
                CanvasPane.this.contents.center();
            }
        }
    }

    private class ZoomListener
    implements MouseWheelListener {
        private ZoomListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            if (mwe.isControlDown()) {
                double zoom = CanvasPane.this.zoomModel.getZoomFactor();
                List<Double> opts = CanvasPane.this.zoomModel.getZoomOptions();
                if (mwe.getWheelRotation() < 0) {
                    double max = opts.get(opts.size() - 1) / 100.0;
                    CanvasPane.this.zoomModel.setZoomFactor(Math.min(zoom += 0.1, max), mwe);
                } else {
                    double min = opts.get(0) / 100.0;
                    CanvasPane.this.zoomModel.setZoomFactor(Math.max(zoom -= 0.1, min), mwe);
                }
            } else if (mwe.isShiftDown()) {
                CanvasPane.this.getHorizontalScrollBar().setValue(this.scrollValue(CanvasPane.this.getHorizontalScrollBar(), mwe.getWheelRotation()));
            } else {
                CanvasPane.this.getVerticalScrollBar().setValue(this.scrollValue(CanvasPane.this.getVerticalScrollBar(), mwe.getWheelRotation()));
            }
        }

        private int scrollValue(JScrollBar bar, int val) {
            if (val > 0 ? bar.getValue() < bar.getMaximum() + val * 2 * bar.getBlockIncrement() : bar.getValue() > bar.getMinimum() + val * 2 * bar.getBlockIncrement()) {
                return bar.getValue() + val * 2 * bar.getBlockIncrement();
            }
            return 0;
        }
    }
}

