/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.JInputComponent;
import com.cburch.logisim.util.LocaleListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSelector
extends JPanel
implements JInputComponent,
ActionListener,
ListSelectionListener,
LocaleListener {
    private final Set<String> fontNames;
    private Font currentFont = StdAttr.DEFAULT_LABEL_FONT;
    private final JTextArea preview = new JTextArea(3, 20);
    private final JList<String> selectableFontFamilies;
    private final JList<Integer> selectableFontSize;
    private JCheckBox boldAttribute;
    private JCheckBox italicAttribute;
    private int fontSize;
    private int fontStyle;
    public static final FontSelector FONT_SELECTOR = new FontSelector();

    public FontSelector() {
        this.fontNames = new TreeSet<String>();
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            this.fontNames.add(font.getFamily());
        }
        this.setLayout(new BorderLayout());
        this.preview.setEditable(false);
        this.add((Component)new JScrollPane(this.preview), "South");
        this.selectableFontFamilies = new JList<Object>(this.fontNames.toArray());
        this.selectableFontFamilies.addListSelectionListener(this);
        TreeSet<Integer> selections = new TreeSet<Integer>();
        for (int size = 2; size < 65; ++size) {
            selections.add(size);
        }
        this.selectableFontSize = new JList<Object>(selections.toArray());
        ((DefaultListCellRenderer)this.selectableFontSize.getCellRenderer()).setHorizontalAlignment(4);
        this.selectableFontSize.addListSelectionListener(this);
        this.add((Component)new JScrollPane(this.selectableFontFamilies), "West");
        this.add((Component)new JScrollPane(this.selectableFontSize), "Center");
        this.add((Component)new JScrollPane(this.getStyle()), "East");
        this.localeChanged();
    }

    @Override
    public Object getValue() {
        return this.currentFont;
    }

    private JPanel getStyle() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        this.boldAttribute = new JCheckBox();
        this.boldAttribute.addActionListener(this);
        panel.add(this.boldAttribute);
        this.italicAttribute = new JCheckBox();
        this.italicAttribute.addActionListener(this);
        panel.add(this.italicAttribute);
        return panel;
    }

    private void fontChanged() {
        this.preview.setCaretPosition(0);
        this.preview.setFont(new Font(this.currentFont.getFamily(), this.fontStyle, AppPreferences.getScaled(this.fontSize)));
        this.preview.repaint(this.preview.getVisibleRect());
        this.selectableFontFamilies.setSelectedValue(this.currentFont.getFamily(), true);
        this.selectableFontSize.setSelectedValue(this.fontSize, true);
    }

    @Override
    public void setValue(Object value) {
        Font font;
        if (value instanceof Font && this.fontNames.contains((font = (Font)value).getFamily())) {
            this.currentFont = font;
            this.fontSize = font.getSize();
            this.fontStyle = font.getStyle();
            this.boldAttribute.setSelected((this.fontStyle & 1) != 0);
            this.italicAttribute.setSelected((this.fontStyle & 2) != 0);
            this.fontChanged();
            return;
        }
        throw new IllegalArgumentException("Object is neither a font nor a supported font type!");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.boldAttribute.equals(e.getSource())) {
            int newStyle;
            boolean isChecked = this.boldAttribute.isSelected();
            int n = newStyle = isChecked ? this.fontStyle | 1 : this.fontStyle & 0xFFFFFFFE;
            if (newStyle != this.fontStyle) {
                this.fontStyle = newStyle;
                this.currentFont = new Font(this.currentFont.getFamily(), this.fontStyle, this.fontSize);
                this.fontChanged();
            }
        } else if (this.italicAttribute.equals(e.getSource())) {
            int newStyle;
            boolean isChecked = this.italicAttribute.isSelected();
            int n = newStyle = isChecked ? this.fontStyle | 2 : this.fontStyle & 0xFFFFFFFD;
            if (newStyle != this.fontStyle) {
                this.fontStyle = newStyle;
                this.currentFont = new Font(this.currentFont.getFamily(), this.fontStyle, this.fontSize);
                this.fontChanged();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean change;
        String selectedFont = this.selectableFontFamilies.getSelectedValue();
        Integer selectedFontSize = this.selectableFontSize.getSelectedValue();
        boolean bl = change = selectedFontSize != null && selectedFontSize != this.fontSize;
        if (selectedFont != null && this.fontNames.contains(selectedFont)) {
            change |= !selectedFont.equals(this.currentFont.getFamily());
        }
        if (change) {
            if (selectedFontSize != null) {
                this.fontSize = selectedFontSize;
            }
            this.currentFont = new Font(selectedFont, this.fontStyle, this.fontSize);
            this.fontChanged();
        }
    }

    @Override
    public void localeChanged() {
        this.boldAttribute.setText(Strings.S.get("fontBoldFont"));
        this.italicAttribute.setText(Strings.S.get("fontItalicFont"));
        this.preview.setText(Strings.S.get("fontExampleLineText"));
        this.repaint();
    }
}

