/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.MacCompatibility;
import com.cburch.logisim.util.WindowClosable;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class LFrame
extends JFrame
implements WindowClosable {
    private static final long serialVersionUID = 1L;
    private static final String pathBasePart = "resources/logisim/img/logisim-icon-";
    private static final int[] sizes = new int[]{16, 32, 48, 64, 128};
    private static final int defaultSize = 48;
    private static List<Image> allIcons = null;
    private static Image defaultIcon = null;
    public static final int TYPE_MAIN_WINDOW = 1;
    public static final int TYPE_SUB_WINDOW = 2;
    public static final int TYPE_DIALOG = 3;
    protected final LogisimMenuBar menubar;
    protected final Project project;
    protected final int type;

    private LFrame(int t, Project p, boolean enableSim) {
        this.project = p;
        this.type = t;
        LFrame.attachIcon(this);
        if (this.type == 1) {
            this.menubar = new LogisimMenuBar(this, p, p, p);
            this.setJMenuBar(this.menubar);
        } else if (this.type == 2 || MacCompatibility.isRunningOnMac()) {
            this.menubar = new LogisimMenuBar(this, null, p, enableSim ? p : null);
            this.setJMenuBar(this.menubar);
        } else {
            this.menubar = null;
        }
        if (this.type != 1 && this.project != null) {
            this.project.getFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    LFrame.this.dispose();
                }
            });
        }
    }

    public static void attachIcon(Window frame) {
        if (allIcons == null) {
            ArrayList<Image> loadedIcons = new ArrayList<Image>();
            ClassLoader loader = LFrame.class.getClassLoader();
            for (int size : sizes) {
                URL url = loader.getResource(pathBasePart + size + ".png");
                if (url == null) continue;
                ImageIcon icon = new ImageIcon(url);
                loadedIcons.add(icon.getImage());
                if (size != 48) continue;
                defaultIcon = icon.getImage();
            }
            allIcons = loadedIcons;
        }
        boolean success = false;
        try {
            if (CollectionUtil.isNotEmpty(allIcons)) {
                Method set = frame.getClass().getMethod("setIconImages", List.class);
                set.invoke((Object)frame, allIcons);
                success = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!success && frame instanceof JFrame && defaultIcon != null) {
            frame.setIconImage(defaultIcon);
        }
    }

    @Override
    public void requestClose() {
        WindowEvent closing = new WindowEvent(this, 201);
        this.processWindowEvent(closing);
    }

    public Project getProject() {
        return this.project;
    }

    public LogisimMenuBar getLogisimMenuBar() {
        return this.menubar;
    }

    public static class Dialog
    extends LFrame {
        private static final long serialVersionUID = 1L;

        public Dialog(Project p) {
            super(3, p, false);
        }
    }

    public static class SubWindowWithSimulation
    extends LFrame {
        private static final long serialVersionUID = 1L;

        public SubWindowWithSimulation(Project p) {
            super(2, p, true);
        }
    }

    public static class SubWindow
    extends LFrame {
        private static final long serialVersionUID = 1L;

        public SubWindow(Project p) {
            super(2, p, false);
        }
    }

    public static class MainWindow
    extends LFrame {
        private static final long serialVersionUID = 1L;

        public MainWindow(Project p) {
            super(1, p, true);
            if (p == null) {
                throw new IllegalArgumentException("project is null");
            }
        }
    }
}

