/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.generic.ProjectExplorerModel;
import com.cburch.logisim.gui.generic.ProjectExplorerToolNode;
import com.cburch.logisim.std.base.BaseLibrary;
import com.cburch.logisim.tools.Library;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public class ProjectExplorerLibraryNode
extends ProjectExplorerModel.Node<Library>
implements LibraryListener {
    private static final long serialVersionUID = 1L;
    private LogisimFile file;
    private JTree guiElement = null;
    private final boolean showMouseTools;

    ProjectExplorerLibraryNode(ProjectExplorerModel model, Library lib, JTree gui, boolean showMouseTools) {
        super(model, lib);
        this.guiElement = gui;
        if (lib instanceof LogisimFile) {
            this.file = (LogisimFile)lib;
            this.file.addLibraryListener(this);
        }
        this.showMouseTools = showMouseTools;
        this.buildChildren();
    }

    private void buildChildren() {
        Library lib = (Library)this.getValue();
        if (lib != null) {
            boolean showLib;
            boolean bl = showLib = this.showMouseTools & lib instanceof BaseLibrary || !lib.isHidden();
            if (showLib) {
                this.buildChildren(new ProjectExplorerToolNode(this.getModel(), null), lib.getTools(), 0);
                this.buildChildren(new ProjectExplorerLibraryNode(this.getModel(), null, this.guiElement, this.showMouseTools), lib.getLibraries(), lib.getTools().size());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void buildChildren(ProjectExplorerModel.Node<T> factory, List<? extends T> items, int startIndex) {
        HashMap nodeMap = new HashMap();
        ArrayList<ProjectExplorerModel.Node<T>> nodeList = new ArrayList<ProjectExplorerModel.Node<T>>();
        int oldPos = startIndex;
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            TreeNode baseNode = en.nextElement();
            if (baseNode.getClass() != factory.getClass()) continue;
            ProjectExplorerModel.Node node = (ProjectExplorerModel.Node)baseNode;
            nodeMap.put(node.getValue(), node);
            nodeList.add(node);
            node.oldIndex = oldPos++;
            node.newIndex = -1;
        }
        int oldCount = oldPos;
        int actualPos = startIndex;
        int insertionCount = 0;
        oldPos = startIndex;
        for (T tool : items) {
            if (tool instanceof Library && ((Library)tool).isHidden() && (!this.showMouseTools || !(tool instanceof BaseLibrary))) continue;
            ProjectExplorerModel.Node<T> node = (ProjectExplorerModel.Node<T>)nodeMap.get(tool);
            if (node == null) {
                node = factory.create(tool);
                node.oldIndex = -1;
                node.newIndex = actualPos;
                nodeList.add(node);
                ++insertionCount;
            } else {
                node.newIndex = oldPos++;
            }
            ++actualPos;
        }
        if (oldPos != oldCount) {
            void var13_22;
            int[] delIndex = new int[oldCount - oldPos];
            ProjectExplorerModel.Node[] delNodes = new ProjectExplorerModel.Node[delIndex.length];
            int delPos = 0;
            int n = nodeList.size() - 1;
            while (var13_22 >= 0) {
                ProjectExplorerModel.Node node = (ProjectExplorerModel.Node)nodeList.get((int)var13_22);
                if (node.newIndex < 0) {
                    node.decommission();
                    this.remove(node.oldIndex);
                    nodeList.remove(node.oldIndex - startIndex);
                    for (ProjectExplorerModel.Node node2 : nodeList) {
                        if (node2.oldIndex <= node.oldIndex) continue;
                        --node2.oldIndex;
                    }
                    delIndex[delPos] = node.oldIndex;
                    delNodes[delPos] = node;
                    ++delPos;
                }
                --var13_22;
            }
            this.fireNodesRemoved(delIndex, delNodes);
        }
        int minChange = 0xFFFFFFF;
        int maxChange = -268435456;
        for (ProjectExplorerModel.Node node : nodeList) {
            if (node.newIndex == node.oldIndex || node.oldIndex < 0) continue;
            minChange = Math.min(minChange, node.oldIndex);
            maxChange = Math.max(maxChange, node.oldIndex);
        }
        if (minChange <= maxChange) {
            int i;
            int[] moveIndex = new int[maxChange - minChange + 1];
            ProjectExplorerModel.Node[] nodeArray = new ProjectExplorerModel.Node[moveIndex.length];
            for (i = maxChange; i >= minChange; --i) {
                ProjectExplorerModel.Node node = (ProjectExplorerModel.Node)nodeList.get(i);
                moveIndex[node.newIndex - minChange] = node.newIndex;
                nodeArray[node.newIndex - minChange] = node;
                this.remove(i);
            }
            for (i = 0; i < moveIndex.length; ++i) {
                this.insert(nodeArray[i], moveIndex[i]);
            }
            this.fireNodesChanged(moveIndex, nodeArray);
        }
        if (insertionCount > 0) {
            int[] insIndex = new int[insertionCount];
            ProjectExplorerModel.Node[] nodeArray = new ProjectExplorerModel.Node[insertionCount];
            int insertionsPos = 0;
            for (ProjectExplorerModel.Node node : nodeList) {
                if (node.oldIndex >= 0) continue;
                this.insert(node, node.newIndex);
                insIndex[insertionsPos] = node.newIndex;
                nodeArray[insertionsPos] = node;
                ++insertionsPos;
            }
            this.fireNodesInserted(insIndex, nodeArray);
        }
    }

    ProjectExplorerLibraryNode create(Library userObject) {
        return new ProjectExplorerLibraryNode(this.getModel(), userObject, this.guiElement, this.showMouseTools);
    }

    @Override
    void decommission() {
        if (this.file != null) {
            this.file.removeLibraryListener(this);
        }
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            TreeNode n = en.nextElement();
            if (!(n instanceof ProjectExplorerModel.Node)) continue;
            ProjectExplorerModel.Node node = (ProjectExplorerModel.Node)n;
            node.decommission();
        }
    }

    @Override
    public void libraryChanged(LibraryEvent event) {
        switch (event.getAction()) {
            case 6: 
            case 7: {
                this.fireNodeChanged();
                break;
            }
            case 5: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.buildChildren();
                break;
            }
            default: {
                this.fireStructureChanged();
            }
        }
    }
}

