/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.memory.Register;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.util.AlphanumComparator;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.LocaleListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RegTabContent
extends JScrollPane
implements LocaleListener,
Simulator.Listener {
    private static final long serialVersionUID = 1L;
    private static final HashMap<String, com.cburch.logisim.comp.Component> registers = new HashMap();
    private final JPanel panel = new JPanel(new GridBagLayout());
    private final GridBagConstraints constraints = new GridBagConstraints();
    private final Project proj;

    public RegTabContent(Frame frame) {
        this.setViewportView(this.panel);
        this.proj = frame.getProject();
        this.getVerticalScrollBar().setUnitIncrement(16);
        this.proj.getSimulator().addSimulatorListener(this);
        this.fillArray();
    }

    private void fillArray() {
        LoadedLibrary loadedLib;
        Object object;
        registers.clear();
        this.panel.removeAll();
        for (Circuit circuit : this.proj.getLogisimFile().getCircuits()) {
            this.getAllRegisters(circuit);
        }
        Library library = this.proj.getLogisimFile().getLibrary("prodis_v1.3");
        if (library instanceof LoadedLibrary && (object = (loadedLib = (LoadedLibrary)library).getBase()) instanceof LogisimFile) {
            LogisimFile logisimFile = (LogisimFile)object;
            for (Circuit circ3 : logisimFile.getCircuits()) {
                this.getAllRegisters(circ3);
            }
        }
        MyLabel col1 = new MyLabel("Circuit", 3);
        MyLabel myLabel = new MyLabel("Reg name", 1);
        MyLabel col3 = new MyLabel("Value", 1);
        col1.setColor(Color.LIGHT_GRAY);
        myLabel.setColor(Color.LIGHT_GRAY);
        col3.setColor(Color.LIGHT_GRAY);
        this.constraints.fill = 2;
        this.constraints.anchor = 23;
        this.constraints.ipady = 2;
        this.constraints.weighty = 0.0;
        int y = 0;
        this.constraints.gridy = y++;
        this.constraints.gridx = 0;
        this.constraints.weightx = 0.3;
        this.panel.add((Component)col1, this.constraints);
        ++this.constraints.gridx;
        this.constraints.weightx = 0.5;
        this.panel.add((Component)myLabel, this.constraints);
        ++this.constraints.gridx;
        this.constraints.weightx = 0.2;
        this.panel.add((Component)col3, this.constraints);
        if (!registers.isEmpty()) {
            List<String> keys = registers.keySet().stream().sorted(new AlphanumComparator()).toList();
            for (String key : keys) {
                this.constraints.gridy = y;
                this.constraints.gridx = 0;
                String circuitName = key.split("/")[0];
                this.panel.add((Component)new MyLabel(circuitName, 2, true), this.constraints);
                ++this.constraints.gridx;
                String registerName = key.split("/")[1];
                this.panel.add((Component)new MyLabel(registerName), this.constraints);
                ++this.constraints.gridx;
                com.cburch.logisim.comp.Component selReg = registers.get(key);
                CircuitState mainCircState = this.proj.getCircuitState();
                if (mainCircState == null) continue;
                while (mainCircState.getParentState() != null) {
                    mainCircState = mainCircState.getParentState();
                }
                Value val = this.findVal(mainCircState, circuitName, selReg.getEnd(0).getLocation());
                if (val != null) {
                    MyLabel hexLabel = new MyLabel(val.toHexString());
                    hexLabel.setFont(new Font("Monospaced", 0, hexLabel.getFont().getSize()));
                    this.panel.add((Component)hexLabel, this.constraints);
                } else {
                    this.panel.add((Component)new MyLabel("-"), this.constraints);
                }
                ++y;
            }
        }
        this.constraints.weighty = 1.0;
        ++this.constraints.gridy;
        this.constraints.gridx = 0;
        this.constraints.weightx = 1.0;
        this.panel.add((Component)new MyLabel(""), this.constraints);
        this.panel.validate();
    }

    private synchronized Value findVal(CircuitState cs, String cn, Location loc) {
        if (cs.containsKey(loc) && cs.getCircuit().getName().equals(cn)) {
            return cs.getValue(loc);
        }
        if (CollectionUtil.isNotEmpty(cs.getSubStates())) {
            for (CircuitState cst : cs.getSubStates()) {
                Value ret = this.findVal(cst, cn, loc);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    private synchronized void getAllRegisters(Circuit circuit) {
        for (com.cburch.logisim.comp.Component comp : circuit.getNonWires()) {
            if (!comp.getFactory().getName().equals("Register") || !comp.getAttributeSet().getValue(Register.ATTR_SHOW_IN_TAB).booleanValue() || comp.getAttributeSet().getValue(StdAttr.LABEL).equals("")) continue;
            registers.put(circuit.getName() + "/" + comp.getAttributeSet().getValue(StdAttr.LABEL), comp);
        }
    }

    @Override
    public void localeChanged() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void simulatorReset(Simulator.Event e) {
        this.fillArray();
    }

    @Override
    public void propagationCompleted(Simulator.Event e) {
        this.fillArray();
    }

    @Override
    public void simulatorStateChanged(Simulator.Event e) {
    }

    private static class MyLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        private MyLabel(String text) {
            super(text);
        }

        private MyLabel(String text, int style) {
            super(text);
            this.setFont(this.getFont().deriveFont(style));
        }

        private MyLabel(String text, int style, boolean small) {
            super(text);
            this.setFont(this.getFont().deriveFont(style));
            this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
        }

        private void setColor(Color color) {
            this.setBackground(color);
            this.setOpaque(true);
        }
    }
}

