/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.draw.shapes.DrawAttr;
import com.cburch.logisim.util.XmlUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TikZInfo
implements Cloneable {
    private static final double BASIC_STROKE_WIDTH = 1.0;
    private AffineTransform myTransformer = new AffineTransform();
    private Color drawColor;
    private Color backColor;
    private ArrayList<DrawObject> contents = new ArrayList();
    private HashMap<String, String> customColors = new HashMap();
    private ArrayList<String> usedFonts = new ArrayList();
    private int fontIndex;
    private int fontSize;
    private boolean fontBold;
    private boolean fontItalic;
    private String currentDrawColor;
    private String currentBackColor;
    private Font curFont;
    private BasicStroke curStroke = new BasicStroke(1.0f);
    private double myRotation = 0.0;
    private Rectangle clip;

    public TikZInfo() {
        this.setFont(DrawAttr.DEFAULT_FONT);
        this.setBackground(Color.WHITE);
        this.setColor(Color.BLACK);
    }

    public static double rounded(double v) {
        return (double)Math.round(v * 1000.0) / 1000.0;
    }

    public static String getPoint(Point2D p) {
        return " (" + TikZInfo.rounded(p.getX()) + "," + TikZInfo.rounded(p.getY()) + ") ";
    }

    public static String getPgfPoint(Point2D p) {
        return "\\pgfpoint{" + p.getX() + "}{" + p.getY() + "}";
    }

    public TikZInfo clone() {
        TikZInfo newInst = new TikZInfo();
        newInst.myTransformer = (AffineTransform)this.myTransformer.clone();
        newInst.drawColor = this.drawColor;
        newInst.backColor = this.backColor;
        newInst.contents = this.contents;
        newInst.customColors = this.customColors;
        newInst.currentDrawColor = this.currentDrawColor;
        newInst.currentBackColor = this.currentBackColor;
        newInst.curFont = this.curFont;
        newInst.curStroke = this.curStroke;
        newInst.myRotation = this.myRotation;
        newInst.fontIndex = this.fontIndex;
        newInst.fontSize = this.fontSize;
        newInst.usedFonts = this.usedFonts;
        newInst.fontBold = this.fontBold;
        newInst.fontItalic = this.fontItalic;
        if (this.clip != null) {
            newInst.clip = (Rectangle)this.clip.clone();
        }
        return newInst;
    }

    private String getColorName(Color c) {
        String custName = "custcol_" + Integer.toString(c.getRed(), 16) + "_" + Integer.toString(c.getGreen(), 16) + "_" + Integer.toString(c.getBlue(), 16);
        String rgbCol = c.getRed() + ", " + c.getGreen() + ", " + c.getBlue();
        this.customColors.put(custName, rgbCol);
        return custName;
    }

    public void transform(Point2D src, Point2D dest) {
        this.myTransformer.transform(src, dest);
    }

    public float getStrokeWidth() {
        return this.curStroke.getLineWidth();
    }

    public String getDrawColorString() {
        return this.currentDrawColor;
    }

    public String getBackColorString() {
        return this.currentBackColor;
    }

    public double getRotationDegrees() {
        return this.myRotation / Math.PI * 180.0;
    }

    public Color getColor() {
        return this.drawColor;
    }

    public void setColor(Color c) {
        this.currentDrawColor = this.getColorName(c);
        this.drawColor = c;
    }

    public Color getBackground() {
        return this.backColor;
    }

    public void setBackground(Color color) {
        this.backColor = color;
        this.currentBackColor = this.getColorName(color);
    }

    public Stroke getStroke() {
        return this.curStroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke s;
            this.curStroke = s = (BasicStroke)stroke;
        } else {
            System.out.println("TikZWriter: Unsupported Stroke set");
        }
    }

    public AffineTransform getAffineTransform() {
        return this.myTransformer;
    }

    public void setAffineTransform(AffineTransform tx) {
        this.myTransformer = tx;
    }

    private double toDegree(double angle) {
        return angle / Math.PI * 180.0;
    }

    public void addLine(int x1, int y1, int x2, int y2) {
        this.contents.add(new TikZLine(x1, y1, x2, y2));
    }

    public void addBezier(Shape s, boolean filled) {
        this.contents.add(new TikZBezier(s, filled));
    }

    public void addRectangle(int x, int y, int width, int height, boolean filled, boolean backcolor) {
        TikZRectangle obj = new TikZRectangle(x, y, width, height, filled);
        if (backcolor) {
            obj.setBackColor();
        }
        this.contents.add(obj);
    }

    public void addRoundedRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight, boolean filled) {
        this.contents.add(new TikZRectangle(x, y, width, height, arcWidth, arcHeight, filled));
    }

    public void addElipse(int x, int y, int width, int height, boolean filled) {
        this.contents.add(new TikZElipse(x, y, width, height, filled));
    }

    public void addArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean filled) {
        this.contents.add(new TikZArc(x, y, width, height, startAngle, arcAngle, filled));
    }

    public void addPolyline(int[] xPoints, int[] yPoints, int nPoints, boolean filled, boolean closed) {
        this.contents.add(new TikZLine(xPoints, yPoints, nPoints, filled, closed));
    }

    public void addString(String str, int x, int y) {
        this.contents.add(new TikZString(str, x, y));
    }

    public void addString(AttributedCharacterIterator str, int x, int y) {
        this.contents.add(new TikZString(str, x, y));
    }

    public void rotate(double theta) {
        this.getAffineTransform().rotate(theta);
        this.myRotation += theta;
    }

    public void rotate(double theta, double x, double y) {
        this.getAffineTransform().rotate(theta, x, y);
        this.myRotation += theta;
    }

    public Font getFont() {
        return this.curFont;
    }

    public void setFont(Font f) {
        this.curFont = f;
        String fontName = f.getFamily();
        this.fontSize = f.getSize();
        this.fontBold = f.isBold();
        this.fontItalic = f.isItalic();
        if (this.usedFonts.contains(fontName)) {
            this.fontIndex = this.usedFonts.indexOf(fontName);
        } else {
            this.usedFonts.add(fontName);
            this.fontIndex = this.usedFonts.size() - 1;
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        ArrayList<DrawObject> copyList = new ArrayList<DrawObject>();
        for (DrawObject obj : this.contents) {
            if (!obj.insideArea(x, y, width, height)) continue;
            DrawObject objClone = obj.clone();
            objClone.move(dx, dy);
            copyList.add(objClone);
        }
        this.contents.addAll(copyList);
    }

    public void setClip(int x, int y, int width, int height) {
        this.clip = new Rectangle(x, y, width, height);
    }

    public Rectangle getClip() {
        return this.clip;
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        for (int i = 0; i < g.getNumGlyphs(); ++i) {
            AffineTransform at = AffineTransform.getTranslateInstance(x, y);
            Point2D p = g.getGlyphPosition(i);
            at.transform(p, p);
            Shape shape = g.getGlyphOutline(i);
            this.contents.add(new TikZBezier(p, shape, true));
        }
    }

    private void optimize() {
        ListIterator<DrawObject> l = this.contents.listIterator();
        while (l.hasNext()) {
            TikZLine lineB;
            DrawObject n;
            DrawObject obj = l.next();
            if (!(obj instanceof TikZLine)) continue;
            TikZLine lineA = (TikZLine)obj;
            boolean merged = false;
            for (int i = this.contents.indexOf(obj) + 1; !(i >= this.contents.size() || (n = this.contents.get(i)) instanceof TikZLine && (lineB = (TikZLine)n).canMerge(lineA) && (merged = lineB.merge(lineA))); ++i) {
            }
            if (merged) {
                l.remove();
                continue;
            }
            ((TikZLine)obj).closeIfPossible();
        }
    }

    private String getCharRepresentation(int i) {
        int repeat = i / 26;
        int charId = i % 26;
        return String.valueOf((char)(charId + 65)).repeat(repeat + 1);
    }

    private String getFontDefinition(int i) {
        StringBuilder content = new StringBuilder();
        boolean replaced = false;
        content.append("\\def\\logisimfont").append(this.getCharRepresentation(i)).append("#1{\\fontfamily{");
        String fontName = this.usedFonts.get(i);
        if (fontName.contains("SansSerif")) {
            replaced = true;
            fontName = "cmr";
        } else if (fontName.contains("Monospaced")) {
            replaced = true;
            fontName = "cmtt";
        } else if (fontName.contains("Courier")) {
            replaced = true;
            fontName = "pcr";
        }
        content.append(fontName);
        content.append("}{#1}}");
        if (replaced) {
            content.append(" % Replaced by logisim, original font was \"").append(this.usedFonts.get(i)).append("\"");
        }
        content.append("\n");
        return content.toString();
    }

    private String getColorDefinitions() {
        StringBuilder content = new StringBuilder();
        for (String key : this.customColors.keySet()) {
            content.append("\\definecolor{").append(key).append("}{RGB}{").append(this.customColors.get(key)).append("}\n");
        }
        return content.toString();
    }

    public void writeFile(File outfile) throws IOException {
        this.optimize();
        FileWriter writer = new FileWriter(outfile);
        writer.write("% Important: If latex complains about unicode characters,\n");
        writer.write("% please use \"\\usepackage[utf8x]{inputenc}\" in your preamble\n");
        writer.write("% You can change the size of the picture by putting it into the construct:\n");
        writer.write("% 1) \\resizebox{10cm}{!}{\"below picture\"} to scale horizontally to 10 cm\n");
        writer.write("% 2) \\resizebox{!}{15cm}{\"below picture\"} to scale vertically to 15 cm\n");
        writer.write("% 3) \\resizebox{10cm}{15cm}{\"below picture\"} a combination of above two\n");
        writer.write("% It is not recomended to use the scale option of the tikzpicture environment.\n");
        writer.write("\\begin{tikzpicture}[x=1pt,y=-1pt,line cap=rect]\n");
        for (int i = 0; i < this.usedFonts.size(); ++i) {
            writer.write(this.getFontDefinition(i));
        }
        writer.write(this.getColorDefinitions());
        for (DrawObject obj : this.contents) {
            writer.write(obj.getTikZCommand() + "\n");
        }
        writer.write("\\end{tikzpicture}\n\n");
        writer.close();
    }

    public void writeSvg(int width, int height, File outfile) throws ParserConfigurationException, TransformerException {
        this.optimize();
        DocumentBuilderFactory factory = XmlUtil.getHardenedBuilderFactory();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document svgInfo = parser.newDocument();
        Element svg = svgInfo.createElement("svg");
        svg.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        svg.setAttribute("version", "1.1");
        svg.setAttribute("viewBox", "0 0 " + width + " " + height);
        svgInfo.appendChild(svg);
        for (DrawObject obj : this.contents) {
            obj.getSvgCommand(svgInfo, svg);
        }
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        tranFactory.setAttribute("indent-number", 3);
        Transformer transformer = tranFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(svgInfo);
        StreamResult dest = new StreamResult(outfile);
        transformer.transform(src, dest);
    }

    private class TikZLine
    extends AbstratctTikZ {
        public TikZLine() {
        }

        public TikZLine(int x1, int y1, int x2, int y2) {
            super(x1, y1, x2, y2);
        }

        public TikZLine(int[] pointsX, int[] pointsY, int pointsCnt, boolean fill, boolean isPolygon) {
            this.strokeWidth = TikZInfo.this.getStrokeWidth();
            this.color = TikZInfo.this.getDrawColorString();
            this.start = null;
            this.end = null;
            for (int i = 0; i < pointsCnt; ++i) {
                Point p = new Point(pointsX[i], pointsY[i]);
                TikZInfo.this.transform(p, p);
                this.points.add(p);
            }
            this.filled = fill;
            this.close = isPolygon;
        }

        public Point getStartPoint() {
            return this.points.isEmpty() ? this.start : (Point)this.points.get(0);
        }

        public Point getEndPoint() {
            return this.points.isEmpty() ? this.end : (Point)this.points.get(this.points.size() - 1);
        }

        public boolean canMerge(TikZLine l) {
            if (this.close || l.close) {
                return false;
            }
            if (!this.color.equals(l.color)) {
                return false;
            }
            if (this.strokeWidth != l.strokeWidth) {
                return false;
            }
            if (this.filled || l.filled) {
                return false;
            }
            if (this.getStartPoint().equals(l.getEndPoint())) {
                return true;
            }
            if (this.getEndPoint().equals(l.getStartPoint())) {
                return true;
            }
            if (this.getStartPoint().equals(l.getStartPoint())) {
                return true;
            }
            return this.getEndPoint().equals(l.getEndPoint());
        }

        public void closeIfPossible() {
            if (this.points.isEmpty()) {
                return;
            }
            if (this.getStartPoint().equals(this.getEndPoint())) {
                this.points.remove(this.points.size() - 1);
                this.close = true;
            }
        }

        private void addPoints(ArrayList<Point> p, int start, int end, boolean atEnd, boolean reverseOrder) {
            if (atEnd) {
                if (reverseOrder) {
                    for (int i = end - 1; i >= start; --i) {
                        this.points.add(p.get(i));
                    }
                } else {
                    for (int i = start; i < end; ++i) {
                        this.points.add(p.get(i));
                    }
                }
            } else if (reverseOrder) {
                for (int i = start; i < end; ++i) {
                    this.points.add(0, p.get(i));
                }
            } else {
                for (int i = end - 1; i >= start; --i) {
                    this.points.add(0, p.get(i));
                }
            }
        }

        public boolean merge(TikZLine l) {
            if (!this.canMerge(l)) {
                return false;
            }
            if (this.points.isEmpty()) {
                this.points.add(this.start);
                this.points.add(this.end);
            }
            if (l.points.isEmpty()) {
                l.points.add(l.start);
                l.points.add(l.end);
            }
            if (this.getStartPoint().equals(l.getEndPoint())) {
                this.addPoints(l.points, 0, l.points.size() - 1, false, false);
            } else if (this.getEndPoint().equals(l.getStartPoint())) {
                this.addPoints(l.points, 1, l.points.size(), true, false);
            } else if (this.getStartPoint().equals(l.getStartPoint())) {
                this.addPoints(l.points, 1, l.points.size(), false, true);
            } else if (this.getEndPoint().equals(l.getEndPoint())) {
                this.addPoints(l.points, 0, l.points.size() - 1, true, true);
            } else {
                return false;
            }
            return true;
        }

        @Override
        public String getTikZCommand() {
            StringBuilder contents = new StringBuilder();
            if (this.filled) {
                contents.append("\\fill ");
            } else {
                contents.append("\\draw ");
            }
            contents.append("[line width=");
            double width = (double)this.strokeWidth * 1.0;
            contents.append(TikZInfo.rounded(width)).append("pt, ").append(this.color).append(" ] ");
            if (this.points.isEmpty()) {
                contents.append(TikZInfo.getPoint(this.start));
                contents.append("--");
                contents.append(TikZInfo.getPoint(this.end));
            } else {
                boolean first = true;
                for (Point point : this.points) {
                    if (first) {
                        first = false;
                    } else {
                        contents.append("--");
                    }
                    contents.append(TikZInfo.getPoint(point));
                }
            }
            if (this.close) {
                contents.append("-- cycle");
            }
            contents.append(";");
            return contents.toString();
        }

        @Override
        public void getSvgCommand(Document root, Element e) {
            StringBuilder content = new StringBuilder();
            Element ne = root.createElement(this.close ? "polygon" : "polyline");
            e.appendChild(ne);
            ne.setAttribute("fill", (String)(this.filled ? "rgb(" + TikZInfo.this.customColors.get(this.color) + ")" : "none"));
            ne.setAttribute("stroke", (String)(this.filled ? "none" : "rgb(" + TikZInfo.this.customColors.get(this.color) + ")"));
            double width = (double)this.strokeWidth * 1.0;
            ne.setAttribute("stroke-width", Double.toString(TikZInfo.rounded(width)));
            ne.setAttribute("stroke-linecap", "square");
            if (this.points.isEmpty()) {
                content.append(this.start.x).append(",").append(this.start.y).append(" ").append(this.end.x).append(",").append(this.end.y);
            } else {
                boolean first = true;
                for (Point point : this.points) {
                    if (first) {
                        first = false;
                    } else {
                        content.append(" ");
                    }
                    content.append(point.x).append(",").append(point.y);
                }
            }
            ne.setAttribute("points", content.toString());
        }

        @Override
        public DrawObject clone() {
            TikZLine newIns = new TikZLine();
            newIns.start = (Point)this.start.clone();
            newIns.end = (Point)this.end.clone();
            newIns.strokeWidth = this.strokeWidth;
            newIns.color = this.color;
            newIns.points = (ArrayList)this.points.clone();
            newIns.filled = this.filled;
            newIns.close = this.close;
            return newIns;
        }
    }

    private class TikZBezier
    extends AbstratctTikZ {
        private final ArrayList<BezierInfo> myPath;

        public TikZBezier() {
            this.myPath = new ArrayList();
        }

        public TikZBezier(Shape s, boolean filled) {
            this.myPath = new ArrayList();
            Point2D.Double p = new Point2D.Double();
            p.setLocation(0.0, 0.0);
            this.create(p, s, filled);
        }

        public TikZBezier(Point2D orig, Shape s, boolean filled) {
            this.myPath = new ArrayList();
            this.create(orig, s, filled);
        }

        private void create(Point2D origin, Shape s, boolean filled) {
            this.filled = filled;
            this.color = TikZInfo.this.getDrawColorString();
            this.alpha = (double)TikZInfo.this.drawColor.getAlpha() / 255.0;
            this.strokeWidth = TikZInfo.this.getStrokeWidth();
            AffineTransform at = AffineTransform.getTranslateInstance(origin.getX(), origin.getY());
            PathIterator p = s.getPathIterator(at);
            while (!p.isDone()) {
                double[] coords = new double[6];
                int type = p.currentSegment(coords);
                if (type == 0) {
                    Point2D.Double current = new Point2D.Double();
                    current.setLocation(coords[0], coords[1]);
                    this.myPath.add(new BezierInfo((Point2D)current, true, filled));
                } else if (type == 1) {
                    next = new Point2D.Double();
                    next.setLocation(coords[0], coords[1]);
                    this.myPath.add(new BezierInfo((Point2D)next, false, false));
                } else if (type == 4) {
                    this.myPath.add(new BezierInfo());
                } else if (type == 2) {
                    next = new Point2D.Double();
                    Point2D.Double control = new Point2D.Double();
                    control.setLocation(coords[0], coords[1]);
                    next.setLocation(coords[2], coords[3]);
                    this.myPath.add(new BezierInfo(control, next));
                } else if (type == 3) {
                    next = new Point2D.Double();
                    Point2D.Double control1 = new Point2D.Double();
                    Point2D.Double control2 = new Point2D.Double();
                    control1.setLocation(coords[0], coords[1]);
                    control2.setLocation(coords[2], coords[3]);
                    next.setLocation(coords[4], coords[5]);
                    this.myPath.add(new BezierInfo((Point2D)control1, control2, next));
                }
                p.next();
            }
        }

        @Override
        public String getTikZCommand() {
            StringBuilder contents = new StringBuilder();
            double width = (double)this.strokeWidth * 1.0;
            contents.append(this.filled ? "\\fill " : "\\draw ").append("[line width=").append(TikZInfo.rounded(width)).append("pt, ").append(this.color);
            if (this.filled && this.alpha != 1.0) {
                contents.append(", fill opacity=").append(TikZInfo.rounded(this.alpha));
            }
            contents.append(" ] ");
            for (BezierInfo point : this.myPath) {
                contents.append(point.getTikZCommand());
            }
            contents.append(";");
            return contents.toString();
        }

        @Override
        public void getSvgCommand(Document root, Element e) {
            Element ne = root.createElement("path");
            e.appendChild(ne);
            ne.setAttribute("fill", (String)(this.filled ? "rgb(" + TikZInfo.this.customColors.get(this.color) + ")" : "none"));
            if (this.filled && this.alpha != 1.0) {
                ne.setAttribute("fill-opacity", Double.toString(TikZInfo.rounded(this.alpha)));
            }
            ne.setAttribute("stroke", (String)(this.filled ? "none" : "rgb(" + TikZInfo.this.customColors.get(this.color) + ")"));
            double width = (double)this.strokeWidth * 1.0;
            ne.setAttribute("stroke-width", Double.toString(TikZInfo.rounded(width)));
            ne.setAttribute("stroke-linecap", "square");
            StringBuilder content = new StringBuilder();
            for (BezierInfo point : this.myPath) {
                content.append(point.getSvgPath());
            }
            ne.setAttribute("d", content.toString());
        }

        @Override
        public boolean insideArea(int x, int y, int width, int height) {
            boolean inside = true;
            for (BezierInfo point : this.myPath) {
                inside &= point.insideArea(x, y, width, height);
            }
            return inside;
        }

        @Override
        public DrawObject clone() {
            TikZBezier newInst = new TikZBezier();
            newInst.filled = this.filled;
            newInst.color = this.color;
            newInst.alpha = this.alpha;
            newInst.strokeWidth = this.strokeWidth;
            for (BezierInfo point : this.myPath) {
                newInst.myPath.add(point.clone());
            }
            return newInst;
        }

        @Override
        public void move(int dx, int dy) {
            for (BezierInfo point : this.myPath) {
                point.move(dx, dy);
            }
        }

        private class BezierInfo
        implements Cloneable {
            private Point2D startPoint;
            private Point2D controlPoint1;
            private Point2D controlPoint2;
            private Point2D endPoint;
            private boolean closePath;

            public BezierInfo() {
                this.endPoint = null;
                this.controlPoint2 = null;
                this.controlPoint1 = null;
                this.startPoint = null;
                this.closePath = true;
            }

            public BezierInfo(Point2D nextPoint, boolean startpoint, boolean filled) {
                this.controlPoint2 = null;
                this.controlPoint1 = null;
                if (startpoint) {
                    this.startPoint = nextPoint;
                    this.endPoint = null;
                } else {
                    this.startPoint = null;
                    this.endPoint = nextPoint;
                }
                this.closePath = false;
                this.scale();
            }

            public BezierInfo(Point2D controlPoint, Point2D nextPoint) {
                this.controlPoint2 = null;
                this.startPoint = null;
                this.controlPoint1 = controlPoint;
                this.endPoint = nextPoint;
                this.closePath = false;
                this.scale();
            }

            public BezierInfo(Point2D controlPointa, Point2D controlPointb, Point2D nextPoint) {
                this.startPoint = null;
                this.controlPoint1 = controlPointa;
                this.controlPoint2 = controlPointb;
                this.endPoint = nextPoint;
                this.closePath = false;
                this.scale();
            }

            private void scale() {
                if (this.startPoint != null) {
                    TikZInfo.this.transform(this.startPoint, this.startPoint);
                }
                if (this.controlPoint1 != null) {
                    TikZInfo.this.transform(this.controlPoint1, this.controlPoint1);
                }
                if (this.controlPoint2 != null) {
                    TikZInfo.this.transform(this.controlPoint2, this.controlPoint2);
                }
                if (this.endPoint != null) {
                    TikZInfo.this.transform(this.endPoint, this.endPoint);
                }
            }

            public BezierInfo clone() {
                BezierInfo newInst = new BezierInfo();
                newInst.startPoint = this.startPoint;
                newInst.controlPoint1 = this.controlPoint1;
                newInst.controlPoint2 = this.controlPoint2;
                newInst.endPoint = this.endPoint;
                newInst.closePath = this.closePath;
                return newInst;
            }

            public void move(int dx, int dy) {
                AffineTransform at = AffineTransform.getTranslateInstance(dx, dy);
                if (this.startPoint != null) {
                    at.transform(this.startPoint, this.startPoint);
                }
                if (this.controlPoint1 != null) {
                    at.transform(this.controlPoint1, this.controlPoint1);
                }
                if (this.controlPoint2 != null) {
                    at.transform(this.controlPoint2, this.controlPoint2);
                }
                if (this.endPoint != null) {
                    at.transform(this.endPoint, this.endPoint);
                }
            }

            public String getTikZCommand() {
                StringBuilder contents = new StringBuilder();
                if (this.closePath) {
                    contents.append("-- cycle ");
                } else if (this.startPoint != null) {
                    contents.append(TikZInfo.getPoint(this.startPoint));
                } else if (this.controlPoint1 == null && this.controlPoint2 == null) {
                    contents.append("-- ").append(TikZInfo.getPoint(this.endPoint));
                } else {
                    contents.append(".. controls ").append(TikZInfo.getPoint(this.controlPoint1)).append(" ");
                    if (this.controlPoint2 != null) {
                        contents.append(" and ").append(TikZInfo.getPoint(this.controlPoint2)).append(" ");
                    }
                    contents.append(".. ").append(TikZInfo.getPoint(this.endPoint));
                }
                return contents.toString();
            }

            public String getSvgPath() {
                StringBuilder contents = new StringBuilder();
                if (this.closePath) {
                    contents.append(" Z");
                } else if (this.startPoint != null) {
                    contents.append(" M").append(this.startPoint.getX()).append(",").append(this.startPoint.getY());
                } else if (this.controlPoint1 == null && this.controlPoint2 == null) {
                    contents.append(" L").append(this.endPoint.getX()).append(",").append(this.endPoint.getY());
                } else {
                    Point2D singlePoint = this.controlPoint2 == null ? this.controlPoint1 : this.controlPoint2;
                    contents.append(" C").append(this.controlPoint1.getX()).append(",").append(this.controlPoint1.getY());
                    contents.append(" ").append(singlePoint.getX()).append(",").append(singlePoint.getY());
                    contents.append(" ").append(this.endPoint.getX()).append(",").append(this.endPoint.getY());
                }
                return contents.toString();
            }

            public boolean insideArea(int x, int y, int width, int height) {
                if (this.closePath) {
                    return true;
                }
                boolean inside = true;
                int x2 = x + width;
                int y2 = y + height;
                if (this.startPoint != null) {
                    inside &= this.startPoint.getX() >= (double)x && this.startPoint.getX() <= (double)x2 && this.startPoint.getY() >= (double)y && this.startPoint.getY() <= (double)y2;
                }
                if (this.endPoint != null) {
                    inside &= this.endPoint.getX() >= (double)x && this.endPoint.getX() <= (double)x2 && this.endPoint.getY() >= (double)y && this.endPoint.getY() <= (double)y2;
                }
                return inside;
            }
        }
    }

    private class TikZRectangle
    extends AbstratctTikZ {
        Point2D rad;

        public TikZRectangle() {
        }

        public TikZRectangle(int x1, int y1, int x2, int y2, int arcwidth, int archeight, boolean filled) {
            super(x1, y1, x2, y2);
            this.rad = new Point2D.Double();
            this.rad.setLocation((double)arcwidth / 2.0, (double)archeight / 2.0);
            this.filled = filled;
        }

        public TikZRectangle(int x1, int y1, int x2, int y2, boolean filled) {
            super(x1, y1, x2, y2);
            this.filled = filled;
            this.rad = null;
        }

        public void setBackColor() {
            this.color = TikZInfo.this.getBackColorString();
        }

        @Override
        public DrawObject clone() {
            TikZRectangle newIns = new TikZRectangle();
            newIns.start = (Point)this.start.clone();
            newIns.end = (Point)this.end.clone();
            newIns.strokeWidth = this.strokeWidth;
            newIns.color = this.color;
            newIns.filled = this.filled;
            newIns.rad = (Point2D)this.rad.clone();
            newIns.alpha = this.alpha;
            return newIns;
        }

        @Override
        public String getTikZCommand() {
            StringBuilder contents = new StringBuilder();
            if (this.rad == null) {
                contents.append(this.filled ? "\\fill " : "\\draw ");
                contents.append("[line width=");
                double width = (double)this.strokeWidth * 1.0;
                contents.append(TikZInfo.rounded(width)).append("pt, ").append(this.color);
                if (this.filled && this.alpha != 1.0) {
                    contents.append(", fill opacity=").append(TikZInfo.rounded(this.alpha));
                }
                contents.append(" ] ");
                contents.append(TikZInfo.getPoint(this.start));
                contents.append("rectangle");
                contents.append(TikZInfo.getPoint(this.end));
                contents.append(";");
            } else {
                contents.append("\\begin{pgfpicture}\n");
                contents.append("   \\begin{pgfmagnify}{1pt}{-1pt}\n");
                contents.append("      \\pgfsetrectcap\n");
                contents.append("      \\pgfsetcornersarced{").append(TikZInfo.getPgfPoint(this.rad)).append("}\n");
                contents.append("      \\pgfsetlinewidth{").append(this.strokeWidth).append("}\n");
                contents.append("      \\color{").append(this.color).append("}\n");
                contents.append("      \\pgfsetfillopacity{").append(this.alpha).append("}\n");
                contents.append("      \\pgfpathrectanglecorners{").append(TikZInfo.getPgfPoint(this.start)).append("}{").append(TikZInfo.getPgfPoint(this.end)).append("}\n");
                contents.append("      \\pgfusepath{").append(this.filled ? "fill" : "stroke").append("}\n");
                contents.append("   \\end{pgfmagnify}\n");
                contents.append("\\end{pgfpicture}");
            }
            return contents.toString();
        }

        @Override
        public void getSvgCommand(Document root, Element e) {
            Element ne = root.createElement("rect");
            e.appendChild(ne);
            ne.setAttribute("fill", (String)(this.filled ? "rgb(" + TikZInfo.this.customColors.get(this.color) + ")" : "none"));
            if (this.filled && this.alpha != 1.0) {
                ne.setAttribute("fill-opacity", Double.toString(TikZInfo.rounded(this.alpha)));
            }
            ne.setAttribute("stroke", (String)(this.filled ? "none" : "rgb(" + TikZInfo.this.customColors.get(this.color) + ")"));
            double width = (double)this.strokeWidth * 1.0;
            ne.setAttribute("stroke-width", Double.toString(TikZInfo.rounded(width)));
            ne.setAttribute("stroke-linecap", "square");
            if (this.rad != null) {
                ne.setAttribute("rx", Double.toString(this.rad.getX()));
                ne.setAttribute("ry", Double.toString(this.rad.getY()));
            }
            int xpos = Math.min(this.end.x, this.start.x);
            int bwidth = Math.abs(this.end.x - this.start.x);
            int ypos = Math.min(this.end.y, this.start.y);
            int bheight = Math.abs(this.end.y - this.start.y);
            ne.setAttribute("x", Integer.toString(xpos));
            ne.setAttribute("y", Integer.toString(ypos));
            ne.setAttribute("width", Integer.toString(bwidth));
            ne.setAttribute("height", Integer.toString(bheight));
        }
    }

    private class TikZElipse
    extends AbstratctTikZ {
        protected double radX;
        protected double radY;
        protected int rotation;

        public TikZElipse() {
        }

        public TikZElipse(int x, int y, int width, int height, boolean filled) {
            super(x + (width >> 1), y + (height >> 1), 0, 0);
            this.init(width, height, filled);
        }

        private void init(int width, int height, boolean filled) {
            this.filled = filled;
            this.radX = (double)width / 2.0;
            this.radY = (double)height / 2.0;
            this.rotation = (int)TikZInfo.this.getRotationDegrees();
        }

        @Override
        public DrawObject clone() {
            TikZElipse newIns = new TikZElipse();
            newIns.start = (Point)this.start.clone();
            newIns.end = (Point)this.end.clone();
            newIns.strokeWidth = this.strokeWidth;
            newIns.color = this.color;
            newIns.filled = this.filled;
            newIns.radX = this.radX;
            newIns.radY = this.radY;
            newIns.rotation = this.rotation;
            newIns.alpha = this.alpha;
            return newIns;
        }

        @Override
        public String getTikZCommand() {
            StringBuilder contents = new StringBuilder();
            contents.append(this.filled ? "\\fill " : "\\draw ");
            contents.append("[line width=");
            double width = (double)this.strokeWidth * 1.0;
            contents.append(TikZInfo.rounded(width)).append("pt, ").append(this.color);
            if (this.rotation != 0) {
                contents.append(", rotate around={").append(this.rotation).append(":").append(TikZInfo.getPoint(this.start)).append("}");
            }
            if (this.filled && this.alpha != 1.0) {
                contents.append(", fill opacity=").append(TikZInfo.rounded(this.alpha));
            }
            contents.append("] ");
            contents.append(TikZInfo.getPoint(this.start));
            contents.append("ellipse (").append(this.radX).append(" and ").append(this.radY).append(" );");
            return contents.toString();
        }

        @Override
        public void getSvgCommand(Document root, Element e) {
            Element ne = root.createElement("ellipse");
            e.appendChild(ne);
            ne.setAttribute("fill", (String)(this.filled ? "rgb(" + TikZInfo.this.customColors.get(this.color) + ")" : "none"));
            if (this.filled && this.alpha != 1.0) {
                ne.setAttribute("fill-opacity", Double.toString(TikZInfo.rounded(this.alpha)));
            }
            ne.setAttribute("stroke", (String)(this.filled ? "none" : "rgb(" + TikZInfo.this.customColors.get(this.color) + ")"));
            double width = (double)this.strokeWidth * 1.0;
            ne.setAttribute("stroke-width", Double.toString(TikZInfo.rounded(width)));
            if (this.rotation != 0) {
                ne.setAttribute("transform", "translate(" + this.start.getX() + " " + this.start.getY() + ") rotate(" + this.rotation + ")");
            } else {
                ne.setAttribute("cx", Double.toString(this.start.getX()));
                ne.setAttribute("cy", Double.toString(this.start.getY()));
            }
            ne.setAttribute("rx", Double.toString(Math.abs(this.radX)));
            ne.setAttribute("ry", Double.toString(Math.abs(this.radY)));
        }
    }

    private class TikZArc
    extends TikZElipse {
        private double startAngle;
        private double stopAngle;
        private Point2D startPos = new Point2D.Double();
        private Point2D stopPos = new Point2D.Double();

        public TikZArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean fill) {
            this.filled = fill;
            this.strokeWidth = TikZInfo.this.getStrokeWidth();
            this.color = TikZInfo.this.getDrawColorString();
            this.points.clear();
            this.close = false;
            Point2D.Double radius = new Point2D.Double();
            Point2D.Double center = new Point2D.Double();
            radius.setLocation((double)width / 2.0, (double)height / 2.0);
            center.setLocation((double)x + radius.getX(), (double)y + radius.getY());
            double startAnglePi = (double)startAngle * Math.PI / 180.0;
            double startX = center.getX() + radius.getX() * Math.cos(startAnglePi);
            double startY = center.getY() - radius.getY() * Math.sin(startAnglePi);
            double stopAnglePi = (double)(startAngle + arcAngle) * Math.PI / 180.0;
            double stopX = center.getX() + radius.getX() * Math.cos(stopAnglePi);
            double stopY = center.getY() - radius.getY() * Math.sin(stopAnglePi);
            this.radX = radius.getX();
            this.radY = radius.getY();
            this.startAngle = -TikZInfo.this.toDegree(startAnglePi);
            this.stopAngle = -TikZInfo.this.toDegree(stopAnglePi);
            this.rotation = (int)TikZInfo.this.getRotationDegrees();
            this.startAngle += (double)this.rotation;
            this.stopAngle += (double)this.rotation;
            this.startPos.setLocation(startX, startY);
            TikZInfo.this.transform(this.startPos, this.startPos);
            this.stopPos.setLocation(stopX, stopY);
            TikZInfo.this.transform(this.stopPos, this.stopPos);
        }

        public TikZArc() {
        }

        @Override
        public DrawObject clone() {
            TikZArc newIns = new TikZArc();
            newIns.strokeWidth = this.strokeWidth;
            newIns.color = this.color;
            newIns.filled = this.filled;
            newIns.radX = this.radX;
            newIns.radY = this.radY;
            newIns.rotation = this.rotation;
            newIns.startAngle = this.startAngle;
            newIns.stopAngle = this.stopAngle;
            newIns.alpha = this.alpha;
            newIns.startPos = (Point2D)this.startPos.clone();
            newIns.stopPos = (Point2D)this.stopPos.clone();
            return newIns;
        }

        @Override
        public String getTikZCommand() {
            StringBuilder contents = new StringBuilder();
            contents.append(this.filled ? "\\fill " : "\\draw ");
            contents.append("[line width=");
            double width = (double)this.strokeWidth * 1.0;
            contents.append(TikZInfo.rounded(width)).append("pt, ").append(this.color);
            if (this.filled && this.alpha != 1.0) {
                contents.append(", fill opacity=").append(TikZInfo.rounded(this.alpha));
            }
            contents.append("] ");
            contents.append("(").append(TikZInfo.rounded(this.startPos.getX())).append(",").append(TikZInfo.rounded(this.startPos.getY())).append(")");
            contents.append(" arc (").append(this.startAngle).append(":").append(this.stopAngle).append(":").append(this.radX).append(" and ").append(this.radY).append(" );");
            return contents.toString();
        }

        @Override
        public void getSvgCommand(Document root, Element e) {
            Element ne = root.createElement("path");
            e.appendChild(ne);
            ne.setAttribute("fill", (String)(this.filled ? "rgb(" + TikZInfo.this.customColors.get(this.color) + ")" : "none"));
            if (this.filled && this.alpha != 1.0) {
                ne.setAttribute("fill-opacity", Double.toString(TikZInfo.rounded(this.alpha)));
            }
            ne.setAttribute("stroke", (String)(this.filled ? "none" : "rgb(" + TikZInfo.this.customColors.get(this.color) + ")"));
            double width = (double)this.strokeWidth * 1.0;
            ne.setAttribute("stroke-width", Double.toString(TikZInfo.rounded(width)));
            String info = this.startAngle > this.stopAngle ? " 0,0 " : " 0,1 ";
            String content = "M" + this.startPos.getX() + "," + this.startPos.getY() + " A" + this.radX + "," + this.radY + " " + this.startAngle + info + this.stopPos.getX() + "," + this.stopPos.getY();
            ne.setAttribute("d", content);
        }
    }

    private class TikZString
    implements DrawObject {
        private Point location;
        private String name;
        private AttributedCharacterIterator strIter;
        private String color;
        private double rotation;
        private int fontIndex;
        private int fontSize;
        private boolean isFontBold;
        private boolean isFontItalic;

        public TikZString() {
        }

        public TikZString(String str, int x, int y) {
            this.name = str;
            this.strIter = null;
            this.init(x, y);
            this.fontIndex = TikZInfo.this.fontIndex;
            this.fontSize = TikZInfo.this.fontSize;
            this.isFontBold = TikZInfo.this.fontBold;
            this.isFontItalic = TikZInfo.this.fontItalic;
        }

        public TikZString(AttributedCharacterIterator str, int x, int y) {
            this.name = null;
            this.strIter = str;
            if (str.getAttribute(TextAttribute.FAMILY) == null || str.getAttribute(TextAttribute.FAMILY).equals("Default")) {
                this.fontIndex = TikZInfo.this.fontIndex;
                this.fontSize = TikZInfo.this.fontSize;
                this.isFontBold = TikZInfo.this.fontBold;
                this.isFontItalic = TikZInfo.this.fontItalic;
            } else {
                this.isFontBold = str.getAttribute(TextAttribute.WEIGHT) == TextAttribute.WEIGHT_BOLD;
                this.isFontItalic = false;
                this.fontSize = (Integer)str.getAttribute(TextAttribute.SIZE);
                String fontName = (String)str.getAttribute(TextAttribute.FAMILY);
                if (!TikZInfo.this.usedFonts.contains(fontName)) {
                    TikZInfo.this.usedFonts.add(fontName);
                }
                this.fontIndex = TikZInfo.this.usedFonts.indexOf(fontName);
            }
            this.init(x, y);
        }

        private void init(int x, int y) {
            this.rotation = -TikZInfo.this.getRotationDegrees();
            this.location = new Point(x, y);
            TikZInfo.this.transform(this.location, this.location);
            this.color = TikZInfo.this.getDrawColorString();
        }

        private String getAttrString(boolean svg, Document root, Element e) {
            this.strIter.first();
            StringBuilder content = new StringBuilder();
            Element tspan = null;
            if (!svg) {
                content.append("$\\text{");
            } else {
                tspan = root.createElement("tspan");
            }
            while (this.strIter.getIndex() < this.strIter.getEndIndex()) {
                char kar;
                if (this.strIter.getAttribute(TextAttribute.SUPERSCRIPT) == TextAttribute.SUPERSCRIPT_SUB) {
                    if (svg) {
                        if (content.length() > 0) {
                            e.appendChild(tspan);
                            tspan.setTextContent(content.toString());
                            content = new StringBuilder();
                        }
                        tspan = root.createElement("tspan");
                        tspan.setAttribute("dy", "3");
                        tspan.setAttribute("font-size", ".7em");
                    } else {
                        content.append("}_{\\text{");
                    }
                    while (this.strIter.getIndex() < this.strIter.getEndIndex() && this.strIter.getAttribute(TextAttribute.SUPERSCRIPT) == TextAttribute.SUPERSCRIPT_SUB) {
                        kar = this.strIter.current();
                        if (kar == '_' && !svg) {
                            content.append("\\_");
                        }
                        if (kar == '&' && !svg) {
                            content.append("\\&");
                        } else {
                            content.append(kar);
                        }
                        this.strIter.next();
                    }
                    if (svg) {
                        if (content.length() > 0) {
                            e.appendChild(tspan);
                            tspan.setTextContent(content.toString());
                            content = new StringBuilder();
                            tspan = root.createElement("tspan");
                            tspan.setAttribute("dy", "-3");
                            continue;
                        }
                        tspan = root.createElement("tspan");
                        continue;
                    }
                    content.append("}}\\text{");
                    continue;
                }
                kar = this.strIter.current();
                if (kar == '\u22c5' && !svg) {
                    content.append("}\\cdot\\text{");
                } else if (kar == '_' && !svg) {
                    content.append("\\_");
                } else if (kar == '&' && !svg) {
                    content.append("\\&");
                } else {
                    content.append(kar);
                }
                this.strIter.next();
            }
            if (!svg) {
                content.append("}$");
            } else if (content.length() > 0) {
                e.appendChild(tspan);
                tspan.setTextContent(content.toString());
                content = new StringBuilder();
            }
            return content.toString();
        }

        @Override
        public String getTikZCommand() {
            StringBuilder content = new StringBuilder();
            content.append("\\logisimfont").append(TikZInfo.this.getCharRepresentation(this.fontIndex)).append("{");
            content.append("\\fontsize{").append(this.fontSize).append("pt}{").append(this.fontSize).append("pt}");
            if (this.isFontBold) {
                content.append("\\fontseries{bx}");
            }
            if (this.isFontItalic) {
                content.append("\\fontshape{it}");
            }
            content.append("\\selectfont\\node[inner sep=0, outer sep=0, ").append(this.color).append(", anchor=base west");
            if (this.rotation != 0.0) {
                content.append(", rotate=").append(this.rotation);
            }
            content.append("] at ").append(TikZInfo.getPoint(this.location)).append(" {");
            if (this.name != null) {
                if (this.name.isEmpty()) {
                    return "";
                }
                for (int i = 0; i < this.name.length(); ++i) {
                    char kar = this.name.charAt(i);
                    if (kar == '_' || kar == '&') {
                        content.append("\\");
                    }
                    content.append(kar);
                }
            } else {
                content.append(this.getAttrString(false, null, null));
            }
            content.append("};}");
            return content.toString();
        }

        @Override
        public void getSvgCommand(Document root, Element e) {
            Element ne = root.createElement("text");
            ne.setAttribute("font-family", TikZInfo.this.usedFonts.get(TikZInfo.this.fontIndex));
            ne.setAttribute("font-size", Integer.toString(this.fontSize));
            if (this.isFontBold) {
                ne.setAttribute("font-weight", "bold");
            }
            if (this.isFontItalic) {
                ne.setAttribute("font-style", "italic");
            }
            if (this.rotation != 0.0) {
                ne.setAttribute("transform", "rotate(" + -this.rotation + "," + this.location.getX() + "," + this.location.getY() + ")");
            }
            ne.setAttribute("x", Double.toString(this.location.getX()));
            ne.setAttribute("y", Double.toString(this.location.getY()));
            ne.setAttribute("fill", "rgb(" + TikZInfo.this.customColors.get(this.color) + ")");
            if (this.name != null) {
                ne.setTextContent(this.name);
                if (!this.name.isEmpty()) {
                    e.appendChild(ne);
                }
            } else {
                this.getAttrString(true, root, ne);
                e.appendChild(ne);
            }
        }

        @Override
        public boolean insideArea(int x, int y, int width, int height) {
            return this.location.x >= x && this.location.x <= x + width && this.location.y >= y && this.location.y <= y + height;
        }

        @Override
        public DrawObject clone() {
            TikZString newInst = new TikZString();
            newInst.fontIndex = this.fontIndex;
            newInst.fontSize = this.fontSize;
            newInst.isFontBold = this.isFontBold;
            newInst.isFontItalic = this.isFontItalic;
            newInst.location = (Point)this.location.clone();
            newInst.name = this.name;
            newInst.color = this.color;
            newInst.rotation = this.rotation;
            return newInst;
        }

        @Override
        public void move(int dx, int dy) {
            this.location = new Point(this.location.x + dx, this.location.y + dy);
        }
    }

    public static interface DrawObject {
        public String getTikZCommand();

        public void getSvgCommand(Document var1, Element var2);

        public boolean insideArea(int var1, int var2, int var3, int var4);

        public DrawObject clone();

        public void move(int var1, int var2);
    }

    private class AbstratctTikZ
    implements DrawObject {
        protected Point start;
        protected Point end;
        protected ArrayList<Point> points = new ArrayList();
        protected float strokeWidth;
        protected String color;
        protected double alpha;
        protected boolean filled;
        protected boolean close;

        public AbstratctTikZ() {
        }

        public AbstratctTikZ(int x1, int y1, int x2, int y2) {
            this.start = new Point(x1, y1);
            this.end = new Point(x2, y2);
            TikZInfo.this.transform(this.start, this.start);
            TikZInfo.this.transform(this.end, this.end);
            this.strokeWidth = TikZInfo.this.getStrokeWidth();
            this.color = TikZInfo.this.getDrawColorString();
            this.alpha = (double)TikZInfo.this.drawColor.getAlpha() / 255.0;
            this.points.clear();
            this.filled = false;
            this.close = false;
        }

        @Override
        public String getTikZCommand() {
            return "";
        }

        @Override
        public boolean insideArea(int x, int y, int width, int height) {
            Point left = new Point(x, y);
            Point right = new Point(x + width, y + height);
            TikZInfo.this.transform(left, left);
            TikZInfo.this.transform(right, right);
            int x1 = Math.min(left.x, right.x);
            int x2 = Math.max(left.x, right.x);
            int y1 = Math.min(left.y, right.y);
            int y2 = Math.max(left.y, right.y);
            boolean inside = true;
            if (this.points.isEmpty()) {
                return this.start.x >= x1 && this.start.x <= x2 && this.start.y >= y1 && this.start.y <= y2 && this.end.x >= x1 && this.end.x <= x2 && this.end.y >= y1 && this.end.y <= y2;
            }
            for (Point point : this.points) {
                inside &= point.x >= x1 && point.x <= x2 && point.y >= y1 && point.y <= y2;
            }
            return inside;
        }

        @Override
        public DrawObject clone() {
            return null;
        }

        @Override
        public void move(int dx, int dy) {
            Point move = new Point(dx, dy);
            TikZInfo.this.transform(move, move);
            if (this.points.isEmpty()) {
                this.start = new Point(this.start.x + move.x, this.start.y + move.y);
                this.end = new Point(this.end.x + move.x, this.start.y + move.y);
            } else {
                for (Point point : this.points) {
                    point.x += move.x;
                    point.y += move.y;
                }
            }
        }

        @Override
        public void getSvgCommand(Document root, Element e) {
        }
    }
}

