/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.gui.icons.BaseIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;

public class ArithmeticIcon
extends BaseIcon {
    private final String opp;
    private boolean invalid;
    private int nrOfChars = 2;

    public ArithmeticIcon(String operation) {
        this.opp = operation;
        this.invalid = false;
    }

    public ArithmeticIcon(String operation, int charsPerLine) {
        this.opp = operation;
        this.invalid = false;
        this.nrOfChars = charsPerLine;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    @Override
    protected void paintIcon(Graphics2D g2) {
        g2.setStroke(new BasicStroke(this.scale(2)));
        g2.setColor(Color.BLACK);
        int scale = this.opp.length() >= this.nrOfChars ? this.nrOfChars : 1;
        int yOff = this.opp.length() > this.nrOfChars ? this.getIconHeight() >> 2 : this.getIconHeight() >> 1;
        Font font = g2.getFont().deriveFont((float)this.getIconWidth() / (float)scale).deriveFont(1);
        g2.drawRect(this.scale(1), this.scale(1), this.getIconWidth() - this.scale(2), this.getIconHeight() - this.scale(2));
        TextLayout textLayout = new TextLayout(this.opp.length() > this.nrOfChars ? this.opp.substring(0, this.nrOfChars) : this.opp, font, g2.getFontRenderContext());
        textLayout.draw(g2, (float)((double)(this.getIconWidth() / 2) - textLayout.getBounds().getCenterX()), (float)((double)yOff - textLayout.getBounds().getCenterY()));
        if (this.opp.length() > this.nrOfChars) {
            textLayout = new TextLayout(this.opp.length() > 2 * this.nrOfChars ? this.opp.substring(this.nrOfChars, 2 * this.nrOfChars) : this.opp.substring(this.nrOfChars), font, g2.getFontRenderContext());
            textLayout.draw(g2, (float)((double)(this.getIconWidth() / 2) - textLayout.getBounds().getCenterX()), (float)((double)(3 * yOff) - textLayout.getBounds().getCenterY()));
        }
        if (this.invalid) {
            g2.setColor(Color.RED);
            g2.fillOval(0, this.getIconHeight() / 2, this.getIconWidth() / 2, this.getIconHeight() / 2);
            font = g2.getFont().deriveFont(this.scale((float)this.getIconWidth() / 2.8f)).deriveFont(1);
            textLayout = new TextLayout("!", font, g2.getFontRenderContext());
            g2.setColor(Color.WHITE);
            textLayout.draw(g2, (float)((double)(this.getIconWidth() / 4) - textLayout.getBounds().getCenterX()), (float)((double)(3 * this.getIconHeight() / 4) - textLayout.getBounds().getCenterY()));
        }
    }
}

