/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.BaseIcon;
import java.awt.BasicStroke;
import java.awt.Graphics2D;

public class PlexerIcon
extends BaseIcon {
    private static final int[] xpos = new int[]{4, 4, 10, 10};
    private static final int[] ypos = new int[]{0, 14, 9, 5};
    private final boolean inverted;
    private final boolean singleInput;

    public PlexerIcon(boolean demux, boolean singleInput) {
        this.inverted = demux;
        this.singleInput = singleInput;
    }

    @Override
    protected void paintIcon(Graphics2D g2) {
        g2.setStroke(new BasicStroke(this.scale(2)));
        int[] realPosX = new int[4];
        int[] realPosY = new int[4];
        int xOffset = this.inverted ? 2 : 0;
        for (int i = 0; i < 4; ++i) {
            realPosX[i] = this.scale(xpos[i + xOffset & 3]);
            realPosY[i] = this.scale(ypos[i]);
        }
        g2.drawPolygon(realPosX, realPosY, 4);
        xOffset = this.inverted ? this.scale(7) : this.scale(8);
        g2.drawLine(xOffset, this.scale(11), xOffset, this.scale(15));
        xOffset = this.inverted ? this.scale(xpos[0] - 1) : this.scale(xpos[2] - 1);
        int yOffset = this.scale(ypos[3] + 1);
        g2.setColor(Value.trueColor);
        g2.fillOval(xOffset, yOffset, this.scale(3), this.scale(3));
        int n = xOffset = this.inverted ? this.scale(xpos[2] - 1) : this.scale(xpos[0] - 1);
        if (this.singleInput) {
            g2.fillOval(xOffset, yOffset, this.scale(3), this.scale(3));
        } else {
            g2.fillOval(xOffset, this.scale(1), this.scale(3), this.scale(3));
            g2.fillOval(xOffset, this.scale(11), this.scale(3), this.scale(3));
        }
    }
}

