/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.gui.log.Signal;
import com.cburch.logisim.util.UniquelyNamedThread;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Objects;

class LogThread
extends UniquelyNamedThread
implements Model.Listener {
    private static final int FLUSH_FREQUENCY = 500;
    private static final int IDLE_UNTIL_CLOSE = 10000;
    private final Model model;
    private final Object lock = new Object();
    private boolean canceled = false;
    private PrintWriter writer = null;
    private boolean modeDirty = true;
    private boolean headerDirty = true;
    private long lastWrite = 0L;
    private long timeNextWrite = 0L;
    private final HashMap<Signal, Signal.Iterator> cursors = new HashMap();

    public LogThread(Model model) {
        super("LogThread");
        this.model = model;
        model.addModelListener(this);
    }

    private void writeSignals() {
        if (this.writer == null) {
            try {
                this.writer = new PrintWriter(new FileWriter(this.model.getFile(), true));
            }
            catch (IOException e) {
                this.model.setFile(null);
                return;
            }
        }
        if (this.modeDirty) {
            String mode = this.model.isStepMode() ? "step" : (this.model.isRealMode() ? "real-time" : "clocked");
            String gran = this.model.isFine() ? "fine" : "coarse";
            this.writer.println("# mode: " + mode + " granularity: " + gran);
            this.modeDirty = false;
        }
        if (this.headerDirty) {
            if (this.model.getFileHeader()) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.model.getSignalCount(); ++i) {
                    if (i > 0) {
                        buf.append("\t");
                    }
                    buf.append(this.model.getItem(i).getDisplayName());
                }
                this.writer.println(buf);
            }
            this.headerDirty = false;
        }
        Signal.Iterator[] cur = new Signal.Iterator[this.model.getSignalCount()];
        for (int i = 0; i < this.model.getSignalCount(); ++i) {
            Signal s = this.model.getSignal(i);
            cur[i] = this.cursors.get(s);
            if (cur[i] != null) continue;
            Signal signal = s;
            Objects.requireNonNull(signal);
            cur[i] = signal.new Signal.Iterator(this.timeNextWrite);
            this.cursors.put(s, cur[i]);
        }
        long timeStop = this.model.getEndTime();
        while (this.timeNextWrite < timeStop) {
            long duration = timeStop - this.timeNextWrite;
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < cur.length; ++i) {
                if (i > 0) {
                    buf.append("\t");
                }
                buf.append(cur[i].getFormattedValue());
                if (cur[i].duration >= duration) continue;
                duration = cur[i].duration;
            }
            this.writer.println(buf + "\t# " + Model.formatDuration(duration));
            for (Signal.Iterator c : cur) {
                c.advance(duration);
            }
            this.timeNextWrite += duration;
        }
        this.lastWrite = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.canceled = true;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalsReset(Model.Event event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.writing()) {
                this.timeNextWrite = 0L;
                this.cursors.clear();
                this.writeSignals();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalsExtended(Model.Event event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.writing()) {
                this.writeSignals();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filePropertyChanged(Model.Event event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.writing()) {
                if (this.writer == null) {
                    this.writeSignals();
                }
            } else if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    private boolean writing() {
        return !this.canceled && this.model.isSelected() && this.model.isFileEnabled() && this.model.getFile() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        while (!this.canceled) {
            object = this.lock;
            synchronized (object) {
                if (this.writer != null) {
                    if (System.currentTimeMillis() - this.lastWrite > 10000L) {
                        this.writer.close();
                        this.writer = null;
                    } else {
                        this.writer.flush();
                    }
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged(Model.Event event) {
        Object object = this.lock;
        synchronized (object) {
            this.cursors.keySet().retainAll(this.model.getSignals());
            this.headerDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modeChanged(Model.Event event) {
        Object object = this.lock;
        synchronized (object) {
            this.modeDirty = true;
        }
    }

    @Override
    public void historyLimitChanged(Model.Event event) {
    }
}

