/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.log.ClockSource;
import com.cburch.logisim.gui.log.LogFrame;
import com.cburch.logisim.gui.log.LogPanel;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.gui.log.SignalInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

class OptionsPanel
extends LogPanel
implements ActionListener,
ChangeListener,
Model.Listener {
    private static final long serialVersionUID = 1L;
    final JButton selectionButton;
    final JRadioButton stepTime = new JRadioButton();
    final JRadioButton realTime = new JRadioButton();
    final JRadioButton clockTime = new JRadioButton();
    final JCheckBox stepFine = new JCheckBox();
    final JCheckBox realFine = new JCheckBox();
    final JCheckBox clockFine = new JCheckBox();
    final TimeSelector stepScale = new TimeSelector("timeScale", 5000L);
    final TimeSelector stepGate = new TimeSelector("gateDelay", 200L);
    final TimeSelector realScale = new TimeSelector("timeScale", 5000L, "perSecond");
    final TimeSelector clockScale = new TimeSelector("timeScale", 5000L, "perTick");
    final TimeSelector clockGate = new TimeSelector("gateDelay", 200L);
    final JLabel clockSrcLabel = new JLabel();
    final JButton clockSrcButton = new JButton();
    final String[] clockDisciplineNames = new String[]{"clockDisciplineDual", "clockDisciplineRising", "clockDisciplineFalling", "clockDisciplineHigh", "clockDisciplineLow"};
    final int[] clockDisciplines = new int[]{30, 40, 50, 60, 70};
    final JLabeledComboBox<String> clockDiscipline = new JLabeledComboBox<String>("clockDisciplineLabel", this.clockDisciplineNames);
    final JLabel clockTicks = new JLabel();
    final JCheckBox unlimited = new JCheckBox();
    final JSpinner limit = new JSpinner();
    final JLabel limitLabel = new JLabel();
    final JLabel description = new JLabel();
    final JPanel selectionPanel = new JPanel();
    final Box modePanel = new Box(1);
    final JPanel optionsPanel = new JPanel(new CardLayout());
    final Box stepOptionsPanel = new Box(1);
    final Box realOptionsPanel = new Box(1);
    final Box clockOptionsPanel = new Box(1);
    final Box historyPanel = new Box(1);
    final JScrollPane pane;

    OptionsPanel(LogFrame frame) {
        super(frame);
        this.selectionButton = frame.makeSelectionButton();
        this.selectionPanel.add(this.selectionButton);
        ButtonGroup g = new ButtonGroup();
        g.add(this.stepTime);
        g.add(this.realTime);
        g.add(this.clockTime);
        this.modePanel.add(this.stepTime);
        this.modePanel.add(this.realTime);
        this.modePanel.add(this.clockTime);
        this.stepFine.setAlignmentX(0.0f);
        this.stepFine.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.stepOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.stepOptionsPanel.add(this.stepFine);
        this.stepOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.stepOptionsPanel.add(this.stepScale.getPanel());
        this.stepOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.stepOptionsPanel.add(this.stepGate.getPanel());
        this.stepOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.realFine.setAlignmentX(0.0f);
        this.realFine.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.realOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.realOptionsPanel.add(this.realFine);
        this.realOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.realOptionsPanel.add(this.realScale.getPanel());
        this.realOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.clockFine.setAlignmentX(0.0f);
        this.clockFine.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.clockOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.clockOptionsPanel.add(this.clockFine);
        this.clockOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.clockOptionsPanel.add(this.clockScale.getPanel());
        this.clockOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.clockOptionsPanel.add(this.clockGate.getPanel());
        this.clockOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        Box clockSrcBox = new Box(0);
        clockSrcBox.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        clockSrcBox.setAlignmentX(0.0f);
        clockSrcBox.add(this.clockSrcLabel);
        clockSrcBox.add(Box.createRigidArea(new Dimension(6, 0)));
        clockSrcBox.add(this.clockSrcButton);
        this.clockOptionsPanel.add(clockSrcBox);
        this.clockOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.clockOptionsPanel.add(this.clockDiscipline.getPanel());
        this.clockOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.clockTicks.setAlignmentX(0.0f);
        this.clockTicks.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.clockOptionsPanel.add(this.clockTicks);
        this.clockOptionsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.optionsPanel.add((Component)this.stepOptionsPanel, "stepTime");
        this.optionsPanel.add((Component)this.realOptionsPanel, "realTime");
        this.optionsPanel.add((Component)this.clockOptionsPanel, "clockTime");
        this.limit.setModel(new SpinnerNumberModel(400, 10, Integer.MAX_VALUE, 100));
        this.limit.setEditor(new JSpinner.NumberEditor(this.limit, "####"));
        this.limit.setMaximumSize(this.limit.getPreferredSize());
        this.unlimited.setAlignmentX(0.0f);
        Box limitBox = new Box(0);
        limitBox.add(this.limitLabel);
        limitBox.add(Box.createRigidArea(new Dimension(6, 0)));
        limitBox.add(this.limit);
        limitBox.setAlignmentX(0.0f);
        this.historyPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.historyPanel.add(this.unlimited);
        this.historyPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.historyPanel.add(limitBox);
        this.historyPanel.add(Box.createVerticalGlue());
        ScrollablePanel inner = new ScrollablePanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        inner.setLayout(gb);
        gc.fill = 1;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.gridy = 0;
        gc.gridx = 0;
        gb.setConstraints(this.selectionPanel, gc);
        inner.add(this.selectionPanel);
        gc.gridy = 1;
        gb.setConstraints(this.modePanel, gc);
        inner.add(this.modePanel);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridheight = 2;
        gb.setConstraints(this.optionsPanel, gc);
        inner.add(this.optionsPanel);
        gc.gridx = 2;
        gb.setConstraints(this.historyPanel, gc);
        inner.add(this.historyPanel);
        Component fill = Box.createGlue();
        gc.gridx = 3;
        gb.setConstraints(fill, gc);
        inner.add(fill);
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridheight = 1;
        gc.gridwidth = 4;
        gb.setConstraints(this.description, gc);
        inner.add(this.description);
        this.description.setFont(this.description.getFont().deriveFont(0));
        this.pane = new JScrollPane(inner, 20, 30);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pane, "Center");
        this.unlimited.addActionListener(this);
        this.limit.addChangeListener(this);
        this.stepTime.addActionListener(this);
        this.realTime.addActionListener(this);
        this.clockTime.addActionListener(this);
        this.stepFine.addActionListener(this);
        this.realFine.addActionListener(this);
        this.clockFine.addActionListener(this);
        this.stepScale.addActionListener(this);
        this.stepGate.addActionListener(this);
        this.realScale.addActionListener(this);
        this.clockScale.addActionListener(this);
        this.clockGate.addActionListener(this);
        this.clockSrcButton.addActionListener(this);
        this.clockDiscipline.addActionListener(this);
        this.stepTime.setSelected(false);
        this.realTime.setSelected(false);
        this.clockTime.setSelected(false);
        this.modelChanged(null, this.getModel());
        this.localeChanged();
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                OptionsPanel.this.pane.getVerticalScrollBar().setValue(0);
                OptionsPanel.this.pane.getHorizontalScrollBar().setValue(0);
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Model m = this.getLogFrame().getModel();
        this.limit.setEnabled(!this.unlimited.isSelected());
        if (this.unlimited.isSelected()) {
            m.setHistoryLimit(0);
        } else {
            try {
                this.limit.commitEdit();
            }
            catch (ParseException ex) {
                JComponent editor = this.limit.getEditor();
                ((JSpinner.NumberEditor)editor).getTextField().setValue(this.limit.getValue());
            }
            m.setHistoryLimit((Integer)this.limit.getValue());
        }
    }

    private void doClockSourceDialog() {
        Model m = this.getLogFrame().getModel();
        SignalInfo item = ClockSource.doClockObserverDialog(m.getCircuit());
        if (item == null) {
            return;
        }
        m.setClockSourceInfo(item);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Model m = this.getLogFrame().getModel();
        if (e.getSource() == this.unlimited) {
            this.stateChanged(null);
        } else if (e.getSource() == this.clockSrcButton) {
            this.doClockSourceDialog();
        } else {
            if (this.stepTime.isSelected()) {
                m.setStepMode(this.stepFine.isSelected(), (Long)this.stepScale.getValue(), (Long)this.stepGate.getValue());
            } else if (this.realTime.isSelected()) {
                m.setRealMode((Long)this.realScale.getValue(), this.realFine.isSelected());
            } else {
                String d = this.clockDiscipline.getValue();
                int discipline = this.clockDisciplines[Arrays.asList(this.clockDisciplineNames).indexOf(d)];
                m.setClockMode(this.clockFine.isSelected(), discipline, (Long)this.clockScale.getValue(), (Long)this.clockGate.getValue());
            }
            this.updateDescription();
        }
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("optionsHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("optionsTab");
    }

    @Override
    public void localeChanged() {
        this.selectionPanel.setBorder(BorderFactory.createTitledBorder(Strings.S.get("selectionLabel")));
        this.modePanel.setBorder(BorderFactory.createTitledBorder(Strings.S.get("modeLabel")));
        this.historyPanel.setBorder(BorderFactory.createTitledBorder(Strings.S.get("historyLabel")));
        this.stepTime.setText(Strings.S.get("stepTime"));
        this.realTime.setText(Strings.S.get("realTime"));
        this.clockTime.setText(Strings.S.get("clockTime"));
        this.stepFine.setText(Strings.S.get("fineDetail"));
        this.realFine.setText(Strings.S.get("fineDetail"));
        this.clockFine.setText(Strings.S.get("fineDetail"));
        this.unlimited.setText(Strings.S.get("historyUnlimited"));
        this.limitLabel.setText(Strings.S.get("historyLimit"));
        this.clockSrcLabel.setText(Strings.S.get("clockSourceLabel"));
        this.stepScale.localeChanged();
        this.stepGate.localeChanged();
        this.realScale.localeChanged();
        this.clockScale.localeChanged();
        this.clockGate.localeChanged();
        this.updateDescription();
    }

    void updateDescription() {
        String d;
        String mode;
        this.limit.setEnabled(!this.unlimited.isSelected());
        if (this.stepTime.isSelected()) {
            mode = "stepTime";
            boolean fine = this.stepFine.isSelected();
            this.stepGate.setEnabled(fine);
            d = fine ? Strings.S.get("stepFineDescription", this.stepGate.getText(), this.stepScale.getText()) : Strings.S.get("stepCoarseDescription", this.stepScale.getText());
            this.realFine.setSelected(fine);
            this.clockFine.setSelected(fine);
            this.realScale.setSelectedItem(this.stepScale.getValue());
            this.clockScale.setSelectedItem(this.stepScale.getValue());
            this.clockGate.setSelectedItem(this.stepGate.getValue());
        } else if (this.realTime.isSelected()) {
            mode = "realTime";
            boolean fine = this.realFine.isSelected();
            d = fine ? Strings.S.get("realFineDescription", this.realScale.getText()) : Strings.S.get("realCoarseDescription", this.realScale.getText());
            this.stepFine.setSelected(fine);
            this.clockFine.setSelected(fine);
            this.stepScale.setSelectedItem(this.realScale.getValue());
            this.clockScale.setSelectedItem(this.realScale.getValue());
        } else {
            mode = "clockTime";
            boolean fine = this.clockFine.isSelected();
            String disciplineName = this.clockDiscipline.getValue();
            int discipline = this.clockDisciplines[Arrays.asList(this.clockDisciplineNames).indexOf(disciplineName)];
            boolean levelSensitive = discipline == 60 || discipline == 70;
            this.clockGate.setEnabled(fine || levelSensitive);
            int ticks = 2;
            Model m = this.getLogFrame().getModel();
            SignalInfo clockSource = m.getClockSourceInfo();
            if (clockSource == null) {
                this.clockSrcButton.setIcon(null);
                this.clockSrcButton.setText(Strings.S.get("clockSourceNone"));
            } else {
                this.clockSrcButton.setIcon(clockSource.icon);
                this.clockSrcButton.setText(clockSource.getDisplayName());
                ticks = ClockSource.getCycleInfo((SignalInfo)clockSource).ticks;
            }
            this.clockTicks.setText(Strings.S.get("cycleLength", ticks));
            String dgate = this.clockGate.getText();
            Long t = (Long)this.clockScale.getValue();
            String dCycle = this.clockScale.renderAsText(t * (long)ticks);
            String dTick = this.clockScale.renderAsText(t);
            d = fine ? Strings.S.get("clockFineDescription", dgate, dCycle, dTick) : (discipline == 30 ? Strings.S.get("clockCoarseDescriptionDual", dCycle, dTick) : (discipline == 40 ? Strings.S.get("clockCoarseDescriptionRising", dCycle, dTick) : (discipline == 50 ? Strings.S.get("clockCoarseDescriptionFalling", dCycle, dTick) : (discipline == 60 ? Strings.S.get("clockCoarseDescriptionHigh", dgate, dCycle, dTick) : Strings.S.get("clockCoarseDescriptionLow", dgate, dCycle, dTick)))));
            this.stepFine.setSelected(fine);
            this.realFine.setSelected(fine);
            this.stepScale.setSelectedItem(this.clockScale.getValue());
            this.realScale.setSelectedItem(this.clockScale.getValue());
            this.stepGate.setSelectedItem(this.clockGate.getValue());
        }
        ((CardLayout)this.optionsPanel.getLayout()).show(this.optionsPanel, mode);
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(Strings.S.get("timingLabel") + ": " + Strings.S.get(mode)));
        this.description.setText("<html>" + d + "</html>");
    }

    @Override
    public void modelChanged(Model oldModel, Model newModel) {
        SignalInfo clockSource;
        if (oldModel != null) {
            oldModel.removeModelListener(this);
        }
        if (newModel != null) {
            newModel.addModelListener(this);
        }
        this.modeChanged(null);
        this.stepScale.setSelectedItem(newModel.getTimeScale());
        this.realScale.setSelectedItem(newModel.getTimeScale());
        this.clockScale.setSelectedItem(newModel.getTimeScale());
        this.stepGate.setSelectedItem(newModel.getGateDelay());
        this.clockGate.setSelectedItem(newModel.getGateDelay());
        this.stepFine.setSelected(newModel.isFine());
        this.realFine.setSelected(newModel.isFine());
        this.clockFine.setSelected(newModel.isFine());
        this.updateDescription();
        int n = newModel.getHistoryLimit();
        this.unlimited.setSelected(n == 0);
        if (n > 0) {
            this.limit.setValue(n);
        }
        if ((clockSource = newModel.getClockSourceInfo()) == null) {
            this.clockSrcButton.setIcon(null);
            this.clockSrcButton.setText(Strings.S.get("clockSourceNone"));
        } else {
            this.clockSrcButton.setIcon(clockSource.icon);
            this.clockSrcButton.setText(clockSource.getDisplayName());
        }
    }

    @Override
    public void modeChanged(Model.Event event) {
        Model m = this.getLogFrame().getModel();
        if (m.isStepMode()) {
            this.stepTime.setSelected(true);
        } else if (m.isRealMode()) {
            this.realTime.setSelected(true);
        } else {
            this.clockTime.setSelected(true);
        }
        int discipline = m.getClockDiscipline();
        for (int i = 0; i < this.clockDisciplines.length; ++i) {
            if (discipline != this.clockDisciplines[i]) continue;
            this.clockDiscipline.setSelectedItem(this.clockDisciplineNames[i]);
        }
    }

    static class TimeSelector
    extends JLabeledComboBox<Long> {
        private static final long serialVersionUID = 1L;
        String suffix;
        static final Long[] defaultVals = new Long[]{1L, 2L, 5L, 10L, 50L, 100L, 200L, 500L, 1000L, 2000L, 5000L, 10000L, 20000L, 50000L, 100000L, 200000L, 500000L, 1000000L, 2000000L, 5000000L, 10000000L, 20000000L, 50000000L, 100000000L, 200000000L, 500000000L, 1000000000L};

        TimeSelector(String labelKey, long nsDefault, String suffix) {
            super(labelKey, defaultVals);
            this.setSelectedItem(nsDefault);
        }

        TimeSelector(String labelKey, long nsDefault) {
            this(labelKey, nsDefault, null);
        }

        @Override
        String renderAsText(Long v) {
            Object s = Model.formatDuration(v);
            if (this.suffix != null) {
                s = (String)s + " " + Strings.S.get(this.suffix);
            }
            return s;
        }
    }

    static class JLabeledComboBox<E>
    extends JComboBox<E> {
        private static final long serialVersionUID = 1L;
        final String labelKey;
        final JLabel label = new JLabel();
        final JPanel panel = new JPanel();

        JLabeledComboBox(String labelKey, E[] items) {
            super(items);
            this.setRenderer(new Renderer());
            this.labelKey = labelKey;
            this.label.setText(Strings.S.get(labelKey));
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.panel.add(this.label);
            this.panel.add(this);
            this.panel.setMaximumSize(this.panel.getPreferredSize());
            this.panel.setAlignmentX(0.0f);
        }

        void localeChanged() {
            this.label.setText(Strings.S.get(this.labelKey));
            this.repaint();
        }

        JPanel getPanel() {
            return this.panel;
        }

        E getValue() {
            return this.getItemAt(this.getSelectedIndex());
        }

        String renderAsText(E v) {
            return v instanceof String ? Strings.S.get((String)v) : v.toString();
        }

        String getText() {
            return this.renderAsText(this.getValue());
        }

        class Renderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;

            Renderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object w, int index, boolean isSelected, boolean cellHasFocus) {
                String s = JLabeledComboBox.this.renderAsText(w);
                return super.getListCellRendererComponent(list, s, index, isSelected, cellHasFocus);
            }
        }
    }

    static class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1L;

        ScrollablePanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    static class TimeVerifier
    extends InputVerifier {
        final String suffix;
        long scale;
        long value;
        boolean matched;
        String text;

        public TimeVerifier(String s) {
            this.suffix = s;
        }

        void trySuffix(String suffix, long v) {
            if (!this.text.endsWith(suffix = suffix.trim())) {
                return;
            }
            this.text = this.text.substring(0, this.text.length() - suffix.length());
            this.scale = v;
            this.matched = true;
        }

        @Override
        public boolean verify(JComponent input) {
            this.text = ((JTextField)input).getText().trim();
            String s = Strings.S.get(this.suffix);
            if (this.text.endsWith(s)) {
                this.text = this.text.substring(0, this.text.length() - s.length()).trim();
            }
            this.scale = 1L;
            this.matched = false;
            if (!this.matched) {
                this.trySuffix("ns", 1L);
            }
            if (!this.matched) {
                this.trySuffix("nsec", 1L);
            }
            if (!this.matched) {
                this.trySuffix(Strings.S.get("nsFormat", ""), 1L);
            }
            if (!this.matched) {
                this.trySuffix("us", 1000L);
            }
            if (!this.matched) {
                this.trySuffix("usec", 1000L);
            }
            if (!this.matched) {
                this.trySuffix(Strings.S.get("usFormat", ""), 1000L);
            }
            if (!this.matched) {
                this.trySuffix("ms", 1000000L);
            }
            if (!this.matched) {
                this.trySuffix("msec", 1000000L);
            }
            if (!this.matched) {
                this.trySuffix(Strings.S.get("msFormat", ""), 1000000L);
            }
            if (!this.matched) {
                this.trySuffix("s", 1000000000L);
            }
            if (!this.matched) {
                this.trySuffix("sec", 1000000000L);
            }
            if (!this.matched) {
                this.trySuffix(Strings.S.get("sFormat", ""), 1000000000L);
            }
            if (!this.matched) {
                this.scale = 1000000L;
            }
            try {
                this.value = Long.parseLong(this.text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    static class TimeEditor
    extends BasicComboBoxEditor {
        final String suffix;
        final TimeVerifier verifier;

        public TimeEditor(String s) {
            this.suffix = s;
            this.verifier = new TimeVerifier(this.suffix);
        }

        @Override
        protected JTextField createEditorComponent() {
            JTextField f = super.createEditorComponent();
            f.setInputVerifier(this.verifier);
            return f;
        }

        @Override
        public Object getItem() {
            return this.verifier.matched ? Long.valueOf(this.verifier.value * this.verifier.scale) : null;
        }
    }
}

