/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.gui.log.SignalInfo;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.IconsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class SelectionList
extends JTable {
    private static final long serialVersionUID = 1L;
    private Model logModel;
    private static final Font MSG_FONT = new Font("Sans Serif", 2, 12);

    public SelectionList() {
        this.setModel(new SelectionListModel());
        this.setDefaultRenderer(SignalInfo.class, new SignalInfoRenderer());
        this.setDefaultEditor(SignalInfo.class, new SignalInfoEditor());
        this.setSelectionMode(2);
        this.getTableHeader().setUI(null);
        this.setRowHeight(24);
        this.setShowGrid(false);
        this.setFillsViewportHeight(true);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setTransferHandler(new SelectionTransferHandler());
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "Delete");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("Delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionList.this.removeSelected();
            }
        });
    }

    void removeSelected() {
        int idx = 0;
        SignalInfo.List items = this.getSelectedValuesList();
        for (SignalInfo item : items) {
            idx = Math.max(idx, this.logModel.indexOf(item));
        }
        int count = this.logModel.remove(items);
        if (count > 0 && this.logModel.getSignalCount() > 0) {
            idx = Math.min(idx + 1 - count, this.logModel.getSignalCount() - 1);
            this.setRowSelectionInterval(idx, idx);
        }
        this.repaint();
    }

    public void localeChanged() {
        this.repaint();
    }

    public void setLogModel(Model m) {
        if (this.logModel != m) {
            SelectionListModel listModel = (SelectionListModel)this.getModel();
            if (this.logModel != null) {
                this.logModel.removeModelListener(listModel);
            }
            this.logModel = m;
            if (this.logModel != null) {
                this.logModel.addModelListener(listModel);
            }
            listModel.selectionChanged(null);
        }
    }

    SignalInfo.List getSelectedValuesList() {
        int[] sel;
        SignalInfo.List items = new SignalInfo.List();
        for (int i : sel = this.getSelectedRows()) {
            items.add(this.logModel.getItem(i));
        }
        return items;
    }

    private void addOrMove(SignalInfo.List items, int idx) {
        if (CollectionUtil.isNullOrEmpty(items)) {
            return;
        }
        this.logModel.addOrMove(items, idx);
        this.clearSelection();
        for (SignalInfo item : items) {
            int i = this.logModel.indexOf(item);
            this.addRowSelectionInterval(i, i);
        }
    }

    public void add(SignalInfo.List items) {
        this.addOrMove(items, this.logModel.getSignalCount());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font f = g.getFont();
        Color c = g.getColor();
        g.setColor(Color.GRAY);
        g.setFont(MSG_FONT);
        g.drawString("drag here to add", 10, this.getRowHeight() * this.getRowCount() + 20);
        g.setFont(f);
        g.setColor(c);
    }

    private class SelectionListModel
    extends AbstractTableModel
    implements Model.Listener {
        private static final long serialVersionUID = 1L;

        private SelectionListModel() {
        }

        @Override
        public void selectionChanged(Model.Event event) {
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return SignalInfo.class;
        }

        @Override
        public int getRowCount() {
            return SelectionList.this.logModel == null ? 0 : SelectionList.this.logModel.getSignalCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return SelectionList.this.logModel.getItem(row);
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }

    private static class SignalInfoRenderer
    extends DefaultTableCellRenderer {
        private SignalInfoRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component ret = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (ret instanceof JLabel) {
                JLabel label = (JLabel)ret;
                if (value instanceof SignalInfo) {
                    SignalInfo item = (SignalInfo)value;
                    label.setIcon(item.icon);
                    label.setText(item + " [" + item.getRadix().toDisplayString() + "]");
                }
            }
            return ret;
        }
    }

    class SignalInfoEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        final JPanel panel = new JPanel();
        final JLabel label = new JLabel();
        final JButton button = new JButton(IconsUtil.getIcon("dropdown.png"));
        final JPopupMenu popup = new JPopupMenu("Options");
        SignalInfo item;
        SignalInfo.List items;
        final Map<RadixOption, JRadioButtonMenuItem> radixMenuItems = new HashMap<RadixOption, JRadioButtonMenuItem>();

        public SignalInfoEditor() {
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.label.setFont(this.label.getFont().deriveFont(0));
            this.button.setFont(this.button.getFont().deriveFont(9.0f));
            ButtonGroup g = new ButtonGroup();
            for (RadixOption r : RadixOption.OPTIONS) {
                JRadioButtonMenuItem m = new JRadioButtonMenuItem(r.toDisplayString());
                this.radixMenuItems.put(r, m);
                this.popup.add(m);
                g.add(m);
                m.addActionListener(e -> {
                    for (SignalInfo s : this.items) {
                        SelectionList.this.logModel.setRadix(s, r);
                    }
                    if (this.item != null) {
                        this.label.setText(this.item + " [" + this.item.getRadix().toDisplayString() + "]");
                    }
                    SelectionList.this.repaint();
                });
            }
            this.popup.addSeparator();
            JMenuItem m = new JMenuItem("Delete");
            this.popup.add(m);
            m.addActionListener(e -> {
                this.cancelCellEditing();
                SelectionList.this.removeSelected();
            });
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.setHorizontalTextPosition(2);
            this.button.setText("Options");
            this.button.addActionListener(e -> this.popup.show(this.panel, this.button.getX(), this.button.getY() + this.button.getHeight()));
            this.button.setMinimumSize(this.button.getPreferredSize());
            this.label.setHorizontalAlignment(2);
            this.label.setAlignmentX(0.0f);
            this.label.setAlignmentY(0.5f);
            this.button.setAlignmentX(1.0f);
            this.button.setAlignmentY(0.5f);
            this.panel.add(this.label);
            this.panel.add(this.button);
        }

        @Override
        public Object getCellEditorValue() {
            return this.item;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int margin = SelectionList.this.getColumnModel().getColumnMargin();
            this.label.setBorder(BorderFactory.createEmptyBorder(0, margin, 0, margin));
            Dimension d = new Dimension(SelectionList.this.getColumnModel().getTotalColumnWidth(), SelectionList.this.getRowHeight());
            this.label.setMinimumSize(new Dimension(10, d.height));
            this.label.setPreferredSize(new Dimension(d.width - this.button.getWidth(), d.height));
            this.label.setMaximumSize(new Dimension(d.width - this.button.getWidth(), d.height));
            this.panel.setBackground(isSelected ? SelectionList.this.getSelectionBackground() : SelectionList.this.getBackground());
            this.item = (SignalInfo)value;
            this.items = SelectionList.this.getSelectedValuesList();
            if (!this.items.contains(this.item)) {
                this.items.clear();
                this.items.add(this.item);
            }
            this.radixMenuItems.get(this.item.getRadix()).setSelected(true);
            this.label.setIcon(this.item.icon);
            this.label.setText(this.item.toString() + " [" + this.item.getRadix().toDisplayString() + "]");
            return this.panel;
        }

        @Override
        public boolean stopCellEditing() {
            super.stopCellEditing();
            return true;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }
    }

    private class SelectionTransferHandler
    extends TransferHandler {
        boolean removing;

        private SelectionTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent comp) {
            return 2;
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            this.removing = true;
            SignalInfo.List items = new SignalInfo.List();
            items.addAll(SelectionList.this.getSelectedValuesList());
            return items.isEmpty() ? null : items;
        }

        @Override
        public void exportDone(JComponent comp, Transferable trans, int action) {
            if (this.removing) {
                SelectionList.this.logModel.remove(SelectionList.this.getSelectedValuesList());
            }
            this.removing = false;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(SignalInfo.List.dataFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            this.removing = false;
            try {
                SignalInfo.List items = (SignalInfo.List)support.getTransferable().getTransferData(SignalInfo.List.dataFlavor);
                int newIdx = SelectionList.this.logModel.getSignalCount();
                if (support.isDrop()) {
                    try {
                        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
                        newIdx = Math.min(dl.getRow(), SelectionList.this.logModel.getSignalCount());
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                SelectionList.this.addOrMove(items, newIdx);
                return true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

