/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.contracts.BaseMouseInputListenerContract;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Propagator;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.WidthIncompatibilityData;
import com.cburch.logisim.circuit.WireSet;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.MouseMappings;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.CanvasPane;
import com.cburch.logisim.gui.generic.CanvasPaneContents;
import com.cburch.logisim.gui.generic.GridPainter;
import com.cburch.logisim.gui.generic.ZoomControl;
import com.cburch.logisim.gui.generic.ZoomModel;
import com.cburch.logisim.gui.main.CanvasPaintThread;
import com.cburch.logisim.gui.main.CanvasPainter;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.gui.main.TickCounter;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.EditTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.PokeTool;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.tools.ToolTipMaker;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.vhdl.base.HdlModel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class Canvas
extends JPanel
implements LocaleListener,
CanvasPaneContents,
AdjustmentListener {
    public static final byte ZOOM_BUTTON_SIZE = 52;
    public static final byte ZOOM_BUTTON_MARGIN = 30;
    public static final Color HALO_COLOR = new Color(255, 0, 255);
    static final double SQRT_2 = Math.sqrt(2.0);
    private static final long serialVersionUID = 1L;
    private static final int THRESH_SIZE_UPDATE = 10;
    private static final int BUTTONS_MASK = 7168;
    private static final Color DEFAULT_ERROR_COLOR;
    private static final Color OSC_ERR_COLOR;
    private static final Color SIM_EXCEPTION_COLOR;
    private static final Font ERR_MSG_FONT;
    private static final Color TICK_RATE_COLOR;
    private static final Font TICK_RATE_FONT;
    private static final Color SINGLE_STEP_MSG_COLOR;
    private static final Font SINGLE_STEP_MSG_FONT;
    public static final Color DEFAULT_ZOOM_BUTTON_COLOR;
    private final Project proj;
    private final Selection selection;
    private final MyListener myListener = new MyListener();
    private final MyViewport viewport = new MyViewport();
    private final MyProjectListener myProjectListener = new MyProjectListener();
    private final TickCounter tickCounter;
    private final CanvasPaintThread paintThread;
    private final CanvasPainter painter;
    private final Object repaintLock = new Object();
    private Tool dragTool;
    private Tool tempTool;
    private MouseMappings mappings;
    private CanvasPane canvasPane;
    private Bounds oldPreferredSize;
    private volatile boolean paintDirty = false;
    private boolean inPaint = false;

    public Canvas(Project proj) {
        this.proj = proj;
        this.selection = new Selection(proj, this);
        this.painter = new CanvasPainter(this);
        this.oldPreferredSize = null;
        this.paintThread = new CanvasPaintThread(this);
        this.mappings = proj.getOptions().getMouseMappings();
        this.canvasPane = null;
        this.tickCounter = new TickCounter();
        this.setBackground(new Color(AppPreferences.CANVAS_BG_COLOR.get()));
        this.addMouseListener(this.myListener);
        this.addMouseMotionListener(this.myListener);
        this.addMouseWheelListener(this.myListener);
        this.addKeyListener(this.myListener);
        proj.addProjectListener(this.myProjectListener);
        proj.addLibraryListener(this.myProjectListener);
        proj.addCircuitListener(this.myProjectListener);
        proj.getSimulator().addSimulatorListener(this.tickCounter);
        this.selection.addListener(this.myProjectListener);
        LocaleManager.addLocaleListener(this);
        AttributeSet options = proj.getOptions().getAttributeSet();
        options.addAttributeListener(this.myProjectListener);
        AppPreferences.COMPONENT_TIPS.addPropertyChangeListener(this.myListener);
        AppPreferences.GATE_SHAPE.addPropertyChangeListener(this.myListener);
        AppPreferences.SHOW_TICK_RATE.addPropertyChangeListener(this.myListener);
        AppPreferences.CANVAS_BG_COLOR.addPropertyChangeListener(this.myListener);
        this.loadOptions(options);
        this.paintThread.start();
    }

    public static boolean autoZoomButtonClicked(Dimension sz, double x, double y) {
        return Point2D.distance(x, y, sz.width - 26 - 30, sz.height - 30 - 26) <= 26.0;
    }

    public static void paintAutoZoomButton(Graphics g, Dimension sz, Color zoomButtonColor) {
        Color oldColor = g.getColor();
        g.setColor(TICK_RATE_COLOR);
        g.fillOval(sz.width - 52 - 33, sz.height - 52 - 33, 58, 58);
        g.setColor(zoomButtonColor);
        g.fillOval(sz.width - 52 - 30, sz.height - 52 - 30, 52, 52);
        g.setColor(Value.unknownColor);
        GraphicsUtil.switchToWidth(g, 3);
        int width = sz.width - 30;
        int height = sz.height - 30;
        g.drawOval(width - 39, height - 39, 26, 26);
        g.drawLine(width - 13 + 4, height - 26, width - 39 - 4, height - 26);
        g.drawLine(width - 26, height - 13 + 4, width - 26, height - 39 - 4);
        g.setColor(oldColor);
    }

    public static void snapToGrid(MouseEvent e) {
        int oldX = e.getX();
        int oldY = e.getY();
        int newX = Canvas.snapXToGrid(oldX);
        int newY = Canvas.snapYToGrid(oldY);
        e.translatePoint(newX - oldX, newY - oldY);
    }

    public static int snapXToGrid(int x) {
        if (x < 0) {
            return -((-x + 5) / 10) * 10;
        }
        return (x + 5) / 10 * 10;
    }

    public static int snapYToGrid(int y) {
        if (y < 0) {
            return -((-y + 5) / 10) * 10;
        }
        return (y + 5) / 10 * 10;
    }

    public CanvasPane getCanvasPane() {
        return this.canvasPane;
    }

    @Override
    public void setCanvasPane(CanvasPane value) {
        this.canvasPane = value;
        this.canvasPane.setViewport(this.viewport);
        this.canvasPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.canvasPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.viewport.setView(this);
        this.setOpaque(false);
        this.computeSize(true);
    }

    @Override
    public void center() {
        Graphics g = this.getGraphics();
        Bounds bounds = g != null ? this.proj.getCurrentCircuit().getBounds(this.getGraphics()) : this.proj.getCurrentCircuit().getBounds();
        if (bounds.getHeight() == 0 || bounds.getWidth() == 0) {
            this.setScrollBar(0, 0);
            return;
        }
        int xpos = (int)Math.round((double)bounds.getX() * this.getZoomFactor() - (this.canvasPane.getViewport().getSize().getWidth() - (double)bounds.getWidth() * this.getZoomFactor()) / 2.0);
        int ypos = (int)Math.round((double)bounds.getY() * this.getZoomFactor() - (this.canvasPane.getViewport().getSize().getHeight() - (double)bounds.getHeight() * this.getZoomFactor()) / 2.0);
        this.setScrollBar(xpos, ypos);
    }

    public void closeCanvas() {
        this.paintThread.requestStop();
    }

    private void completeAction() {
        if (this.proj.getCurrentCircuit() == null) {
            return;
        }
        this.computeSize(false);
        if (!this.proj.getSimulator().nudge()) {
            this.paintThread.requestRepaint();
        }
    }

    public void computeSize(boolean immediate) {
        Bounds old;
        if (this.proj.getCurrentCircuit() == null) {
            return;
        }
        Graphics g = this.getGraphics();
        Bounds bounds = g != null ? this.proj.getCurrentCircuit().getBounds(this.getGraphics()) : this.proj.getCurrentCircuit().getBounds();
        int height = 0;
        int width = 0;
        if (bounds != null && this.viewport != null) {
            width = bounds.getX() + bounds.getWidth() + this.viewport.getWidth();
            height = bounds.getY() + bounds.getHeight() + this.viewport.getHeight();
        }
        Dimension dim = this.canvasPane == null ? new Dimension(width, height) : this.canvasPane.supportPreferredSize(width, height);
        if (!immediate && (old = this.oldPreferredSize) != null && Math.abs(old.getWidth() - dim.width) < 10 && Math.abs(old.getHeight() - dim.height) < 10) {
            return;
        }
        this.oldPreferredSize = Bounds.create(0, 0, dim.width, dim.height);
        this.setPreferredSize(dim);
        this.revalidate();
    }

    public Rectangle getViewableRect() {
        Rectangle viewableBase;
        if (this.canvasPane != null) {
            viewableBase = this.canvasPane.getViewport().getViewRect();
        } else {
            Bounds bds = this.proj.getCurrentCircuit().getBounds();
            viewableBase = new Rectangle(0, 0, bds.getWidth(), bds.getHeight());
        }
        double zoom = this.getZoomFactor();
        Rectangle viewable = zoom == 1.0 ? viewableBase : new Rectangle((int)((double)viewableBase.x / zoom), (int)((double)viewableBase.y / zoom), (int)((double)viewableBase.width / zoom), (int)((double)viewableBase.height / zoom));
        return viewable;
    }

    private void computeViewportContents() {
        Set<WidthIncompatibilityData> exceptions = this.proj.getCurrentCircuit().getWidthIncompatibilityData();
        if (exceptions == null || exceptions.size() == 0) {
            this.viewport.setWidthMessage(null);
            return;
        }
        this.viewport.setWidthMessage(Strings.S.get("canvasWidthError") + (String)(exceptions.size() == 1 ? "" : " (" + exceptions.size() + ")"));
        for (WidthIncompatibilityData ex : exceptions) {
            Location p = ex.getPoint(0);
            this.setArrows(p.getX(), p.getY(), p.getX(), p.getY());
        }
    }

    public Circuit getCircuit() {
        return this.proj.getCurrentCircuit();
    }

    public HdlModel getCurrentHdl() {
        return this.proj.getCurrentHdl();
    }

    public CircuitState getCircuitState() {
        return this.proj.getCircuitState();
    }

    Tool getDragTool() {
        return this.dragTool;
    }

    public StringGetter getErrorMessage() {
        return this.viewport.errorMessage;
    }

    public void setErrorMessage(StringGetter message) {
        this.viewport.setErrorMessage(message, null);
    }

    public void setErrorMessage(StringGetter message, Color color) {
        this.viewport.setErrorMessage(message, color);
    }

    GridPainter getGridPainter() {
        return this.painter.getGridPainter();
    }

    Component getHaloedComponent() {
        return this.painter.getHaloedComponent();
    }

    public int getHorizontalScrollBar() {
        return this.canvasPane.getHorizontalScrollBar().getValue();
    }

    public int getVerticalScrollBar() {
        return this.canvasPane.getVerticalScrollBar().getValue();
    }

    public void setVerticalScrollBar(int posY) {
        this.canvasPane.getVerticalScrollBar().setValue(posY);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public Project getProject() {
        return this.proj;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.canvasPane.supportScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.canvasPane.supportScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public Selection getSelection() {
        return this.selection;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        boolean showTips = AppPreferences.COMPONENT_TIPS.getBoolean();
        if (showTips) {
            Canvas.snapToGrid(event);
            Location loc = Location.create(event.getX(), event.getY(), false);
            ComponentUserEvent e = null;
            for (Component comp : this.getCircuit().getAllContaining(loc)) {
                String ret;
                Object makerObj = comp.getFeature(ToolTipMaker.class);
                if (!(makerObj instanceof ToolTipMaker)) continue;
                ToolTipMaker maker = (ToolTipMaker)makerObj;
                if (e == null) {
                    e = new ComponentUserEvent(this, loc.getX(), loc.getY());
                }
                if ((ret = maker.getToolTip(e)) == null) continue;
                this.unrepairMouseEvent(event);
                return ret;
            }
        }
        return null;
    }

    double getZoomFactor() {
        CanvasPane pane = this.canvasPane;
        return pane == null ? 1.0 : pane.getZoomFactor();
    }

    boolean ifPaintDirtyReset() {
        if (this.paintDirty) {
            this.paintDirty = false;
            return false;
        }
        return true;
    }

    boolean isPopupMenuUp() {
        return this.myListener.menuOn;
    }

    private void loadOptions(AttributeSet options) {
        boolean showTips = AppPreferences.COMPONENT_TIPS.getBoolean();
        this.setToolTipText(showTips ? "" : null);
        this.proj.getSimulator().removeSimulatorListener(this.myProjectListener);
        this.proj.getSimulator().addSimulatorListener(this.myProjectListener);
    }

    @Override
    public void localeChanged() {
        this.paintThread.requestRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        if (AppPreferences.AntiAliassing.getBoolean()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.inPaint = true;
        try {
            super.paintComponent(g);
            boolean clear = false;
            do {
                if (clear) {
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                clear = true;
                this.painter.paintContents(g, this.proj);
            } while (this.paintDirty);
            if (this.canvasPane == null) {
                this.viewport.paintContents(g);
            }
        }
        finally {
            this.inPaint = false;
            Object object = this.repaintLock;
            synchronized (object) {
                this.repaintLock.notifyAll();
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        this.repairMouseEvent(e);
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this.repairMouseEvent(e);
        super.processMouseMotionEvent(e);
    }

    @Override
    public void recomputeSize() {
        this.computeSize(true);
    }

    @Override
    public void repaint() {
        if (this.inPaint) {
            this.paintDirty = true;
        } else {
            super.repaint();
        }
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        double zoom = this.getZoomFactor();
        if (zoom < 1.0) {
            int newX = (int)Math.floor((double)x * zoom);
            int newY = (int)Math.floor((double)y * zoom);
            width += x - newX;
            height += y - newY;
            x = newX;
            y = newY;
        } else if (zoom > 1.0) {
            int x1 = (int)Math.ceil((double)(x + width) * zoom);
            int y1 = (int)Math.ceil((double)(y + height) * zoom);
            width = x1 - x;
            height = y1 - y;
        }
        super.repaint(x, y, width, height);
    }

    @Override
    public void repaint(Rectangle r) {
        double zoom = this.getZoomFactor();
        if (zoom == 1.0) {
            super.repaint(r);
        } else {
            this.repaint(r.x, r.y, r.width, r.height);
        }
    }

    private void repairMouseEvent(MouseEvent e) {
        double zoom = this.getZoomFactor();
        if (zoom != 1.0) {
            this.zoomEvent(e, zoom);
        }
    }

    public void updateArrows() {
        if (this.proj.getCurrentCircuit() == null) {
            return;
        }
        Graphics g = this.getGraphics();
        Bounds circBds = g != null ? this.proj.getCurrentCircuit().getBounds(this.getGraphics()) : this.proj.getCurrentCircuit().getBounds();
        if (circBds == null || circBds.getHeight() == 0 || circBds.getWidth() == 0) {
            return;
        }
        int x = circBds.getX();
        int y = circBds.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setArrows(x, y, x + circBds.getWidth(), y + circBds.getHeight());
    }

    public void setArrows(int x0, int y0, int x1, int y1) {
        boolean isSouth;
        Rectangle viewableBase;
        if (this.proj.getCurrentCircuit() == null) {
            return;
        }
        this.viewport.clearArrows();
        if (this.canvasPane != null) {
            viewableBase = this.canvasPane.getViewport().getViewRect();
        } else {
            Graphics g = this.getGraphics();
            Bounds bds = g != null ? this.proj.getCurrentCircuit().getBounds(this.getGraphics()) : this.proj.getCurrentCircuit().getBounds();
            viewableBase = new Rectangle(0, 0, bds.getWidth(), bds.getHeight());
        }
        double zoom = this.getZoomFactor();
        Rectangle viewable = zoom == 1.0 ? viewableBase : new Rectangle((int)((double)viewableBase.x / zoom), (int)((double)viewableBase.y / zoom), (int)((double)viewableBase.width / zoom), (int)((double)viewableBase.height / zoom));
        boolean isWest = x0 < viewable.x;
        boolean isEast = x1 >= viewable.x + viewable.width;
        boolean isNorth = y0 < viewable.y;
        boolean bl = isSouth = y1 >= viewable.y + viewable.height;
        if (isNorth) {
            if (isEast) {
                this.viewport.setNortheast(true);
            }
            if (isWest) {
                this.viewport.setNorthwest(true);
            }
            if (!isWest && !isEast) {
                this.viewport.setNorth(true);
            }
        }
        if (isSouth) {
            if (isEast) {
                this.viewport.setSoutheast(true);
            }
            if (isWest) {
                this.viewport.setSouthwest(true);
            }
            if (!isWest && !isEast) {
                this.viewport.setSouth(true);
            }
        }
        if (isEast && !this.viewport.isSoutheast && !this.viewport.isNortheast) {
            this.viewport.setEast(true);
        }
        if (isWest && !this.viewport.isSouthwest && !this.viewport.isNorthwest) {
            this.viewport.setWest(true);
        }
    }

    void setHaloedComponent(Circuit circ, Component comp) {
        this.painter.setHaloedComponent(circ, comp);
    }

    public void setHighlightedWires(WireSet value) {
        this.painter.setHighlightedWires(value);
    }

    public void setHorizontalScrollBar(int posX) {
        this.canvasPane.getHorizontalScrollBar().setValue(posX);
    }

    public void setScrollBar(int posX, int posY) {
        this.setHorizontalScrollBar(posX);
        this.setVerticalScrollBar(posY);
    }

    public void showPopupMenu(JPopupMenu menu, int x, int y) {
        double zoom = this.getZoomFactor();
        if (zoom != 1.0) {
            x = (int)Math.round((double)x * zoom);
            y = (int)Math.round((double)y * zoom);
        }
        this.myListener.menuOn = true;
        menu.addPopupMenuListener(this.myListener);
        menu.show(this, x, y);
    }

    private void unrepairMouseEvent(MouseEvent e) {
        double zoom = this.getZoomFactor();
        if (zoom != 1.0) {
            this.zoomEvent(e, 1.0 / zoom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRepaintDone() {
        Object object = this.repaintLock;
        synchronized (object) {
            try {
                while (this.inPaint) {
                    this.repaintLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void zoomEvent(MouseEvent e, double zoom) {
        int oldx = e.getX();
        int oldy = e.getY();
        int newx = (int)Math.round((double)e.getX() / zoom);
        int newy = (int)Math.round((double)e.getY() / zoom);
        e.translatePoint(newx - oldx, newy - oldy);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.updateArrows();
    }

    static {
        OSC_ERR_COLOR = DEFAULT_ERROR_COLOR = new Color(192, 0, 0);
        SIM_EXCEPTION_COLOR = DEFAULT_ERROR_COLOR;
        ERR_MSG_FONT = new Font("Sans Serif", 1, 18);
        TICK_RATE_COLOR = new Color(0, 0, 92, 92);
        TICK_RATE_FONT = new Font("Monospaced", 0, 28);
        SINGLE_STEP_MSG_COLOR = Color.BLUE;
        SINGLE_STEP_MSG_FONT = new Font("Sans Serif", 1, 12);
        DEFAULT_ZOOM_BUTTON_COLOR = Color.WHITE;
    }

    private class MyListener
    implements BaseMouseInputListenerContract,
    KeyListener,
    PopupMenuListener,
    PropertyChangeListener,
    MouseWheelListener {
        boolean menuOn = false;

        private MyListener() {
        }

        private Tool getToolFor(MouseEvent e) {
            if (this.menuOn) {
                return null;
            }
            Tool ret = Canvas.this.mappings.getToolFor(e);
            if (ret == null) {
                return Canvas.this.proj.getTool();
            }
            return ret;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Tool tool = Canvas.this.proj.getTool();
            if (tool != null) {
                tool.keyPressed(Canvas.this, e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            Tool tool = Canvas.this.proj.getTool();
            if (tool != null) {
                tool.keyReleased(Canvas.this, e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            Tool tool = Canvas.this.proj.getTool();
            if (tool != null) {
                tool.keyTyped(Canvas.this, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (Canvas.this.dragTool != null) {
                Canvas.this.dragTool.mouseDragged(Canvas.this, Canvas.this.getGraphics(), e);
                ZoomModel zoomModel = Canvas.this.proj.getFrame().getZoomModel();
                double zoomFactor = zoomModel.getZoomFactor();
                Canvas.this.scrollRectToVisible(new Rectangle((int)((double)e.getX() * zoomFactor), (int)((double)e.getY() * zoomFactor), 1, 1));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (Canvas.this.dragTool != null) {
                Canvas.this.dragTool.mouseEntered(Canvas.this, Canvas.this.getGraphics(), e);
            } else {
                Tool tool = this.getToolFor(e);
                if (tool != null) {
                    tool.mouseEntered(Canvas.this, Canvas.this.getGraphics(), e);
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (Canvas.this.dragTool != null) {
                Canvas.this.dragTool.mouseExited(Canvas.this, Canvas.this.getGraphics(), e);
            } else {
                Tool tool = this.getToolFor(e);
                if (tool != null) {
                    tool.mouseExited(Canvas.this, Canvas.this.getGraphics(), e);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if ((e.getModifiersEx() & 0x1C00) != 0) {
                this.mouseDragged(e);
                return;
            }
            Tool tool = this.getToolFor(e);
            if (tool != null) {
                tool.mouseMoved(Canvas.this, Canvas.this.getGraphics(), e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Graphics g;
            Bounds bounds;
            Canvas.this.viewport.setErrorMessage(null, null);
            if (Canvas.this.proj.isStartupScreen() && ((bounds = (g = Canvas.this.getGraphics()) != null ? Canvas.this.proj.getCurrentCircuit().getBounds(Canvas.this.getGraphics()) : Canvas.this.proj.getCurrentCircuit().getBounds()).getHeight() != 0 || bounds.getWidth() != 0)) {
                Canvas.this.proj.setStartupScreen(false);
            }
            if (e.getButton() == 1 && Canvas.this.viewport.zoomButtonVisible && Canvas.autoZoomButtonClicked(Canvas.this.viewport.getSize(), (double)e.getX() * Canvas.this.getZoomFactor() - (double)Canvas.this.getHorizontalScrollBar(), (double)e.getY() * Canvas.this.getZoomFactor() - (double)Canvas.this.getVerticalScrollBar())) {
                Canvas.this.viewport.zoomButtonColor = DEFAULT_ZOOM_BUTTON_COLOR.darker();
                Canvas.this.viewport.repaint();
            } else {
                Canvas.this.requestFocus();
                Canvas.this.dragTool = this.getToolFor(e);
                if (Canvas.this.dragTool != null) {
                    Canvas.this.dragTool.mousePressed(Canvas.this, Canvas.this.getGraphics(), e);
                    if (e.getButton() != 1) {
                        Canvas.this.tempTool = Canvas.this.proj.getTool();
                        Canvas.this.proj.setTool(Canvas.this.dragTool);
                    }
                }
                Canvas.this.completeAction();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Tool tool;
            if (e.getButton() == 1 && Canvas.this.viewport.zoomButtonVisible && Canvas.autoZoomButtonClicked(Canvas.this.viewport.getSize(), (double)e.getX() * Canvas.this.getZoomFactor() - (double)Canvas.this.getHorizontalScrollBar(), (double)e.getY() * Canvas.this.getZoomFactor() - (double)Canvas.this.getVerticalScrollBar()) && Canvas.this.viewport.zoomButtonColor != DEFAULT_ZOOM_BUTTON_COLOR || e.getButton() == 2 && e.getClickCount() == 2) {
                Canvas.this.center();
                Canvas.this.setCursor(Canvas.this.proj.getTool().getCursor());
            }
            if (Canvas.this.dragTool != null) {
                Canvas.this.dragTool.mouseReleased(Canvas.this, Canvas.this.getGraphics(), e);
                Canvas.this.dragTool = null;
            }
            if (Canvas.this.tempTool != null) {
                Canvas.this.proj.setTool(Canvas.this.tempTool);
                Canvas.this.tempTool = null;
            }
            if ((tool = Canvas.this.proj.getTool()) != null && !(tool instanceof EditTool)) {
                tool.mouseMoved(Canvas.this, Canvas.this.getGraphics(), e);
                Canvas.this.setCursor(tool.getCursor());
            }
            Canvas.this.completeAction();
            Canvas.this.viewport.zoomButtonColor = DEFAULT_ZOOM_BUTTON_COLOR;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            Tool tool = Canvas.this.proj.getTool();
            if (mwe.isControlDown()) {
                ZoomControl zoomControl = Canvas.this.proj.getFrame().getZoomControl();
                Canvas.this.repairMouseEvent(mwe);
                if (mwe.getWheelRotation() < 0) {
                    zoomControl.zoomIn();
                } else {
                    zoomControl.zoomOut();
                }
                Rectangle rect = Canvas.this.getViewableRect();
                double zoom = Canvas.this.proj.getFrame().getZoomModel().getZoomFactor();
                Canvas.this.setHorizontalScrollBar((int)((double)(mwe.getX() - rect.width / 2) * zoom));
                Canvas.this.setVerticalScrollBar((int)((double)(mwe.getY() - rect.height / 2) * zoom));
            } else if (tool instanceof PokeTool && ((PokeTool)tool).isScrollable()) {
                int id = mwe.getWheelRotation() < 0 ? 38 : 40;
                KeyEvent e = new KeyEvent(mwe.getComponent(), 401, mwe.getWhen(), 0, id, '\u0000');
                tool.keyPressed(Canvas.this, e);
            } else if (mwe.isShiftDown()) {
                Canvas.this.canvasPane.getHorizontalScrollBar().setValue(this.scrollValue(Canvas.this.canvasPane.getHorizontalScrollBar(), mwe.getWheelRotation()));
            } else {
                Canvas.this.canvasPane.getVerticalScrollBar().setValue(this.scrollValue(Canvas.this.canvasPane.getVerticalScrollBar(), mwe.getWheelRotation()));
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.menuOn = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.menuOn = false;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (AppPreferences.GATE_SHAPE.isSource(event) || AppPreferences.SHOW_TICK_RATE.isSource(event) || AppPreferences.AntiAliassing.isSource(event)) {
                Canvas.this.paintThread.requestRepaint();
            } else if (AppPreferences.COMPONENT_TIPS.isSource(event)) {
                boolean showTips = AppPreferences.COMPONENT_TIPS.getBoolean();
                Canvas.this.setToolTipText(showTips ? "" : null);
            } else if (AppPreferences.CANVAS_BG_COLOR.isSource(event)) {
                Canvas.this.setBackground(new Color(AppPreferences.CANVAS_BG_COLOR.get()));
            }
        }

        private int scrollValue(JScrollBar bar, int val) {
            if (val > 0 ? bar.getValue() < bar.getMaximum() + val * 2 * bar.getBlockIncrement() : bar.getValue() > bar.getMinimum() + val * 2 * bar.getBlockIncrement()) {
                return bar.getValue() + val * 2 * bar.getBlockIncrement();
            }
            return 0;
        }
    }

    private class MyViewport
    extends JViewport {
        private static final long serialVersionUID = 1L;
        StringGetter errorMessage = null;
        String widthMessage = null;
        Color errorColor = DEFAULT_ERROR_COLOR;
        boolean isNorth = false;
        boolean isSouth = false;
        boolean isWest = false;
        boolean isEast = false;
        boolean isNortheast = false;
        boolean isNorthwest = false;
        boolean isSoutheast = false;
        boolean isSouthwest = false;
        boolean zoomButtonVisible = false;
        Color zoomButtonColor = DEFAULT_ZOOM_BUTTON_COLOR;

        MyViewport() {
        }

        void clearArrows() {
            this.isNorth = false;
            this.isSouth = false;
            this.isWest = false;
            this.isEast = false;
            this.isNortheast = false;
            this.isNorthwest = false;
            this.isSoutheast = false;
            this.isSouthwest = false;
        }

        @Override
        public Color getBackground() {
            return this.getView() == null ? super.getBackground() : this.getView().getBackground();
        }

        @Override
        public void paintChildren(Graphics g) {
            super.paintChildren(g);
            this.paintContents(g);
        }

        void paintContents(Graphics g) {
            String hz;
            if (AppPreferences.AntiAliassing.getBoolean()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            int msgY = this.getHeight() - 23;
            StringGetter message = this.errorMessage;
            if (message != null) {
                g.setColor(this.errorColor);
                msgY = this.paintString(g, msgY, message.toString());
            }
            if (Canvas.this.proj.getSimulator().isOscillating()) {
                g.setColor(OSC_ERR_COLOR);
                msgY = this.paintString(g, msgY, Strings.S.get("canvasOscillationError"));
            }
            if (Canvas.this.proj.getSimulator().isExceptionEncountered()) {
                g.setColor(SIM_EXCEPTION_COLOR);
                msgY = this.paintString(g, msgY, Strings.S.get("canvasExceptionError"));
            }
            Canvas.this.computeViewportContents();
            Dimension sz = this.getSize();
            if (this.widthMessage != null) {
                g.setColor(Value.widthErrorColor);
                msgY = this.paintString(g, msgY, this.widthMessage);
            } else {
                g.setColor(TICK_RATE_COLOR);
            }
            if (this.isNorth || this.isSouth || this.isEast || this.isWest || this.isNortheast || this.isNorthwest || this.isSoutheast || this.isSouthwest) {
                this.zoomButtonVisible = true;
                Canvas.paintAutoZoomButton(g, this.getSize(), this.zoomButtonColor);
                if (this.isNorth) {
                    GraphicsUtil.drawArrow2(g, sz.width / 2 - 20, 15, sz.width / 2, 5, sz.width / 2 + 20, 15);
                }
                if (this.isSouth) {
                    GraphicsUtil.drawArrow2(g, sz.width / 2 - 20, sz.height - 15, sz.width / 2, sz.height - 5, sz.width / 2 + 20, sz.height - 15);
                }
                if (this.isEast) {
                    GraphicsUtil.drawArrow2(g, sz.width - 15, sz.height / 2 + 20, sz.width - 5, sz.height / 2, sz.width - 15, sz.height / 2 - 20);
                }
                if (this.isWest) {
                    GraphicsUtil.drawArrow2(g, 15, sz.height / 2 + 20, 5, sz.height / 2, 15, sz.height / 2 + -20);
                }
                if (this.isNortheast) {
                    GraphicsUtil.drawArrow2(g, sz.width - 30, 5, sz.width - 5, 5, sz.width - 5, 30);
                }
                if (this.isNorthwest) {
                    GraphicsUtil.drawArrow2(g, 30, 5, 5, 5, 5, 30);
                }
                if (this.isSoutheast) {
                    GraphicsUtil.drawArrow2(g, sz.width - 30, sz.height - 5, sz.width - 5, sz.height - 5, sz.width - 5, sz.height - 30);
                }
                if (this.isSouthwest) {
                    GraphicsUtil.drawArrow2(g, 30, sz.height - 5, 5, sz.height - 5, 5, sz.height - 30);
                }
            } else {
                this.zoomButtonVisible = false;
            }
            if (AppPreferences.SHOW_TICK_RATE.getBoolean() && (hz = Canvas.this.tickCounter.getTickRate()) != null && !hz.equals("")) {
                FontMetrics fm = g.getFontMetrics();
                int x = 10;
                int y = fm.getAscent() + 10;
                g.setColor(new Color(AppPreferences.CLOCK_FREQUENCY_COLOR.get()));
                g.setFont(TICK_RATE_FONT);
                g.drawString(hz, x, y);
            }
            if (!Canvas.this.proj.getSimulator().isAutoPropagating()) {
                g.setColor(SINGLE_STEP_MSG_COLOR);
                Font old = g.getFont();
                g.setFont(SINGLE_STEP_MSG_FONT);
                g.drawString(Canvas.this.proj.getSimulator().getSingleStepMessage(), 10, 15);
                g.setFont(old);
            }
            g.setColor(Color.BLACK);
        }

        private int paintString(Graphics g, int y, String msg) {
            Font old = g.getFont();
            g.setFont(ERR_MSG_FONT);
            FontMetrics fm = g.getFontMetrics();
            int x = (this.getWidth() - fm.stringWidth(msg)) / 2;
            if (x < 0) {
                x = 0;
            }
            g.drawString(msg, x, y);
            g.setFont(old);
            return y - 23;
        }

        void setEast(boolean value) {
            this.isEast = value;
        }

        void setErrorMessage(StringGetter msg, Color color) {
            if (this.errorMessage != msg) {
                this.errorMessage = msg;
                this.errorColor = color == null ? DEFAULT_ERROR_COLOR : color;
                Canvas.this.paintThread.requestRepaint();
            }
        }

        void setNorth(boolean value) {
            this.isNorth = value;
        }

        void setNortheast(boolean value) {
            this.isNortheast = value;
        }

        void setNorthwest(boolean value) {
            this.isNorthwest = value;
        }

        void setSouth(boolean value) {
            this.isSouth = value;
        }

        void setSoutheast(boolean value) {
            this.isSoutheast = value;
        }

        void setSouthwest(boolean value) {
            this.isSouthwest = value;
        }

        void setWest(boolean value) {
            this.isWest = value;
        }

        void setWidthMessage(String msg) {
            this.widthMessage = msg;
        }
    }

    private class MyProjectListener
    implements ProjectListener,
    LibraryListener,
    CircuitListener,
    AttributeListener,
    Simulator.Listener,
    Selection.Listener {
        private MyProjectListener() {
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            Attribute<?> attr = e.getAttribute();
            if (attr == Options.ATTR_GATE_UNDEFINED) {
                CircuitState circState = Canvas.this.getCircuitState();
                circState.markComponentsDirty(Canvas.this.getCircuit().getNonWires());
            }
        }

        @Override
        public void circuitChanged(CircuitEvent event) {
            int act = event.getAction();
            if (act == 2) {
                Component c = (Component)event.getData();
                if (c == Canvas.this.painter.getHaloedComponent()) {
                    Canvas.this.proj.getFrame().viewComponentAttributes(null, null);
                }
            } else if (act == 5) {
                if (Canvas.this.painter.getHaloedComponent() != null) {
                    Canvas.this.proj.getFrame().viewComponentAttributes(null, null);
                }
            } else if (act == 4) {
                Canvas.this.completeAction();
            }
        }

        private Tool findTool(List<? extends Tool> opts) {
            Tool ret = null;
            for (Tool tool : opts) {
                if (ret == null && tool != null) {
                    ret = tool;
                    continue;
                }
                if (!(tool instanceof EditTool)) continue;
                ret = tool;
            }
            return ret;
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            if (event.getAction() == 1) {
                Object t = event.getData();
                Circuit circ = null;
                if (t instanceof AddTool && (t = ((AddTool)t).getFactory()) instanceof SubcircuitFactory) {
                    SubcircuitFactory subFact = (SubcircuitFactory)t;
                    circ = subFact.getSubcircuit();
                }
                if (t == Canvas.this.proj.getCurrentCircuit() && t != null) {
                    Canvas.this.proj.setCurrentCircuit(Canvas.this.proj.getLogisimFile().getMainCircuit());
                }
                if (Canvas.this.proj.getTool() == event.getData()) {
                    Tool next = this.findTool(Canvas.this.proj.getLogisimFile().getOptions().getToolbarData().getContents());
                    if (next == null) {
                        Library lib;
                        Iterator<Library> iterator = Canvas.this.proj.getLogisimFile().getLibraries().iterator();
                        while (iterator.hasNext() && (next = this.findTool((lib = iterator.next()).getTools())) == null) {
                        }
                    }
                    Canvas.this.proj.setTool(next);
                }
                if (circ != null) {
                    CircuitState state;
                    CircuitState last = state = Canvas.this.getCircuitState();
                    while (state != null && state.getCircuit() != circ) {
                        last = state;
                        state = state.getParentState();
                    }
                    if (state != null) {
                        Canvas.this.getProject().setCircuitState(last.cloneState());
                    }
                }
            }
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            int act = event.getAction();
            if (act == 1) {
                Canvas.this.viewport.setErrorMessage(null, null);
                if (Canvas.this.painter.getHaloedComponent() != null) {
                    Canvas.this.proj.getFrame().viewComponentAttributes(null, null);
                }
            } else if (act == 0) {
                LogisimFile file;
                LogisimFile old = (LogisimFile)event.getOldData();
                if (old != null) {
                    old.getOptions().getAttributeSet().removeAttributeListener(this);
                }
                if ((file = (LogisimFile)event.getData()) != null) {
                    AttributeSet attrs = file.getOptions().getAttributeSet();
                    attrs.addAttributeListener(this);
                    Canvas.this.loadOptions(attrs);
                    Canvas.this.mappings = file.getOptions().getMouseMappings();
                }
            } else if (act == 2) {
                Canvas.this.viewport.setErrorMessage(null, null);
                Tool t = event.getTool();
                if (t == null) {
                    Canvas.this.setCursor(Cursor.getDefaultCursor());
                } else {
                    Canvas.this.setCursor(t.getCursor());
                }
            } else if (act == 4) {
                Propagator newProp;
                Propagator oldProp;
                CircuitState oldState = (CircuitState)event.getOldData();
                CircuitState newState = (CircuitState)event.getData();
                if (oldState != null && newState != null && (oldProp = oldState.getPropagator()) != (newProp = newState.getPropagator())) {
                    Canvas.this.tickCounter.clear();
                }
            }
            if (act != 3 && act != 5 && act != 8) {
                Canvas.this.completeAction();
            }
        }

        @Override
        public void selectionChanged(Selection.Event event) {
            Canvas.this.repaint();
        }

        @Override
        public void propagationCompleted(Simulator.Event e) {
            Canvas.this.paintThread.requestRepaint();
            if (e.didTick()) {
                Canvas.this.waitForRepaintDone();
            }
        }

        @Override
        public void simulatorStateChanged(Simulator.Event e) {
        }

        @Override
        public void simulatorReset(Simulator.Event e) {
            Canvas.this.waitForRepaintDone();
        }
    }
}

