/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.util.UniquelyNamedThread;
import java.awt.Rectangle;

class CanvasPaintThread
extends UniquelyNamedThread {
    private static final int REPAINT_TIMESPAN = 50;
    private final Canvas canvas;
    private final Object lock;
    private boolean repaintRequested;
    private long nextRepaint;
    private boolean alive;
    private Rectangle repaintRectangle;

    public CanvasPaintThread(Canvas canvas) {
        super("CanvasPaintThread");
        this.canvas = canvas;
        this.lock = new Object();
        this.repaintRequested = false;
        this.alive = true;
        this.nextRepaint = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requentRepaint(Rectangle rect) {
        Object object = this.lock;
        synchronized (object) {
            if (this.repaintRequested) {
                if (this.repaintRectangle != null) {
                    this.repaintRectangle.add(rect);
                }
            } else {
                this.repaintRequested = true;
                this.repaintRectangle = rect;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRepaint() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.repaintRequested) {
                this.repaintRequested = true;
                this.repaintRectangle = null;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        Object object = this.lock;
        synchronized (object) {
            this.alive = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.alive) {
            long now = System.currentTimeMillis();
            Object object = this.lock;
            synchronized (object) {
                long wait = this.nextRepaint - now;
                while (this.alive && (!this.repaintRequested || wait > 0L)) {
                    try {
                        if (wait > 0L) {
                            this.lock.wait(wait);
                        } else {
                            this.lock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                    wait = this.nextRepaint - now;
                }
                if (!this.alive) {
                    break;
                }
                this.repaintRequested = false;
                this.nextRepaint = now + 50L;
            }
            this.canvas.repaint();
        }
    }
}

