/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.util.PropertyChangeWeakSupport;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;

class Clipboard {
    public static final String CONTENTS_PROPERTY = "contents";
    private static final PropertyChangeWeakSupport propertySupport = new PropertyChangeWeakSupport(Clipboard.class);
    private static Clipboard current = null;
    private final HashSet<Component> components = new HashSet();
    private AttributeSet oldAttrs = null;
    private AttributeSet newAttrs = null;

    private Clipboard(Selection sel, AttributeSet viewAttrs) {
        for (Component base : sel.getComponents()) {
            AttributeSet baseAttrs = base.getAttributeSet();
            AttributeSet copyAttrs = (AttributeSet)baseAttrs.clone();
            Component copy = base.getFactory().createComponent(base.getLocation(), copyAttrs);
            this.components.add(copy);
            if (baseAttrs != viewAttrs) continue;
            this.oldAttrs = baseAttrs;
            this.newAttrs = copyAttrs;
        }
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.addPropertyChangeListener(listener);
    }

    public static void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public static Clipboard get() {
        return current;
    }

    public static boolean isEmpty() {
        return current == null || Clipboard.current.components.isEmpty();
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.removePropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    public static void set(Clipboard value) {
        Clipboard old = current;
        current = value;
        propertySupport.firePropertyChange(CONTENTS_PROPERTY, old, current);
    }

    public static void set(Selection value, AttributeSet oldAttrs) {
        Clipboard.set(new Clipboard(value, oldAttrs));
    }

    public Collection<Component> getComponents() {
        return this.components;
    }

    public AttributeSet getNewAttributeSet() {
        return this.newAttrs;
    }

    public AttributeSet getOldAttributeSet() {
        return this.oldAttrs;
    }

    void setOldAttributeSet(AttributeSet value) {
        this.oldAttrs = value;
    }
}

