/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.memory.Ram;
import com.cburch.logisim.std.memory.Rom;
import com.cburch.logisim.util.CollectionUtil;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SelectionBase {
    static final Logger logger = LoggerFactory.getLogger(SelectionBase.class);
    static final Set<Component> NO_COMPONENTS = Collections.emptySet();
    final HashSet<Component> selected = new HashSet();
    final HashSet<Component> lifted = new HashSet();
    final HashSet<Component> suppressHandles = new HashSet();
    final Set<Component> unionSet = CollectionUtil.createUnmodifiableSetUnion(this.selected, this.lifted);
    private final ArrayList<Selection.Listener> listeners = new ArrayList();
    final Project proj;
    private Bounds bounds = Bounds.EMPTY_BOUNDS;
    private boolean shouldSnap = false;

    public SelectionBase(Project proj) {
        this.proj = proj;
    }

    private static Bounds computeBounds(Collection<Component> components) {
        if (components.isEmpty()) {
            return Bounds.EMPTY_BOUNDS;
        }
        Iterator<Component> it = components.iterator();
        Bounds ret = it.next().getBounds();
        while (it.hasNext()) {
            Component comp = it.next();
            Bounds bds = comp.getBounds();
            ret = ret.add(bds);
        }
        return ret;
    }

    private static boolean shouldSnapComponent(Component comp) {
        Boolean shouldSnapValue = (Boolean)comp.getFactory().getFeature(ComponentFactory.SHOULD_SNAP, comp.getAttributeSet());
        return shouldSnapValue == null || shouldSnapValue != false;
    }

    public void add(Component comp) {
        if (this.selected.add(comp)) {
            this.fireSelectionChanged();
        }
    }

    public void addAll(Collection<? extends Component> comps) {
        if (this.selected.addAll(comps)) {
            this.fireSelectionChanged();
        }
    }

    public void addListener(Selection.Listener l) {
        this.listeners.add(l);
    }

    void clear(CircuitMutation xn) {
        this.clear(xn, true);
    }

    void clear(CircuitMutation xn, boolean dropLifted) {
        if (this.selected.isEmpty() && this.lifted.isEmpty()) {
            return;
        }
        if (dropLifted && !this.lifted.isEmpty()) {
            xn.addAll(this.lifted);
        }
        this.selected.clear();
        this.lifted.clear();
        this.shouldSnap = false;
        this.bounds = Bounds.EMPTY_BOUNDS;
        this.fireSelectionChanged();
    }

    private void computeShouldSnap() {
        this.shouldSnap = false;
        for (Component comp : this.unionSet) {
            if (!SelectionBase.shouldSnapComponent(comp)) continue;
            this.shouldSnap = true;
            return;
        }
    }

    private HashMap<Component, Component> copyComponents(Collection<Component> components, boolean translate) {
        Bounds bds = SelectionBase.computeBounds(components);
        int index = 0;
        while (true) {
            int dy;
            int dx;
            if (index == 0) {
                dx = 0;
                dy = 0;
            } else {
                int side = 1;
                while (side * side <= index) {
                    side += 2;
                }
                int offs = index - (side - 2) * (side - 2);
                dx = side / 2;
                dy = side / 2;
                if (offs < side - 1) {
                    dx -= offs;
                } else if (offs < 2 * (side - 1)) {
                    dx = -dx;
                    dy -= (offs -= side - 1);
                } else if (offs < 3 * (side - 1)) {
                    dx = -dx + (offs -= 2 * (side - 1));
                    dy = -dy;
                } else {
                    dy = -dy + (offs -= 3 * (side - 1));
                }
                dx *= 10;
                dy *= 10;
            }
            if (bds.getX() + dx >= 0 && bds.getY() + dy >= 0 && !this.hasConflictTranslated(components, dx, dy, true)) {
                return this.copyComponents(components, dx, dy, translate);
            }
            ++index;
        }
    }

    private HashMap<Component, Component> copyComponents(Collection<Component> components, int dx, int dy, boolean translate) {
        HashMap<Component, Component> ret = new HashMap<Component, Component>();
        for (Component comp : components) {
            Location oldLoc = comp.getLocation();
            AttributeSet attrs = translate || comp.getFactory() instanceof Rom || comp.getFactory() instanceof Ram ? comp.getAttributeSet() : (AttributeSet)comp.getAttributeSet().clone();
            int newX = oldLoc.getX() + dx;
            int newY = oldLoc.getY() + dy;
            Object snap = comp.getFactory().getFeature(ComponentFactory.SHOULD_SNAP, attrs);
            if (snap == null || ((Boolean)snap).booleanValue()) {
                newX = Canvas.snapXToGrid(newX);
                newY = Canvas.snapYToGrid(newY);
            }
            Location newLoc = Location.create(newX, newY, false);
            Component copy = comp.getFactory().createComponent(newLoc, attrs);
            ret.put(comp, copy);
        }
        return ret;
    }

    void deleteAllHelper(CircuitMutation xn) {
        for (Component comp : this.selected) {
            xn.remove(comp);
        }
        this.selected.clear();
        this.lifted.clear();
        this.fireSelectionChanged();
    }

    void dropAll(CircuitMutation xn) {
        if (!this.lifted.isEmpty()) {
            xn.addAll(this.lifted);
            this.selected.addAll(this.lifted);
            this.lifted.clear();
        }
    }

    void duplicateHelper(CircuitMutation xn) {
        HashSet<Component> oldSelected = new HashSet<Component>(this.selected);
        oldSelected.addAll(this.lifted);
        this.pasteHelper(xn, oldSelected);
    }

    public void fireSelectionChanged() {
        this.bounds = null;
        this.computeShouldSnap();
        Selection.Event e = new Selection.Event(this);
        for (Selection.Listener l : this.listeners) {
            l.selectionChanged(e);
        }
    }

    public Bounds getBounds() {
        if (this.bounds == null) {
            this.bounds = SelectionBase.computeBounds(this.unionSet);
        }
        return this.bounds;
    }

    public Bounds getBounds(Graphics g) {
        Iterator<Component> it = this.unionSet.iterator();
        if (it.hasNext()) {
            this.bounds = it.next().getBounds(g);
            while (it.hasNext()) {
                Component comp = it.next();
                Bounds bds = comp.getBounds(g);
                this.bounds = this.bounds.add(bds);
            }
        } else {
            this.bounds = Bounds.EMPTY_BOUNDS;
        }
        return this.bounds;
    }

    private boolean hasConflictTranslated(Collection<Component> components, int dx, int dy, boolean selfConflicts) {
        Circuit circuit = this.proj.getCurrentCircuit();
        if (circuit == null) {
            return false;
        }
        for (Component comp : components) {
            if (comp instanceof Wire) continue;
            for (EndData endData : comp.getEnds()) {
                Location endLoc;
                Component conflict;
                if (endData == null || !endData.isExclusive() || (conflict = circuit.getExclusive(endLoc = endData.getLocation().translate(dx, dy))) == null || !selfConflicts && components.contains(conflict)) continue;
                return true;
            }
            Location newLoc = comp.getLocation().translate(dx, dy);
            Bounds newBounds = comp.getBounds().translate(dx, dy);
            for (Component comp2 : circuit.getAllContaining(newLoc)) {
                Bounds bds = comp2.getBounds();
                if (!bds.equals(newBounds) || !selfConflicts && components.contains(comp2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasConflictWhenMoved(int dx, int dy) {
        return this.hasConflictTranslated(this.unionSet, dx, dy, false);
    }

    void pasteHelper(CircuitMutation xn, Collection<Component> comps) {
        this.clear(xn);
        HashMap<Component, Component> newLifted = this.copyComponents(comps, false);
        this.lifted.addAll(newLifted.values());
        this.fireSelectionChanged();
    }

    public void print() {
        logger.debug(" shouldSnap: {}", (Object)this.shouldSnap());
        boolean hasPrinted = false;
        for (Component comp : this.selected) {
            if (hasPrinted) {
                logger.debug("       : {}  [{}]", (Object)comp, (Object)comp.hashCode());
            } else {
                logger.debug(" select: {}  [{}]", (Object)comp, (Object)comp.hashCode());
            }
            hasPrinted = true;
        }
        hasPrinted = false;
        for (Component comp : this.lifted) {
            if (hasPrinted) {
                logger.debug("       : {}  [{}]", (Object)comp, (Object)comp.hashCode());
            } else {
                logger.debug(" lifted: {}  [{}]", (Object)comp, (Object)comp.hashCode());
            }
            hasPrinted = true;
        }
    }

    void remove(CircuitMutation xn, Component comp) {
        boolean removed = this.selected.remove(comp);
        if (this.lifted.contains(comp)) {
            if (xn == null) {
                throw new IllegalStateException("cannot remove");
            }
            this.lifted.remove(comp);
            removed = true;
            xn.add(comp);
        }
        if (removed) {
            if (SelectionBase.shouldSnapComponent(comp)) {
                this.computeShouldSnap();
            }
            this.fireSelectionChanged();
        }
    }

    public void removeListener(Selection.Listener l) {
        this.listeners.remove(l);
    }

    public void setSuppressHandles(Collection<Component> toSuppress) {
        this.suppressHandles.clear();
        if (toSuppress != null) {
            this.suppressHandles.addAll(toSuppress);
        }
    }

    public boolean shouldSnap() {
        return this.shouldSnap;
    }

    void translateHelper(CircuitMutation xn, int dx, int dy) {
        HashMap<Component, Component> translatedComps = this.copyComponents(this.selected, dx, dy, true);
        for (Map.Entry entry : translatedComps.entrySet()) {
            xn.replace((Component)entry.getKey(), (Component)entry.getValue());
            this.selected.add((Component)entry.getValue());
        }
        HashMap<Component, Component> liftedAfter = this.copyComponents(this.lifted, dx, dy, true);
        this.lifted.clear();
        for (Map.Entry entry : liftedAfter.entrySet()) {
            xn.add((Component)entry.getValue());
            this.selected.add((Component)entry.getValue());
        }
        this.fireSelectionChanged();
    }
}

