/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.gui.main.SimulationTreeModel;
import com.cburch.logisim.gui.main.SimulationTreeNode;
import com.cburch.logisim.instance.StdAttr;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.tree.TreeNode;

class SimulationTreeCircuitNode
extends SimulationTreeNode
implements CircuitListener,
AttributeListener,
Comparator<Component> {
    private final CircuitState circuitState;
    private final Component subcircComp;

    public SimulationTreeCircuitNode(SimulationTreeModel model, SimulationTreeCircuitNode parent, CircuitState circuitState, Component subcircComp) {
        super(model, parent);
        this.circuitState = circuitState;
        this.subcircComp = subcircComp;
        circuitState.getCircuit().addCircuitListener(this);
        if (subcircComp != null) {
            subcircComp.getAttributeSet().addAttributeListener(this);
        } else {
            circuitState.getCircuit().getStaticAttributes().addAttributeListener(this);
        }
        this.computeChildren();
    }

    @Override
    public void attributeValueChanged(AttributeEvent e) {
        Attribute<?> attr = e.getAttribute();
        if (attr == CircuitAttributes.CIRCUIT_LABEL_ATTR || attr == StdAttr.LABEL) {
            this.model.fireNodeChanged(this);
        }
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.model.fireNodeChanged(this);
        } else if (this.computeChildren()) {
            this.model.fireStructureChanged(this);
        }
    }

    @Override
    public int compare(Component a, Component b) {
        String nameB;
        String nameA;
        int ret;
        if (a != b && (ret = (nameA = a.getFactory().getDisplayName()).compareToIgnoreCase(nameB = b.getFactory().getDisplayName())) != 0) {
            return ret;
        }
        return a.getLocation().toString().compareTo(b.getLocation().toString());
    }

    private boolean computeChildren() {
        ArrayList<Object> newChildren = new ArrayList<Object>();
        ArrayList<Component> subcircs = new ArrayList<Component>();
        for (Component comp : this.circuitState.getCircuit().getNonWires()) {
            if (comp.getFactory() instanceof SubcircuitFactory) {
                subcircs.add(comp);
                continue;
            }
            SimulationTreeNode toAdd = this.model.mapComponentToNode(comp);
            if (toAdd == null) continue;
            newChildren.add(toAdd);
        }
        newChildren.sort(new CompareByName());
        subcircs.sort(this);
        for (Component comp : subcircs) {
            SubcircuitFactory factory = (SubcircuitFactory)comp.getFactory();
            CircuitState state = factory.getSubstate(this.circuitState, comp);
            SimulationTreeCircuitNode toAdd = null;
            for (TreeNode treeNode : this.children) {
                if (!(treeNode instanceof SimulationTreeCircuitNode)) continue;
                SimulationTreeCircuitNode node = (SimulationTreeCircuitNode)treeNode;
                if (node.circuitState != state) continue;
                toAdd = node;
                break;
            }
            if (toAdd == null) {
                toAdd = new SimulationTreeCircuitNode(this.model, this, state, comp);
            }
            newChildren.add(toAdd);
        }
        if (!this.children.equals(newChildren)) {
            this.children = newChildren;
            return true;
        }
        return false;
    }

    public CircuitState getCircuitState() {
        return this.circuitState;
    }

    @Override
    public ComponentFactory getComponentFactory() {
        return this.circuitState.getCircuit().getSubcircuitFactory();
    }

    @Override
    public boolean isCurrentView(SimulationTreeModel model) {
        return model.getCurrentView() == this.circuitState;
    }

    public String toString() {
        String label;
        if (this.subcircComp != null && (label = this.subcircComp.getAttributeSet().getValue(StdAttr.LABEL)) != null && !label.equals("")) {
            return label;
        }
        Object ret = this.circuitState.getCircuit().getName();
        if (this.subcircComp != null) {
            ret = (String)ret + this.subcircComp.getLocation();
        }
        return ret;
    }

    private static class CompareByName
    implements Comparator<Object> {
        private CompareByName() {
        }

        @Override
        public int compare(Object a, Object b) {
            return a.toString().compareToIgnoreCase(b.toString());
        }
    }
}

