/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.gui.main.SimulationTreeCircuitNode;
import com.cburch.logisim.gui.main.SimulationTreeNode;
import com.cburch.logisim.gui.main.SimulationTreeTopNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SimulationTreeModel
implements TreeModel {
    private final ArrayList<TreeModelListener> listeners = new ArrayList();
    private final SimulationTreeTopNode root;
    private CircuitState currentView;

    public SimulationTreeModel(List<CircuitState> allRootStates) {
        this.root = new SimulationTreeTopNode(this, allRootStates);
        this.currentView = null;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    private TreePath findPath(Object node) {
        ArrayList<Object> path = new ArrayList<Object>();
        Object current = node;
        while (current instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)current;
            path.add(0, current);
            current = treeNode.getParent();
        }
        if (current != null) {
            path.add(0, current);
        }
        return new TreePath(path.toArray());
    }

    protected void fireNodeChanged(Object node) {
        TreeModelEvent e = new TreeModelEvent((Object)this, this.findPath(node));
        for (TreeModelListener l : this.listeners) {
            l.treeNodesChanged(e);
        }
    }

    protected void fireStructureChanged(Object node) {
        TreeModelEvent e = new TreeModelEvent((Object)this, this.findPath(node));
        for (TreeModelListener l : this.listeners) {
            l.treeStructureChanged(e);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeNode treeNode;
        if (parent instanceof TreeNode) {
            TreeNode node = (TreeNode)parent;
            treeNode = node.getChildAt(index);
        } else {
            treeNode = null;
        }
        return treeNode;
    }

    @Override
    public int getChildCount(Object parent) {
        int n;
        if (parent instanceof TreeNode) {
            TreeNode node = (TreeNode)parent;
            n = node.getChildCount();
        } else {
            n = 0;
        }
        return n;
    }

    public CircuitState getCurrentView() {
        return this.currentView;
    }

    public void setCurrentView(CircuitState value) {
        CircuitState oldView = this.currentView;
        if (oldView != value) {
            SimulationTreeCircuitNode node2;
            this.currentView = value;
            SimulationTreeCircuitNode node1 = this.mapToNode(oldView);
            if (node1 != null) {
                this.fireNodeChanged(node1);
            }
            if ((node2 = this.mapToNode(value)) != null) {
                this.fireNodeChanged(node2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (!(parent instanceof TreeNode)) return -1;
        TreeNode parentNode = (TreeNode)parent;
        if (!(child instanceof TreeNode)) return -1;
        TreeNode childNode = (TreeNode)child;
        int n = parentNode.getIndex(childNode);
        return n;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        TreeNode treeNode;
        return node instanceof TreeNode ? (treeNode = (TreeNode)node).getChildCount() == 0 : true;
    }

    public void updateSimulationList(List<CircuitState> allRootStates) {
        this.root.updateSimulationList(allRootStates);
    }

    protected SimulationTreeNode mapComponentToNode(Component comp) {
        return null;
    }

    private SimulationTreeCircuitNode mapToNode(CircuitState state) {
        TreePath path = this.mapToPath(state);
        if (path == null) {
            return null;
        }
        return (SimulationTreeCircuitNode)path.getLastPathComponent();
    }

    public TreePath mapToPath(CircuitState state) {
        if (state == null) {
            return null;
        }
        ArrayList<CircuitState> path = new ArrayList<CircuitState>();
        CircuitState current = state;
        CircuitState parent = current.getParentState();
        while (parent != null && parent != state) {
            path.add(current);
            current = parent;
            parent = current.getParentState();
        }
        path.add(current);
        Object[] pathNodes = new Object[path.size() + 1];
        pathNodes[0] = this.root;
        int pathPos = 1;
        SimulationTreeNode node = this.root;
        for (int i = path.size() - 1; i >= 0; --i) {
            current = (CircuitState)path.get(i);
            SimulationTreeTopNode oldNode = node;
            for (TreeNode child : Collections.list(node.children())) {
                SimulationTreeCircuitNode circNode;
                if (!(child instanceof SimulationTreeCircuitNode) || (circNode = (SimulationTreeCircuitNode)child).getCircuitState() != current) continue;
                node = circNode;
                break;
            }
            if (node == oldNode) {
                return null;
            }
            pathNodes[pathPos] = node;
            ++pathPos;
        }
        return new TreePath(pathNodes);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException();
    }
}

