/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.gui.Strings;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class TickCounter
implements Simulator.Listener {
    private final DecimalFormat formatter;
    private Simulator simulator;
    private long tickCount = 0L;
    private long startTime;
    private boolean useKiloHertz = false;
    private double previousFrequency = 0.0;
    private long elapsedTimeSinceLastUnitUpdate = 0L;
    static final int NANOSECONDS_PER_SECONDS = 1000000000;
    static final int UNIT_UPDATE_THRESHOLD_NANOSECONDS = 500000000;
    static final int TICKS_THRESHOLD_BEFORE_HISTORY_WEIGHT_REDUCTION = 1000;
    static final int WEIGHT_REDUCTION_TICKS_COUNT = 500;

    public TickCounter() {
        this.clear();
        this.formatter = new DecimalFormat("0.00");
        this.formatter.setRoundingMode(RoundingMode.HALF_UP);
    }

    public void clear() {
        if (this.simulator != null) {
            double tickPeriodNanoseconds = 1.0E9 / this.simulator.getTickFrequency();
            this.tickCount = 12L;
            this.startTime = System.nanoTime() - (long)((double)this.tickCount * tickPeriodNanoseconds);
        } else {
            this.tickCount = 0L;
            this.startTime = System.nanoTime();
        }
    }

    public String getTickRate() {
        long elapsedTime;
        if (this.simulator == null || !this.simulator.isAutoTicking()) {
            return "";
        }
        double currentFrequency = this.simulator.getTickFrequency();
        if (this.previousFrequency != currentFrequency) {
            this.previousFrequency = currentFrequency;
            this.clear();
        }
        if ((elapsedTime = System.nanoTime() - this.startTime) == 0L) {
            return "";
        }
        if (this.tickCount < 1L) {
            return "";
        }
        double ticksPerNanoseconds = (double)this.tickCount / (double)elapsedTime;
        double fullCyclesPerSeconds = 5.0E8 * ticksPerNanoseconds;
        this.elapsedTimeSinceLastUnitUpdate += elapsedTime;
        if (this.elapsedTimeSinceLastUnitUpdate > 500000000L) {
            this.useKiloHertz = fullCyclesPerSeconds > 1000.0;
            this.elapsedTimeSinceLastUnitUpdate = 0L;
        }
        if (this.tickCount > 1000L) {
            this.tickCount -= 500L;
            double nanoseconds = 500.0 / ticksPerNanoseconds;
            this.startTime = (long)((double)this.startTime + nanoseconds);
        }
        if (this.useKiloHertz) {
            return Strings.S.get("tickRateKHz", this.formatter.format(fullCyclesPerSeconds / 1000.0));
        }
        return Strings.S.get("tickRateHz", this.formatter.format(fullCyclesPerSeconds));
    }

    @Override
    public void simulatorStateChanged(Simulator.Event e) {
        this.simulator = e.getSource();
        this.clear();
    }

    @Override
    public void simulatorReset(Simulator.Event e) {
        this.simulator = e.getSource();
        this.clear();
    }

    @Override
    public void propagationCompleted(Simulator.Event e) {
        if (e.didTick()) {
            this.simulator = e.getSource();
            ++this.tickCount;
        }
    }
}

