/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.contracts.BaseKeyListenerContract;
import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class AssemblyWindow
implements ActionListener,
BaseWindowListenerContract,
Simulator.Listener,
BaseKeyListenerContract {
    private static Circuit curCircuit;
    private static CircuitState curCircuitState;
    private final Preferences prefs;
    private final LFrame windows;
    private final JMenuBar winMenuBar;
    private final JCheckBoxMenuItem ontopItem;
    private final JMenuItem openFileItem;
    private final JMenuItem reloadFileItem;
    private final JMenuItem close;
    private final JButton refresh = new JButton("Get Registers");
    private final JLabel status = new JLabel();
    private final JEditorPane document = new JEditorPane();
    private final JComboBox combo = new JComboBox();
    private final HashMap<String, Component> entry = new HashMap();
    private final Project proj;
    private Component selReg = null;
    private File file;

    public AssemblyWindow(Project proj) {
        this.proj = proj;
        curCircuit = proj.getCurrentCircuit();
        curCircuitState = proj.getCircuitState();
        this.winMenuBar = new JMenuBar();
        JMenu windowMenu = new JMenu("Window");
        JMenu fileMenu = new JMenu("File");
        JPanel main = new JPanel(new BorderLayout());
        JPanel north = new JPanel(new FlowLayout(0, 5, 2));
        windowMenu.setMnemonic('W');
        fileMenu.setMnemonic('F');
        this.combo.addActionListener(this);
        this.combo.setFocusable(false);
        this.refresh.addActionListener(this);
        this.refresh.setFocusable(false);
        this.refresh.setToolTipText("Get register list of current displayed circuit.");
        this.ontopItem = new JCheckBoxMenuItem("Set on top", true);
        this.ontopItem.addActionListener(this);
        this.openFileItem = new JMenuItem("Open lss file");
        this.openFileItem.addActionListener(this);
        this.reloadFileItem = new JMenuItem("Reload lss file");
        this.reloadFileItem.addActionListener(this);
        this.close = new JMenuItem("Close");
        this.close.addActionListener(this);
        this.winMenuBar.add(fileMenu);
        this.winMenuBar.add(windowMenu);
        this.winMenuBar.setFocusable(false);
        windowMenu.add(this.ontopItem);
        fileMenu.add(this.openFileItem);
        fileMenu.add(this.reloadFileItem);
        fileMenu.addSeparator();
        fileMenu.add(this.close);
        this.windows = new LFrame.Dialog(null);
        this.windows.setTitle("Assembly: " + proj.getLogisimFile().getDisplayName());
        this.windows.setJMenuBar(this.winMenuBar);
        this.windows.toFront();
        this.windows.setAlwaysOnTop(true);
        this.windows.setVisible(false);
        this.windows.addWindowListener(this);
        this.windows.addKeyListener(this);
        north.add(new JLabel("Register: "));
        north.add(this.combo);
        north.add(this.refresh);
        this.document.setFont(new Font("Monospaced", 0, 12));
        this.document.setEditable(false);
        this.document.setPreferredSize(new Dimension(this.document.getWidth() * 4 / 5, Math.max(200, this.document.getHeight() * 2 / 3)));
        this.document.addKeyListener(this);
        main.add((java.awt.Component)new JScrollPane(this.document), "Center");
        main.add((java.awt.Component)north, "North");
        main.add((java.awt.Component)this.status, "South");
        this.windows.setContentPane(main);
        proj.getSimulator().addSimulatorListener(this);
        this.windows.pack();
        this.prefs = Preferences.userRoot().node(this.getClass().getName());
        this.windows.setLocation(this.prefs.getInt("X", 0), this.prefs.getInt("Y", 0));
        this.windows.setSize(this.prefs.getInt("W", this.windows.getSize().width), this.prefs.getInt("H", this.windows.getSize().height));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.ontopItem) {
            e.paramString();
            this.windows.setAlwaysOnTop(this.ontopItem.getState());
        } else if (src == this.openFileItem) {
            JFileChooser fileChooser = this.proj.createChooser();
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".lss");
                }

                @Override
                public String getDescription() {
                    return ".lss disassembly file";
                }
            };
            fileChooser.setFileFilter(ff);
            fileChooser.setAcceptAllFileFilterUsed(false);
            int result = fileChooser.showOpenDialog(this.windows);
            if (result == 0) {
                this.file = fileChooser.getSelectedFile();
                try {
                    if (this.file.getName().toLowerCase().endsWith(".lss")) {
                        this.status.setText("");
                        this.document.setPage(this.file.toURI().toURL());
                    } else {
                        this.status.setText("Wrong file selected !");
                        this.file = null;
                    }
                }
                catch (Exception ex) {
                    this.status.setText("Cannot open file !");
                    this.file = null;
                }
            }
            this.document.getDocument().putProperty("stream", null);
            this.windows.invalidate();
        } else if (src == this.reloadFileItem) {
            if (this.file != null) {
                try {
                    this.document.setPage(this.file.toURI().toURL());
                    this.status.setText("File reloaded.");
                }
                catch (Exception ex) {
                    this.status.setText("Cannot open file !");
                    this.file = null;
                }
            }
            this.windows.invalidate();
        } else if (src == this.refresh) {
            curCircuit = this.proj.getCurrentCircuit();
            curCircuitState = this.proj.getCircuitState();
            this.fillCombo();
            this.updateHighlightLine();
        } else if (src == this.combo) {
            this.updateHighlightLine();
        } else if (src == this.close) {
            this.setVisible(false);
        }
    }

    private void fillCombo() {
        Set<Component> comps = curCircuit.getNonWires();
        Iterator<Component> iter = comps.iterator();
        this.entry.clear();
        while (iter.hasNext()) {
            Component comp = iter.next();
            if (!comp.getFactory().getName().equals("Register") || comp.getAttributeSet().getValue(StdAttr.LABEL).equals("")) continue;
            this.entry.put(comp.getAttributeSet().getValue(StdAttr.LABEL), comp);
        }
        this.combo.removeAllItems();
        if (this.entry.isEmpty()) {
            this.status.setText("No labeled registers found.");
            this.combo.setEnabled(false);
        } else {
            this.status.setText("");
            this.combo.setEnabled(true);
            Object[] objArr = this.entry.keySet().toArray();
            Arrays.sort(objArr);
            for (Object obj : objArr) {
                this.combo.addItem(obj);
            }
        }
    }

    public boolean isVisible() {
        if (this.windows != null) {
            return this.windows.isVisible();
        }
        return false;
    }

    public void setVisible(boolean bool) {
        this.fillCombo();
        this.windows.setVisible(bool);
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 113 && this.proj.getSimulator() != null) {
            this.proj.getSimulator().tick(2);
        }
    }

    @Override
    public void propagationCompleted(Simulator.Event e) {
        if (e.getSource().isAutoTicking()) {
            this.updateHighlightLine();
        }
    }

    @Override
    public void simulatorReset(Simulator.Event e) {
    }

    @Override
    public void simulatorStateChanged(Simulator.Event e) {
    }

    public void setTitle(String title) {
        this.windows.setTitle(title);
    }

    public void toFront() {
        if (this.windows != null) {
            this.windows.toFront();
        }
    }

    private void updateHighlightLine() {
        if (this.combo.getSelectedItem() != null) {
            this.selReg = this.entry.get(this.combo.getSelectedItem().toString());
            Value val = curCircuitState.getInstanceState(this.selReg).getPortValue(0);
            if (val.isFullyDefined()) {
                Pattern pattern;
                Matcher m;
                String where = val.toHexString().replaceAll("^0*", "");
                if (where.isEmpty()) {
                    where = "0";
                }
                if ((m = (pattern = Pattern.compile("^ +" + where + ":", 10)).matcher(this.document.getText().replaceAll("\r", ""))).find()) {
                    this.document.setCaretPosition(m.start());
                    this.status.setText("");
                    try {
                        this.document.getHighlighter().removeAllHighlights();
                        DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
                        this.document.getHighlighter().addHighlight(m.start(), m.end(), highlightPainter);
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    this.status.setText("Line (" + where + ") not found!");
                }
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.prefs.putInt("X", this.windows.getX());
        this.prefs.putInt("Y", this.windows.getY());
        this.prefs.putInt("W", this.windows.getWidth());
        this.prefs.putInt("H", this.windows.getHeight());
    }
}

