/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.Menu;
import com.cburch.logisim.gui.menu.MenuItemImpl;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

class MenuEdit
extends Menu {
    private static final long serialVersionUID = 1L;
    private final LogisimMenuBar menubar;
    private final JMenuItem undo = new JMenuItem();
    private final JMenuItem redo = new JMenuItem();
    private final MenuItemImpl cut = new MenuItemImpl(this, LogisimMenuBar.CUT);
    private final MenuItemImpl copy = new MenuItemImpl(this, LogisimMenuBar.COPY);
    private final MenuItemImpl paste = new MenuItemImpl(this, LogisimMenuBar.PASTE);
    private final MenuItemImpl delete = new MenuItemImpl(this, LogisimMenuBar.DELETE);
    private final MenuItemImpl dup = new MenuItemImpl(this, LogisimMenuBar.DUPLICATE);
    private final MenuItemImpl selall = new MenuItemImpl(this, LogisimMenuBar.SELECT_ALL);
    private final MenuItemImpl raise = new MenuItemImpl(this, LogisimMenuBar.RAISE);
    private final MenuItemImpl lower = new MenuItemImpl(this, LogisimMenuBar.LOWER);
    private final MenuItemImpl raiseTop = new MenuItemImpl(this, LogisimMenuBar.RAISE_TOP);
    private final MenuItemImpl lowerBottom = new MenuItemImpl(this, LogisimMenuBar.LOWER_BOTTOM);
    private final MenuItemImpl addCtrl = new MenuItemImpl(this, LogisimMenuBar.ADD_CONTROL);
    private final MenuItemImpl remCtrl = new MenuItemImpl(this, LogisimMenuBar.REMOVE_CONTROL);
    private final MyListener myListener = new MyListener();

    public MenuEdit(LogisimMenuBar menubar) {
        this.menubar = menubar;
        int menuMask = this.getToolkit().getMenuShortcutKeyMaskEx();
        this.undo.setAccelerator(KeyStroke.getKeyStroke(90, menuMask));
        this.redo.setAccelerator(KeyStroke.getKeyStroke(90, menuMask | 0x40));
        this.cut.setAccelerator(KeyStroke.getKeyStroke(88, menuMask));
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, menuMask));
        this.paste.setAccelerator(KeyStroke.getKeyStroke(86, menuMask));
        this.delete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.dup.setAccelerator(KeyStroke.getKeyStroke(68, menuMask));
        this.selall.setAccelerator(KeyStroke.getKeyStroke(65, menuMask));
        this.raise.setAccelerator(KeyStroke.getKeyStroke(38, menuMask));
        this.lower.setAccelerator(KeyStroke.getKeyStroke(40, menuMask));
        this.raiseTop.setAccelerator(KeyStroke.getKeyStroke(38, menuMask | 0x40));
        this.lowerBottom.setAccelerator(KeyStroke.getKeyStroke(40, menuMask | 0x40));
        this.add(this.undo);
        this.add(this.redo);
        this.addSeparator();
        this.add(this.cut);
        this.add(this.copy);
        this.add(this.paste);
        this.addSeparator();
        this.add(this.delete);
        this.add(this.dup);
        this.add(this.selall);
        this.addSeparator();
        this.add(this.raise);
        this.add(this.lower);
        this.add(this.raiseTop);
        this.add(this.lowerBottom);
        this.addSeparator();
        this.add(this.addCtrl);
        this.add(this.remCtrl);
        Project proj = menubar.getSaveProject();
        if (proj != null) {
            proj.addProjectListener(this.myListener);
            this.undo.addActionListener(this.myListener);
            this.redo.addActionListener(this.myListener);
        }
        this.undo.setEnabled(false);
        this.redo.setEnabled(false);
        menubar.registerItem(LogisimMenuBar.CUT, this.cut);
        menubar.registerItem(LogisimMenuBar.COPY, this.copy);
        menubar.registerItem(LogisimMenuBar.PASTE, this.paste);
        menubar.registerItem(LogisimMenuBar.DELETE, this.delete);
        menubar.registerItem(LogisimMenuBar.DUPLICATE, this.dup);
        menubar.registerItem(LogisimMenuBar.SELECT_ALL, this.selall);
        menubar.registerItem(LogisimMenuBar.RAISE, this.raise);
        menubar.registerItem(LogisimMenuBar.LOWER, this.lower);
        menubar.registerItem(LogisimMenuBar.RAISE_TOP, this.raiseTop);
        menubar.registerItem(LogisimMenuBar.LOWER_BOTTOM, this.lowerBottom);
        menubar.registerItem(LogisimMenuBar.ADD_CONTROL, this.addCtrl);
        menubar.registerItem(LogisimMenuBar.REMOVE_CONTROL, this.remCtrl);
        this.computeEnabled();
    }

    @Override
    void computeEnabled() {
        this.setEnabled(this.menubar.getSaveProject() != null || this.cut.hasListeners() || this.copy.hasListeners() || this.paste.hasListeners() || this.delete.hasListeners() || this.dup.hasListeners() || this.selall.hasListeners() || this.raise.hasListeners() || this.lower.hasListeners() || this.raiseTop.hasListeners() || this.lowerBottom.hasListeners() || this.addCtrl.hasListeners() || this.remCtrl.hasListeners());
    }

    public void localeChanged() {
        this.setText(Strings.S.get("editMenu"));
        this.myListener.projectChanged(null);
        this.cut.setText(Strings.S.get("editCutItem"));
        this.copy.setText(Strings.S.get("editCopyItem"));
        this.paste.setText(Strings.S.get("editPasteItem"));
        this.delete.setText(Strings.S.get("editClearItem"));
        this.dup.setText(Strings.S.get("editDuplicateItem"));
        this.selall.setText(Strings.S.get("editSelectAllItem"));
        this.raise.setText(Strings.S.get("editRaiseItem"));
        this.lower.setText(Strings.S.get("editLowerItem"));
        this.raiseTop.setText(Strings.S.get("editRaiseTopItem"));
        this.lowerBottom.setText(Strings.S.get("editLowerBottomItem"));
        this.addCtrl.setText(Strings.S.get("editAddControlItem"));
        this.remCtrl.setText(Strings.S.get("editRemoveControlItem"));
    }

    private class MyListener
    implements ProjectListener,
    ActionListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            Project proj = MenuEdit.this.menubar.getSaveProject();
            if (src == MenuEdit.this.undo && proj != null) {
                proj.undoAction();
            } else if (src == MenuEdit.this.redo && proj != null) {
                proj.redoAction();
            }
        }

        @Override
        public void projectChanged(ProjectEvent e) {
            Action next;
            Action last;
            Project proj = MenuEdit.this.menubar.getSaveProject();
            Action action = last = proj != null ? proj.getLastAction() : null;
            if (last == null) {
                MenuEdit.this.undo.setText(Strings.S.get("editCantUndoItem"));
                MenuEdit.this.undo.setEnabled(false);
            } else {
                MenuEdit.this.undo.setText(Strings.S.get("editUndoItem", last.getName()));
                MenuEdit.this.undo.setEnabled(true);
            }
            Action action2 = next = proj == null || !proj.getCanRedo() ? null : proj.getLastRedoAction();
            if (next != null) {
                MenuEdit.this.redo.setText(Strings.S.get("editRedoItem", next.getName()));
                MenuEdit.this.redo.setEnabled(true);
            } else {
                MenuEdit.this.redo.setText(Strings.S.get("editCantRedoItem"));
                MenuEdit.this.redo.setEnabled(false);
            }
        }
    }
}

