/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.LogisimMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class MenuListener {
    protected final LogisimMenuBar menubar;
    protected final ArrayList<EnabledListener> listeners;
    protected final EditListener editListener = new EditListener();

    public MenuListener(LogisimMenuBar menubar) {
        this.menubar = menubar;
        this.listeners = new ArrayList();
    }

    public void addEnabledListener(EnabledListener listener) {
        this.listeners.add(listener);
    }

    public void removeEnabledListener(EnabledListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEnableChanged() {
        for (EnabledListener listener : this.listeners) {
            listener.menuEnableChanged(this);
        }
    }

    public void setEditHandler(EditHandler handler) {
        this.editListener.setHandler(handler);
    }

    public void doAction(LogisimMenuItem item) {
        this.menubar.doAction(item);
    }

    public LogisimMenuBar getMenuBar() {
        return this.menubar;
    }

    public boolean isEnabled(LogisimMenuItem item) {
        return this.menubar.isEnabled(item);
    }

    protected class EditListener
    implements ActionListener,
    EditHandler.Listener {
        private EditHandler handler = null;

        protected EditListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.handler != null) {
                this.handler.actionPerformed(e);
            }
        }

        @Override
        public void enableChanged(EditHandler handler, LogisimMenuItem action, boolean value) {
            if (handler == this.handler) {
                MenuListener.this.menubar.setEnabled(action, value);
                MenuListener.this.fireEnableChanged();
            }
        }

        public void register() {
            for (LogisimMenuItem item : LogisimMenuBar.EDIT_ITEMS) {
                MenuListener.this.menubar.addActionListener(item, this);
            }
            this.computeEnabled();
        }

        public void computeEnabled() {
            if (this.handler != null) {
                this.handler.computeEnabled();
            } else {
                for (LogisimMenuItem item : LogisimMenuBar.EDIT_ITEMS) {
                    MenuListener.this.menubar.setEnabled(item, false);
                }
            }
        }

        private void setHandler(EditHandler value) {
            this.handler = value;
            if (this.handler != null) {
                this.handler.setListener(this);
            }
            this.computeEnabled();
        }
    }

    public static interface EnabledListener {
        public void menuEnableChanged(MenuListener var1);
    }
}

