/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.Menu;
import com.cburch.logisim.gui.menu.MenuItemImpl;
import com.cburch.logisim.gui.menu.ProjectLibraryActions;
import com.cburch.logisim.proj.Project;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class MenuProject
extends Menu {
    private static final long serialVersionUID = 1L;
    private final LogisimMenuBar menubar;
    private final MyListener myListener = new MyListener();
    private final MenuItemImpl addCircuit = new MenuItemImpl(this, LogisimMenuBar.ADD_CIRCUIT);
    private final MenuItemImpl addVhdl = new MenuItemImpl(this, LogisimMenuBar.ADD_VHDL);
    private final MenuItemImpl importVhdl = new MenuItemImpl(this, LogisimMenuBar.IMPORT_VHDL);
    private final JMenu loadLibrary = new JMenu();
    private final JMenuItem loadBuiltin = new JMenuItem();
    private final JMenuItem loadLogisim = new JMenuItem();
    private final JMenuItem loadJar = new JMenuItem();
    private final JMenuItem unload = new JMenuItem();
    private final MenuItemImpl moveUp = new MenuItemImpl(this, LogisimMenuBar.MOVE_CIRCUIT_UP);
    private final MenuItemImpl moveDown = new MenuItemImpl(this, LogisimMenuBar.MOVE_CIRCUIT_DOWN);
    private final MenuItemImpl remove = new MenuItemImpl(this, LogisimMenuBar.REMOVE_CIRCUIT);
    private final MenuItemImpl setAsMain = new MenuItemImpl(this, LogisimMenuBar.SET_MAIN_CIRCUIT);
    private final MenuItemImpl revertAppearance = new MenuItemImpl(this, LogisimMenuBar.REVERT_APPEARANCE);
    private final MenuItemImpl layout = new MenuItemImpl(this, LogisimMenuBar.EDIT_LAYOUT);
    private final MenuItemImpl appearance = new MenuItemImpl(this, LogisimMenuBar.EDIT_APPEARANCE);
    private final MenuItemImpl toggleLayoutAppearance = new MenuItemImpl(this, LogisimMenuBar.TOGGLE_APPEARANCE);
    private final MenuItemImpl analyze = new MenuItemImpl(this, LogisimMenuBar.ANALYZE_CIRCUIT);
    private final MenuItemImpl stats = new MenuItemImpl(this, LogisimMenuBar.CIRCUIT_STATS);
    private final JMenuItem options = new JMenuItem();

    MenuProject(LogisimMenuBar menubar) {
        this.menubar = menubar;
        menubar.registerItem(LogisimMenuBar.ADD_CIRCUIT, this.addCircuit);
        menubar.registerItem(LogisimMenuBar.ADD_VHDL, this.addVhdl);
        menubar.registerItem(LogisimMenuBar.IMPORT_VHDL, this.importVhdl);
        this.loadBuiltin.addActionListener(this.myListener);
        this.loadLogisim.addActionListener(this.myListener);
        this.loadJar.addActionListener(this.myListener);
        this.unload.addActionListener(this.myListener);
        menubar.registerItem(LogisimMenuBar.MOVE_CIRCUIT_UP, this.moveUp);
        menubar.registerItem(LogisimMenuBar.MOVE_CIRCUIT_DOWN, this.moveDown);
        menubar.registerItem(LogisimMenuBar.SET_MAIN_CIRCUIT, this.setAsMain);
        menubar.registerItem(LogisimMenuBar.REMOVE_CIRCUIT, this.remove);
        menubar.registerItem(LogisimMenuBar.REVERT_APPEARANCE, this.revertAppearance);
        menubar.registerItem(LogisimMenuBar.EDIT_LAYOUT, this.layout);
        menubar.registerItem(LogisimMenuBar.EDIT_APPEARANCE, this.appearance);
        menubar.registerItem(LogisimMenuBar.TOGGLE_APPEARANCE, this.toggleLayoutAppearance);
        menubar.registerItem(LogisimMenuBar.ANALYZE_CIRCUIT, this.analyze);
        menubar.registerItem(LogisimMenuBar.CIRCUIT_STATS, this.stats);
        this.options.addActionListener(this.myListener);
        this.loadLibrary.add(this.loadBuiltin);
        this.loadLibrary.add(this.loadLogisim);
        this.loadLibrary.add(this.loadJar);
        this.add(this.addCircuit);
        this.add(this.addVhdl);
        this.add(this.importVhdl);
        this.add(this.loadLibrary);
        this.add(this.unload);
        this.addSeparator();
        this.add(this.moveUp);
        this.add(this.moveDown);
        this.add(this.setAsMain);
        this.add(this.remove);
        this.add(this.revertAppearance);
        this.addSeparator();
        this.add(this.layout);
        this.add(this.appearance);
        this.addSeparator();
        this.add(this.analyze);
        this.add(this.stats);
        this.addSeparator();
        this.add(this.options);
        boolean known = menubar.getSaveProject() != null;
        this.loadLibrary.setEnabled(known);
        this.loadBuiltin.setEnabled(known);
        this.loadLogisim.setEnabled(known);
        this.loadJar.setEnabled(known);
        this.unload.setEnabled(known);
        this.options.setEnabled(known);
        this.computeEnabled();
    }

    @Override
    void computeEnabled() {
        this.setEnabled(this.menubar.getSaveProject() != null || this.addCircuit.hasListeners() || this.addVhdl.hasListeners() || this.importVhdl.hasListeners() || this.moveUp.hasListeners() || this.moveDown.hasListeners() || this.setAsMain.hasListeners() || this.remove.hasListeners() || this.layout.hasListeners() || this.revertAppearance.hasListeners() || this.appearance.hasListeners() || this.analyze.hasListeners() || this.stats.hasListeners());
        this.menubar.fireEnableChanged();
    }

    public void localeChanged() {
        this.setText(Strings.S.get("projectMenu"));
        this.addCircuit.setText(Strings.S.get("projectAddCircuitItem"));
        this.addVhdl.setText(Strings.S.get("projectAddVhdlItem"));
        this.importVhdl.setText(Strings.S.get("projectImportVhdlItem"));
        this.loadLibrary.setText(Strings.S.get("projectLoadLibraryItem"));
        this.loadBuiltin.setText(Strings.S.get("projectLoadBuiltinItem"));
        this.loadLogisim.setText(Strings.S.get("projectLoadLogisimItem"));
        this.loadJar.setText(Strings.S.get("projectLoadJarItem"));
        this.unload.setText(Strings.S.get("projectUnloadLibrariesItem"));
        this.moveUp.setText(Strings.S.get("projectMoveCircuitUpItem"));
        this.moveDown.setText(Strings.S.get("projectMoveCircuitDownItem"));
        this.setAsMain.setText(Strings.S.get("projectSetAsMainItem"));
        this.remove.setText(Strings.S.get("projectRemoveCircuitItem"));
        this.revertAppearance.setText(Strings.S.get("projectRevertAppearanceItem"));
        this.layout.setText(Strings.S.get("projectEditCircuitLayoutItem"));
        this.appearance.setText(Strings.S.get("projectEditCircuitAppearanceItem"));
        this.toggleLayoutAppearance.setText(Strings.S.get("projectToggleCircuitAppearanceItem"));
        this.analyze.setText(Strings.S.get("projectAnalyzeCircuitItem"));
        this.stats.setText(Strings.S.get("projectGetCircuitStatisticsItem"));
        this.options.setText(Strings.S.get("projectOptionsItem"));
    }

    private class MyListener
    implements ActionListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            Project proj = MenuProject.this.menubar.getSaveProject();
            if (proj == null) {
                return;
            }
            if (src == MenuProject.this.loadBuiltin) {
                ProjectLibraryActions.doLoadBuiltinLibrary(proj);
            } else if (src == MenuProject.this.loadLogisim) {
                ProjectLibraryActions.doLoadLogisimLibrary(proj);
            } else if (src == MenuProject.this.loadJar) {
                ProjectLibraryActions.doLoadJarLibrary(proj);
            } else if (src == MenuProject.this.unload) {
                ProjectLibraryActions.doUnloadLibraries(proj);
            } else if (src == MenuProject.this.options) {
                proj.getOptionsFrame().setVisible(true);
            }
        }
    }
}

