/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectActions;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class OpenRecent
extends JMenu
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ITEM_LENGTH = 50;
    private final LogisimMenuBar menubar;
    private final List<RecentItem> recentItems;

    OpenRecent(LogisimMenuBar menubar) {
        this.menubar = menubar;
        this.recentItems = new ArrayList<RecentItem>();
        AppPreferences.addPropertyChangeListener("recentProjects", this);
        this.renewItems();
    }

    private static String getFileText(File file) {
        String ret;
        if (file == null) {
            return Strings.S.get("fileOpenRecentNoChoices");
        }
        try {
            ret = file.getCanonicalPath();
        }
        catch (IOException e) {
            ret = file.toString();
        }
        if (ret.length() <= 50) {
            return ret;
        }
        int splitLoc = (ret = ret.substring(ret.length() - 50 + 3)).indexOf(File.separatorChar);
        if (splitLoc >= 0) {
            ret = ret.substring(splitLoc);
        }
        return "..." + ret;
    }

    void localeChanged() {
        this.setText(Strings.S.get("fileOpenRecentItem"));
        for (RecentItem item : this.recentItems) {
            if (item.file != null) continue;
            item.setText(Strings.S.get("fileOpenRecentNoChoices"));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("recentProjects")) {
            this.renewItems();
        }
    }

    private void renewItems() {
        for (int index = this.recentItems.size() - 1; index >= 0; --index) {
            this.remove(this.recentItems.get(index));
        }
        this.recentItems.clear();
        List<File> files = AppPreferences.getRecentFiles();
        if (files.isEmpty()) {
            this.recentItems.add(new RecentItem(null));
        } else {
            for (File file : files) {
                this.recentItems.add(new RecentItem(file));
            }
        }
        for (RecentItem item : this.recentItems) {
            this.add(item);
        }
    }

    private class RecentItem
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final File file;

        RecentItem(File file) {
            super(OpenRecent.getFileText(file));
            this.file = file;
            this.setEnabled(file != null);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Project proj = OpenRecent.this.menubar.getSaveProject();
            Project baseProj = OpenRecent.this.menubar.getBaseProject();
            Container parent = baseProj != null ? baseProj.getFrame().getCanvas() : OpenRecent.this.menubar.getParentFrame();
            Project newProj = ProjectActions.doOpen(parent, baseProj, this.file);
            if (newProj != null && proj != null && !proj.isFileDirty() && proj.getLogisimFile().getLoader().getMainFile() == null) {
                proj.getFrame().dispose();
            }
        }
    }
}

